/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.ExtendedIndexIterator;
import com.j_spaces.core.cache.IExtendedIndex;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class TemplatesExtendedIndexHandler<K>
implements IExtendedIndex<K, TemplateCacheInfo> {
    private final FastConcurrentSkipListMap<K, IStoredList<TemplateCacheInfo>> _orderedStore = new FastConcurrentSkipListMap();
    private final TypeDataIndex _index;
    private final AtomicInteger _size;
    private static final boolean _FORCE_ORDERED_SCAN = true;

    public TemplatesExtendedIndexHandler(TypeDataIndex index) {
        this._index = index;
        this._size = new AtomicInteger(0);
    }

    @Override
    public IObjectInfo insertEntryIndexedField(TemplateCacheInfo pTemplate, K fieldValue, TypeData pType, boolean alreadyCloned) {
        IObjectInfo<TemplateCacheInfo> oi;
        block8: {
            IObjectInfo<TemplateCacheInfo> myoi;
            oi = null;
            IStoredList<TemplateCacheInfo> newSL = null;
            IStoredList<TemplateCacheInfo> currentSL = null;
            boolean first = true;
            this._size.incrementAndGet();
            while (true) {
                if (first) {
                    first = false;
                    currentSL = this._orderedStore.get(fieldValue);
                }
                if (currentSL == null) {
                    if (!alreadyCloned && this._index.considerValueClone()) {
                        fieldValue = this._index.cloneIndexValue(fieldValue, pTemplate.m_TemplateHolder);
                        alreadyCloned = true;
                    }
                    if ((currentSL = this._orderedStore.putIfAbsent(fieldValue, pTemplate)) == null) {
                        oi = pTemplate;
                        break block8;
                    }
                }
                if (currentSL.isMultiObjectCollection()) {
                    oi = currentSL.add(pTemplate);
                    if (oi == null) {
                        this._orderedStore.remove(fieldValue, currentSL);
                        currentSL = null;
                        continue;
                    }
                    break block8;
                }
                if (newSL == null) {
                    newSL = StoredListFactory.createConcurrentList(true);
                }
                IObjectInfo<TemplateCacheInfo> otheroi = newSL.addUnlocked(currentSL.getObjectFromHead());
                myoi = newSL.addUnlocked(pTemplate);
                if (this._orderedStore.replace(fieldValue, currentSL, newSL)) break;
                newSL.removeUnlocked(otheroi);
                newSL.removeUnlocked(myoi);
                myoi = null;
                currentSL = null;
            }
            oi = myoi;
        }
        return oi;
    }

    @Override
    public void removeEntryIndexedField(IEntryHolder eh, Object fieldValue, TemplateCacheInfo pTemplate, IObjectInfo oi) {
        this.removeNonUniqueIndexedField(eh, fieldValue, pTemplate, oi);
        this._size.decrementAndGet();
    }

    private void removeNonUniqueIndexedField(IEntryHolder eh, Object fieldValue, TemplateCacheInfo pTemplate, IObjectInfo oi) {
        do {
            IStoredList<TemplateCacheInfo> templates;
            if ((templates = this._orderedStore.get(fieldValue)) == null) {
                throw new RuntimeException("Template Class: " + eh.getClassName() + " - Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field.");
            }
            if (templates.isMultiObjectCollection()) {
                IObjectInfo<TemplateCacheInfo> myoi = oi;
                if (myoi == pTemplate && (myoi = templates.getHead()).getSubject() != pTemplate) {
                    throw new RuntimeException("Template Class: " + eh.getClassName() + " - Single-template to multiple wrong OI ,  " + fieldValue.getClass() + " class field.");
                }
                templates.remove(myoi);
                if (!templates.invalidate()) break;
                this._orderedStore.remove(fieldValue, templates);
                break;
            }
            if (templates == pTemplate) continue;
            throw new RuntimeException("Template Class: " + eh.getClassName() + " - Single-template Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field.");
        } while (!this._orderedStore.remove(fieldValue, pTemplate));
    }

    @Override
    public ExtendedIndexIterator<TemplateCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive) {
        return this.establishScan((Object)startPos, relation, (Object)endPos, endPosInclusive, false);
    }

    @Override
    public ExtendedIndexIterator<TemplateCacheInfo> establishScan(K startPos, short relation, K endPos, boolean endPosInclusive, boolean ordered) {
        if (this.isEmpty()) {
            return null;
        }
        return (ordered |= true) ? this.establishScanOrdered(startPos, relation, endPos, endPosInclusive) : this.establishScanUnOrdered(startPos, relation, endPos, endPosInclusive);
    }

    private boolean isEmpty() {
        return this._size.get() == 0;
    }

    private ExtendedIndexIterator<TemplateCacheInfo> establishScanUnOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        boolean endInclusive;
        K end;
        boolean startinclusive;
        K start;
        short originalEndCondition;
        boolean reversedScan = relation == 4 || relation == 5;
        K originalStart = startPos;
        K originalEnd = endPos;
        short originalStartCondition = reversedScan ? (short)0 : relation;
        short s = originalEndCondition = !reversedScan ? (short)0 : relation;
        if (reversedScan) {
            start = endPos;
            startinclusive = endPosInclusive;
            end = startPos;
            endInclusive = relation == 5;
        } else {
            startinclusive = relation == 3;
            start = startPos;
            end = endPos;
            endInclusive = endPosInclusive;
        }
        FastConcurrentSkipListMap<K, IStoredList<TemplateCacheInfo>> baseMap = this._orderedStore;
        NavigableMap<K, Object> mapToScan = end == null ? (start != null ? baseMap.tailMap(start, startinclusive) : baseMap) : (start != null ? baseMap.subMap(start, startinclusive, end, endInclusive) : baseMap.headMap(end, endInclusive));
        return new ExtendedIndexIterator<TemplateCacheInfo>(mapToScan, this._index, originalStart, originalStartCondition, originalEnd, originalEndCondition);
    }

    private ExtendedIndexIterator<TemplateCacheInfo> establishScanOrdered(K startPos, short relation, K endPos, boolean endPosInclusive) {
        NavigableMap<K, IStoredList<TemplateCacheInfo>> baseMap;
        boolean reversedScan = relation == 4 || relation == 5;
        boolean startinclusive = relation == 3 || relation == 5;
        K originalStart = startPos;
        K originalEnd = endPos;
        short originalStartCondition = reversedScan ? (short)0 : relation;
        short originalEndCondition = !reversedScan ? (short)0 : relation;
        NavigableMap<K, IStoredList<TemplateCacheInfo>> navigableMap = baseMap = reversedScan ? this._orderedStore.descendingMap() : this._orderedStore;
        NavigableMap<K, IStoredList<TemplateCacheInfo>> mapToScan = endPos == null ? (startPos != null ? baseMap.tailMap(startPos, startinclusive) : baseMap) : (startPos != null ? baseMap.subMap(startPos, startinclusive, endPos, endPosInclusive) : baseMap.headMap(endPos, endPosInclusive));
        return new ExtendedIndexIterator<TemplateCacheInfo>(mapToScan, this._index, originalStart, originalStartCondition, originalEnd, originalEndCondition);
    }

    public FastConcurrentSkipListMap<K, IStoredList<TemplateCacheInfo>> getOrderedStore() {
        return this._orderedStore;
    }
}

