/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.time.SystemTime;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class TerminatingFifoXtnsInfo {
    public static final long UNKNOWN_FIFO_XTN = -1L;
    private volatile long _latestTransactionTerminationNum;
    public ConcurrentHashMap<FifoXtnEntryInfo, FifoXtnEntryInfo> _terminatingXtnsEntries = new ConcurrentHashMap();

    public long getLatestTTransactionTerminationNum() {
        return this._latestTransactionTerminationNum;
    }

    public void setLatestTransactionTerminationNum(long xtnTerminationNum) {
        this._latestTransactionTerminationNum = xtnTerminationNum;
    }

    public void setFifoCreationXtnInfoForEntry(IEntryHolder eh, long xtnNumber) {
        FifoXtnEntryInfo xe = new FifoXtnEntryInfo(eh.getUID(), eh.getSCN(), eh.getOrder());
        xe._creatingXtn = xtnNumber;
        xe.setTime();
        this._terminatingXtnsEntries.put(xe, xe);
    }

    public void updateFifoXtnInfoForEntry(IEntryHolder eh, long xtnNumber, boolean writeLock, boolean entryWritingXtn) {
        FifoXtnEntryInfo newXe = new FifoXtnEntryInfo(eh.getUID(), eh.getSCN(), eh.getOrder());
        FifoXtnEntryInfo xe = this._terminatingXtnsEntries.putIfAbsent(newXe, newXe);
        if (xe == null) {
            xe = newXe;
        }
        if (writeLock) {
            xe._writeLockInfo = entryWritingXtn ? new FifoXtnWriteLockEntryInfo(xtnNumber, xtnNumber) : new FifoXtnWriteLockEntryInfo(xtnNumber);
        } else {
            xe._terminatingXtnReadLock = xtnNumber;
        }
        xe.setTime();
    }

    public void removeFifoXtnInfoForEntry(IEntryHolder eh) {
        FifoXtnEntryInfo Xe = new FifoXtnEntryInfo(eh.getUID(), eh.getSCN(), eh.getOrder());
        this._terminatingXtnsEntries.remove(Xe);
    }

    public FifoXtnEntryInfo getFifoEntryXtnInfo(IEntryHolder eh) {
        FifoXtnEntryInfo Xe = new FifoXtnEntryInfo(eh.getUID(), eh.getSCN(), eh.getOrder());
        return this._terminatingXtnsEntries.get(Xe);
    }

    public ConcurrentHashMap<FifoXtnEntryInfo, FifoXtnEntryInfo> getTerminatingXtnsEntries() {
        return this._terminatingXtnsEntries;
    }

    public static boolean isSeqTransactionGT(long xtn1, long xtn2) {
        return xtn1 != -1L && xtn2 != -1L && (xtn1 > xtn2 || xtn1 < xtn2 && xtn2 - xtn1 > 1000000L);
    }

    public static class FifoXtnWriteLockEntryInfo {
        private long _terminatingXtnWriteLock;
        private long _entryWriteXtnNumber;

        public FifoXtnWriteLockEntryInfo(long terminatingXtnWriteLock, long entryWriteXtnNumber) {
            this._terminatingXtnWriteLock = terminatingXtnWriteLock;
            this._entryWriteXtnNumber = entryWriteXtnNumber;
        }

        public FifoXtnWriteLockEntryInfo(long terminatingXtnWriteLock) {
            this(terminatingXtnWriteLock, -1L);
        }

        public long getTerminatingXtnWriteLock() {
            return this._terminatingXtnWriteLock;
        }

        public long getEntryWriteXtnNumber() {
            return this._entryWriteXtnNumber;
        }
    }

    public static class FifoXtnEntryInfo {
        private String _UID;
        private long _scn;
        private int _order;
        private long _creatingXtn;
        private long _terminatingXtnReadLock;
        private volatile FifoXtnWriteLockEntryInfo _writeLockInfo;
        private volatile long _changeTime;

        public FifoXtnEntryInfo(String UID, long scn, int order) {
            this._UID = UID;
            this._scn = scn;
            this._order = order;
            this._terminatingXtnReadLock = -1L;
            this._creatingXtn = -1L;
        }

        public void setTime() {
            this._changeTime = SystemTime.timeMillis();
        }

        public long getCreatingXtn() {
            return this._creatingXtn;
        }

        public long getTerminatingXtnReadLock() {
            return this._terminatingXtnReadLock;
        }

        public long getTerminatingXtnWriteLock() {
            return this._writeLockInfo != null ? this._writeLockInfo.getTerminatingXtnWriteLock() : -1L;
        }

        public long getChangeTime() {
            return this._changeTime;
        }

        public String getUid() {
            return this._UID;
        }

        public long getEntryWriteXtnNumber() {
            return this._writeLockInfo != null ? this._writeLockInfo.getEntryWriteXtnNumber() : -1L;
        }

        public int hashCode() {
            return this._UID.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            FifoXtnEntryInfo otherInfo = (FifoXtnEntryInfo)other;
            return this._scn == otherInfo._scn && this._order == otherInfo._order && this._UID.equals(otherInfo._UID);
        }
    }
}

