/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.MatchTarget;
import com.gigaspaces.internal.server.space.SpaceUidFactory;
import com.gigaspaces.internal.server.space.metadata.TypeDataFactory;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.metadata.StorageType;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.ISpaceCompoundIndexSegment;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.query.extension.metadata.TypeQueryExtensions;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.admin.TemplateInfo;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CompoundCustomTypeDataIndex;
import com.j_spaces.core.cache.CompoundIndexSegmentTypeData;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.QueryExtensionIndexManagerWrapper;
import com.j_spaces.core.cache.SequenceNumberGenerator;
import com.j_spaces.core.cache.SpaceServerEntryImpl;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.FifoGroupCacheImpl;
import com.j_spaces.core.client.SequenceNumberException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TypeData {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private static final int _fifoCountRecheckFrom = 2147383647;
    private final CacheManager _cacheManager;
    private final String _className;
    private final String _classUidPrefix;
    private final PropertyInfo[] _properties;
    private final ConcurrentHashMap<String, TypeDataIndex<?>> _indexTable;
    private final boolean _hasIndexes;
    private final boolean _hasInitialIndexes;
    private final TypeDataIndex<Object>[] _indexes;
    private final int _numOfBackRefs;
    private final int _numOfCustomIndexes;
    private final TypeDataIndex<Object> _fifoGroupingIndex;
    private final TypeDataIndex<?> _idPropertyIndex;
    private IStoredList<IEntryCacheInfo> _entries;
    private final IStoredList<TemplateCacheInfo> _readTakeTemplates;
    private final IStoredList<TemplateCacheInfo> _notifyTemplates;
    private final IStoredList<TemplateCacheInfo> _readTakeExtendedTemplates;
    private final IStoredList<TemplateCacheInfo> _notifyExtendedTemplates;
    private final ConcurrentHashMap<String, IStoredList<TemplateCacheInfo>> _readTakeUidTemplates;
    private final ConcurrentHashMap<String, IStoredList<TemplateCacheInfo>> _notifyUidTemplates;
    private final boolean _fifoSupport;
    private final AtomicInteger _nextInFifoOrder;
    private final AtomicInteger m_NumRegularNotifyTemplatesStored;
    private final AtomicInteger _numDurableNotifyTemplatesStored;
    private final ConcurrentHashMap<String, Integer> _columnsOrdinalsByName;
    private final boolean _useConcurrentSl;
    private final TypeDataFactory _typeDataFactory;
    private volatile boolean _typeDataReplaced;
    private final boolean _supportsDynamicIndexing;
    private final ReentrantReadWriteLock _typeLock;
    private final int _lastIndexCreationNumber;
    private final int _lastIndexPendingCreationNumber;
    private final boolean _anyInitialExtendedIndex;
    private final boolean _allowFifoIndexScans;
    private final List<TypeDataIndex> _compoundIndexes;
    private final List<CompoundIndex> _compoundIndexDefinitions;
    private final boolean _anyNonFGCompoundIndex;
    private final List<TypeDataIndex> _uniqueIndexes;
    private final boolean _isLocalCache;
    private final boolean _isAutoGeneratedId;
    private final boolean _isBlobStoreClass;
    private final boolean[] _indexesRelatedFixedProperties;
    private final HashSet<String> _indexesRelatedDynamicProperties;
    private final SequenceNumberGenerator _sequenceNumberGenerator;
    private final TypeDataIndex<?> _sequenceNumberIndex;
    public static String Compound_Fifo_Groups_Index_Name_Suffix = "_COMPOUND_FIFO_GROUPS";
    private volatile Set<QueryExtensionIndexManagerWrapper> queryExtensionIndexManagers = new HashSet<QueryExtensionIndexManagerWrapper>();

    public String toString() {
        return "TypeData: " + this._className;
    }

    public TypeData(IServerTypeDesc serverTypeDesc, TypeDataFactory typeDataFactory, boolean isLocalCache, boolean isResidentEntriesCachePolicy) {
        if (serverTypeDesc == null) {
            throw new IllegalArgumentException("Argument cannot be null - 'serverTypeDesc'.");
        }
        if (serverTypeDesc.isInactive()) {
            throw new IllegalArgumentException("Cannot create TypeData for inactive type descriptor - '" + serverTypeDesc.getTypeName() + "'.");
        }
        this._cacheManager = typeDataFactory.getCcheManager();
        this._nextInFifoOrder = new AtomicInteger(0);
        this.m_NumRegularNotifyTemplatesStored = new AtomicInteger(0);
        this._numDurableNotifyTemplatesStored = new AtomicInteger(0);
        this._supportsDynamicIndexing = true;
        this._lastIndexCreationNumber = 0;
        this._lastIndexPendingCreationNumber = 0;
        this._typeDataFactory = typeDataFactory;
        this._isLocalCache = isLocalCache;
        this._isAutoGeneratedId = serverTypeDesc.getTypeDesc().isAutoGenerateId();
        int numOfCoresToUseSL = Integer.getInteger("com.gs.engine.coresToUseConcurrentSL", 2);
        this._useConcurrentSl = Runtime.getRuntime().availableProcessors() >= numOfCoresToUseSL;
        this._className = serverTypeDesc.getTypeName();
        this._classUidPrefix = SpaceUidFactory.generateTypePrefix(this._className);
        this._properties = serverTypeDesc.getTypeDesc().getProperties();
        this._indexTable = new ConcurrentHashMap();
        this._fifoSupport = serverTypeDesc.isFifoSupported();
        TypeDataIndex fifoGroupingIndex = null;
        ISpaceIndex fifoGroupingIndexDef = null;
        int numOfExtendedIndexes = 0;
        this._columnsOrdinalsByName = new ConcurrentHashMap();
        Map<String, SpaceIndex> typeIndexes = serverTypeDesc.getTypeDesc().getIndexes();
        ArrayList<TypeDataIndex> indexes = new ArrayList<TypeDataIndex>();
        boolean anyRequestsForFGCompound = false;
        this._compoundIndexes = new ArrayList<TypeDataIndex>();
        String fifoGroupingName = serverTypeDesc.getTypeDesc().getFifoGroupingPropertyPath();
        Set<String> fifoGroupingIndexes = serverTypeDesc.getTypeDesc().getFifoGroupingIndexesPaths();
        ArrayList<CompoundIndex> compoundIndexesToBuild = new ArrayList<CompoundIndex>();
        ArrayList uniqueIndexes = null;
        boolean[] indexesRelatedFixedProperties = new boolean[this._properties.length];
        HashSet<String> indexesRelatedDynamicProperties = new HashSet<String>();
        boolean bl = this._isBlobStoreClass = typeDataFactory.getCcheManager().isblobStoreDataSpace() && serverTypeDesc.getTypeDesc().isBlobstoreEnabled();
        if (serverTypeDesc.getTypeDesc().hasSequenceNumber()) {
            if (this._cacheManager.isEvictableCachePolicy() && !this._cacheManager.isMemorySpace()) {
                throw new SequenceNumberException(this._className, " sequence number not supported with persistent LRU");
            }
            this._sequenceNumberGenerator = new SequenceNumberGenerator();
        } else {
            this._sequenceNumberGenerator = null;
        }
        TypeDataIndex sequenceNumberIndex = null;
        for (int i = 0; i < this._properties.length; ++i) {
            PropertyInfo property = this._properties[i];
            this._columnsOrdinalsByName.put(property.getName(), i);
            SpaceIndex index = typeIndexes.get(property.getName());
            if (index == null || !index.getIndexType().isIndexed()) continue;
            if (((ISpaceIndex)index).isUnique()) {
                ISpaceIndex u = (ISpaceIndex)index;
                String string = serverTypeDesc.getTypeDesc().getIdPropertyName();
                if (string == null || !string.equals(u.getName())) {
                    if (isLocalCache) {
                        u.setUnique(false);
                    } else if (!isResidentEntriesCachePolicy) {
                        throw new UnsupportedOperationException("unique indices not supported for evictable cache policy=" + serverTypeDesc.getTypeName() + " index=" + u.getName());
                    }
                }
            }
            if (index.getIndexType().isOrdered()) {
                ++numOfExtendedIndexes;
            }
            TypeDataIndex currIndex = null;
            if (!((ISpaceIndex)index).isMultiValuePerEntryIndex()) {
                ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexTypes = TypeData.getIndexFifoGroupingType(index, fifoGroupingName, fifoGroupingIndexes);
                if (fifoGroupsIndexTypes == ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY) {
                    anyRequestsForFGCompound = true;
                }
                currIndex = typeDataFactory.createTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(index), i, 0, property.getType(), fifoGroupsIndexTypes);
            } else {
                currIndex = typeDataFactory.createMultiValuePerEntryTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(index), i, 0, ((ISpaceIndex)index).getMultiValueIndexType());
            }
            if (this.hasSequenceNumber() && serverTypeDesc.getTypeDesc().getSequenceNumberFixedPropertyID() == i) {
                if (currIndex.isUniqueIndex() && this._isLocalCache) {
                    ((ISpaceIndex)index).setUnique(false);
                }
                sequenceNumberIndex = currIndex;
            }
            indexes.add(currIndex);
            this._indexTable.put(property.getName(), currIndex);
            indexesRelatedFixedProperties[i] = true;
            if (currIndex.isUniqueIndex()) {
                if (uniqueIndexes == null) {
                    uniqueIndexes = new ArrayList();
                }
                uniqueIndexes.add(currIndex);
            }
            if (!currIndex.isFifoGroupsMainIndex()) continue;
            if (fifoGroupingIndex != null) {
                throw new UnsupportedOperationException(" only 1 fifo-group index can be defined per type");
            }
            fifoGroupingIndex = currIndex;
            fifoGroupingIndexDef = (ISpaceIndex)index;
        }
        String idProperty = serverTypeDesc.getTypeDesc().getIdPropertyName();
        this._idPropertyIndex = idProperty != null ? this._indexTable.get(idProperty) : null;
        int indexPosition = this._properties.length;
        int numOfCustomIndexes = 0;
        if (typeIndexes != null) {
            for (Map.Entry<String, SpaceIndex> entry : typeIndexes.entrySet()) {
                SpaceIndex spaceIndex;
                if (this._indexTable.containsKey(entry.getKey()) || !(spaceIndex = entry.getValue()).getIndexType().isIndexed()) continue;
                if (((ISpaceIndex)spaceIndex).isUnique()) {
                    ISpaceIndex u = (ISpaceIndex)spaceIndex;
                    if (isLocalCache) {
                        u.setUnique(false);
                    } else if (!isResidentEntriesCachePolicy) {
                        throw new UnsupportedOperationException("unique indices not supported for non All-In_cache policy type=" + serverTypeDesc.getTypeName() + " index=" + u.getName());
                    }
                }
                if (((ISpaceIndex)spaceIndex).isCompoundIndex()) {
                    compoundIndexesToBuild.add((CompoundIndex)spaceIndex);
                    continue;
                }
                TypeDataIndex currIndex = null;
                if (!((ISpaceIndex)spaceIndex).isMultiValuePerEntryIndex()) {
                    ISpaceIndex.FifoGroupsIndexTypes fifoGroupingType = TypeData.getIndexFifoGroupingType(spaceIndex, fifoGroupingName, fifoGroupingIndexes);
                    if (fifoGroupingType == ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY) {
                        anyRequestsForFGCompound = true;
                    }
                    currIndex = typeDataFactory.createCustomTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(spaceIndex), indexPosition++, 0, fifoGroupingType);
                } else {
                    currIndex = typeDataFactory.createCustomMultiValuePerEntryTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(spaceIndex), indexPosition++, 0, ((ISpaceIndex)spaceIndex).getMultiValueIndexType());
                }
                indexes.add(currIndex);
                this._indexTable.put(spaceIndex.getName(), currIndex);
                this.addIndexRelatedProperties(serverTypeDesc, spaceIndex, currIndex, false, indexesRelatedFixedProperties, indexesRelatedDynamicProperties);
                if (currIndex.isUniqueIndex()) {
                    if (uniqueIndexes == null) {
                        uniqueIndexes = new ArrayList();
                    }
                    uniqueIndexes.add(currIndex);
                }
                ++numOfCustomIndexes;
                if (!currIndex.isFifoGroupsMainIndex()) continue;
                if (fifoGroupingIndex != null) {
                    throw new UnsupportedOperationException(" only 1 fifo-grouping can be defined per type");
                }
                fifoGroupingIndex = currIndex;
                fifoGroupingIndexDef = (ISpaceIndex)spaceIndex;
            }
        }
        this._fifoGroupingIndex = fifoGroupingIndex;
        this._allowFifoIndexScans = this._fifoSupport || this._fifoGroupingIndex != null;
        for (CompoundIndex compoundIndex : compoundIndexesToBuild) {
            TypeDataIndex compound = TypeData.buildCompoundIndex(compoundIndex, this._indexTable, serverTypeDesc, indexPosition++, ISpaceIndex.FifoGroupsIndexTypes.NONE, 0, typeDataFactory);
            indexes.add(compound);
            this._compoundIndexes.add(compound);
            if (compound.isUniqueIndex()) {
                if (uniqueIndexes == null) {
                    uniqueIndexes = new ArrayList();
                }
                uniqueIndexes.add(compound);
            }
            this.addCompundIndexRelatedProperties(serverTypeDesc, compound, false, indexesRelatedFixedProperties, indexesRelatedDynamicProperties);
            ++numOfCustomIndexes;
            if (!compound.isExtendedIndex()) continue;
            ++numOfExtendedIndexes;
        }
        this._compoundIndexDefinitions = compoundIndexesToBuild;
        boolean bl2 = this._anyNonFGCompoundIndex = !this._compoundIndexes.isEmpty();
        if (this._fifoGroupingIndex != null && anyRequestsForFGCompound) {
            List<TypeDataIndex> fgCompounds = FifoGroupCacheImpl.createFifoGroupCompoundIndexes(this._properties, typeIndexes, this._indexTable, fifoGroupingIndex, fifoGroupingIndexDef, typeDataFactory, indexPosition, fifoGroupingName, fifoGroupingIndexes, this._compoundIndexDefinitions, serverTypeDesc);
            numOfCustomIndexes += fgCompounds.size();
            for (TypeDataIndex c : fgCompounds) {
                this._compoundIndexes.add(c);
                indexes.add(c);
                if (c.isExtendedIndex()) {
                    ++numOfExtendedIndexes;
                }
                this.addCompundIndexRelatedProperties(serverTypeDesc, c, false, indexesRelatedFixedProperties, indexesRelatedDynamicProperties);
            }
        }
        this._hasInitialIndexes = this._hasIndexes = this._indexTable.size() != 0;
        this._numOfBackRefs = this._indexTable.size() + numOfExtendedIndexes + 1;
        this._numOfCustomIndexes = numOfCustomIndexes;
        this._anyInitialExtendedIndex = numOfExtendedIndexes > 0;
        this._entries = this.createEntriesStoredList(this._fifoSupport || this._fifoGroupingIndex != null, this._useConcurrentSl);
        this._readTakeTemplates = TypeData.createStoreList(this._useConcurrentSl);
        this._notifyTemplates = TypeData.createStoreList(this._useConcurrentSl);
        this._readTakeExtendedTemplates = TypeData.createStoreList(this._useConcurrentSl);
        this._notifyExtendedTemplates = TypeData.createStoreList(this._useConcurrentSl);
        this._readTakeUidTemplates = new ConcurrentHashMap();
        this._notifyUidTemplates = new ConcurrentHashMap();
        this._typeLock = new ReentrantReadWriteLock();
        TypeDataIndex[] temp_i = new TypeDataIndex[indexes.size()];
        if (indexes.size() > 0) {
            temp_i = indexes.toArray(temp_i);
        }
        this._indexes = temp_i;
        this._uniqueIndexes = uniqueIndexes != null ? new ArrayList<TypeDataIndex>(uniqueIndexes) : null;
        this._indexesRelatedFixedProperties = indexesRelatedFixedProperties;
        this._indexesRelatedDynamicProperties = indexesRelatedDynamicProperties;
        this._sequenceNumberIndex = sequenceNumberIndex;
        ITypeDesc iTypeDesc = serverTypeDesc.getTypeDesc();
        TypeQueryExtensions queryExtensionsInfo = iTypeDesc.getQueryExtensions();
        if (queryExtensionsInfo != null) {
            for (String namespace : queryExtensionsInfo.getNamespaces()) {
                try {
                    QueryExtensionIndexManagerWrapper manager = this._cacheManager.getQueryExtensionManager(namespace);
                    manager.introduceType(iTypeDesc);
                    this.queryExtensionIndexManagers.add(manager);
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "Failed to install query extension manager for " + namespace, e);
                }
            }
        }
    }

    public static ISpaceIndex.FifoGroupsIndexTypes getIndexFifoGroupingType(SpaceIndex spaceIndex, String fifoGroupingName, Set<String> fifoGroupingIndexes) {
        if (spaceIndex.getName().equals(fifoGroupingName)) {
            return ISpaceIndex.FifoGroupsIndexTypes.MAIN;
        }
        if (fifoGroupingIndexes != null && fifoGroupingIndexes.contains(spaceIndex.getName())) {
            return ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY;
        }
        return ISpaceIndex.FifoGroupsIndexTypes.NONE;
    }

    public TypeData(IServerTypeDesc serverTypeDesc, TypeData originalTypeData, TypeDataRecreationReasons reason) {
        if (!originalTypeData.supportsDynamicIndexing()) {
            throw new UnsupportedOperationException();
        }
        this._cacheManager = originalTypeData._cacheManager;
        this._nextInFifoOrder = originalTypeData._nextInFifoOrder;
        this.m_NumRegularNotifyTemplatesStored = originalTypeData.m_NumRegularNotifyTemplatesStored;
        this._numDurableNotifyTemplatesStored = originalTypeData._numDurableNotifyTemplatesStored;
        this._supportsDynamicIndexing = true;
        this._typeDataFactory = originalTypeData._typeDataFactory;
        this._isLocalCache = originalTypeData._isLocalCache;
        this._isAutoGeneratedId = originalTypeData._isAutoGeneratedId;
        this._useConcurrentSl = originalTypeData._useConcurrentSl;
        this._className = originalTypeData._className;
        this._classUidPrefix = originalTypeData._classUidPrefix;
        this._properties = serverTypeDesc.getTypeDesc().getProperties();
        this._fifoSupport = originalTypeData._fifoSupport;
        this._columnsOrdinalsByName = originalTypeData._columnsOrdinalsByName;
        this._entries = originalTypeData._entries;
        this._typeLock = originalTypeData._typeLock;
        this._hasInitialIndexes = originalTypeData._hasInitialIndexes;
        this._anyInitialExtendedIndex = originalTypeData._anyInitialExtendedIndex;
        this._isBlobStoreClass = originalTypeData._isBlobStoreClass;
        boolean[] indexesRelatedFixedProperties = new boolean[originalTypeData._indexesRelatedFixedProperties.length];
        System.arraycopy(originalTypeData._indexesRelatedFixedProperties, 0, indexesRelatedFixedProperties, 0, indexesRelatedFixedProperties.length);
        HashSet<String> indexesRelatedDynamicProperties = new HashSet<String>(originalTypeData._indexesRelatedDynamicProperties);
        this._sequenceNumberGenerator = originalTypeData._sequenceNumberGenerator;
        Object sequenceNumberIndex = originalTypeData._sequenceNumberIndex;
        if (reason == TypeDataRecreationReasons.DYNAMIC_INDEX_CREATION) {
            ArrayList<Object> indexes = new ArrayList<Object>();
            ArrayList<TypeDataIndex> compoundIndexes = new ArrayList<TypeDataIndex>(originalTypeData._compoundIndexes);
            boolean anyNonFGCompoundIndex = originalTypeData._anyNonFGCompoundIndex;
            int numOfExtendedIndexes = 0;
            this._indexTable = originalTypeData._indexTable;
            HashMap<String, Object> nonCustomIndexes = new HashMap<String, Object>();
            ArrayList<CompoundIndex> compoundIndexDefinitions = new ArrayList<CompoundIndex>(originalTypeData._compoundIndexDefinitions);
            ArrayList<CompoundIndex> newCompounds = new ArrayList<CompoundIndex>();
            this._lastIndexCreationNumber = originalTypeData._lastIndexCreationNumber;
            int numNewIndexes = 0;
            Map<String, SpaceIndex> typeIndexes = serverTypeDesc.getTypeDesc().getIndexes();
            for (int i = 0; i < this._properties.length; ++i) {
                Object currIndex;
                boolean bl;
                PropertyInfo property = this._properties[i];
                this._columnsOrdinalsByName.put(property.getName(), i);
                SpaceIndex index = typeIndexes.get(property.getName());
                if (index == null || !index.getIndexType().isIndexed()) continue;
                if (index.getIndexType().isOrdered()) {
                    ++numOfExtendedIndexes;
                }
                boolean bl2 = bl = (currIndex = this._indexTable.get(property.getName())) == null;
                if (bl) {
                    if (((ISpaceIndex)index).isUnique()) {
                        ISpaceIndex u = (ISpaceIndex)index;
                        if (this._isLocalCache) {
                            u.setUnique(false);
                        } else {
                            throw new UnsupportedOperationException("dynamic unique indices not supported type=" + serverTypeDesc.getTypeName() + " index=" + u.getName());
                        }
                    }
                    currIndex = !((ISpaceIndex)index).isMultiValuePerEntryIndex() ? this._typeDataFactory.createTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(index), i, this._lastIndexCreationNumber + numNewIndexes, property.getType(), ISpaceIndex.FifoGroupsIndexTypes.NONE) : this._typeDataFactory.createMultiValuePerEntryTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(index), i, this._lastIndexCreationNumber + ++numNewIndexes, ((ISpaceIndex)index).getMultiValueIndexType());
                    if (this.hasSequenceNumber() && serverTypeDesc.getTypeDesc().getSequenceNumberFixedPropertyID() == i) {
                        sequenceNumberIndex = currIndex;
                    }
                    indexesRelatedFixedProperties[i] = true;
                }
                indexes.add(currIndex);
                if (bl) {
                    this._indexTable.put(property.getName(), (TypeDataIndex<?>)currIndex);
                }
                nonCustomIndexes.put(property.getName(), currIndex);
            }
            String idProperty = serverTypeDesc.getTypeDesc().getIdPropertyName();
            this._idPropertyIndex = idProperty != null ? this._indexTable.get(idProperty) : null;
            int indexPosition = this._properties.length;
            int numOfCustomIndexes = 0;
            if (typeIndexes != null) {
                for (TypeDataIndex<Object> index : originalTypeData._indexes) {
                    if (!index.isCustomIndex()) continue;
                    indexes.add(index);
                    indexPosition = index.getPos() + 1;
                    ++numOfCustomIndexes;
                }
                for (Map.Entry entry : typeIndexes.entrySet()) {
                    TypeDataIndex<Object> currIndex;
                    boolean newIndex;
                    SpaceIndex spaceIndex;
                    if (nonCustomIndexes.containsKey(entry.getKey()) || !(spaceIndex = (SpaceIndex)entry.getValue()).getIndexType().isIndexed() || !(newIndex = (currIndex = this._indexTable.get(spaceIndex.getName())) == null)) continue;
                    if (((ISpaceIndex)spaceIndex).isUnique()) {
                        ISpaceIndex u = (ISpaceIndex)spaceIndex;
                        if (this._isLocalCache) {
                            u.setUnique(false);
                        } else {
                            throw new UnsupportedOperationException("dynamic unique indices not supported type=" + serverTypeDesc.getTypeName() + " index=" + u.getName());
                        }
                    }
                    if (((ISpaceIndex)spaceIndex).isCompoundIndex()) {
                        newCompounds.add((CompoundIndex)spaceIndex);
                        continue;
                    }
                    currIndex = !((ISpaceIndex)spaceIndex).isMultiValuePerEntryIndex() ? this._typeDataFactory.createCustomTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(spaceIndex), indexPosition++, this._lastIndexCreationNumber + numNewIndexes, ISpaceIndex.FifoGroupsIndexTypes.NONE) : this._typeDataFactory.createCustomMultiValuePerEntryTypeDataIndex(this._typeDataFactory.getCcheManager(), TypeData.getInternalIndex(spaceIndex), indexPosition++, this._lastIndexCreationNumber + ++numNewIndexes, ((ISpaceIndex)spaceIndex).getMultiValueIndexType());
                    indexes.add(currIndex);
                    this._indexTable.put(spaceIndex.getName(), currIndex);
                    ++numOfCustomIndexes;
                    this.addIndexRelatedProperties(serverTypeDesc, spaceIndex, currIndex, true, indexesRelatedFixedProperties, indexesRelatedDynamicProperties);
                }
                for (CompoundIndex compoundIndex : newCompounds) {
                    TypeDataIndex compound = TypeData.buildCompoundIndex(compoundIndex, this._indexTable, serverTypeDesc, indexPosition++, ISpaceIndex.FifoGroupsIndexTypes.NONE, this._lastIndexCreationNumber + ++numNewIndexes, this._typeDataFactory);
                    indexes.add(compound);
                    anyNonFGCompoundIndex = true;
                    compoundIndexDefinitions.add(compoundIndex);
                    compoundIndexes.add(compound);
                    ++numOfCustomIndexes;
                    if (compound.isExtendedIndex()) {
                        ++numOfExtendedIndexes;
                    }
                    this.addCompundIndexRelatedProperties(serverTypeDesc, compound, true, indexesRelatedFixedProperties, indexesRelatedDynamicProperties);
                }
            }
            this._hasIndexes = this._indexTable.size() != 0;
            this._numOfBackRefs = this._indexTable.size() + numOfExtendedIndexes + 1;
            this._numOfCustomIndexes = numOfCustomIndexes;
            TypeDataIndex[] temp_i = new TypeDataIndex[indexes.size()];
            if (indexes.size() > 0) {
                temp_i = indexes.toArray(temp_i);
            }
            this._indexes = temp_i;
            this._lastIndexPendingCreationNumber = numNewIndexes > 0 ? this._lastIndexCreationNumber + numNewIndexes : 0;
            this._compoundIndexes = compoundIndexes;
            this._compoundIndexDefinitions = compoundIndexDefinitions;
            this._anyNonFGCompoundIndex = anyNonFGCompoundIndex;
        } else if (reason == TypeDataRecreationReasons.DYNAMIC_INDEX_CREATION_COMPLETION) {
            this._indexTable = originalTypeData._indexTable;
            this._idPropertyIndex = originalTypeData._idPropertyIndex;
            this._indexes = originalTypeData._indexes;
            this._hasIndexes = originalTypeData._hasIndexes;
            this._numOfBackRefs = originalTypeData._numOfBackRefs;
            this._numOfCustomIndexes = originalTypeData._numOfCustomIndexes;
            this._lastIndexCreationNumber = originalTypeData._lastIndexPendingCreationNumber > 0 ? originalTypeData._lastIndexPendingCreationNumber : originalTypeData._lastIndexCreationNumber;
            this._lastIndexPendingCreationNumber = 0;
            this._compoundIndexDefinitions = originalTypeData._compoundIndexDefinitions;
            this._compoundIndexes = originalTypeData._compoundIndexes;
            this._anyNonFGCompoundIndex = originalTypeData._anyNonFGCompoundIndex;
        } else {
            throw new UnsupportedOperationException();
        }
        this._readTakeTemplates = originalTypeData._readTakeTemplates;
        this._notifyTemplates = originalTypeData._notifyTemplates;
        this._readTakeExtendedTemplates = originalTypeData._readTakeExtendedTemplates;
        this._notifyExtendedTemplates = originalTypeData._notifyExtendedTemplates;
        this._readTakeUidTemplates = originalTypeData._readTakeUidTemplates;
        this._notifyUidTemplates = originalTypeData._notifyUidTemplates;
        this._fifoGroupingIndex = originalTypeData._fifoGroupingIndex;
        this._allowFifoIndexScans = this._fifoSupport | this._fifoGroupingIndex != null;
        this._uniqueIndexes = originalTypeData._uniqueIndexes;
        this._indexesRelatedFixedProperties = indexesRelatedFixedProperties;
        this._indexesRelatedDynamicProperties = indexesRelatedDynamicProperties;
        this._sequenceNumberIndex = sequenceNumberIndex;
        this.queryExtensionIndexManagers = originalTypeData.queryExtensionIndexManagers;
    }

    public Set<QueryExtensionIndexManagerWrapper> getForeignQueriesHandlers() {
        return this.queryExtensionIndexManagers;
    }

    public boolean isUsingQueryExtensionIndexManager() {
        return this.queryExtensionIndexManagers != null && !this.queryExtensionIndexManagers.isEmpty();
    }

    public static TypeDataIndex buildCompoundIndex(CompoundIndex definition, Map<String, TypeDataIndex<?>> indexTable, IServerTypeDesc serverTypeDesc, int indexPosition, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType, int indexCreationNumber, TypeDataFactory typeDataFactory) {
        if (indexTable.containsKey(definition)) {
            throw new IllegalArgumentException("duplicate index name=" + definition.getName());
        }
        if (!serverTypeDesc.getTypeDesc().supportsDynamicProperties()) {
            for (int i = 0; i < definition.getNumSegments(); ++i) {
                String root;
                String path = definition.getCompoundIndexSegments()[i].getName();
                String string = root = path.indexOf(".") != -1 ? path.substring(0, path.indexOf(".")) : path;
                if (serverTypeDesc.getTypeDesc().getFixedPropertyPosition(root) == -1) {
                    throw new IllegalArgumentException("path has to be based on a property " + root);
                }
                if (serverTypeDesc.getTypeDesc().getFixedProperty(root).getStorageType() == StorageType.OBJECT || serverTypeDesc.getTypeDesc().getFixedProperty(root).getStorageType() == StorageType.DEFAULT && serverTypeDesc.getTypeDesc().getStorageType() == StorageType.OBJECT) continue;
                throw new IllegalArgumentException("invalid compound index segment storage type " + root);
            }
        }
        CompoundIndexSegmentTypeData[] segments = new CompoundIndexSegmentTypeData[definition.getNumSegments()];
        HashSet names = new HashSet();
        for (int i = 0; i < segments.length; ++i) {
            if (names.contains(definition.getCompoundIndexSegments()[i].getName())) {
                throw new UnsupportedOperationException("duplicate segment name=" + definition.getCompoundIndexSegments()[i].getName() + " index=" + definition.getName());
            }
            segments[i] = new CompoundIndexSegmentTypeData(definition.getCompoundIndexSegments()[i], indexTable, serverTypeDesc);
        }
        if (indexCreationNumber == 0 && fifoGroupsIndexType != ISpaceIndex.FifoGroupsIndexTypes.COMPOUND && segments.length == 2 && segments[1].getOriginatingIndex() != null && segments[1].getOriginatingIndex().isFifoGroupsMainIndex() && segments[0].getOriginatingIndex() != null && segments[0].getOriginatingIndex().getFifoGroupsIndexType() == ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY && !segments[0].getOriginatingIndex().getIndexDefinition().isMultiValuePerEntryIndex()) {
            fifoGroupsIndexType = ISpaceIndex.FifoGroupsIndexTypes.COMPOUND;
        }
        TypeDataIndex newIndex = typeDataFactory.createCompoundCustomTypeDataIndex(typeDataFactory.getCcheManager(), definition, segments, indexCreationNumber, indexPosition, fifoGroupsIndexType);
        if (fifoGroupsIndexType == ISpaceIndex.FifoGroupsIndexTypes.COMPOUND) {
            segments[0].getOriginatingIndex().setCompoundFifoGroupsIndexForSegment(newIndex);
        }
        indexTable.put(definition.getName(), newIndex);
        return newIndex;
    }

    private void addCompundIndexRelatedProperties(IServerTypeDesc serverTypeDesc, TypeDataIndex c, boolean fromAddIndex, boolean[] indexesRelatedFixedProperties, HashSet<String> indexesRelatedDynamicProperties) {
        CompoundIndexSegmentTypeData[] segs;
        for (CompoundIndexSegmentTypeData segData : segs = ((CompoundCustomTypeDataIndex)c).getCompoundIndexSegments()) {
            String root;
            ISpaceCompoundIndexSegment seg = segData.getDefinitionSegment();
            int pos = seg.getName().indexOf(".");
            String string = root = pos == -1 ? seg.getName() : seg.getName().substring(0, pos);
            if (serverTypeDesc.getTypeDesc().getFixedPropertyPosition(root) != -1) {
                indexesRelatedFixedProperties[serverTypeDesc.getTypeDesc().getFixedPropertyPosition((String)root)] = true;
                continue;
            }
            if (serverTypeDesc.getTypeDesc().supportsDynamicProperties()) {
                indexesRelatedDynamicProperties.add(root);
                continue;
            }
            if (fromAddIndex) continue;
            throw new RuntimeException("invalid root segment property in compoundindex root=" + root);
        }
    }

    private void addIndexRelatedProperties(IServerTypeDesc serverTypeDesc, SpaceIndex indexDefinition, TypeDataIndex index, boolean fromAddIndex, boolean[] indexesRelatedFixedProperties, HashSet<String> indexesRelatedDynamicProperties) {
        String root;
        int pos = indexDefinition.getName().indexOf(".");
        String string = root = pos == -1 ? indexDefinition.getName() : indexDefinition.getName().substring(0, pos);
        if (index.isMultiValuePerEntryIndex()) {
            pos = root.indexOf("[");
            String string2 = root = pos == -1 ? root : root.substring(0, pos);
        }
        if (serverTypeDesc.getTypeDesc().getFixedPropertyPosition(root) != -1) {
            indexesRelatedFixedProperties[serverTypeDesc.getTypeDesc().getFixedPropertyPosition((String)root)] = true;
        } else if (serverTypeDesc.getTypeDesc().supportsDynamicProperties()) {
            indexesRelatedDynamicProperties.add(root);
        } else if (!fromAddIndex) {
            throw new RuntimeException("invalid root property in index root=" + root);
        }
    }

    private static <T> IStoredList<T> createStoreList(boolean isConcurrent) {
        if (isConcurrent) {
            return StoredListFactory.createConcurrentSegmentedList(true, 1, true);
        }
        return StoredListFactory.createList(false);
    }

    public IStoredList<IEntryCacheInfo> getEntries() {
        return this._entries;
    }

    public IScanListIterator<IEntryCacheInfo> scanTypeEntries() {
        if (this.getEntries() == null) {
            return null;
        }
        return new ScanSingleListIterator<IEntryCacheInfo>(this.getEntries(), false);
    }

    public PropertyInfo getProperty(int propertyID) {
        return this._properties[propertyID];
    }

    public IStoredList<TemplateCacheInfo> getTemplates(MatchTarget matchTarget) {
        return matchTarget == MatchTarget.NOTIFY ? this._notifyTemplates : this._readTakeTemplates;
    }

    public IStoredList<TemplateCacheInfo> getNotifyTemplates() {
        return this._notifyTemplates;
    }

    public IStoredList<TemplateCacheInfo> getReadTakeTemplates() {
        return this._readTakeTemplates;
    }

    public boolean hasIndexes() {
        return this._hasIndexes;
    }

    public String getClassName() {
        return this._className;
    }

    public String generateUid(Object id) {
        return SpaceUidFactory.generateUid(this._classUidPrefix, id.toString());
    }

    public CacheManager getCacheManager() {
        return this._cacheManager;
    }

    public int getFieldOrdinal(String fieldName) {
        Integer res = this._columnsOrdinalsByName.get(fieldName);
        return res == null ? -1 : res;
    }

    public TypeDataIndex<?> getIndex(String indexName) {
        return this._indexTable.get(indexName);
    }

    public TypeDataIndex[] getIndexes() {
        return this._indexes;
    }

    public int numberOfBackRefs() {
        return this._numOfBackRefs;
    }

    public IStoredList<TemplateCacheInfo> getExtendedTemplates(MatchTarget matchTarget) {
        return matchTarget == MatchTarget.NOTIFY ? this._notifyExtendedTemplates : this._readTakeExtendedTemplates;
    }

    public IStoredList<TemplateCacheInfo> getNotifyExtendedTemplates() {
        return this._notifyExtendedTemplates;
    }

    public IStoredList<TemplateCacheInfo> getReadTakeExtendedTemplates() {
        return this._readTakeExtendedTemplates;
    }

    public IStoredList<TemplateCacheInfo> getUidTemplates(MatchTarget matchTarget, String uid) {
        return matchTarget == MatchTarget.NOTIFY ? this._notifyUidTemplates.get(uid) : this._readTakeUidTemplates.get(uid);
    }

    public ConcurrentHashMap<String, IStoredList<TemplateCacheInfo>> getNotifyUidTemplates() {
        return this._notifyUidTemplates;
    }

    public ConcurrentHashMap<String, IStoredList<TemplateCacheInfo>> getReadTakeUidTemplates() {
        return this._readTakeUidTemplates;
    }

    public List<TemplateInfo> fillTemplatesInfo(List<TemplateInfo> templates) {
        this.addTemplatesInfo(templates, this._notifyTemplates);
        this.addTemplatesInfo(templates, this._notifyExtendedTemplates);
        if (this._hasIndexes) {
            this.addTemplatesInfo(templates, this._indexes[0]._NNullTemplates);
            for (IStoredList[] iStoredListArray : this._indexes[0]._NTemplates.values()) {
                this.addTemplatesInfo(templates, iStoredListArray[0]);
            }
        }
        for (IStoredList<TemplateCacheInfo> iStoredList : this._notifyUidTemplates.values()) {
            this.addTemplatesInfo(templates, iStoredList);
        }
        return templates;
    }

    private void addTemplatesInfo(List<TemplateInfo> templates, IStoredList<TemplateCacheInfo> list) {
        IStoredListIterator pos = list.establishListScan(false);
        while (pos != null) {
            TemplateCacheInfo template = (TemplateCacheInfo)pos.getSubject();
            if (template != null && !template.m_TemplateHolder.isDeleted()) {
                TemplateInfo info = this.createTemplateInfo(template.m_TemplateHolder);
                templates.add(info);
            }
            pos = list.next(pos);
        }
    }

    private TemplateInfo createTemplateInfo(ITemplateHolder template) {
        return new TemplateInfo(template.isFifoTemplate(), new Date(template.getExpirationTime()), template.getEntryData().getFixedPropertiesValues(), template.getUidToOperateBy(), template.getOperationModifiers());
    }

    public int getTotalNotifyTemplates() {
        return this.m_NumRegularNotifyTemplatesStored.get() + this._numDurableNotifyTemplatesStored.get();
    }

    public int getM_NumRegularNotifyTemplatesStored() {
        return this.m_NumRegularNotifyTemplatesStored.get();
    }

    public int decM_NumRegularNotifyTemplatesStored() {
        return this.m_NumRegularNotifyTemplatesStored.decrementAndGet();
    }

    public int incM_NumRegularNotifyTemplatesStored() {
        return this.m_NumRegularNotifyTemplatesStored.incrementAndGet();
    }

    public int decNumDurableNotificationsStored() {
        return this._numDurableNotifyTemplatesStored.decrementAndGet();
    }

    public int incNumDurableNotificationsStored() {
        return this._numDurableNotifyTemplatesStored.incrementAndGet();
    }

    private IStoredList<IEntryCacheInfo> createEntriesStoredList(boolean fifoSupport, boolean useConcurrentStoreList) {
        if (fifoSupport) {
            if (useConcurrentStoreList) {
                if (this._fifoGroupingIndex != null) {
                    return StoredListFactory.createConcurrentSegmentedList(true, 0, true);
                }
                return StoredListFactory.createConcurrentSegmentedList(true, 1, true);
            }
            return StoredListFactory.createRandomScanList(false);
        }
        if (useConcurrentStoreList) {
            return StoredListFactory.createConcurrentSegmentedList(false);
        }
        return StoredListFactory.createSegmentedList();
    }

    public boolean isFifoSupport() {
        return this._fifoSupport;
    }

    public boolean isAllowFifoIndexScans() {
        return this._allowFifoIndexScans;
    }

    public TypeDataIndex getIdField() {
        return this._idPropertyIndex;
    }

    public boolean disableIdIndexForEntries(TypeDataIndex index) {
        return !this._cacheManager.forceSpaceIdIndexIfEqual() && this.getIdField() == index && !index.isExtendedIndex() && !this._isAutoGeneratedId;
    }

    public boolean isBlobStoreClass() {
        return this._isBlobStoreClass;
    }

    List<TypeDataIndex> getUniqueIndexes() {
        return this._uniqueIndexes;
    }

    int getNumUniqueIndexes() {
        return this._uniqueIndexes == null ? 0 : this._uniqueIndexes.size();
    }

    public boolean[] getIndexesRelatedFixedProperties() {
        return this._indexesRelatedFixedProperties;
    }

    public HashSet<String> getIndexesRelatedDynamicProperties() {
        return this._indexesRelatedDynamicProperties;
    }

    public boolean hasSequenceNumber() {
        return this._sequenceNumberGenerator != null;
    }

    public SequenceNumberGenerator getSequenceNumberGenerator() {
        return this._sequenceNumberGenerator;
    }

    public boolean hasSequenceNumberIndex() {
        return this._sequenceNumberIndex != null;
    }

    public TypeDataIndex<?> getSequenceNumberIndex() {
        return this._sequenceNumberIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFifoOrderFieldsForEntry(IEntryHolder eh) {
        while (true) {
            eh.setOrder(this._nextInFifoOrder.incrementAndGet());
            if (eh.getOrder() < 0) {
                long starttine = SystemTime.timeMillis();
                do {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (SystemTime.timeMillis() == starttine);
                TypeData typeData = this;
                synchronized (typeData) {
                    if (this._nextInFifoOrder.get() < 0) {
                        this._nextInFifoOrder.set(0);
                    }
                }
            }
            eh.setSCN(SystemTime.timeMillis());
            if (2147383647 > eh.getOrder() || eh.getOrder() <= this._nextInFifoOrder.get()) break;
        }
    }

    public void updateEntryReferences(CacheManager cacheManager, IEntryHolder eh, IEntryCacheInfo pEntry, IEntryData oldEntryData) {
        if (!this.hasIndexes()) {
            return;
        }
        if (pEntry.getEntryHolder(cacheManager).hasShadow()) {
            this.updateEntryReferencesUnderXtn(cacheManager, pEntry, oldEntryData);
            return;
        }
        boolean insertedNewValues = false;
        int refpos = 1;
        ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs = pEntry.getBackRefs();
        if (deletedBackRefs != null) {
            pEntry.setBackRefs(new ArrayList<IObjectInfo<IEntryCacheInfo>>(deletedBackRefs.size()));
            pEntry.getBackRefs().add(deletedBackRefs.get(0));
        }
        IEntryData entryData = pEntry.getEntryHolder(cacheManager).getEntryData();
        int numOfFieldsDone = 0;
        ArrayList<Object> originalUniques = null;
        try {
            for (TypeDataIndex<Object> index : this._indexes) {
                if (index.disableIndexUsageForOperation(this, pEntry.getLatestIndexCreationNumber())) continue;
                Object fieldValue = index.getIndexValue(entryData);
                Object oldFieldValue = index.getIndexValue(oldEntryData);
                if (index.isUniqueIndex() && this.getNumUniqueIndexes() > 1) {
                    int originalpos = refpos;
                    refpos = index.updateIndexValue(this, pEntry.getEntryHolder(cacheManager), pEntry, oldFieldValue, fieldValue, deletedBackRefs, refpos, TypeDataIndex.UpdateIndexModes.INSERT_NONEQUALS);
                    if (deletedBackRefs != null) {
                        if (deletedBackRefs.get(originalpos) != null) {
                            if (originalUniques == null) {
                                originalUniques = new ArrayList<Object>(this.getNumUniqueIndexes() * 2);
                            }
                            originalUniques.add(index);
                            originalUniques.add(originalpos);
                        }
                    } else if (!TypeData.objectsEquality(oldFieldValue, fieldValue)) {
                        if (originalUniques == null) {
                            originalUniques = new ArrayList(this.getNumUniqueIndexes() * 2);
                        }
                        originalUniques.add(index);
                        originalUniques.add(-1);
                    }
                } else {
                    refpos = index.updateIndexValue(this, pEntry.getEntryHolder(cacheManager), pEntry, oldFieldValue, fieldValue, deletedBackRefs, refpos, TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS);
                }
                ++numOfFieldsDone;
            }
            for (QueryExtensionIndexManagerWrapper queryExtensionIndexManager : this.getForeignQueriesHandlers()) {
                try {
                    queryExtensionIndexManager.replaceEntry(new SpaceServerEntryImpl(pEntry, cacheManager));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Remove entry to foreign index failed", ex);
                }
            }
            insertedNewValues = true;
            if (originalUniques != null) {
                for (int pos = 0; pos < originalUniques.size(); ++pos) {
                    TypeDataIndex index = (TypeDataIndex)originalUniques.get(pos++);
                    Object fieldValue = index.getIndexValue(entryData);
                    Object oldFieldValue = index.getIndexValue(oldEntryData);
                    refpos = (Integer)originalUniques.get(pos);
                    index.updateIndexValue(this, pEntry.getEntryHolder(cacheManager), pEntry, oldFieldValue, fieldValue, deletedBackRefs, refpos, TypeDataIndex.UpdateIndexModes.REMOVE_NONEQUALS);
                }
            }
        }
        catch (RuntimeException ex) {
            block21: {
                try {
                    this.restoreReferencesAfterUpdateFailure(cacheManager, eh, pEntry, oldEntryData, deletedBackRefs, numOfFieldsDone, insertedNewValues, originalUniques);
                }
                catch (Exception ex1) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block21;
                    _logger.log(Level.SEVERE, "failed to restore entry after update failure ", ex1);
                }
            }
            throw ex;
        }
    }

    private void restoreReferencesAfterUpdateFailure(CacheManager cacheManager, IEntryHolder eh, IEntryCacheInfo pEntry, IEntryData originalEntryData, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, int numOfUpdatedFields, boolean insertedNewValues, ArrayList<Object> originalUniques) {
        if (insertedNewValues) {
            return;
        }
        ArrayList<IObjectInfo<IEntryCacheInfo>> failedBackRefs = pEntry.getBackRefs();
        IEntryData failedEntryData = pEntry.getEntryHolder(cacheManager).getEntryData();
        int refpos = 1;
        if (originalBackRefs != null) {
            pEntry.setBackRefs(new ArrayList<IObjectInfo<IEntryCacheInfo>>(originalBackRefs.size()));
            pEntry.getBackRefs().add(failedBackRefs.get(0));
        }
        int numOfFieldsDone = 0;
        eh.updateEntryData(originalEntryData, originalEntryData.getExpirationTime());
        for (TypeDataIndex<Object> index : this._indexes) {
            if (index.disableIndexUsageForOperation(this, pEntry.getLatestIndexCreationNumber())) continue;
            if (numOfFieldsDone < numOfUpdatedFields) {
                Object originalValue = index.getIndexValue(originalEntryData);
                Object failedValue = index.getIndexValue(failedEntryData);
                if (originalUniques != null && index.isUniqueIndex() && originalUniques.contains(index)) {
                    refpos = index.updateIndexValue(this, pEntry.getEntryHolder(cacheManager), pEntry, failedValue, originalValue, failedBackRefs, refpos, TypeDataIndex.UpdateIndexModes.REMOVE_NONEQUALS);
                    if (originalBackRefs != null) {
                        pEntry.getBackRefs().add(originalBackRefs.get(pEntry.getBackRefs().size()));
                        if (index.numOfEntryIndexBackRefs(originalValue) == 2) {
                            pEntry.getBackRefs().add(originalBackRefs.get(pEntry.getBackRefs().size()));
                        }
                    }
                } else {
                    refpos = index.updateIndexValue(this, pEntry.getEntryHolder(cacheManager), pEntry, failedValue, originalValue, failedBackRefs, refpos, TypeDataIndex.UpdateIndexModes.REPLACE_NONEQUALS);
                }
                ++numOfFieldsDone;
                continue;
            }
            break;
        }
        if (originalBackRefs != null) {
            for (int i = pEntry.getBackRefs().size(); i < originalBackRefs.size(); ++i) {
                pEntry.getBackRefs().add(originalBackRefs.get(i));
            }
        }
    }

    public void prepareForUpdatingIndexValues(CacheManager cacheManager, IEntryCacheInfo pEntry, IEntryData newEntryData) {
        if (!this.hasIndexes() || !this._typeDataFactory.useEconomyHashMap()) {
            return;
        }
        IEntryData entryData = pEntry.getEntryHolder(cacheManager).getEntryData();
        for (TypeDataIndex<Object> index : this._indexes) {
            Object newFieldValue;
            Object fieldValue;
            if (!index.usedEconomyHashMap() || index.disableIndexUsageForOperation(this, pEntry.getLatestIndexCreationNumber()) || TypeData.objectsEquality(fieldValue = index.getIndexValue(entryData), newFieldValue = index.getIndexValue(newEntryData))) continue;
            index.prepareForReplacingEntryIndexedField(fieldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntryReferencesUnderXtn(CacheManager cacheManager, IEntryCacheInfo pEntry, IEntryData oldEntryData) {
        RuntimeException ex_thrown = null;
        try {
            boolean double_update;
            ShadowEntryHolder shadowEh = pEntry.getEntryHolder(cacheManager).getShadow();
            shadowEh.resetNumOfIndexesUpdated();
            shadowEh.incrementNumOfUpdates();
            IEntryData shadowEntryData = shadowEh.getEntryData();
            boolean bl = double_update = shadowEntryData.getFixedPropertiesValues() != oldEntryData.getFixedPropertiesValues();
            if (this.hasIndexes()) {
                int refpos = 1;
                ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs = pEntry.getBackRefs();
                if (pEntry.indexesBackRefsKept()) {
                    pEntry.setBackRefs(new ArrayList<IObjectInfo<IEntryCacheInfo>>(this.numberOfBackRefs()));
                    pEntry.getBackRefs().add(deletedBackRefs.get(0));
                }
                IEntryData newEntryData = pEntry.getEntryHolder(cacheManager).getEntryData();
                for (TypeDataIndex<Object> index : this._indexes) {
                    if (index.disableIndexUsageForOperation(this, pEntry.getLatestIndexCreationNumber())) continue;
                    Object newFieldValue = index.getIndexValue(newEntryData);
                    Object oldFieldValue = index.getIndexValue(oldEntryData);
                    int cursize = pEntry.indexesBackRefsKept() ? pEntry.getBackRefs().size() : -1;
                    try {
                        refpos = index.updateIndexValueUndexXtn(this, pEntry.getEntryHolder(cacheManager), pEntry, oldFieldValue, newFieldValue, deletedBackRefs, refpos, double_update);
                        shadowEh.incrementNumOfIndexesUpdated();
                    }
                    catch (RuntimeException ex) {
                        if (ex_thrown == null) {
                            ex_thrown = ex;
                        }
                        if (!pEntry.indexesBackRefsKept()) continue;
                        if (pEntry.getBackRefs().size() == cursize) {
                            pEntry.getBackRefs().add(TypeDataIndex._DummyOI);
                        }
                        ++refpos;
                        if (!index.isExtendedIndex()) continue;
                        if (newFieldValue != null && pEntry.getBackRefs().size() == cursize + 1) {
                            pEntry.getBackRefs().add(TypeDataIndex._DummyOI);
                        }
                        if (oldFieldValue == null) continue;
                        ++refpos;
                    }
                }
                for (QueryExtensionIndexManagerWrapper queryExtensionIndexManager : this.getForeignQueriesHandlers()) {
                    if (double_update) {
                        queryExtensionIndexManager.replaceEntry(new SpaceServerEntryImpl(pEntry, cacheManager));
                        continue;
                    }
                    queryExtensionIndexManager.insertEntry(new SpaceServerEntryImpl(pEntry, cacheManager), true);
                }
            }
        }
        finally {
            if (ex_thrown != null) {
                XtnEntry xtnEntry = pEntry.getEntryHolder(cacheManager).getWriteLockOwner();
                cacheManager.consolidateWithShadowEntry(this, pEntry, true, true);
                pEntry.getEntryHolder(cacheManager).setWriteLockOwnerAndOperation(xtnEntry, 2);
                xtnEntry.getXtnData().removeRewrittenEntryIndication(pEntry.getUID());
                throw ex_thrown;
            }
        }
    }

    static boolean objectsEquality(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (a == b) {
            return true;
        }
        return a.equals(b);
    }

    public int[] createIndexBackreferenceArray(IEntryCacheInfo pEntry, IEntryData masterEntryData) {
        if (!this._hasIndexes || !pEntry.indexesBackRefsKept()) {
            return null;
        }
        int[] backrefIndexPos = new int[masterEntryData.getNumOfFixedProperties() + this._numOfCustomIndexes];
        int refpos = 1;
        for (TypeDataIndex<Object> index : this._indexes) {
            if (index.disableIndexUsageForOperation(this, pEntry.getLatestIndexCreationNumber())) continue;
            int position = index.getPos();
            backrefIndexPos[position] = refpos;
            refpos += index.numOfEntryIndexBackRefs(index.getIndexValue(masterEntryData));
        }
        return backrefIndexPos;
    }

    public boolean isTypeDataReplaced() {
        return this._typeDataReplaced;
    }

    public void setTypeDataReplaced() {
        this._typeDataReplaced = true;
    }

    public boolean supportsDynamicIndexing() {
        return this._supportsDynamicIndexing;
    }

    void typeLock() {
        this._typeLock.writeLock().lock();
    }

    void typeUnLock() {
        this._typeLock.writeLock().unlock();
    }

    public int getLastIndexCreationNumber() {
        return this._lastIndexCreationNumber;
    }

    int getLastIndexPendingCreationNumber() {
        return this._lastIndexPendingCreationNumber;
    }

    public boolean hasInitialIndexes() {
        return this._hasInitialIndexes;
    }

    public boolean anyInitialExtendedIndex() {
        return this._anyInitialExtendedIndex;
    }

    private static ISpaceIndex getInternalIndex(SpaceIndex index) {
        if (index instanceof ISpaceIndex) {
            return (ISpaceIndex)index;
        }
        throw new UnsupportedOperationException("Space indexes must implement internal ISpaceIndex interface.");
    }

    public TypeDataFactory getTypeDataFactory() {
        return this._typeDataFactory;
    }

    public boolean hasFifoGroupingIndex() {
        return this._fifoGroupingIndex != null;
    }

    public TypeDataIndex<Object> getFifoGroupingIndex() {
        return this._fifoGroupingIndex;
    }

    public boolean anyCompoundIndex() {
        return !this._compoundIndexes.isEmpty();
    }

    public List<TypeDataIndex> getCompoundIndexes() {
        return this._compoundIndexes;
    }

    public boolean anyNonFGCompoundIndex() {
        return this._anyNonFGCompoundIndex;
    }

    public static enum TypeDataRecreationReasons {
        DYNAMIC_INDEX_CREATION,
        DYNAMIC_INDEX_CREATION_COMPLETION;

    }
}

