/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.server.space.MatchTarget;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ShadowEntryHolder;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.economy.EconomyConcurrentHashMap;
import com.gigaspaces.internal.utils.collections.economy.HashEntryHandlerSpaceEntry;
import com.gigaspaces.internal.utils.collections.economy.IEconomyConcurrentMap;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CompoundIndexSegmentTypeData;
import com.j_spaces.core.cache.DefaultValueCloner;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.ExtendedIndexHandler;
import com.j_spaces.core.cache.FifoGroupsExtendedIndexHandler;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.IExtendedEntriesIndex;
import com.j_spaces.core.cache.IExtendedIndex;
import com.j_spaces.core.cache.IExtendedIndexScanPositioner;
import com.j_spaces.core.cache.IValueCloner;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.TemplatesExtendedIndexHandler;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsMainIndexExtention;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupsIndexExtention;
import com.j_spaces.core.client.DuplicateIndexValueException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.list.IScanListIterator;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TypeDataIndex<K> {
    private final Logger _logger;
    public static IEntryCacheInfo _DummyOI = EntryCacheInfoFactory.createEntryCacheInfo(null);
    private static final boolean _indexesBackrefsForBlobStoreData = true;
    private static final int UNIQUE_VALUE_TRY_THRESHOLD = 40;
    private final int _position;
    private final SpaceIndexType _indexType;
    private final ISpaceIndex _indexDefinition;
    private final ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> _nonUniqueEntriesStore;
    private final ConcurrentMap<Object, IEntryCacheInfo> _uniqueEntriesStore;
    public final ConcurrentHashMap<Object, IStoredList<TemplateCacheInfo>[]> _RTTemplates;
    public final ConcurrentHashMap<Object, IStoredList<TemplateCacheInfo>[]> _NTemplates;
    private final IStoredList<IEntryCacheInfo> _nullEntries;
    public final IStoredList<TemplateCacheInfo> _RTNullTemplates;
    public final IStoredList<TemplateCacheInfo> _NNullTemplates;
    private final IExtendedEntriesIndex<K, IEntryCacheInfo> _concurrentExtendedIndex;
    private final IExtendedEntriesIndex<K, IEntryCacheInfo> _concurrentExtendedFifoGroupsIndex;
    protected boolean m_AreAnyLogicallDelitions;
    private final IExtendedIndex<K, TemplateCacheInfo> m_Notify_GT_Index;
    private final TemplatesExtendedIndexHandler<K> m_RT_GT_Index;
    private final IExtendedIndex<K, TemplateCacheInfo> m_Notify_LT_Index;
    private final TemplatesExtendedIndexHandler<K> m_RT_LT_Index;
    private final IExtendedIndex<K, TemplateCacheInfo> m_Notify_NE_Index;
    private final TemplatesExtendedIndexHandler<K> m_RT_NE_Index;
    private int _estimatedNumNonNullValues;
    private int _estimatedUniqueNonNullValues;
    private final boolean _useConcurrentSl;
    private final boolean _useEconomyHashMap;
    private Class<?> _valueType;
    private final int _indexCreationNumber;
    private final boolean _considerValueClone;
    private final boolean _cloneableIndexValue;
    private final boolean _valueTypeKnown;
    private final ISpaceIndex.FifoGroupsIndexTypes _fifoGroupsIndexType;
    private TypeDataIndex _compoundFifoGroupsIndex;
    protected IFifoGroupsIndexExtention<K> _fifoGroupsIndexExtention;
    private final ThreadLocal<IValueCloner> _valueCloner = new ThreadLocal();
    private final CacheManager _cacheManager;
    private final boolean _unique;
    private final boolean _thinExtendedIndex;
    private static final Set<String> _immutableTypes = TypeDataIndex.initImmutableTypes();

    public TypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, boolean useEconomyHashmap, int indexCreationNumber) {
        this(cacheManager, index, pos, useEconomyHashmap, indexCreationNumber, null, ISpaceIndex.FifoGroupsIndexTypes.NONE);
    }

    public TypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, boolean useEconomyHashmap, int indexCreationNumber, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        this(cacheManager, index, pos, useEconomyHashmap, indexCreationNumber, null, fifoGroupsIndexType);
    }

    public TypeDataIndex(CacheManager cacheManager, ISpaceIndex index, int pos, boolean useEconomyHashmap, int indexCreationNumber, Class<?> valueClass, ISpaceIndex.FifoGroupsIndexTypes fifoGroupsIndexType) {
        this._logger = Logger.getLogger("com.gigaspaces.cache." + cacheManager.getEngine().getSpaceImpl().getNodeName());
        this._cacheManager = cacheManager;
        this._useEconomyHashMap = useEconomyHashmap;
        this._indexCreationNumber = indexCreationNumber;
        this._position = pos;
        this._indexType = index.getIndexType();
        this._thinExtendedIndex = this._indexType == SpaceIndexType.ORDERED;
        this._indexDefinition = index;
        this._unique = index.isUnique();
        int numOfCHMSegents = Integer.getInteger("com.gs.cacheManager.hashmapSegments", 64);
        if (!this._thinExtendedIndex) {
            if (this._useEconomyHashMap) {
                this._uniqueEntriesStore = index.isUnique() ? new EconomyConcurrentHashMap(16, 0.75f, numOfCHMSegents, new HashEntryHandlerSpaceEntry(pos)) : null;
                this._nonUniqueEntriesStore = new EconomyConcurrentHashMap<Object, IStoredList<IEntryCacheInfo>>(16, 0.75f, numOfCHMSegents, new HashEntryHandlerSpaceEntry(pos));
            } else {
                this._uniqueEntriesStore = index.isUnique() ? new ConcurrentHashMap(16, 0.75f, numOfCHMSegents) : null;
                this._nonUniqueEntriesStore = new ConcurrentHashMap<Object, IStoredList<IEntryCacheInfo>>(16, 0.75f, numOfCHMSegents);
            }
        } else {
            this._uniqueEntriesStore = null;
            this._nonUniqueEntriesStore = null;
        }
        int numOfCoresToUseSL = Integer.getInteger("com.gs.engine.coresToUseConcurrentSL", 2);
        this._useConcurrentSl = Runtime.getRuntime().availableProcessors() >= numOfCoresToUseSL;
        this._RTTemplates = new ConcurrentHashMap();
        this._NTemplates = new ConcurrentHashMap();
        if (this._useConcurrentSl) {
            this._nullEntries = StoredListFactory.createConcurrentSegmentedList(true, 1, true);
            this._RTNullTemplates = StoredListFactory.createConcurrentSegmentedList(true, 1, true);
            this._NNullTemplates = StoredListFactory.createConcurrentSegmentedList(true, 1, true);
        } else {
            this._nullEntries = StoredListFactory.createRandomScanList(true);
            this._RTNullTemplates = StoredListFactory.createList(true);
            this._NNullTemplates = StoredListFactory.createList(true);
        }
        if (this._indexType.isOrdered()) {
            this._concurrentExtendedIndex = new ExtendedIndexHandler(this);
            this.m_Notify_GT_Index = new TemplatesExtendedIndexHandler(this);
            this.m_RT_GT_Index = new TemplatesExtendedIndexHandler(this);
            this.m_Notify_LT_Index = new TemplatesExtendedIndexHandler(this);
            this.m_RT_LT_Index = new TemplatesExtendedIndexHandler(this);
            this.m_Notify_NE_Index = new TemplatesExtendedIndexHandler(this);
            this.m_RT_NE_Index = new TemplatesExtendedIndexHandler(this);
        } else {
            this._concurrentExtendedIndex = null;
            this.m_Notify_GT_Index = null;
            this.m_RT_GT_Index = null;
            this.m_Notify_LT_Index = null;
            this.m_RT_LT_Index = null;
            this.m_Notify_NE_Index = null;
            this.m_RT_NE_Index = null;
        }
        this._fifoGroupsIndexType = fifoGroupsIndexType;
        if (this.isFifoGroupsMainIndex()) {
            this._fifoGroupsIndexExtention = new FifoGroupsMainIndexExtention(cacheManager, this);
        }
        this._concurrentExtendedFifoGroupsIndex = this._concurrentExtendedIndex != null && (this.isFifoGroupsMainIndex() || fifoGroupsIndexType == ISpaceIndex.FifoGroupsIndexTypes.COMPOUND) ? new FifoGroupsExtendedIndexHandler<K>(this, this._concurrentExtendedIndex, fifoGroupsIndexType) : null;
        String val = System.getProperty("com.gs.cacheManager.EmbeddedIndexProtection");
        boolean embeddedIndexProtection = new Boolean(val != null ? val : "true");
        if (!embeddedIndexProtection) {
            this._considerValueClone = false;
            this._cloneableIndexValue = false;
            this._valueTypeKnown = false;
        } else if (valueClass == null || valueClass.getName().equals("java.lang.Object")) {
            this._valueTypeKnown = false;
            this._considerValueClone = true;
            this._cloneableIndexValue = false;
        } else {
            this._valueTypeKnown = true;
            if (TypeDataIndex.isImmutableIndexValue(valueClass)) {
                this._considerValueClone = false;
                this._cloneableIndexValue = false;
            } else {
                this._considerValueClone = true;
                this._cloneableIndexValue = TypeDataIndex.isCloneableIndexValue(valueClass);
            }
        }
    }

    public boolean isExtendedIndex() {
        return this._concurrentExtendedIndex != null;
    }

    public IExtendedEntriesIndex<K, IEntryCacheInfo> getExtendedIndex() {
        return this._concurrentExtendedIndex;
    }

    public IExtendedEntriesIndex<K, IEntryCacheInfo> getExtendedFGIndex() {
        return this._concurrentExtendedFifoGroupsIndex;
    }

    boolean considerValueClone() {
        return this._considerValueClone;
    }

    public CacheManager getCacheManager() {
        return this._cacheManager;
    }

    public int numOfEntryIndexBackRefs(Object fieldValue) {
        return !this.isExtendedIndex() || fieldValue == null ? 1 : 2;
    }

    public boolean isUniqueIndex() {
        return this._unique;
    }

    public ISpaceIndex getIndexDefinition() {
        return this._indexDefinition;
    }

    private boolean isThinExtendedIndex() {
        return this._thinExtendedIndex;
    }

    public boolean isFifoGroupsMainIndex() {
        return this._fifoGroupsIndexType == ISpaceIndex.FifoGroupsIndexTypes.MAIN;
    }

    public ISpaceIndex.FifoGroupsIndexTypes getFifoGroupsIndexType() {
        return this._fifoGroupsIndexType;
    }

    public static boolean isIndexesBackRefsForBlobStoreData() {
        return true;
    }

    public boolean disableIndexUsageForOperation(TypeData typeData, int inputIndexCreationNumber) {
        return inputIndexCreationNumber < this.getIndexCreationNumber() || typeData.disableIdIndexForEntries(this);
    }

    public void markIndexValue(boolean unique) {
        if (unique) {
            ++this._estimatedUniqueNonNullValues;
        }
        ++this._estimatedNumNonNullValues;
        if (this._estimatedNumNonNullValues < 0) {
            this._estimatedNumNonNullValues = 0;
            this._estimatedUniqueNonNullValues = 0;
        }
    }

    public boolean assumeUniqueValue() {
        int estimatedNumNonNullValues = this._estimatedNumNonNullValues;
        int estimatedUniqueNonNullValues = this._estimatedUniqueNonNullValues;
        return estimatedNumNonNullValues == 0 ? true : estimatedUniqueNonNullValues / estimatedNumNonNullValues * 100 > 40;
    }

    public Object getIndexValue(ServerEntry entry) {
        return entry.getFixedPropertyValue(this._position);
    }

    public IStoredList<IEntryCacheInfo> getIndexEntries(Object indexValue) {
        if (!this.isThinExtendedIndex()) {
            if (this.isUniqueIndex()) {
                return (IStoredList)this.getUniqueEntriesStore().get(indexValue);
            }
            return (IStoredList)this.getNonUniqueEntriesStore().get(indexValue);
        }
        return this.getConcurrentExtendedIndex().getIndexEntries(indexValue);
    }

    public ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> getNonUniqueEntriesStore() {
        return this.isThinExtendedIndex() ? this._concurrentExtendedIndex.getNonUniqueEntriesStore() : this._nonUniqueEntriesStore;
    }

    public ConcurrentMap<Object, IEntryCacheInfo> getUniqueEntriesStore() {
        return this.isThinExtendedIndex() ? this._concurrentExtendedIndex.getUniqueEntriesStore() : this._uniqueEntriesStore;
    }

    public IStoredList<IEntryCacheInfo> getNullEntries() {
        return this._nullEntries;
    }

    public IExtendedEntriesIndex<K, IEntryCacheInfo> getConcurrentExtendedIndex() {
        return this._concurrentExtendedIndex;
    }

    public IExtendedIndex<K, IEntryCacheInfo> getExtendedFifoGroupsIndexForScanning() {
        return this._concurrentExtendedFifoGroupsIndex;
    }

    public IExtendedIndexScanPositioner<K, IEntryCacheInfo> getExtendedIndexForScanning() {
        return this._concurrentExtendedIndex;
    }

    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType) {
        if (this._fifoGroupsIndexExtention == null) {
            this.insertEntryIndexedField_impl(pEntry, fieldValue, pType, pEntry.getBackRefs());
        } else {
            this._fifoGroupsIndexExtention.insertEntryIndexedField(pEntry, fieldValue, pType);
        }
    }

    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, ArrayList<IObjectInfo<IEntryCacheInfo>> insertBackRefs) {
        if (this._fifoGroupsIndexExtention == null) {
            this.insertEntryIndexedField_impl(pEntry, fieldValue, pType, insertBackRefs);
        } else {
            this._fifoGroupsIndexExtention.insertEntryIndexedField(pEntry, fieldValue, pType, insertBackRefs);
        }
    }

    public void insertEntryIndexedField_impl(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs) {
        if (backRefs == null && pEntry.indexesBackRefsKept()) {
            throw new RuntimeException("null backrefs but backrefs have to be kept!!!!");
        }
        IObjectInfo<IEntryCacheInfo> oi = null;
        boolean uniqueValue = true;
        boolean alreadyCloned = false;
        if (fieldValue == null) {
            oi = this._nullEntries.add(pEntry);
            if (backRefs != null) {
                backRefs.add(oi);
            }
        } else {
            block28: {
                this.updateValueType(fieldValue);
                if (this.isUniqueIndex()) {
                    IEntryCacheInfo other;
                    while (true) {
                        if ((other = this.getUniqueEntriesStore().putIfAbsent(fieldValue, pEntry)) == null) {
                            oi = pEntry;
                            break block28;
                        }
                        if (!other.isRemovingOrRemoved() && !other.isDeleted()) break;
                        this.getUniqueEntriesStore().remove(fieldValue, other);
                    }
                    DuplicateIndexValueException ex = new DuplicateIndexValueException(pEntry.getUID(), pEntry.getEntryHolder(this._cacheManager).getClassName(), this._indexDefinition.getName(), fieldValue, other.getUID());
                    if (this._logger.isLoggable(Level.SEVERE)) {
                        this._logger.log(Level.SEVERE, "Duplicate value encountered on unique index insertion ", ex);
                    }
                    throw ex;
                }
                IStoredList<IEntryCacheInfo> newSL = null;
                IObjectInfo<IEntryCacheInfo> myoi = null;
                IObjectInfo otheroi = null;
                IStoredList<IEntryCacheInfo> currentSL = null;
                boolean first = true;
                while (true) {
                    if (first) {
                        first = false;
                        if (!this.assumeUniqueValue()) {
                            currentSL = (IStoredList)this.getNonUniqueEntriesStore().get(fieldValue);
                        }
                    }
                    if (currentSL == null) {
                        if (this._considerValueClone && !alreadyCloned) {
                            fieldValue = this.cloneIndexValue(fieldValue, pEntry.getEntryHolder(this._cacheManager));
                            alreadyCloned = true;
                        }
                        if ((currentSL = this.getNonUniqueEntriesStore().putIfAbsent(fieldValue, pEntry)) == null) {
                            oi = pEntry;
                            if (this._fifoGroupsIndexExtention != null) {
                                this._fifoGroupsIndexExtention.addToValuesList(fieldValue, pEntry);
                            }
                            break block28;
                        }
                    }
                    if (currentSL.isMultiObjectCollection()) {
                        oi = currentSL.add(pEntry);
                        if (oi == null) {
                            this.getNonUniqueEntriesStore().remove(fieldValue, currentSL);
                            currentSL = null;
                            continue;
                        }
                        uniqueValue = false;
                        break block28;
                    }
                    if (newSL == null) {
                        newSL = this._useEconomyHashMap ? StoredListFactory.createConcurrentSegmentedList(false, pType.isAllowFifoIndexScans(), fieldValue) : StoredListFactory.createConcurrentList(pType.isAllowFifoIndexScans());
                    }
                    otheroi = newSL.addUnlocked((IEntryCacheInfo)currentSL.getObjectFromHead());
                    myoi = newSL.addUnlocked(pEntry);
                    if (this.getNonUniqueEntriesStore().replace(fieldValue, currentSL, newSL)) break;
                    newSL.removeUnlocked(otheroi);
                    newSL.removeUnlocked(myoi);
                    myoi = null;
                    currentSL = null;
                }
                uniqueValue = false;
                oi = myoi;
                if (this._fifoGroupsIndexExtention != null) {
                    this._fifoGroupsIndexExtention.addToValuesList(fieldValue, newSL);
                    this._fifoGroupsIndexExtention.removeFromValuesList(fieldValue, currentSL);
                }
            }
            if (!this.isUniqueIndex()) {
                this.markIndexValue(uniqueValue);
            }
            if (backRefs != null) {
                backRefs.add(this.isUniqueIndex() ? pEntry : oi);
            }
            if (this.isExtendedIndex()) {
                try {
                    if (!this.isThinExtendedIndex()) {
                        oi = this._concurrentExtendedIndex.insertEntryIndexedField(pEntry, fieldValue, pType, alreadyCloned);
                    }
                    if (backRefs != null) {
                        backRefs.add(oi);
                    }
                }
                catch (RuntimeException ex) {
                    if (!pEntry.getEntryHolder(this._cacheManager).hasShadow()) {
                        ArrayList<IObjectInfo<IEntryCacheInfo>> failedBackRefs = pEntry.getBackRefs();
                        this.removeNotNullIndex(pEntry.getEntryHolder(this._cacheManager), failedBackRefs, fieldValue, failedBackRefs != null ? failedBackRefs.size() - 1 : 0, pEntry, failedBackRefs != null ? failedBackRefs.get(failedBackRefs.size() - 1) : null, true);
                    } else {
                        backRefs.add(_DummyOI);
                    }
                    throw ex;
                }
            }
        }
    }

    K cloneIndexValue(K fieldValue, IEntryHolder entryHolder) {
        Object res;
        Class<?> clzz;
        Class<?> clazz = clzz = !this._valueTypeKnown ? fieldValue.getClass() : this.getValueType();
        if (!this._valueTypeKnown && TypeDataIndex.isImmutableIndexValue(clzz)) {
            return fieldValue;
        }
        if (this._valueCloner.get() == null) {
            this._valueCloner.set(new DefaultValueCloner());
        }
        if (!((res = this._valueCloner.get().cloneValue(fieldValue, this._cloneableIndexValue, clzz, entryHolder.getUID(), entryHolder.getClassName())) == fieldValue || fieldValue.hashCode() == res.hashCode() && fieldValue.equals(res))) {
            throw new RuntimeException("Entry Class: " + entryHolder.getClassName() + " - Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field");
        }
        return (K)res;
    }

    protected boolean isConsiderValueClone() {
        return this._considerValueClone;
    }

    private void removeNonUniqueIndexedField(IEntryHolder eh, K fieldValue, IEntryCacheInfo pEntry, IObjectInfo oi) {
        block8: {
            ConcurrentMap<Object, IStoredList<IEntryCacheInfo>> store;
            do {
                IStoredList entries;
                if ((entries = (IStoredList)(store = this.getNonUniqueEntriesStore()).get(fieldValue)) == null) {
                    throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field, or field value changed while entry stored in space.");
                }
                if (entries.isMultiObjectCollection()) {
                    IObjectInfo myoi = oi;
                    if (myoi == pEntry && (myoi = entries.getHead()).getSubject() != pEntry) {
                        throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Single-entry to multiple wrong OI ,  " + fieldValue.getClass() + " class field .");
                    }
                    if (oi != null) {
                        entries.remove(myoi);
                    } else {
                        boolean res = entries.removeByObject(pEntry);
                        if (!res) {
                            throw new RuntimeException("Entry Class: " + eh.getClassName() + " - removeByObject on SL returned false ,  " + fieldValue.getClass() + " class field.");
                        }
                    }
                    if (!entries.invalidate()) break block8;
                    store.remove(fieldValue, entries);
                    if (this._fifoGroupsIndexExtention != null) {
                        this._fifoGroupsIndexExtention.removeFromValuesList(fieldValue, entries);
                    }
                    break block8;
                }
                if (entries == pEntry) continue;
                throw new RuntimeException("Entry Class: " + eh.getClassName() + " - Single-entry Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field, or field value changed while entry stored in space..");
            } while (!store.remove(fieldValue, pEntry));
            if (this._fifoGroupsIndexExtention == null) break block8;
            this._fifoGroupsIndexExtention.removeFromValuesList(fieldValue, pEntry);
        }
    }

    public int removeEntryIndexedField_main(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        int res = this.removeEntryIndexedField(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
        if (this.isExtendedIndex()) {
            this.getExtendedIndex().onRemove(pEntry);
            if (this.getExtendedFGIndex() != null) {
                this.getExtendedFGIndex().onRemove(pEntry);
            }
        }
        return res;
    }

    public int removeEntryIndexedField(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        if (this._fifoGroupsIndexExtention == null || !removeIndexedValue || fieldValue == null) {
            return this.removeEntryIndexedField_impl(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
        }
        return this._fifoGroupsIndexExtention.removeEntryIndexedField(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
    }

    public int removeEntryIndexedField_impl(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        IObjectInfo oi = null;
        if (deletedBackRefs != null) {
            oi = deletedBackRefs.set(refpos, null);
        }
        if (oi == null && pEntry.indexesBackRefsKept()) {
            throw new RuntimeException("oi is null but backrefs have to be kept!!!!");
        }
        ++refpos;
        if (oi == _DummyOI) {
            removeIndexedValue = false;
        }
        if (!removeIndexedValue) {
            if (fieldValue != null && this.isExtendedIndex()) {
                if (deletedBackRefs != null) {
                    oi = deletedBackRefs.set(refpos, null);
                }
                ++refpos;
            }
            return refpos;
        }
        if (fieldValue == null) {
            if (oi != null) {
                this._nullEntries.remove(oi);
            } else {
                boolean res = this._nullEntries.removeByObject(pEntry);
                if (!res) {
                    throw new RuntimeException("Entry Class: " + eh.getClassName() + " - removeByObject on NULLS SL returned false");
                }
            }
        } else {
            this.removeNotNullIndex(eh, deletedBackRefs, fieldValue, refpos, pEntry, oi, false);
            if (this.isExtendedIndex()) {
                ++refpos;
            }
        }
        return refpos;
    }

    private void removeNotNullIndex(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, IEntryCacheInfo pEntry, IObjectInfo oi, boolean fromFailure) {
        if (this.isUniqueIndex()) {
            this.removeUniqueIndexedField(fieldValue, pEntry);
        } else {
            this.removeNonUniqueIndexedField(eh, fieldValue, pEntry, oi);
        }
        if (this.isExtendedIndex() && !fromFailure) {
            if (deletedBackRefs != null) {
                oi = deletedBackRefs.set(refpos, null);
            }
            if (oi != _DummyOI && !this.isThinExtendedIndex()) {
                this._concurrentExtendedIndex.removeEntryIndexedField(eh, fieldValue, pEntry, oi);
            }
        }
    }

    static void reindexEntry(CacheManager cacheManager, IEntryCacheInfo entryCacheInfo, TypeData typeData) {
        TypeDataIndex[] indexes;
        if (!typeData.hasIndexes()) {
            return;
        }
        if (entryCacheInfo.getLatestIndexCreationNumber() >= typeData.getLastIndexPendingCreationNumber() && entryCacheInfo.getLatestIndexCreationNumber() >= typeData.getLastIndexCreationNumber()) {
            return;
        }
        if (entryCacheInfo.getEntryHolder(cacheManager).hasShadow(true)) {
            TypeDataIndex.reindexEntryAndShadow(cacheManager, entryCacheInfo, typeData);
            return;
        }
        ArrayList<IObjectInfo<IEntryCacheInfo>> newBackRefs = entryCacheInfo.indexesBackRefsKept() ? new ArrayList<IObjectInfo<IEntryCacheInfo>>(typeData.numberOfBackRefs()) : null;
        ArrayList<IObjectInfo<IEntryCacheInfo>> curBackRefs = entryCacheInfo.getBackRefs();
        int originalPos = 0;
        int newIndexCreationNumber = entryCacheInfo.getLatestIndexCreationNumber();
        entryCacheInfo.setBackRefs(newBackRefs);
        if (entryCacheInfo.indexesBackRefsKept()) {
            newBackRefs.add(curBackRefs.get(originalPos++));
        }
        IEntryData entryData = entryCacheInfo.getEntryHolder(cacheManager).getEntryData();
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            newIndexCreationNumber = Math.max(newIndexCreationNumber, index.getIndexCreationNumber());
            if (typeData.disableIdIndexForEntries(index)) continue;
            if (index.getIndexCreationNumber() <= entryCacheInfo.getLatestIndexCreationNumber()) {
                if (!entryCacheInfo.indexesBackRefsKept()) continue;
                newBackRefs.add(curBackRefs.get(originalPos++));
                if (!index.isExtendedIndex() || index.getIndexValue(entryData) == null) continue;
                newBackRefs.add(curBackRefs.get(originalPos++));
                continue;
            }
            index.insertEntryIndexedField(entryCacheInfo, index.getIndexValue(entryData), typeData);
        }
        entryCacheInfo.setLatestIndexCreationNumber(newIndexCreationNumber);
    }

    private static void reindexEntryAndShadow(CacheManager cacheManager, IEntryCacheInfo entryCacheInfo, TypeData typeData) {
        TypeDataIndex[] indexes;
        ShadowEntryHolder shadowEh = entryCacheInfo.getEntryHolder(cacheManager).getShadow();
        ArrayList<IObjectInfo<IEntryCacheInfo>> newBackRefs = entryCacheInfo.indexesBackRefsKept() ? new ArrayList<IObjectInfo<IEntryCacheInfo>>(typeData.numberOfBackRefs()) : null;
        ArrayList<IObjectInfo<IEntryCacheInfo>> curBackRefs = entryCacheInfo.getBackRefs();
        ArrayList<IObjectInfo<IEntryCacheInfo>> newShadowBackRefs = entryCacheInfo.indexesBackRefsKept() ? new ArrayList<IObjectInfo<IEntryCacheInfo>>(typeData.numberOfBackRefs()) : null;
        ArrayList<IObjectInfo<IEntryCacheInfo>> curShadowBackRefs = shadowEh.getBackRefs();
        int originalPos = 0;
        int originalShadowPos = 0;
        int newIndexCreationNumber = entryCacheInfo.getLatestIndexCreationNumber();
        entryCacheInfo.setBackRefs(newBackRefs);
        shadowEh.setShadowBackRefs(newShadowBackRefs);
        if (entryCacheInfo.indexesBackRefsKept()) {
            newBackRefs.add(curBackRefs.get(originalPos++));
            newShadowBackRefs.add(curShadowBackRefs.get(originalShadowPos++));
        }
        IEntryData entryData = entryCacheInfo.getEntryHolder(cacheManager).getEntryData();
        IEntryData shadowEntryData = shadowEh.getEntryData();
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            newIndexCreationNumber = Math.max(newIndexCreationNumber, index.getIndexCreationNumber());
            if (typeData.disableIdIndexForEntries(index)) continue;
            if (index.getIndexCreationNumber() <= entryCacheInfo.getLatestIndexCreationNumber()) {
                if (!entryCacheInfo.indexesBackRefsKept()) continue;
                newBackRefs.add(curBackRefs.get(originalPos++));
                newShadowBackRefs.add(curShadowBackRefs.get(originalShadowPos++));
                if (index.isExtendedIndex() && index.getIndexValue(entryData) != null) {
                    newBackRefs.add(curBackRefs.get(originalPos++));
                }
                if (!index.isExtendedIndex() || index.getIndexValue(shadowEntryData) == null) continue;
                newShadowBackRefs.add(curShadowBackRefs.get(originalShadowPos++));
                continue;
            }
            int beforeOpShadowPos = entryCacheInfo.indexesBackRefsKept() ? newShadowBackRefs.size() : -1;
            index.insertEntryIndexedField(entryCacheInfo, index.getIndexValue(shadowEntryData), typeData, newShadowBackRefs);
            if (!index.isMultiValuePerEntryIndex()) {
                if (TypeData.objectsEquality(index.getIndexValue(shadowEntryData), index.getIndexValue(entryData))) {
                    if (!entryCacheInfo.indexesBackRefsKept()) continue;
                    for (int pos = beforeOpShadowPos; pos < newShadowBackRefs.size(); ++pos) {
                        newBackRefs.add(newShadowBackRefs.get(pos));
                    }
                    continue;
                }
                index.insertEntryIndexedField(entryCacheInfo, index.getIndexValue(entryData), typeData, newBackRefs);
                continue;
            }
            index.updateIndexValueUndexXtn(typeData, entryCacheInfo.getEntryHolder(cacheManager), entryCacheInfo, index.getIndexValue(shadowEntryData), index.getIndexValue(entryData), newShadowBackRefs, beforeOpShadowPos, false);
        }
        entryCacheInfo.setLatestIndexCreationNumber(newIndexCreationNumber);
        if (entryCacheInfo.indexesBackRefsKept()) {
            shadowEh.setBackrefIndexPos(typeData.createIndexBackreferenceArray(entryCacheInfo, shadowEntryData));
        }
    }

    public void removeUniqueIndexedField(K fieldValue, IEntryCacheInfo pEntry) {
        if (!this.getUniqueEntriesStore().remove(fieldValue, pEntry)) {
            K other;
            K k = other = this._considerValueClone ? this.cloneIndexValue(fieldValue, pEntry.getEntryHolder(this._cacheManager)) : fieldValue;
            if (!(other == fieldValue || fieldValue.hashCode() == other.hashCode() && fieldValue.equals(other))) {
                throw new RuntimeException("Entry Class: " + pEntry.getClassName() + " - Wrong hashCode() or equals() implementation of " + fieldValue.getClass() + " class field, or field value changed while entry stored in space.");
            }
        }
    }

    public void prepareForReplacingEntryIndexedField(Object fieldValue) {
        if (!this._useEconomyHashMap || fieldValue == null) {
            return;
        }
        if (this.isUniqueIndex()) {
            ((IEconomyConcurrentMap)this.getUniqueEntriesStore()).setKeyUnstable(fieldValue);
        } else {
            ((IEconomyConcurrentMap)this.getNonUniqueEntriesStore()).setKeyUnstable(fieldValue);
        }
    }

    public boolean isIndexed() {
        return this._indexType.isIndexed();
    }

    public int getPos() {
        return this._position;
    }

    public int getMaxFixedPropertiesSegmentPos() {
        throw new UnsupportedOperationException();
    }

    public SpaceIndexType getIndexType() {
        return this._indexType;
    }

    public void addNullNotifyTemplate(TemplateCacheInfo template) {
        IObjectInfo<TemplateCacheInfo> oi = this._NNullTemplates.add(template);
        template.m_BackRefs.add(oi);
    }

    public void addNullReadTakeTemplate(TemplateCacheInfo template) {
        IObjectInfo<TemplateCacheInfo> oi = this._RTNullTemplates.add(template);
        template.m_BackRefs.add(oi);
    }

    public boolean usedEconomyHashMap() {
        return this._useEconomyHashMap;
    }

    public Class<?> getValueType() {
        return this._valueType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateValueType(Object fieldValue) {
        Class<?> type = fieldValue.getClass();
        if (this._valueType == null) {
            TypeDataIndex typeDataIndex = this;
            synchronized (typeDataIndex) {
                if (this._valueType == null) {
                    this._valueType = type;
                }
            }
        }
        if (this._valueType != type && !this._valueType.isAssignableFrom(type)) {
            TypeDataIndex typeDataIndex = this;
            synchronized (typeDataIndex) {
                this._valueType = TypeDataIndex.getCommonSuperType(type, this._valueType);
            }
        }
    }

    public int getIndexCreationNumber() {
        return this._indexCreationNumber;
    }

    public boolean isCustomIndex() {
        return false;
    }

    public boolean isMultiValuePerEntryIndex() {
        return false;
    }

    public int moveValueBackrefsOnUpdate(IEntryCacheInfo pEntry, Object value, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, ArrayList<IObjectInfo<IEntryCacheInfo>> updatedBackRefs, int originalRefPos, boolean setNullToOriginalRef) {
        if (pEntry.indexesBackRefsKept()) {
            updatedBackRefs.add(originalBackRefs.get(originalRefPos++));
            if (setNullToOriginalRef) {
                originalBackRefs.set(originalRefPos - 1, null);
            }
            if (value != null && this.isExtendedIndex()) {
                updatedBackRefs.add(originalBackRefs.get(originalRefPos++));
                if (setNullToOriginalRef) {
                    originalBackRefs.set(originalRefPos - 1, null);
                }
            }
        }
        return originalRefPos;
    }

    public int updateIndexValue(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K original, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> originalBackRefs, int refpos, UpdateIndexModes updateMode) {
        if (originalBackRefs == null && pEntry.indexesBackRefsKept()) {
            throw new RuntimeException("null backrefs but backrefs have to be kept!!!!");
        }
        if ((updateMode == UpdateIndexModes.INSERT_NONEQUALS || updateMode == UpdateIndexModes.REPLACE_NONEQUALS || updateMode == UpdateIndexModes.REMOVE_NONEQUALS) && TypeData.objectsEquality(updated, original)) {
            return this.moveValueBackrefsOnUpdate(pEntry, updated, originalBackRefs, pEntry.getBackRefs(), refpos, true);
        }
        this.validateIdFieldNotBeingUpdated(pType, eh, original, updated);
        if (this.isExtendedIndex()) {
            this.getExtendedIndex().onUpdate(pEntry);
            if (this.getExtendedFGIndex() != null) {
                this.getExtendedFGIndex().onUpdate(pEntry);
            }
        }
        if (updateMode == UpdateIndexModes.INSERT_NONEQUALS || updateMode == UpdateIndexModes.REPLACE_NONEQUALS) {
            this.insertEntryIndexedField(pEntry, updated, pType);
        }
        if (updateMode == UpdateIndexModes.REMOVE_NONEQUALS || updateMode == UpdateIndexModes.REPLACE_NONEQUALS) {
            int res = this.removeEntryIndexedField(pEntry.getEntryHolder(this._cacheManager), originalBackRefs, original, refpos, true, pEntry);
            if (this.isExtendedIndex()) {
                this.getExtendedIndex().onUpdateEnd(pEntry);
                if (this.getExtendedFGIndex() != null) {
                    this.getExtendedFGIndex().onUpdateEnd(pEntry);
                }
            }
            return res;
        }
        return refpos + this.numOfEntryIndexBackRefs(original);
    }

    public int updateIndexValueUndexXtn(TypeData pType, IEntryHolder eh, IEntryCacheInfo pEntry, K previous, K updated, ArrayList<IObjectInfo<IEntryCacheInfo>> previousBackRefs, int refpos, boolean entry_double_update) {
        if (previousBackRefs == null && pEntry.indexesBackRefsKept()) {
            throw new RuntimeException("null backrefs but backrefs have to be kept!!!!");
        }
        ShadowEntryHolder shadowEh = pEntry.getEntryHolder(this._cacheManager).getShadow();
        IEntryData shadowEntryData = shadowEh.getEntryData();
        int fnum = this.getPos();
        if (TypeData.objectsEquality(updated, previous)) {
            if (pEntry.indexesBackRefsKept()) {
                pEntry.getBackRefs().add(previousBackRefs.get(refpos));
            }
            ++refpos;
            if (this.isExtendedIndex() && updated != null) {
                if (pEntry.indexesBackRefsKept()) {
                    pEntry.getBackRefs().add(previousBackRefs.get(refpos));
                }
                ++refpos;
            }
            return refpos;
        }
        this.validateIdFieldNotBeingUpdated(pType, eh, previous, updated);
        boolean removeIndexValue = false;
        Object shadowFieldValue = this.getIndexValue(shadowEntryData);
        if (entry_double_update) {
            removeIndexValue = !TypeData.objectsEquality(previous, shadowFieldValue);
        }
        boolean insertIndexValue = true;
        if (entry_double_update) {
            boolean bl = insertIndexValue = !TypeData.objectsEquality(updated, shadowFieldValue);
        }
        if (insertIndexValue) {
            this.insertEntryIndexedField(pEntry, updated, pType);
        } else if (pEntry.indexesBackRefsKept()) {
            pEntry.getBackRefs().add(shadowEh.getBackRefs().get(shadowEh.getBackrefIndexPos()[fnum]));
            if (this.isExtendedIndex() && updated != null) {
                pEntry.getBackRefs().add(shadowEh.getBackRefs().get(shadowEh.getBackrefIndexPos()[fnum] + 1));
            }
        }
        return this.removeEntryIndexedField(pEntry.getEntryHolder(this._cacheManager), previousBackRefs, previous, refpos, removeIndexValue, pEntry);
    }

    private void validateIdFieldNotBeingUpdated(TypeData pType, IEntryHolder eh, K original, K updated) {
        if (pType.getIdField() == this && (!eh.getServerTypeDesc().getTypeDesc().isAutoGenerateId() || StringUtils.hasLength((String)original))) {
            throw new IllegalStateException("ID field cannot be updated or invalid hashCode()/equals() value for ID field (autoGenerateId=" + eh.getServerTypeDesc().getTypeDesc().isAutoGenerateId() + "), original ID='" + original + "', update attempt ID='" + updated + "'");
        }
    }

    int consolidateIndexValueOnXtnEnd(IEntryHolder eh, IEntryCacheInfo pEntry, K keptValue, K deletedVlaue, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, int refpos, boolean onError) {
        if (TypeData.objectsEquality(deletedVlaue, keptValue)) {
            return refpos + this.numOfEntryIndexBackRefs(deletedVlaue);
        }
        return this.removeEntryIndexedField(eh, deletedBackRefs, deletedVlaue, refpos, true, pEntry);
    }

    protected int multiValueSize(Object mvo) {
        throw new UnsupportedOperationException();
    }

    protected Iterator<K> multiValueIterator(Object mvo) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompound() {
        return false;
    }

    static Class<?> getCommonSuperType(Class<?> type1, Class<?> type2) {
        if (type1 == null || type2 == null) {
            return Object.class;
        }
        if (type1.equals(type2)) {
            return type1;
        }
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        return TypeDataIndex.getCommonSuperType(type1.getSuperclass(), type2.getSuperclass());
    }

    static boolean isImmutableIndexValue(Class<?> valueClass) {
        return _immutableTypes.contains(valueClass.getName());
    }

    static boolean isCloneableIndexValue(Class<?> valueClass) {
        if (valueClass.getName().endsWith(".Date")) {
            return false;
        }
        Class<?>[] interfaces = valueClass.getInterfaces();
        boolean res = false;
        if (interfaces != null) {
            for (Class<?> clzz : interfaces) {
                if (clzz.getName().startsWith("java.util")) {
                    return false;
                }
                if (!clzz.getName().equals("java.lang.Cloneable")) continue;
                res = true;
            }
        }
        return res;
    }

    private static Set<String> initImmutableTypes() {
        HashSet<String> immutableTypes = new HashSet<String>();
        immutableTypes.add(Byte.TYPE.getName());
        immutableTypes.add(Short.TYPE.getName());
        immutableTypes.add(Integer.TYPE.getName());
        immutableTypes.add(Long.TYPE.getName());
        immutableTypes.add(Float.TYPE.getName());
        immutableTypes.add(Double.TYPE.getName());
        immutableTypes.add(Boolean.TYPE.getName());
        immutableTypes.add(Character.TYPE.getName());
        immutableTypes.add(Byte.class.getName());
        immutableTypes.add(Short.class.getName());
        immutableTypes.add(Integer.class.getName());
        immutableTypes.add(Long.class.getName());
        immutableTypes.add(Float.class.getName());
        immutableTypes.add(Double.class.getName());
        immutableTypes.add(Boolean.class.getName());
        immutableTypes.add(Character.class.getName());
        immutableTypes.add(String.class.getName());
        immutableTypes.add(UUID.class.getName());
        immutableTypes.add(Time.class.getName());
        immutableTypes.add(Timestamp.class.getName());
        return immutableTypes;
    }

    public Object getIndexValueForTemplate(ServerEntry entry) {
        return this.getIndexValue(entry);
    }

    static void insertIndexedTemplate(TemplateCacheInfo pTemplate, TypeData typeData, boolean extendedMatch) {
        int additionToBackrefs = 0;
        pTemplate.initBackRefs(typeData.numberOfBackRefs() + additionToBackrefs);
        boolean useBasicIndex = TypeDataIndex.useBasicIndexTemplate(pTemplate, typeData, extendedMatch);
        if (useBasicIndex) {
            TypeDataIndex.insertBasicIndexTemplate(pTemplate, typeData);
        } else {
            TypeDataIndex.insertExtendedIndexTemplate(pTemplate, typeData);
        }
    }

    private static boolean useBasicIndexTemplate(TemplateCacheInfo pTemplate, TypeData typeData, boolean extendedMatch) {
        List<IQueryIndexScanner> customIndexes;
        ICustomQuery customQuery = pTemplate.m_TemplateHolder.getCustomQuery();
        List<IQueryIndexScanner> list = customIndexes = customQuery == null ? null : customQuery.getCustomIndexes();
        if (!extendedMatch && (customIndexes == null || customIndexes.isEmpty())) {
            return true;
        }
        if (extendedMatch) {
            for (TypeDataIndex typeDataIndex : typeData.getIndexes()) {
                int pos;
                if (typeDataIndex.getIndexCreationNumber() > 0 || typeDataIndex.isCompound() || (pos = typeDataIndex.getPos()) >= pTemplate.m_TemplateHolder.getExtendedMatchCodes().length || pTemplate.m_TemplateHolder.getExtendedMatchCodes()[pos] != 0 || typeDataIndex.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()) == null) continue;
                return true;
            }
        }
        if (customIndexes != null) {
            for (IQueryIndexScanner customIndexScanner : customIndexes) {
                String indexName;
                TypeDataIndex<?> typeDataIndex;
                if (!customIndexScanner.supportsTemplateIndex() || (typeDataIndex = typeData.getIndex(indexName = customIndexScanner.getIndexName())).isCompound() || typeDataIndex.getIndexCreationNumber() > 0) continue;
                return true;
            }
        }
        return !extendedMatch;
    }

    private static void insertBasicIndexTemplate(TemplateCacheInfo pTemplate, TypeData typeData) {
        TypeDataIndex[] indexes;
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            if (index.getIndexCreationNumber() > 0 || index.isCompound()) continue;
            int pos = index.getPos();
            boolean isNullIndex = index.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()) == null || pTemplate.m_TemplateHolder.hasExtendedMatchCodes() && pos < pTemplate.m_TemplateHolder.getExtendedMatchCodes().length && pTemplate.m_TemplateHolder.getExtendedMatchCodes()[pos] != 0;
            index.insertBasicIndexTemplate(pTemplate, isNullIndex);
        }
    }

    protected void insertBasicIndexTemplate(TemplateCacheInfo pTemplate, boolean isNullIndex) {
        if (isNullIndex) {
            if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
                this.addNullNotifyTemplate(pTemplate);
            } else {
                this.addNullReadTakeTemplate(pTemplate);
            }
        } else if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
            this.insertBasicIndexNotifyTemplate(pTemplate);
        } else {
            this.insertBasicIndexReadTakeTemplate(pTemplate);
        }
    }

    private void insertBasicIndexReadTakeTemplate(TemplateCacheInfo pTemplate) {
        IObjectInfo<TemplateCacheInfo> oi = null;
        boolean alreadyCloned = false;
        Object fieldValue = this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData());
        IStoredList<TemplateCacheInfo>[] t_vec = this._RTTemplates.get(fieldValue);
        while (true) {
            IStoredList<TemplateCacheInfo> templates;
            if (t_vec != null) {
                templates = t_vec[0];
                oi = templates.add(pTemplate);
                if (oi != null) break;
                this._RTTemplates.remove(fieldValue, t_vec);
                t_vec = null;
            }
            if (t_vec != null) continue;
            templates = StoredListFactory.createConcurrentList(true);
            oi = templates.add(pTemplate);
            t_vec = new IStoredList[]{templates, this._RTNullTemplates};
            if (this._considerValueClone && !alreadyCloned) {
                fieldValue = this.cloneIndexValue(fieldValue, pTemplate.m_TemplateHolder);
                alreadyCloned = true;
            }
            if ((t_vec = this._RTTemplates.putIfAbsent(fieldValue, t_vec)) == null) break;
        }
        pTemplate.m_BackRefs.add(oi);
    }

    private void insertBasicIndexNotifyTemplate(TemplateCacheInfo pTemplate) {
        IObjectInfo<TemplateCacheInfo> oi = null;
        boolean alreadyCloned = false;
        Object fieldValue = this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData());
        IStoredList<TemplateCacheInfo>[] t_vec = this._NTemplates.get(fieldValue);
        while (true) {
            IStoredList<TemplateCacheInfo> templates;
            if (t_vec != null) {
                templates = t_vec[0];
                oi = templates.add(pTemplate);
                if (oi != null) break;
                this._NTemplates.remove(this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()), t_vec);
                t_vec = null;
            }
            if (t_vec != null) continue;
            templates = StoredListFactory.createConcurrentList(true);
            oi = templates.add(pTemplate);
            t_vec = new IStoredList[]{templates, this._NNullTemplates};
            if (this._considerValueClone && !alreadyCloned) {
                fieldValue = this.cloneIndexValue(fieldValue, pTemplate.m_TemplateHolder);
                alreadyCloned = true;
            }
            if ((t_vec = this._NTemplates.putIfAbsent(fieldValue, t_vec)) == null) break;
        }
        pTemplate.m_BackRefs.add(oi);
    }

    private static void insertExtendedIndexTemplate(TemplateCacheInfo pTemplate, TypeData typeData) {
        TypeDataIndex index_for_NE = null;
        if (typeData.anyInitialExtendedIndex()) {
            for (TypeDataIndex index : typeData.getIndexes()) {
                int pos;
                if (index.getIndexCreationNumber() > 0 || !index.getIndexType().isOrdered() || index.isCompound() || (pos = index.getPos()) >= pTemplate.m_TemplateHolder.getExtendedMatchCodes().length || index.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()) == null) continue;
                short matchCode = pTemplate.m_TemplateHolder.getExtendedMatchCodes()[pos];
                if (matchCode == 3 || matchCode == 2 || matchCode == 5 || matchCode == 4) {
                    index.insertExtendedIndexTemplateValue(pTemplate, typeData);
                    return;
                }
                if (matchCode != 1 || index_for_NE != null) continue;
                index_for_NE = index;
            }
        }
        if (index_for_NE != null) {
            super.insertExtendedIndexTemplateValue(pTemplate, typeData);
            return;
        }
        TypeDataIndex.insertExtendedIndexTemplateGeneralList(pTemplate, typeData);
    }

    private void insertExtendedIndexTemplateValue(TemplateCacheInfo pTemplate, TypeData typeData) {
        short matchCode = pTemplate.m_TemplateHolder.getExtendedMatchCodes()[this.getPos()];
        IExtendedIndex<Object, TemplateCacheInfo> idx = null;
        switch (matchCode) {
            case 2: 
            case 3: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_GT_Index : this.m_RT_GT_Index;
                break;
            }
            case 4: 
            case 5: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_LT_Index : this.m_RT_LT_Index;
                break;
            }
            case 1: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_NE_Index : this.m_RT_NE_Index;
            }
        }
        pTemplate.m_BackRefs.add(idx.insertEntryIndexedField(pTemplate, this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()), typeData, false));
    }

    private static void insertExtendedIndexTemplateGeneralList(TemplateCacheInfo pTemplate, TypeData typeData) {
        IObjectInfo<TemplateCacheInfo> oi = pTemplate.m_TemplateHolder.isNotifyTemplate() ? typeData.getNotifyExtendedTemplates().add(pTemplate) : typeData.getReadTakeExtendedTemplates().add(pTemplate);
        pTemplate.m_BackRefs.add(oi);
    }

    static int removeIndexedTemplate(TemplateCacheInfo pTemplate, boolean extendedMatch, IObjectInfo<TemplateCacheInfo> oi, int refpos, TypeData typeData) {
        refpos = TypeDataIndex.useBasicIndexTemplate(pTemplate, typeData, extendedMatch) ? TypeDataIndex.removeBasicIndexTemplate(pTemplate, oi, refpos, typeData) : TypeDataIndex.removeExtendedIndexTemplate(pTemplate, refpos, typeData);
        return refpos;
    }

    private static int removeExtendedIndexTemplate(TemplateCacheInfo pTemplate, int refpos, TypeData typeData) {
        TypeDataIndex index_for_NE = null;
        if (typeData.anyInitialExtendedIndex()) {
            for (TypeDataIndex index : typeData.getIndexes()) {
                int pos;
                if (index.getIndexCreationNumber() > 0 || !index.getIndexType().isOrdered() || index.isCompound() || (pos = index.getPos()) >= pTemplate.m_TemplateHolder.getExtendedMatchCodes().length || index.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()) == null) continue;
                short matchCode = pTemplate.m_TemplateHolder.getExtendedMatchCodes()[pos];
                if (matchCode == 3 || matchCode == 2 || matchCode == 5 || matchCode == 4) {
                    return index.removeExtendedIndexTemplateValue(pTemplate, refpos);
                }
                if (matchCode != 1 || index_for_NE != null) continue;
                index_for_NE = index;
            }
        }
        if (index_for_NE != null) {
            return super.removeExtendedIndexTemplateValue(pTemplate, refpos);
        }
        return TypeDataIndex.removeExtendedIndexTemplateGeneralList(pTemplate, refpos, typeData);
    }

    private int removeExtendedIndexTemplateValue(TemplateCacheInfo pTemplate, int refpos) {
        short matchCode = pTemplate.m_TemplateHolder.getExtendedMatchCodes()[this.getPos()];
        IExtendedIndex<Object, TemplateCacheInfo> idx = null;
        IObjectInfo<TemplateCacheInfo> oi = pTemplate.m_BackRefs.get(refpos++);
        switch (matchCode) {
            case 2: 
            case 3: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_GT_Index : this.m_RT_GT_Index;
                break;
            }
            case 4: 
            case 5: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_LT_Index : this.m_RT_LT_Index;
                break;
            }
            case 1: {
                idx = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this.m_Notify_NE_Index : this.m_RT_NE_Index;
            }
        }
        idx.removeEntryIndexedField(pTemplate.m_TemplateHolder, this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData()), pTemplate, oi);
        return refpos;
    }

    private static int removeExtendedIndexTemplateGeneralList(TemplateCacheInfo pTemplate, int refpos, TypeData typeData) {
        IObjectInfo<TemplateCacheInfo> oi = pTemplate.m_BackRefs.get(refpos++);
        if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
            typeData.getNotifyExtendedTemplates().remove(oi);
        } else {
            typeData.getReadTakeExtendedTemplates().remove(oi);
        }
        return refpos;
    }

    private static int removeBasicIndexTemplate(TemplateCacheInfo pTemplate, IObjectInfo<TemplateCacheInfo> oi, int refpos, TypeData typeData) {
        TypeDataIndex[] indexes;
        for (TypeDataIndex index : indexes = typeData.getIndexes()) {
            if (index.getIndexCreationNumber() > pTemplate.getLatestIndexCreationNumber() || index.isCompound()) continue;
            refpos = index.removeBasicIndexTemplate(pTemplate, oi, refpos);
        }
        return refpos;
    }

    protected int removeBasicIndexTemplate(TemplateCacheInfo pTemplate, IObjectInfo<TemplateCacheInfo> oi, int refpos) {
        boolean isNullIndex;
        int pos = this.getPos();
        oi = pTemplate.m_BackRefs.get(refpos++);
        Object indexValueForTemplate = this.getIndexValueForTemplate(pTemplate.m_TemplateHolder.getEntryData());
        boolean bl = isNullIndex = indexValueForTemplate == null || pTemplate.m_TemplateHolder.hasExtendedMatchCodes() && pos < pTemplate.m_TemplateHolder.getExtendedMatchCodes().length && pTemplate.m_TemplateHolder.getExtendedMatchCodes()[pos] != 0;
        if (isNullIndex) {
            if (pTemplate.m_TemplateHolder.isNotifyTemplate()) {
                this._NNullTemplates.remove(oi);
            } else {
                this._RTNullTemplates.remove(oi);
            }
        } else {
            IStoredList<TemplateCacheInfo>[] t_vec = pTemplate.m_TemplateHolder.isNotifyTemplate() ? this._NTemplates.get(indexValueForTemplate) : this._RTTemplates.get(indexValueForTemplate);
            t_vec[0].remove(oi);
        }
        return refpos;
    }

    static Object getTemplatesExtendedIndexSearch(TypeData templateType, MatchTarget matchTarget, IEntryHolder entry, Object originalResult) {
        IStoredList<TemplateCacheInfo> gl;
        boolean notify = matchTarget == MatchTarget.NOTIFY;
        Object newResult = null;
        IEntryData entryData = entry.getEntryData();
        TypeDataIndex[] indexes = templateType.getIndexes();
        boolean any_zero_field_value = false;
        if (templateType.anyInitialExtendedIndex()) {
            for (TypeDataIndex index : indexes) {
                if (index.getIndexCreationNumber() > 0 || !index.getIndexType().isOrdered() || index.isCompound()) continue;
                Object entryValue = index.getIndexValue(entryData);
                any_zero_field_value |= entryValue == null;
                if (index.getExtendedIndexForScanning() == null) continue;
                Object resultOIS = null;
                if (any_zero_field_value) continue;
                newResult = TypeDataIndex.integrateTemplatesResult((List)newResult, originalResult, index.getExtendedTemplatesIndexSearch(entryValue, notify, (short)3, (short)5));
                newResult = TypeDataIndex.integrateTemplatesResult((List)newResult, originalResult, index.getExtendedTemplatesIndexSearch(entryValue, notify, (short)5, (short)3));
                newResult = TypeDataIndex.integrateTemplatesResult((List)newResult, originalResult, index.getExtendedTemplatesIndexSearch(entryValue, notify, (short)1, (short)2));
                newResult = TypeDataIndex.integrateTemplatesResult((List)newResult, originalResult, index.getExtendedTemplatesIndexSearch(entryValue, notify, (short)1, (short)4));
            }
        }
        if ((gl = templateType.getExtendedTemplates(matchTarget)) != null && !gl.isEmpty()) {
            newResult = TypeDataIndex.integrateTemplatesResult((List)newResult, originalResult, gl);
        }
        return newResult != null ? newResult : originalResult;
    }

    private static List integrateTemplatesResult(List newResult, Object originalResult, Object searchResult) {
        if (searchResult != null) {
            if (newResult == null) {
                if (originalResult instanceof List) {
                    newResult = (List)originalResult;
                } else {
                    newResult = new ArrayList<Object>();
                    if (originalResult instanceof IStoredList) {
                        newResult.add(originalResult);
                    } else {
                        newResult.addAll(Arrays.asList((IStoredList[])originalResult));
                    }
                }
            }
            newResult.add(searchResult);
        }
        return newResult;
    }

    IScanListIterator<TemplateCacheInfo> getExtendedTemplatesIndexSearch(Object fieldValue, boolean isNotifySearch, short templatesMatchCode, short scanMatchCode) {
        IExtendedIndex<Object, TemplateCacheInfo> idx = null;
        switch (templatesMatchCode) {
            case 2: 
            case 3: {
                idx = isNotifySearch ? this.m_Notify_GT_Index : this.m_RT_GT_Index;
                break;
            }
            case 4: 
            case 5: {
                idx = isNotifySearch ? this.m_Notify_LT_Index : this.m_RT_LT_Index;
                break;
            }
            case 1: {
                idx = isNotifySearch ? this.m_Notify_NE_Index : this.m_RT_NE_Index;
            }
        }
        return idx.establishScan(fieldValue, scanMatchCode, null, true);
    }

    public TypeDataIndex getCompoundFifoGroupsIndexForSegment() {
        return this._compoundFifoGroupsIndex;
    }

    public void setCompoundFifoGroupsIndexForSegment(TypeDataIndex fgIndex) {
        this._compoundFifoGroupsIndex = fgIndex;
    }

    public IFifoGroupsIndexExtention<K> getFifoGroupsIndexExtention() {
        return this._fifoGroupsIndexExtention;
    }

    public TypeDataIndex[] getSegmentsOriginatingIndexes() {
        throw new UnsupportedOperationException();
    }

    public CompoundIndexSegmentTypeData[] getCompoundIndexSegments() {
        throw new UnsupportedOperationException();
    }

    public Object getCompoundIndexValueForTemplate(ServerEntry entry) {
        throw new UnsupportedOperationException();
    }

    public TemplatesExtendedIndexHandler<K> getM_RT_GT_Index() {
        return this.m_RT_GT_Index;
    }

    public TemplatesExtendedIndexHandler<K> getM_RT_LT_Index() {
        return this.m_RT_LT_Index;
    }

    public TemplatesExtendedIndexHandler<K> getM_RT_NE_Index() {
        return this.m_RT_NE_Index;
    }

    public static enum UpdateIndexModes {
        REPLACE_NONEQUALS,
        INSERT_NONEQUALS,
        REMOVE_NONEQUALS;

    }
}

