/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.NullIteratorException;
import com.j_spaces.core.cache.SAIterBase;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;

@InternalApi
public class UnderXtnEntriesIter
extends SAIterBase
implements ISAdapterIterator {
    private final boolean _returnPEntry;
    private final IStoredList<IEntryCacheInfo> _entries;
    private IStoredListIterator<IEntryCacheInfo> _pos;
    private IEntryCacheInfo _currentEntry;

    public UnderXtnEntriesIter(Context context, XtnEntry xtnEntry, int selectType, CacheManager cacheManager, boolean returnPEntry) throws SAException, NullIteratorException {
        super(context, cacheManager);
        XtnData pXtn = xtnEntry.getXtnData();
        if (pXtn == null) {
            this.close();
            throw new NullIteratorException();
        }
        this._returnPEntry = returnPEntry;
        this._entries = pXtn.getUnderXtnEntries(selectType);
        if (this._entries != null) {
            this._pos = this._entries.establishListScan(false);
        }
    }

    public Object next() throws SAException {
        this.checkIfNext();
        if (this._returnPEntry) {
            return this._currentEntry;
        }
        return this._currentEntry == null ? null : this._currentEntry.getEntryHolder(this._cacheManager);
    }

    private void checkIfNext() {
        while (this._pos != null) {
            IEntryCacheInfo pEntry = this._pos.getSubject();
            if (pEntry != null) {
                this._currentEntry = pEntry;
                this._pos = this._entries.next(this._pos);
                return;
            }
            this._pos = this._entries.next(this._pos);
        }
        this._currentEntry = null;
    }

    @Override
    public void close() throws SAException {
        if (this._entries != null) {
            this._entries.freeSLHolder(this._pos);
        }
        super.close();
    }
}

