/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.MatchTarget;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.NullIteratorException;
import com.j_spaces.core.cache.SAIterBase;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cache.XtnData;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;

@InternalApi
public class UnderXtnTemplatesIter
extends SAIterBase
implements ISAdapterIterator<ITemplateHolder> {
    private final IStoredList<TemplateCacheInfo> _templates;
    private IStoredListIterator<TemplateCacheInfo> _pos;
    private TemplateCacheInfo _currentTemplate;

    public UnderXtnTemplatesIter(Context context, XtnEntry xtnEntry, MatchTarget matchTarget, CacheManager cacheManager) throws SAException, NullIteratorException {
        super(context, cacheManager);
        XtnData pXtn = xtnEntry.getXtnData();
        if (pXtn == null) {
            this.close();
            throw new NullIteratorException();
        }
        IStoredList<TemplateCacheInfo> iStoredList = this._templates = matchTarget == MatchTarget.NOTIFY ? pXtn.getNTemplates() : pXtn.getRTTemplates();
        if (this._templates != null) {
            this._pos = this._templates.establishListScan(false);
        }
    }

    @Override
    public ITemplateHolder next() throws SAException {
        this.checkIfNext();
        return this._currentTemplate == null ? null : this._currentTemplate.m_TemplateHolder;
    }

    private void checkIfNext() {
        while (this._pos != null) {
            TemplateCacheInfo pTemplate = this._pos.getSubject();
            if (pTemplate != null && !pTemplate.m_TemplateHolder.isDeleted()) {
                this._currentTemplate = pTemplate;
                this._pos = this._templates.next(this._pos);
                return;
            }
            this._pos = this._templates.next(this._pos);
        }
        this._currentTemplate = null;
    }

    @Override
    public void close() throws SAException {
        if (this._templates != null) {
            this._templates.freeSLHolder(this._pos);
        }
        super.close();
    }
}

