/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.OperationID;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class XtnData {
    private final XtnEntry _xtnEntry;
    private volatile IStoredList<IEntryCacheInfo> _newEntries;
    private volatile IStoredList<IEntryCacheInfo> _lockedEntries;
    private volatile IStoredList<IEntryCacheInfo> _lockedFifoEntries;
    private volatile IStoredList<IEntryCacheInfo> _needNotifyEntries;
    private volatile IStoredList<IEntryCacheInfo> _takenEntries;
    private Map<String, String> _reWrittenEntries;
    private volatile IStoredList<TemplateCacheInfo> _RTTemplates;
    private volatile IStoredList<TemplateCacheInfo> _NTemplates;
    private long _fifoXtnNumber = -1L;
    private volatile Map<String, OperationID> _entriesOperationIDs;
    private volatile Map<OperationID, OperationID> _OperationIDs;
    private volatile HashMap<String, Object> _updatedEntries;
    private volatile Map<String, Object> _fifoGroupsEntries;
    private List<IEntryHolder> _entriesForFifoGroupScan;
    private List<IEntryHolder> _entriesForReplicationIn2PCommit;
    private static final boolean[] EMPTY_INDICATORS = new boolean[0];

    public XtnData(XtnEntry xtnEntry) {
        this._xtnEntry = xtnEntry;
    }

    public boolean isLockedEntry(IEntryCacheInfo pEntry) {
        IStoredList<IEntryCacheInfo> lockedEntries = this.getLockedEntries();
        return lockedEntries != null && lockedEntries.contains(pEntry);
    }

    public void signalRewrittenEntry(String uid) {
        if (this._reWrittenEntries == null) {
            this._reWrittenEntries = new ConcurrentHashMap<String, String>();
        }
        this._reWrittenEntries.put(uid, uid);
    }

    public boolean isReWrittenEntry(String uid) {
        return this._reWrittenEntries != null && this._reWrittenEntries.containsKey(uid);
    }

    public void removeRewrittenEntryIndication(String uid) {
        if (this._reWrittenEntries != null) {
            this._reWrittenEntries.remove(uid);
        }
    }

    public IStoredList<IEntryCacheInfo> getUnderXtnEntries(int selectType) {
        IStoredList<IEntryCacheInfo> entries = null;
        switch (selectType) {
            case 1: {
                entries = this._newEntries;
                break;
            }
            case 3: {
                entries = this._needNotifyEntries;
                break;
            }
            case 4: {
                entries = this._takenEntries;
                break;
            }
            case 5: {
                entries = this._lockedFifoEntries;
                break;
            }
            default: {
                entries = this._lockedEntries;
            }
        }
        return entries;
    }

    public boolean anyFifoEntries() {
        IStoredList<IEntryCacheInfo> lockedFifoEntries = this._lockedFifoEntries;
        return lockedFifoEntries != null && !lockedFifoEntries.isEmpty();
    }

    public ServerTransaction getXtn() {
        return this._xtnEntry.m_Transaction;
    }

    public XtnEntry getXtnEntry() {
        return this._xtnEntry;
    }

    public void addLockedEntry(IEntryCacheInfo pEntry, OperationID operationID, boolean fifo) {
        this.getLockedEntries(true).add(pEntry);
        if (fifo) {
            this.getLockedFifoEntries(true).add(pEntry);
        }
        if (operationID != null) {
            Map<String, OperationID> entriesOperationIDs = this._entriesOperationIDs;
            if (entriesOperationIDs == null) {
                this._entriesOperationIDs = entriesOperationIDs = new Hashtable<String, OperationID>();
                this._OperationIDs = new Hashtable<OperationID, OperationID>();
            }
            entriesOperationIDs.put(pEntry.getUID(), operationID);
            this._OperationIDs.put(operationID, operationID);
        }
    }

    public void updateLock(IEntryCacheInfo pEntry, OperationID operationID, boolean isReadOperation, boolean fifo) {
        IStoredList<IEntryCacheInfo> newEntries;
        IStoredList<IEntryCacheInfo> iStoredList = newEntries = !isReadOperation ? this.getNewEntries() : null;
        if (!(isReadOperation || newEntries != null && newEntries.contains(pEntry))) {
            IStoredList<IEntryCacheInfo> lockedEntries = this.getLockedEntries(true);
            lockedEntries.removeByObject(pEntry);
            lockedEntries.add(pEntry);
            if (fifo) {
                IStoredList<IEntryCacheInfo> lockedFifoEntries = this.getLockedFifoEntries(true);
                lockedFifoEntries.removeByObject(pEntry);
                lockedFifoEntries.add(pEntry);
            }
        }
        if (operationID != null) {
            Map<String, OperationID> entriesOperationIDs = this._entriesOperationIDs;
            if (entriesOperationIDs == null) {
                this._entriesOperationIDs = entriesOperationIDs = new Hashtable<String, OperationID>();
                this._OperationIDs = new Hashtable<OperationID, OperationID>();
            }
            entriesOperationIDs.put(pEntry.getUID(), operationID);
            this._OperationIDs.put(operationID, operationID);
        }
    }

    public OperationID getOperationID(String uid) {
        Map<String, OperationID> entriesOperationIDs = this._entriesOperationIDs;
        return entriesOperationIDs != null ? entriesOperationIDs.get(uid) : null;
    }

    public boolean isOperationID(OperationID oi) {
        Map<OperationID, OperationID> eois = this._OperationIDs;
        return eois != null && eois.containsKey(oi);
    }

    public void setUpdatedEntry(IEntryHolder eh, boolean[] partialUpdateIndicators) {
        HashMap<String, Object> updatedEntries = this._updatedEntries;
        if (updatedEntries == null) {
            this._updatedEntries = updatedEntries = new HashMap();
        }
        boolean[] partialUpdateIndicatorsToUse = EMPTY_INDICATORS;
        if (partialUpdateIndicators != null) {
            Object curPartialUpdateInfo = updatedEntries.get(eh.getUID());
            boolean[] curPartialUpdateIndicators = EMPTY_INDICATORS;
            if (curPartialUpdateInfo != null && curPartialUpdateInfo instanceof boolean[]) {
                curPartialUpdateIndicators = (boolean[])curPartialUpdateInfo;
            }
            boolean any_partial = false;
            if (curPartialUpdateInfo == null) {
                partialUpdateIndicatorsToUse = partialUpdateIndicators;
            } else if (curPartialUpdateIndicators != EMPTY_INDICATORS && partialUpdateIndicators.length == curPartialUpdateIndicators.length) {
                partialUpdateIndicatorsToUse = curPartialUpdateIndicators;
                for (int i = 0; i < partialUpdateIndicators.length; ++i) {
                    partialUpdateIndicatorsToUse[i] = partialUpdateIndicatorsToUse[i] && partialUpdateIndicators[i];
                    any_partial = any_partial || partialUpdateIndicatorsToUse[i];
                }
                if (!any_partial) {
                    partialUpdateIndicatorsToUse = EMPTY_INDICATORS;
                }
            }
        }
        updatedEntries.put(eh.getUID(), partialUpdateIndicatorsToUse);
    }

    public void setInPlaceUpdatedEntry(IEntryHolder eh, Collection<SpaceEntryMutator> mutators) {
        HashMap<String, Object> updatedEntries = this._updatedEntries;
        if (updatedEntries == null) {
            updatedEntries = new HashMap();
            this._updatedEntries = updatedEntries;
        }
        Object updateInfoToUse = mutators;
        Object curInfo = updatedEntries.get(eh.getUID());
        if (curInfo != null && !(curInfo instanceof List)) {
            updateInfoToUse = EMPTY_INDICATORS;
        } else if (curInfo != null) {
            Collection curMutators = (Collection)curInfo;
            for (SpaceEntryMutator sm : mutators) {
                curMutators.add(sm);
            }
            return;
        }
        updatedEntries.put(eh.getUID(), updateInfoToUse);
    }

    public boolean isUpdatedEntry(IEntryHolder eh) {
        HashMap<String, Object> updatedEntries = this._updatedEntries;
        return updatedEntries != null && updatedEntries.containsKey(eh.getUID());
    }

    public HashMap<String, Object> getUpdatedEntries() {
        return this._updatedEntries;
    }

    public void addToEntriesForFifoGroupScan(IEntryHolder entry) {
        if (this._entriesForFifoGroupScan == null) {
            this._entriesForFifoGroupScan = new ArrayList<IEntryHolder>();
        }
        this._entriesForFifoGroupScan.add(entry.createCopy());
    }

    public List<IEntryHolder> getEntriesForFifoGroupScan() {
        return this._entriesForFifoGroupScan;
    }

    public void resetEntriesForFifoGroupsScan() {
        this._entriesForFifoGroupScan = null;
    }

    public boolean anyEntriesForFifoGroupScan() {
        return this._entriesForFifoGroupScan != null && !this._entriesForFifoGroupScan.isEmpty();
    }

    public void addToFifoGroupsEntries(IEntryHolder eh, Object groupValue) {
        Map<String, Object> fifoGroupsEntries = this._fifoGroupsEntries;
        if (fifoGroupsEntries == null) {
            this._fifoGroupsEntries = fifoGroupsEntries = new HashMap<String, Object>();
        }
        fifoGroupsEntries.put(eh.getUID(), groupValue);
    }

    public Map<String, Object> getFifoGroupsEntries() {
        return this._fifoGroupsEntries;
    }

    public boolean anyFifoGroupOperations() {
        Map<String, Object> fifoGroupsEntries = this._fifoGroupsEntries;
        return fifoGroupsEntries != null && !fifoGroupsEntries.isEmpty();
    }

    public IStoredList<IEntryCacheInfo> getLockedEntries() {
        return this.getLockedEntries(false);
    }

    public IStoredList<IEntryCacheInfo> getLockedEntries(boolean createIfNull) {
        IStoredList<IEntryCacheInfo> res = this._lockedEntries;
        if (createIfNull && res == null) {
            this._lockedEntries = res = StoredListFactory.createHashList();
        }
        return res;
    }

    public boolean anyLockedEntries() {
        IStoredList<IEntryCacheInfo> res = this._lockedEntries;
        return res != null && !res.isEmpty();
    }

    public void setFifoXtnNumber(long fifoXtnNumber) {
        this._fifoXtnNumber = fifoXtnNumber;
    }

    public long getFifoXtnNumber() {
        return this._fifoXtnNumber;
    }

    public IStoredList<IEntryCacheInfo> getLockedFifoEntries() {
        return this.getLockedFifoEntries(false);
    }

    public IStoredList<IEntryCacheInfo> getLockedFifoEntries(boolean createIfNull) {
        IStoredList<IEntryCacheInfo> locked = this._lockedFifoEntries;
        if (createIfNull && locked == null) {
            this._lockedFifoEntries = locked = StoredListFactory.createHashList();
        }
        return locked;
    }

    public IStoredList<IEntryCacheInfo> getNeedNotifyEntries() {
        return this.getNeedNotifyEntries(false);
    }

    public IStoredList<IEntryCacheInfo> getNeedNotifyEntries(boolean createIfNull) {
        IStoredList<IEntryCacheInfo> res = this._needNotifyEntries;
        if (createIfNull && res == null) {
            this._needNotifyEntries = res = StoredListFactory.createList(false);
        }
        return res;
    }

    public IStoredList<IEntryCacheInfo> getNewEntries() {
        return this.getNewEntries(false);
    }

    public IStoredList<IEntryCacheInfo> getNewEntries(boolean createIfNull) {
        IStoredList<IEntryCacheInfo> res = this._newEntries;
        if (createIfNull && res == null) {
            this._newEntries = res = StoredListFactory.createHashList();
        }
        return res;
    }

    public void removeFromNewEntries(IEntryCacheInfo subject) {
        IStoredList<IEntryCacheInfo> newEntries = this.getNewEntries();
        if (newEntries != null) {
            newEntries.removeByObject(subject);
        }
    }

    public IStoredList<IEntryCacheInfo> getTakenEntries() {
        return this.getTakenEntries(false);
    }

    public IStoredList<IEntryCacheInfo> getTakenEntries(boolean createIfNull) {
        IStoredList<IEntryCacheInfo> res = this._takenEntries;
        if (createIfNull && res == null) {
            this._takenEntries = res = StoredListFactory.createHashList();
        }
        return res;
    }

    public void addToTakenEntriesIfNotInside(IEntryCacheInfo entry) {
        IStoredList<IEntryCacheInfo> taken = this.getTakenEntries(true);
        if (!taken.contains(entry)) {
            taken.add(entry);
        }
    }

    public void removeTakenEntry(IEntryCacheInfo entry) {
        IStoredList<IEntryCacheInfo> taken = this.getTakenEntries();
        if (taken != null) {
            taken.removeByObject(entry);
        }
    }

    public IStoredList<TemplateCacheInfo> getNTemplates() {
        return this._NTemplates;
    }

    public IStoredList<TemplateCacheInfo> getNTemplates(boolean createIfNull) {
        IStoredList<TemplateCacheInfo> res = this._NTemplates;
        if (createIfNull && res == null) {
            this._NTemplates = res = StoredListFactory.createList(false);
        }
        return res;
    }

    public IStoredList<TemplateCacheInfo> getRTTemplates() {
        return this.getRTTemplates(false);
    }

    public IStoredList<TemplateCacheInfo> getRTTemplates(boolean createIfNull) {
        IStoredList<TemplateCacheInfo> res = this._RTTemplates;
        if (createIfNull && res == null) {
            this._RTTemplates = res = StoredListFactory.createList(false);
        }
        return res;
    }

    public void setEntriesForReplicationIn2PCommit(List<IEntryHolder> pLocked) {
        this._entriesForReplicationIn2PCommit = pLocked;
    }

    public List<IEntryHolder> getEntriesForReplicationIn2PCommit() {
        return this._entriesForReplicationIn2PCommit;
    }
}

