/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.cache.CacheOperationReason;
import com.j_spaces.core.cache.blobStore.BlobStoreCacheImpl;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreInternalCacheFilter;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreCacheHandler;
import com.j_spaces.core.cache.blobStore.IBlobStoreCacheImpl;
import com.j_spaces.core.cache.context.Context;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreCacheHandler
implements IBlobStoreCacheHandler {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private final int BLOB_STORE_INTERNAL_CACHE_CAPACITY;
    private final MetricRegistrator _blobstoreMetricRegistrar;
    private final IBlobStoreCacheImpl _blobStoreCacheImpl;
    private BlobStoreInternalCacheFilter _blobStoreInternalCacheFilter;
    private volatile boolean _isBlobStoreInternalCacheFilterEnabled = false;
    private boolean printLog = true;

    public BlobStoreCacheHandler(Properties properties) {
        this.BLOB_STORE_INTERNAL_CACHE_CAPACITY = Integer.parseInt(properties.getProperty("space-config.engine.blobstore_cache_size", "10000"));
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("BlobStore space data internal cache size=" + this.BLOB_STORE_INTERNAL_CACHE_CAPACITY);
        }
        this._blobStoreCacheImpl = new BlobStoreCacheImpl(this.BLOB_STORE_INTERNAL_CACHE_CAPACITY);
        this._blobstoreMetricRegistrar = (MetricRegistrator)properties.get("blobstoreMetricRegistrar");
        this.registerOperations();
    }

    private boolean evaluateAndReturnIfEntryMatchesFilter(Context context, BlobStoreEntryHolder entry) {
        boolean val = this._isBlobStoreInternalCacheFilterEnabled ? this._blobStoreInternalCacheFilter.isEntryHotData(entry, context) : true;
        entry.getBlobStoreResidentPart().setMatchCacheFilter(this, val);
        return val;
    }

    private boolean isEntryHotData(BlobStoreEntryHolder entry) {
        return entry.getBlobStoreResidentPart().isMatchCacheFilter(this);
    }

    @Override
    public BlobStoreEntryHolder get(BlobStoreRefEntryCacheInfo entryCacheInfo) {
        if (this.isDisabledCache()) {
            return null;
        }
        return this._blobStoreCacheImpl.get(entryCacheInfo);
    }

    @Override
    public void handleOnSpaceOperation(Context context, BlobStoreEntryHolder entry, CacheOperationReason cacheOperationReason) {
        if (this.isDisabledCache()) {
            return;
        }
        if (cacheOperationReason != CacheOperationReason.ON_TAKE && (entry.isDeleted() || entry.isPhantom() || entry.isOptimizedEntry())) {
            return;
        }
        switch (cacheOperationReason) {
            case ON_READ: {
                if (this.isEntryHotData(entry)) {
                    this._blobStoreCacheImpl.storeOrTouch(entry);
                    break;
                }
                if (!this._isBlobStoreInternalCacheFilterEnabled) break;
                this._blobStoreInternalCacheFilter.incrementColdDataMisses();
                break;
            }
            case ON_WRITE: {
                if (!this.evaluateAndReturnIfEntryMatchesFilter(context, entry)) break;
                this._blobStoreCacheImpl.storeOrTouch(entry);
                break;
            }
            case ON_UPDATE: {
                boolean curMatch = this.isEntryHotData(entry);
                if (!curMatch && this._isBlobStoreInternalCacheFilterEnabled) {
                    this._blobStoreInternalCacheFilter.incrementColdDataMisses();
                }
                if (this.evaluateAndReturnIfEntryMatchesFilter(context, entry)) {
                    this._blobStoreCacheImpl.storeOrTouch(entry);
                    break;
                }
                if (!curMatch) break;
                this._blobStoreCacheImpl.remove(entry);
                break;
            }
            case ON_INITIAL_LOAD: {
                if (!this.evaluateAndReturnIfEntryMatchesFilter(context, entry) || this.isFull()) break;
                if (this._isBlobStoreInternalCacheFilterEnabled) {
                    this._blobStoreInternalCacheFilter.incrementInsertedToBlobStoreInternalCacheOnInitialLoad();
                }
                this._blobStoreCacheImpl.storeOrTouch(entry);
                break;
            }
            case ON_TAKE: {
                if (this.isEntryHotData(entry)) {
                    this._blobStoreCacheImpl.remove(entry);
                    break;
                }
                if (!this._isBlobStoreInternalCacheFilterEnabled) break;
                this._blobStoreInternalCacheFilter.incrementColdDataMisses();
                break;
            }
            default: {
                throw new UnsupportedOperationException("invalid space operation in BlobStore cache");
            }
        }
    }

    private boolean isDisabledCache() {
        return this.BLOB_STORE_INTERNAL_CACHE_CAPACITY == 0;
    }

    private void registerOperations() {
        this._blobstoreMetricRegistrar.register("cache-size", this._blobStoreCacheImpl.getCacheSize());
        this._blobstoreMetricRegistrar.register("cache-miss", new Gauge<Long>(){

            @Override
            public Long getValue() throws Exception {
                return BlobStoreCacheHandler.this.getMissCount();
            }
        });
        this._blobstoreMetricRegistrar.register("cache-hit", this._blobStoreCacheImpl.getHitCount());
    }

    @Override
    public boolean isFull() {
        boolean isFull = this._blobStoreCacheImpl.isFull();
        if (isFull && this.printLog) {
            _logger.info("Blobstore cache is full with size [ " + this.getCacheSize() + " ]");
            this.printLog = false;
        }
        return isFull;
    }

    @Override
    public long getCacheSize() {
        return this._blobStoreCacheImpl.getCacheSize().getCount();
    }

    @Override
    public BlobStoreInternalCacheFilter getBlobStoreInternalCacheFilter() {
        return this._blobStoreInternalCacheFilter;
    }

    @Override
    public void setBlobStoreInternalCacheFilter(BlobStoreInternalCacheFilter blobStoreInternalCacheFilter) {
        this._blobStoreInternalCacheFilter = blobStoreInternalCacheFilter;
        boolean bl = this._isBlobStoreInternalCacheFilterEnabled = blobStoreInternalCacheFilter != null;
        if (this._isBlobStoreInternalCacheFilterEnabled) {
            this.registerHotDataMetric();
        }
    }

    private void registerHotDataMetric() {
        this._blobstoreMetricRegistrar.register("hot-data-cache-miss", this._blobStoreCacheImpl.getMissCount());
    }

    @Override
    public long getMissCount() {
        long coldDataMisses = this._isBlobStoreInternalCacheFilterEnabled ? this._blobStoreInternalCacheFilter.getColdDataMissCount().getCount() : 0L;
        return this._blobStoreCacheImpl.getMissCount().getCount() + coldDataMisses;
    }

    @Override
    public long getHitCount() {
        return this._blobStoreCacheImpl.getHitCount().getCount();
    }

    @Override
    public long getHotDataCacheMiss() {
        return this._blobStoreCacheImpl.getMissCount().getCount();
    }
}

