/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicIntegerFieldUpdater;
import com.gigaspaces.metrics.LongCounter;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreCacheImpl;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreCacheImpl
implements IBlobStoreCacheImpl {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private final int BLOB_STORE_INTERNAL_CACHE_CAPACITY;
    private final ConcurrentMap<BlobStoreRefEntryCacheInfo, CacheInfoHolder> _entries;
    private final IStoredList<CacheInfoHolder> _quasiLru;
    private final LongCounter _cacheCounter = new LongCounter();
    private final AtomicInteger _cacheSize = new AtomicInteger();
    private final LongCounter _hit = new LongCounter();
    private final LongCounter _miss = new LongCounter();

    public BlobStoreCacheImpl(int capacity) {
        this.BLOB_STORE_INTERNAL_CACHE_CAPACITY = capacity;
        int numOfCHMSegents = Integer.getInteger("com.gs.cacheManager.hashmapSegments", 64);
        this._entries = new ConcurrentHashMap<BlobStoreRefEntryCacheInfo, CacheInfoHolder>(this.BLOB_STORE_INTERNAL_CACHE_CAPACITY, 0.75f, numOfCHMSegents);
        this._quasiLru = StoredListFactory.createConcurrentSegmentedList(true);
    }

    @Override
    public BlobStoreEntryHolder get(BlobStoreRefEntryCacheInfo entryCacheInfo) {
        if (this.isDisabledCache()) {
            return null;
        }
        CacheInfoHolder cih = (CacheInfoHolder)this._entries.get(entryCacheInfo);
        if (cih != null) {
            this._hit.inc();
            return cih.getEntry();
        }
        this._miss.inc();
        return null;
    }

    @Override
    public void storeOrTouch(BlobStoreEntryHolder entry) {
        if (this.isDisabledCache()) {
            return;
        }
        CacheInfoHolder cih = (CacheInfoHolder)this._entries.get(entry.getBlobStoreResidentPart());
        if (cih == null) {
            this.insert(entry);
        } else {
            this.touch(cih, entry);
        }
    }

    private void insert(BlobStoreEntryHolder entry) {
        CacheInfoHolder cih = new CacheInfoHolder(entry);
        if (this._entries.putIfAbsent(entry.getBlobStoreResidentPart(), cih) != null) {
            return;
        }
        cih.setPos(this._quasiLru.add(cih));
        cih.resetPending();
        if (cih.isDeleted() && this.remove(cih, false)) {
            return;
        }
        this._cacheCounter.inc();
        if (this._cacheSize.incrementAndGet() > this.BLOB_STORE_INTERNAL_CACHE_CAPACITY) {
            this.evict(cih);
        }
        if (entry.isDeleted() && !cih.isDeleted()) {
            this.remove(entry);
        }
    }

    private boolean remove(CacheInfoHolder cih, boolean decrementSize) {
        if (!cih.setRemoved()) {
            return false;
        }
        if (decrementSize) {
            this._cacheCounter.dec();
            this._cacheSize.decrementAndGet();
        }
        this._quasiLru.remove(cih.getPos());
        this._entries.remove(cih.getEntry().getBlobStoreResidentPart(), cih);
        return true;
    }

    private void touch(CacheInfoHolder cih, BlobStoreEntryHolder entry) {
        if (cih.getEntry().getBlobStoreVersion() < entry.getBlobStoreVersion()) {
            cih.setEntry(entry);
        }
        if (this._cacheSize.get() <= this.BLOB_STORE_INTERNAL_CACHE_CAPACITY / 10) {
            return;
        }
        if (!cih.setPending()) {
            return;
        }
        this._quasiLru.remove(cih.getPos());
        cih.setPos(this._quasiLru.add(cih));
        cih.resetPending();
        if (cih.isDeleted()) {
            this.remove(cih, false);
        }
    }

    @Override
    public void remove(BlobStoreEntryHolder entry) {
        if (this.isDisabledCache()) {
            return;
        }
        CacheInfoHolder cih = (CacheInfoHolder)this._entries.get(entry.getBlobStoreResidentPart());
        if (cih != null && !cih.isRemoved()) {
            cih.setDeleted();
            this.remove(cih, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict(CacheInfoHolder cih) {
        try {
            ScanSingleListIterator<CacheInfoHolder> toScan = new ScanSingleListIterator<CacheInfoHolder>(this._quasiLru, true);
            try {
                while (toScan != null && toScan.hasNext()) {
                    CacheInfoHolder cur_cih = (CacheInfoHolder)toScan.next();
                    if (cur_cih == null || cur_cih == cih || cur_cih.isDeleted() || cur_cih.isRemoved()) continue;
                    cur_cih.setDeleted();
                    this.remove(cur_cih, true);
                    return;
                }
            }
            finally {
                if (toScan != null) {
                    toScan.releaseScan();
                }
            }
        }
        catch (SAException sAException) {
            // empty catch block
        }
    }

    private boolean isDisabledCache() {
        return this.BLOB_STORE_INTERNAL_CACHE_CAPACITY == 0;
    }

    @Override
    public boolean isFull() {
        return this._cacheSize.get() >= this.BLOB_STORE_INTERNAL_CACHE_CAPACITY;
    }

    @Override
    public LongCounter getCacheSize() {
        return this._cacheCounter;
    }

    @Override
    public LongCounter getHitCount() {
        return this._hit;
    }

    @Override
    public LongCounter getMissCount() {
        return this._miss;
    }

    private static class CacheInfoHolder {
        private volatile BlobStoreEntryHolder _entry;
        private volatile IObjectInfo<CacheInfoHolder> _pos;
        static final int _STATUS_PENDING = 1;
        static final int _STATUS_UNPENDING = -2;
        static final int _STATUS_DELETED = 2;
        static final int _STATUS_REMOVED = 4;
        private volatile int _status = 1;
        private static final AtomicIntegerFieldUpdater<CacheInfoHolder> cacheStatusUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(CacheInfoHolder.class, "_status");

        CacheInfoHolder(BlobStoreEntryHolder entry) {
            this._entry = entry;
        }

        boolean isPending() {
            return (this._status & 1) == 1;
        }

        boolean setPending() {
            return cacheStatusUpdater.compareAndSet(this, 0, 1);
        }

        void resetPending() {
            int newStat;
            int stat;
            while (!cacheStatusUpdater.compareAndSet(this, stat = this._status, newStat = stat & 0xFFFFFFFE)) {
            }
        }

        boolean isDeleted() {
            return (this._status & 2) == 2;
        }

        void setDeleted() {
            int newStat;
            int stat;
            while (!cacheStatusUpdater.compareAndSet(this, stat = this._status, newStat = stat | 2)) {
            }
        }

        boolean isRemoved() {
            return (this._status & 4) == 4;
        }

        boolean setRemoved() {
            return cacheStatusUpdater.compareAndSet(this, 2, 4);
        }

        BlobStoreEntryHolder getEntry() {
            return this._entry;
        }

        void setEntry(BlobStoreEntryHolder entry) {
            this._entry = entry;
        }

        IObjectInfo<CacheInfoHolder> getPos() {
            return this._pos;
        }

        void setPos(IObjectInfo<CacheInfoHolder> pos) {
            this._pos = pos;
        }
    }
}

