/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.embeddedSyncList.EntryHolderEmbeddedSyncOpInfo;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.storage.EntryHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CacheOperationReason;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBulkInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.locks.ILockObject;

@InternalApi
public class BlobStoreEntryHolder
extends EntryHolder
implements IBlobStoreEntryHolder {
    private BlobStoreRefEntryCacheInfo _blobStoreResidentPart;
    private String _typeName;
    private BlobStoreBulkInfo _bulkInfo;
    private EntryHolderEmbeddedSyncOpInfo _embeddedSyncOpInfo;
    private short _blobStoreVersion;
    private final boolean _optimizedEntry;
    private byte _entryTypeCode;

    public BlobStoreEntryHolder(IServerTypeDesc typeDesc, String uid, long scn, boolean isTransient, ITransactionalEntryData entryData, boolean optimizedEntry) {
        super(typeDesc, uid, scn, isTransient, entryData);
        this._typeName = typeDesc.getTypeName();
        this._entryTypeCode = entryData.getEntryTypeDesc().getEntryType().getTypeCode();
        this._optimizedEntry = optimizedEntry;
    }

    public BlobStoreEntryHolder(IEntryHolder other) {
        super(other);
        this._optimizedEntry = other.isBlobStoreEntry() ? ((IBlobStoreEntryHolder)((Object)other)).isOptimizedEntry() : false;
        this._typeName = other.getServerTypeDesc().getTypeDesc().getTypeName();
        this._entryTypeCode = this.getEntryData().getEntryTypeDesc().getEntryType().getTypeCode();
    }

    @Override
    public ILockObject getExternalLockObject() {
        return this._blobStoreResidentPart;
    }

    @Override
    public BlobStoreRefEntryCacheInfo getBlobStoreResidentPart() {
        if (this._blobStoreResidentPart == null) {
            throw new RuntimeException("external lock object is null for off-heap entry !!!!");
        }
        return this._blobStoreResidentPart;
    }

    @Override
    public void setBlobStoreResidentPart(BlobStoreRefEntryCacheInfo blobStoreResidentPart) {
        this._blobStoreResidentPart = blobStoreResidentPart;
    }

    @Override
    public boolean isSameEntryInstance(IEntryHolder other) {
        if (this == other) {
            return true;
        }
        if (other == null || !other.isBlobStoreEntry()) {
            return false;
        }
        return this._blobStoreResidentPart == ((IBlobStoreEntryHolder)((Object)other)).getBlobStoreResidentPart();
    }

    @Override
    public boolean isBlobStoreEntry() {
        return true;
    }

    @Override
    public boolean isDeleted() {
        return this._blobStoreResidentPart.isDeleted();
    }

    @Override
    public void setDeleted(boolean val) {
        super.setDeleted(val);
        this._blobStoreResidentPart.setDeleted(val);
    }

    @Override
    public IEntryHolder getLatestEntryVersion(CacheManager cacheManager, boolean attatchToMemory, Context attachingContext) {
        return this._blobStoreResidentPart.getLatestEntryVersion(cacheManager, attatchToMemory, this, attachingContext);
    }

    @Override
    public short getBlobStoreVersion() {
        return this._blobStoreVersion;
    }

    @Override
    public void setBlobStoreVersion(short version) {
        this._blobStoreVersion = version;
    }

    @Override
    public void setDirty(CacheManager cacheManager) {
        this._typeName = this.getTypeName();
        this._entryTypeCode = this.getEntryData().getEntryTypeDesc().getEntryType().getTypeCode();
        this._blobStoreResidentPart.setDirty(true, cacheManager);
    }

    @Override
    public String getTypeName() {
        return this._typeName;
    }

    @Override
    public byte getEntryTypeCode() {
        return this._entryTypeCode;
    }

    @Override
    public void insertOrTouchInternalCache(Context context, CacheManager cacheManager, CacheOperationReason cacheOperationReason) {
        this._blobStoreResidentPart.insertOrTouchInternalCache(context, cacheManager, this, cacheOperationReason);
    }

    @Override
    public BlobStoreBulkInfo getBulkInfo() {
        return this._bulkInfo;
    }

    @Override
    public void setBulkInfo(BlobStoreBulkInfo bulkInfo) {
        this._bulkInfo = bulkInfo;
    }

    @Override
    public EntryHolderEmbeddedSyncOpInfo getEmbeddedSyncOpInfo() {
        return this._embeddedSyncOpInfo;
    }

    @Override
    public void setEmbeddedSyncOpInfo(long generationId, long sequenceId, boolean phantom, boolean partOfMultipleUidsInfo) {
        this._embeddedSyncOpInfo = new EntryHolderEmbeddedSyncOpInfo(generationId, sequenceId, phantom, partOfMultipleUidsInfo);
    }

    @Override
    public boolean isPhantom() {
        return this._embeddedSyncOpInfo != null && this._embeddedSyncOpInfo.isPhantom();
    }

    @Override
    public boolean isOptimizedEntry() {
        return this._optimizedEntry;
    }
}

