/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOArrayException;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.io.MarshObject;
import com.gigaspaces.internal.metadata.EntryType;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.ServerTypeDesc;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.FlatEntryData;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.StorageType;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapterClassInfo;
import com.j_spaces.core.cache.blobStore.sadapter.IBlobStoreStorageAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;

@InternalApi
public class BlobStoreEntryLayout
implements Externalizable {
    private static final long serialVersionUID = -5072883352415904068L;
    private transient boolean _recoverable;
    private transient boolean _onlyIndexesPart;
    private String _m_Uid;
    private long _generationId;
    private long _sequenceId;
    private boolean _phantom;
    private boolean _partOfMultipleUidsInfo;
    private short _blobStoreVersion;
    private String _typeName;
    private byte _entryTypeCode;
    private long _scn;
    private boolean _transient;
    private int _order;
    private int _versionID;
    private long _expirationTime;
    private Object[] _fieldsValues;
    private Map<String, Object> _dynamicProperties;
    static final Map<Class<?>, Serializer> types = new HashMap();
    private transient long _dynamicIndexesRelatedIndicators;
    private transient int _dynamicIndexesRelatedLength;
    private static final byte FLAG_RECOVERABLE = 1;
    private static final byte FLAG_ORDER = 2;
    private static final byte FLAG_VERSIONID = 4;
    private static final byte FLAG_EXPIRATION = 8;
    private static final byte FLAG_DYNAMIC_PROPERTIES = 16;
    private static final byte FLAG_TRANSIENT = 32;
    private static final byte FLAG_CONTAINS_EMBEDDED_SYNC_INFO = 1;
    private static final byte FLAG_PHANTOM_OP = 2;
    private static final byte FLAG_PART_OF_MULTIPLE_OP = 4;

    public BlobStoreEntryLayout(BlobStoreEntryHolder eh, boolean recoverable) {
        if (eh.getEntryData().getEntryDataType() != EntryDataType.FLAT) {
            throw new UnsupportedOperationException("off-heap supported only fpr flat entry-data");
        }
        this._recoverable = recoverable;
        this._m_Uid = eh.getUID();
        this._blobStoreVersion = eh.getBlobStoreVersion();
        this._typeName = eh.getTypeName();
        this._entryTypeCode = eh.getEntryTypeCode();
        this._scn = eh.getSCN();
        this._transient = eh.isTransient();
        this._order = eh.getOrder();
        this._versionID = eh.getEntryData().getVersion();
        this._expirationTime = eh.getExpirationTime();
        this._fieldsValues = eh.getEntryData().getFixedPropertiesValues();
        this._dynamicProperties = eh.getEntryData().getDynamicProperties();
        if (eh.getEmbeddedSyncOpInfo() != null) {
            this._generationId = eh.getEmbeddedSyncOpInfo().getGenerationId();
            this._sequenceId = eh.getEmbeddedSyncOpInfo().getSequenceId();
            this._phantom = eh.getEmbeddedSyncOpInfo().isPhantom();
            this._partOfMultipleUidsInfo = eh.getEmbeddedSyncOpInfo().isPartOfMultipleUidsInfo();
        }
    }

    public BlobStoreEntryLayout() {
    }

    BlobStoreEntryHolder buildBlobStoreEntryHolder(CacheManager cacheManager, BlobStoreRefEntryCacheInfo eci) {
        if (this._phantom) {
            throw new UnsupportedOperationException();
        }
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        EntryTypeDesc entryTypeDesc = typeDesc.getTypeDesc().getEntryTypeDesc(EntryType.fromByte(this._entryTypeCode));
        FlatEntryData entryData = new FlatEntryData(this._fieldsValues, this._dynamicProperties, entryTypeDesc, this._versionID, this._expirationTime, false);
        BlobStoreEntryHolder entry = new BlobStoreEntryHolder(typeDesc, eci.getUID(), this._scn, this._transient, entryData, this._onlyIndexesPart);
        if (this._order > 0) {
            entry.setOrder(this._order);
        }
        entry.setBlobStoreResidentPart(eci);
        entry.setBlobStoreVersion(this._blobStoreVersion);
        if (this._generationId != 0L) {
            entry.setEmbeddedSyncOpInfo(this._generationId, this._sequenceId, this._phantom, this._partOfMultipleUidsInfo);
        }
        return entry;
    }

    public BlobStoreEntryHolder buildBlobStoreEntryHolder(CacheManager cacheManager) {
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        EntryTypeDesc entryTypeDesc = typeDesc.getTypeDesc().getEntryTypeDesc(EntryType.fromByte(this._entryTypeCode));
        FlatEntryData entryData = new FlatEntryData(this._fieldsValues, this._dynamicProperties, entryTypeDesc, this._versionID, this._expirationTime, false);
        BlobStoreEntryHolder entry = new BlobStoreEntryHolder(typeDesc, this._m_Uid, this._scn, this._transient, entryData, this._onlyIndexesPart);
        if (this._order > 0) {
            entry.setOrder(this._order);
        }
        entry.setBlobStoreVersion(this._blobStoreVersion);
        if (this._generationId != 0L) {
            entry.setEmbeddedSyncOpInfo(this._generationId, this._sequenceId, this._phantom, this._partOfMultipleUidsInfo);
        }
        return entry;
    }

    public short getBlobStoreVersion() {
        return this._blobStoreVersion;
    }

    private void writeObjectArray(ObjectOutput out, Object[] array, IServerTypeDesc typeDesc, boolean isIndexesPart, boolean[] fixed_indexes) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int i;
            int length = array.length;
            out.writeInt(length);
            try {
                for (i = 0; i < length; ++i) {
                    if (i % 7 == 0) {
                        int noNullIndicators = 0;
                        int lim = Math.min(length, i + 7);
                        for (int j = i; j < lim; ++j) {
                            if (this._phantom || array[j] == null || fixed_indexes[j] != isIndexesPart) continue;
                            noNullIndicators |= 1 << j % 7;
                        }
                        out.writeByte(noNullIndicators);
                    }
                    if (fixed_indexes[i] != isIndexesPart) continue;
                    this.writeObjectToStream(array[i], out, typeDesc, i);
                }
            }
            catch (IOException e) {
                throw new IOArrayException(i, "Failed to serialize item #" + i, e);
            }
        }
    }

    private void writeObjectToStream(Object obj, ObjectOutput out, IServerTypeDesc typeDesc, int arrayPosition) throws IOException {
        Serializer serializer;
        boolean isMarshaled;
        boolean isObject;
        if (this._phantom || obj == null) {
            return;
        }
        boolean bl = isObject = typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.OBJECT || typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.DEFAULT && typeDesc.getTypeDesc().getStorageType() == StorageType.OBJECT;
        boolean bl2 = !isObject ? typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.BINARY || typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.DEFAULT && typeDesc.getTypeDesc().getStorageType() == StorageType.BINARY : (isMarshaled = false);
        Class<MarshObject> clazz = isObject ? typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getType() : (isMarshaled ? MarshObject.class : null);
        Serializer serializer2 = serializer = clazz != null && typeDesc.getTypeDesc().getObjectType() != EntryType.EXTERNAL_ENTRY ? types.get(clazz) : null;
        if (serializer != null) {
            serializer.write(obj, out);
        } else {
            out.writeObject(obj);
        }
    }

    public void setUid(String _m_Uid) {
        this._m_Uid = _m_Uid;
    }

    public void setOnlyIndexesPart(boolean _onlyIndexesPart) {
        this._onlyIndexesPart = _onlyIndexesPart;
    }

    public void setBlobStoreVersion(short version) {
        this._blobStoreVersion = version;
    }

    private Object[] readObjectArray(ObjectInput in, IServerTypeDesc typeDesc, Object[] current) throws IOException, ClassNotFoundException {
        int i;
        int length = in.readInt();
        if (length < 0) {
            return current;
        }
        Object[] array = current == null ? new Object[length] : current;
        try {
            byte noNullIndicators = 0;
            for (i = 0; i < length; ++i) {
                if (i % 7 == 0) {
                    noNullIndicators = in.readByte();
                }
                if ((noNullIndicators & 1 << i % 7) == 0) continue;
                array[i] = this.readObjectFromStream(in, typeDesc, i);
            }
        }
        catch (IOException e) {
            throw new IOArrayException(i, "Failed to deserialize item #" + i, e);
        }
        return array;
    }

    private Object readObjectFromStream(ObjectInput in, IServerTypeDesc typeDesc, int arrayPosition) throws IOException, ClassNotFoundException {
        Serializer serializer;
        boolean isMarshaled;
        boolean isObject;
        boolean bl = isObject = typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.OBJECT || typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.DEFAULT && typeDesc.getTypeDesc().getStorageType() == StorageType.OBJECT;
        boolean bl2 = !isObject ? typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.BINARY || typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getStorageType() == StorageType.DEFAULT && typeDesc.getTypeDesc().getStorageType() == StorageType.BINARY : (isMarshaled = false);
        Class<MarshObject> clazz = isObject ? typeDesc.getTypeDesc().getFixedProperty(arrayPosition).getType() : (isMarshaled ? MarshObject.class : null);
        Serializer serializer2 = serializer = clazz != null && typeDesc.getTypeDesc().getObjectType() != EntryType.EXTERNAL_ENTRY ? types.get(clazz) : null;
        if (serializer != null) {
            return serializer.read(in);
        }
        return in.readObject();
    }

    private void writeMapStringObject(ObjectOutput out, Map<String, Object> map, boolean isIndexesPart, HashSet<String> indexesIndicators) throws IOException {
        if (map == null || this._phantom) {
            out.writeInt(-1);
            return;
        }
        int length = 0;
        int overall = 0;
        if (isIndexesPart) {
            this._dynamicIndexesRelatedIndicators = 0L;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (indexesIndicators.contains(entry.getKey())) {
                    if (overall < 63) {
                        this._dynamicIndexesRelatedIndicators |= 1L << overall;
                    }
                    ++length;
                }
                ++overall;
            }
            this._dynamicIndexesRelatedLength = length;
        } else {
            length = map.size() - this._dynamicIndexesRelatedLength;
        }
        out.writeInt(length);
        if (length == 0) {
            return;
        }
        overall = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (overall < 63) {
                if ((this._dynamicIndexesRelatedIndicators & 1L << overall) != 0L == isIndexesPart) {
                    out.writeUTF(entry.getKey());
                    out.writeObject(entry.getValue());
                }
            } else if (indexesIndicators.contains(entry.getKey()) == isIndexesPart) {
                out.writeUTF(entry.getKey());
                out.writeObject(entry.getValue());
            }
            ++overall;
        }
    }

    private Map<String, Object> readMapStringObject(ObjectInput in, Map<String, Object> current) throws IOException, ClassNotFoundException {
        Map<String, Object> map = current;
        int length = in.readInt();
        if (length >= 0) {
            if (map == null) {
                map = new HashMap<String, Object>(length);
            }
            for (int i = 0; i < length; ++i) {
                String key = in.readUTF();
                Object value = in.readObject();
                map.put(key, value);
            }
        }
        return map;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput out, CacheManager cacheManager) throws IOException {
        if (cacheManager.isPersistentBlobStore()) {
            this.writeExternalPersistentBlobStore(out, cacheManager);
        } else {
            this.writeExternalOffHeap(cacheManager, out, false);
        }
    }

    public byte[] getIndexValuesBytes(CacheManager cacheManager) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteArrayOutputStream);
        this.writeExternalOffHeap(cacheManager, out, true);
        out.close();
        return byteArrayOutputStream.toByteArray();
    }

    private void writeExternalPersistentBlobStore(ObjectOutput out, CacheManager cacheManager) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if ((flags & 1) == 1) {
            PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
            version.write(out);
        }
        out.writeUTF(this._m_Uid);
        byte embeddedSyncInfoFlags = this.buildEmbeddedSyncInfoFlags();
        out.writeByte(embeddedSyncInfoFlags);
        if ((embeddedSyncInfoFlags & 1) == 1) {
            out.writeLong(this._generationId);
            out.writeLong(this._sequenceId);
        }
        out.writeShort(this._blobStoreVersion);
        out.writeUTF(this._typeName);
        out.writeByte(this._entryTypeCode);
        out.writeLong(this._scn);
        if ((flags & 2) == 2) {
            out.writeInt(this._order);
        }
        if ((flags & 4) == 4) {
            out.writeInt(this._versionID);
        }
        if ((flags & 8) == 8) {
            out.writeLong(this._expirationTime);
        }
        boolean[] fixed_indices = null;
        HashSet<String> dynamic_indices = null;
        short indexesStoredVersion = 0;
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        BlobStoreStorageAdapterClassInfo ci = ((IBlobStoreStorageAdapter)((Object)cacheManager.getStorageAdapter())).getBlobStoreStorageAdapterClassInfo(this._typeName);
        if (ci != null) {
            fixed_indices = ci.getIndexesRelatedFixedProperties();
            dynamic_indices = ci.getIndexesRelatedDynamicProperties();
            indexesStoredVersion = ci.getStoredVersion();
        } else {
            TypeData typeData = cacheManager.getTypeData(typeDesc);
            fixed_indices = typeData.getIndexesRelatedFixedProperties();
            dynamic_indices = typeData.getIndexesRelatedDynamicProperties();
        }
        out.writeShort(indexesStoredVersion);
        this.writeObjectArray(out, this._fieldsValues, typeDesc, true, fixed_indices);
        if ((flags & 0x10) == 16) {
            this.writeMapStringObject(out, this._dynamicProperties, true, dynamic_indices);
        }
        this.writeObjectArray(out, this._fieldsValues, typeDesc, false, fixed_indices);
        if ((flags & 0x10) == 16) {
            this.writeMapStringObject(out, this._dynamicProperties, false, dynamic_indices);
        }
    }

    private void writeExternalOffHeap(CacheManager cacheManager, ObjectOutput out, boolean onlyIndexesPart) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        byte embeddedSyncInfoFlags = this.buildEmbeddedSyncInfoFlags();
        out.writeByte(embeddedSyncInfoFlags);
        if ((embeddedSyncInfoFlags & 1) == 1) {
            IOUtils.writeLong(out, this._generationId);
            IOUtils.writeLong(out, this._sequenceId);
        }
        IOUtils.writeShort(out, this._blobStoreVersion);
        out.writeByte(this._entryTypeCode);
        IOUtils.writeLong(out, this._scn);
        if ((flags & 2) == 2) {
            IOUtils.writeInt(out, this._order);
        }
        if ((flags & 4) == 4) {
            IOUtils.writeInt(out, this._versionID);
        }
        if ((flags & 8) == 8) {
            IOUtils.writeLong(out, this._expirationTime);
        }
        boolean[] fixed_indices = null;
        HashSet<String> dynamic_indices = null;
        short indexesStoredVersion = 0;
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        BlobStoreStorageAdapterClassInfo ci = ((IBlobStoreStorageAdapter)((Object)cacheManager.getStorageAdapter())).getBlobStoreStorageAdapterClassInfo(this._typeName);
        if (ci != null) {
            fixed_indices = ci.getIndexesRelatedFixedProperties();
            dynamic_indices = ci.getIndexesRelatedDynamicProperties();
            indexesStoredVersion = ci.getStoredVersion();
        } else {
            TypeData typeData = cacheManager.getTypeData(typeDesc);
            fixed_indices = typeData.getIndexesRelatedFixedProperties();
            dynamic_indices = typeData.getIndexesRelatedDynamicProperties();
        }
        IOUtils.writeShort(out, indexesStoredVersion);
        this.writeObjectArray(out, this._fieldsValues, typeDesc, true, fixed_indices);
        if ((flags & 0x10) == 16) {
            this.writeMapStringObject(out, this._dynamicProperties, true, dynamic_indices);
        }
        if (!onlyIndexesPart) {
            this.writeObjectArray(out, this._fieldsValues, typeDesc, false, fixed_indices);
            if ((flags & 0x10) == 16) {
                this.writeMapStringObject(out, this._dynamicProperties, false, dynamic_indices);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    public void readExternal(ObjectInput in, CacheManager cacheManager, boolean fromInitialLoad, boolean onlyIndexedPart, IBlobStoreOffHeapInfo offHeapInfo) throws IOException, ClassNotFoundException {
        if (cacheManager.isPersistentBlobStore()) {
            this.readExternalPersistentBlobStore(in, cacheManager, fromInitialLoad, onlyIndexedPart);
        } else {
            this.readExternalOffHeap(cacheManager, offHeapInfo.getTypeName(), in, false);
        }
    }

    public void readIndexValuesBytes(CacheManager cacheManager, short serverTypeDescCode, byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        this.readExternalOffHeap(cacheManager, ServerTypeDesc.getByServerTypeDescCode(serverTypeDescCode).getTypeName(), in, true);
        in.close();
    }

    private void readExternalPersistentBlobStore(ObjectInput in, CacheManager cacheManager, boolean fromInitialLoad, boolean onlyIndexedPart) throws IOException, ClassNotFoundException {
        byte embeddedSyncInfoFlags;
        PlatformLogicalVersion version = PlatformLogicalVersion.getLogicalVersion();
        byte flags = in.readByte();
        if ((flags & 1) == 1) {
            this._recoverable = true;
            version = new PlatformLogicalVersion();
            version.read(in);
        }
        this._m_Uid = in.readUTF();
        if (version.greaterOrEquals(PlatformLogicalVersion.v11_0_0) && ((embeddedSyncInfoFlags = in.readByte()) & 1) == 1) {
            this._generationId = in.readLong();
            this._sequenceId = in.readLong();
            this._phantom = (embeddedSyncInfoFlags & 2) == 2;
            this._partOfMultipleUidsInfo = (embeddedSyncInfoFlags & 4) == 4;
        }
        this._blobStoreVersion = in.readShort();
        this._typeName = in.readUTF();
        if (fromInitialLoad && onlyIndexedPart && cacheManager.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter() != null) {
            boolean bl = onlyIndexedPart = !cacheManager.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter().isRelevantType(this._typeName);
        }
        if (onlyIndexedPart && fromInitialLoad) {
            TypeData typeData = cacheManager.getTypeData(cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName));
            onlyIndexedPart &= !typeData.isUsingQueryExtensionIndexManager();
        }
        this._entryTypeCode = in.readByte();
        this._scn = in.readLong();
        boolean bl = this._transient = (flags & 0x20) == 32;
        if ((flags & 2) == 2) {
            this._order = in.readInt();
        }
        this._versionID = (flags & 4) == 4 ? in.readInt() : 1;
        this._expirationTime = (flags & 8) == 8 ? in.readLong() : Long.MAX_VALUE;
        short indexesStoredVersion = in.readShort();
        if (onlyIndexedPart) {
            BlobStoreStorageAdapterClassInfo ci = ((IBlobStoreStorageAdapter)((Object)cacheManager.getStorageAdapter())).getBlobStoreStorageAdapterClassInfo(this._typeName);
            if (ci == null) {
                onlyIndexedPart = false;
                if (CacheManager.getLogger().isLoggable(Level.INFO)) {
                    CacheManager.getLogger().info("Blobstore- full entry loaded since no type was introduced to blobstore type name =" + this._typeName + " uid=" + this._m_Uid);
                }
            }
            if (ci != null && indexesStoredVersion != ci.getStoredVersion()) {
                onlyIndexedPart = false;
                if (CacheManager.getLogger().isLoggable(Level.INFO)) {
                    CacheManager.getLogger().info("Blobstore- full entry loaded since index version changed stored=" + indexesStoredVersion + " current=" + ci.getStoredVersion() + " uid=" + this._m_Uid);
                }
            }
        }
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        this._fieldsValues = this.readObjectArray(in, typeDesc, this._fieldsValues);
        if ((flags & 0x10) == 16) {
            this._dynamicProperties = this.readMapStringObject(in, this._dynamicProperties);
        }
        if (!onlyIndexedPart) {
            if (CacheManager.getLogger().isLoggable(Level.FINER)) {
                CacheManager.getLogger().finer("container [" + cacheManager.getEngine().getFullSpaceName() + "] Blobstore- full entry loaded, uid=" + this._m_Uid);
            }
            this._fieldsValues = this.readObjectArray(in, typeDesc, this._fieldsValues);
            if ((flags & 0x10) == 16) {
                this._dynamicProperties = this.readMapStringObject(in, this._dynamicProperties);
            }
        }
        this._onlyIndexesPart = onlyIndexedPart;
    }

    private void readExternalOffHeap(CacheManager cacheManager, String typeName, ObjectInput in, boolean onlyIndexesPart) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        byte embeddedSyncInfoFlags = in.readByte();
        if ((embeddedSyncInfoFlags & 1) == 1) {
            this._generationId = IOUtils.readLong(in);
            this._sequenceId = IOUtils.readLong(in);
        }
        this._blobStoreVersion = IOUtils.readShort(in);
        this._entryTypeCode = in.readByte();
        this._scn = IOUtils.readLong(in);
        boolean bl = this._transient = (flags & 0x20) == 32;
        if ((flags & 2) == 2) {
            this._order = IOUtils.readInt(in);
        }
        this._versionID = (flags & 4) == 4 ? IOUtils.readInt(in) : 1;
        this._expirationTime = (flags & 8) == 8 ? IOUtils.readLong(in) : Long.MAX_VALUE;
        short indexesStoredVersion = IOUtils.readShort(in);
        this._typeName = typeName;
        IServerTypeDesc typeDesc = cacheManager.getEngine().getTypeManager().getServerTypeDesc(this._typeName);
        this._fieldsValues = this.readObjectArray(in, typeDesc, this._fieldsValues);
        if ((flags & 0x10) == 16) {
            this._dynamicProperties = this.readMapStringObject(in, this._dynamicProperties);
        }
        if (!onlyIndexesPart) {
            this._fieldsValues = this.readObjectArray(in, typeDesc, this._fieldsValues);
            if ((flags & 0x10) == 16) {
                this._dynamicProperties = this.readMapStringObject(in, this._dynamicProperties);
            }
        }
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this._recoverable) {
            flags = (byte)(flags | 1);
        }
        if (this._order != 0) {
            flags = (byte)(flags | 2);
        }
        if (this._versionID != 1) {
            flags = (byte)(flags | 4);
        }
        if (this._expirationTime != Long.MAX_VALUE) {
            flags = (byte)(flags | 8);
        }
        if (this._dynamicProperties != null) {
            flags = (byte)(flags | 0x10);
        }
        if (this._transient) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    public byte buildEmbeddedSyncInfoFlags() {
        byte flags = 0;
        if (this._generationId != 0L) {
            flags = (byte)(flags | 1);
        }
        if (this._phantom) {
            flags = (byte)(flags | 2);
        }
        if (this._partOfMultipleUidsInfo) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    static {
        types.put(Integer.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeInt((Integer)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readInt();
            }
        });
        types.put(Long.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeLong((Long)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readLong();
            }
        });
        types.put(Float.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return Float.valueOf(in.readFloat());
            }
        });
        types.put(Boolean.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeBoolean((Boolean)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readBoolean();
            }
        });
        types.put(Character.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeChar(((Character)object).charValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return Character.valueOf(in.readChar());
            }
        });
        types.put(Short.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeShort(((Short)object).shortValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readShort();
            }
        });
        types.put(Double.TYPE, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeDouble((Double)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readDouble();
            }
        });
        types.put(Integer.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeInt((Integer)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readInt();
            }
        });
        types.put(Long.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeLong((Long)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readLong();
            }
        });
        types.put(Float.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return Float.valueOf(in.readFloat());
            }
        });
        types.put(Boolean.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeBoolean((Boolean)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readBoolean();
            }
        });
        types.put(Character.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeChar(((Character)object).charValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return Character.valueOf(in.readChar());
            }
        });
        types.put(Short.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeShort(((Short)object).shortValue());
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readShort();
            }
        });
        types.put(Double.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                out.writeDouble((Double)object);
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                return in.readDouble();
            }
        });
        types.put(String.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                String input = (String)object;
                if (input.length() <= 20000) {
                    out.writeBoolean(true);
                    out.writeUTF(input);
                } else {
                    out.writeBoolean(false);
                    out.writeObject(input);
                }
            }

            @Override
            public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
                if (in.readBoolean()) {
                    return in.readUTF();
                }
                return in.readObject();
            }
        });
        types.put(MarshObject.class, new Serializer(){

            @Override
            public void write(Object object, ObjectOutput out) throws IOException {
                byte[] data = ((MarshObject)object).getBytes();
                out.writeInt(data.length);
                if (data.length > 0) {
                    out.write(data);
                }
            }

            @Override
            public Object read(ObjectInput in) throws IOException {
                byte[] data = new byte[in.readInt()];
                if (data.length > 0) {
                    in.readFully(data);
                }
                return new MarshObject(data);
            }
        });
    }

    public static interface Serializer {
        public void write(Object var1, ObjectOutput var2) throws IOException;

        public Object read(ObjectInput var1) throws IOException, ClassNotFoundException;
    }
}

