/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationType;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.memory_pool.OffHeapMemoryPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

public abstract class BlobStoreExtendedStorageHandler {
    public void initialize(BlobStoreConfig blobStoreConfig) {
    }

    public abstract Object add(Serializable var1, Serializable var2, BlobStoreObjectType var3, IBlobStoreOffHeapInfo var4);

    public abstract Object replace(Serializable var1, Serializable var2, Object var3, BlobStoreObjectType var4, IBlobStoreOffHeapInfo var5);

    public abstract Serializable get(Serializable var1, Object var2, BlobStoreObjectType var3, IBlobStoreOffHeapInfo var4);

    public abstract Serializable get(Serializable var1, Object var2, BlobStoreObjectType var3, boolean var4, IBlobStoreOffHeapInfo var5);

    public abstract Serializable remove(Serializable var1, Object var2, BlobStoreObjectType var3, IBlobStoreOffHeapInfo var4);

    public abstract void removeIfExists(Serializable var1, Object var2, BlobStoreObjectType var3, IBlobStoreOffHeapInfo var4);

    public List<BlobStoreBulkOperationResult> executeBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        ArrayList<BlobStoreBulkOperationResult> result = new ArrayList<BlobStoreBulkOperationResult>(operations.size());
        for (BlobStoreBulkOperationRequest request : operations) {
            if (request.getOpType() == BlobStoreBulkOperationType.ADD) {
                try {
                    result.add(new BlobStoreAddBulkOperationResult(request.getId(), this.add(request.getId(), request.getData(), objectType, request.getOffHeapInfo())));
                }
                catch (Exception ex) {
                    result.add(new BlobStoreAddBulkOperationResult(request.getId(), ex));
                }
                continue;
            }
            if (request.getOpType() == BlobStoreBulkOperationType.REMOVE) {
                try {
                    this.remove(request.getId(), request.getPosition(), objectType, request.getOffHeapInfo());
                    result.add(new BlobStoreRemoveBulkOperationResult(request.getId()));
                }
                catch (Exception ex) {
                    result.add(new BlobStoreRemoveBulkOperationResult(request.getId(), ex));
                }
                continue;
            }
            if (request.getOpType() == BlobStoreBulkOperationType.REPLACE) {
                try {
                    result.add(new BlobStoreReplaceBulkOperationResult(request.getId(), this.replace(request.getId(), request.getData(), request.getPosition(), objectType, request.getOffHeapInfo()), request.getOffHeapInfo()));
                }
                catch (Exception ex) {
                    result.add(new BlobStoreReplaceBulkOperationResult(request.getId(), ex));
                }
                continue;
            }
            if (request.getOpType() != BlobStoreBulkOperationType.GET) continue;
            try {
                result.add(new BlobStoreGetBulkOperationResult(request.getId(), this.get(request.getId(), request.getPosition(), objectType, request.getOffHeapInfo()), (Object)objectType, request.getOffHeapInfo()));
            }
            catch (Exception ex) {
                result.add(new BlobStoreGetBulkOperationResult(request.getId(), ex));
            }
        }
        return result;
    }

    public DataIterator<BlobStoreGetBulkOperationResult> iterator(BlobStoreObjectType objectType) {
        return null;
    }

    public Properties getProperties() {
        return null;
    }

    public void close() {
    }

    public abstract ExecutorService getPreFetchPool();

    public abstract DataIterator<BlobStoreGetBulkOperationResult> initialLoadIterator();

    public abstract OffHeapMemoryPool getOffHeapCache();

    public abstract AbstractMemoryPool getOffHeapStore();

    public abstract BlobStoreStorageStatistics getStorageStatistics();
}

