/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateEntryData;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.metrics.LongCounter;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BlobStoreInternalCacheFilter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.cache");
    private final SpaceEngine _spaceEngine;
    private final List<SQLQuery> _sqlQueries;
    private final List<ITemplateHolder> _templateHolders;
    private final LongCounter _insertedToBlobStoreInternalCache = new LongCounter();
    private final LongCounter _coldDataMiss = new LongCounter();

    public BlobStoreInternalCacheFilter(SpaceEngine spaceEngine, List<SQLQuery> sqlQueries) throws Exception {
        this._spaceEngine = spaceEngine;
        this._sqlQueries = sqlQueries;
        this._templateHolders = new ArrayList<ITemplateHolder>(this._sqlQueries.size());
        for (SQLQuery sqlQuery : this._sqlQueries) {
            this._templateHolders.add(this.convertSQLQueryToTemplateHolder(sqlQuery));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITemplateHolder convertSQLQueryToTemplateHolder(SQLQuery sqlQuery) throws Exception {
        ObjectType queryObjectType = ObjectType.fromObject(sqlQuery, true);
        ITemplatePacket templatePacket = this._spaceEngine.getSpaceImpl().getSingleProxy().getTypeManager().getTemplatePacketFromObject(sqlQuery, queryObjectType);
        try {
            SpaceInitializationIndicator.setInitializer();
            ITemplatePacket fullTemplatePacket = ((EntrySnapshot)this._spaceEngine.getSpaceImpl().getSingleProxy().snapshot(templatePacket)).getTemplatePacket();
            IServerTypeDesc typeDesc = this._spaceEngine.getTypeManager().loadServerTypeDesc(templatePacket);
            ITemplateHolder iTemplateHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, fullTemplatePacket, null, Long.MAX_VALUE);
            return iTemplateHolder;
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
    }

    public boolean isEntryHotData(IEntryHolder eh, Context context) {
        for (ITemplateHolder templateHolder : this._templateHolders) {
            if (!((TemplateEntryData)templateHolder.getEntryData()).isAssignableFrom(eh.getServerTypeDesc()) || !this._spaceEngine.getTemplateScanner().match(context, eh, templateHolder)) continue;
            return true;
        }
        return false;
    }

    public List<SQLQuery> getSqlQueries() {
        return this._sqlQueries;
    }

    public long getInsertedToBlobStoreInternalCacheOnInitialLoad() {
        return this._insertedToBlobStoreInternalCache.getCount();
    }

    public void incrementInsertedToBlobStoreInternalCacheOnInitialLoad() {
        this._insertedToBlobStoreInternalCache.inc();
    }

    public boolean isRelevantType(String entryTypeName) {
        IServerTypeDesc serverTypeDesc = this._spaceEngine.getTypeManager().getServerTypeDesc(entryTypeName);
        if (serverTypeDesc == null) {
            return true;
        }
        for (ITemplateHolder templateHolder : this._templateHolders) {
            if (!((TemplateEntryData)templateHolder.getEntryData()).isAssignableFrom(serverTypeDesc)) continue;
            return true;
        }
        return false;
    }

    public LongCounter getColdDataMissCount() {
        return this._coldDataMiss;
    }

    public void incrementColdDataMisses() {
        this._coldDataMiss.inc();
    }
}

