/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.start.SystemInfo;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreMemoryMonitor;
import com.j_spaces.core.cache.blobStore.BlobStoreMemoryShortageException;
import com.j_spaces.core.cache.blobStore.SpaceInternalBlobStoreMemoryShortageException;
import java.io.Serializable;
import java.util.Properties;

public class BlobStoreMemoryMonitorWrapper
extends BlobStoreMemoryMonitor {
    private final BlobStoreMemoryMonitor _impl;
    private final String _spaceNameToUse;
    private final String _containerNameToUse;

    public BlobStoreMemoryMonitorWrapper(BlobStoreMemoryMonitor impl, CacheManager cm, String spaceName, Properties properties) {
        this._impl = impl;
        this._spaceNameToUse = cm.getEngine().getSpaceName();
        this._containerNameToUse = cm.getEngine().getSpaceImpl().getContainerName();
    }

    @Override
    public void onMemoryAllocation(Serializable id) {
        try {
            if (this._impl != null) {
                this._impl.onMemoryAllocation(id);
            }
        }
        catch (BlobStoreMemoryShortageException ex) {
            throw new SpaceInternalBlobStoreMemoryShortageException(this._spaceNameToUse, this._containerNameToUse, SystemInfo.singleton().network().getHostId(), ex.getMemoryUsage(), ex.getMaxMemory(), ex);
        }
    }
}

