/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.metrics.ThroughputMetric;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.gigaspaces.server.blobstore.BlobStoreStorageStatistics;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreExtendedStorageHandler;
import com.j_spaces.core.cache.blobStore.BlobStoreSerializationUtils;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.memory_pool.OffHeapMemoryPool;
import com.j_spaces.core.cache.blobStore.offheap.OffHeapStorageContainer;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;

@InternalApi
public class BlobStoreOperationsWrapper
extends BlobStoreExtendedStorageHandler {
    private static final int _blobStorePreFetchMinThreads = Integer.getInteger("engine.blobstore_prefetch_min_threads", 0);
    private static final int _blobStorePreFetchMaxThreads = Integer.getInteger("engine.blobstore_prefetch_max_threads", 16);
    private final CacheManager _cacheManager;
    private final BlobStoreStorageHandler _blobStore;
    private final BlobStoreSerializationUtils _serialization;
    private final boolean _needSerialization;
    private final OffHeapMemoryPool _offHeapCache;
    private final boolean _isOffHeap;
    private final AbstractMemoryPool _offHeapStore;
    private MetricRegistrator _registrator;
    private ExecutorService _preFetchThreadPool;
    private final LongCounter add = new LongCounter();
    private final LongCounter get = new LongCounter();
    private final LongCounter replace = new LongCounter();
    private final LongCounter remove = new LongCounter();
    private final ThroughputMetric add_tp = new ThroughputMetric();
    private final ThroughputMetric get_tp = new ThroughputMetric();
    private final ThroughputMetric replace_tp = new ThroughputMetric();
    private final ThroughputMetric remove_tp = new ThroughputMetric();

    public BlobStoreOperationsWrapper(CacheManager cacheManager, BlobStoreStorageHandler blobStore) {
        this._cacheManager = cacheManager;
        this._blobStore = blobStore;
        this._serialization = new BlobStoreSerializationUtils(cacheManager);
        this._needSerialization = true;
        this._isOffHeap = blobStore instanceof OffHeapStorageContainer;
        this._offHeapStore = this._isOffHeap ? ((OffHeapStorageContainer)((Object)blobStore)).getMemoryPool() : null;
        Properties p = this._blobStore.getProperties();
        String offHeapThreshold = p != null ? p.getProperty("off-heap-cache-memory-threshold") : null;
        OffHeapMemoryPool offHeapMemoryPool = this._offHeapCache = offHeapThreshold == null ? null : new OffHeapMemoryPool(StringUtils.parseStringAsBytes(offHeapThreshold));
        if (this._offHeapCache != null && this._offHeapStore != null) {
            throw new RuntimeException("Configuration exception: can not enable off heap optimization when running with off-heap-blob-store configuration");
        }
        if (this._offHeapStore != null && this._cacheManager.isPersistentBlobStore()) {
            throw new RuntimeException("Configuration exception: can not set space-config.engine.blobstore_persistent to true when running with off-heap-blob-store configuration");
        }
    }

    @Override
    public OffHeapMemoryPool getOffHeapCache() {
        return this._offHeapCache;
    }

    @Override
    public AbstractMemoryPool getOffHeapStore() {
        return this._offHeapStore;
    }

    @Override
    public BlobStoreStorageStatistics getStorageStatistics() {
        return this._blobStore.getStatistics();
    }

    @Override
    public void initialize(BlobStoreConfig blobStoreConfig) {
        this._registrator = blobStoreConfig.getMetricRegistrator();
        this._blobStore.initialize(blobStoreConfig);
        this.registerOperations();
    }

    @Override
    public Properties getProperties() {
        Properties props = this._blobStore.getProperties();
        if (this._offHeapCache != null) {
            if (props == null) {
                props = new Properties();
            }
            props.setProperty("off-heap-cache-memory-threshold", String.valueOf(this._offHeapCache.getThreshold()));
        }
        return props;
    }

    @Override
    public Object add(Serializable id, Serializable data, BlobStoreObjectType objectType, IBlobStoreOffHeapInfo offHeapInfo) {
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return null;
        }
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.add.inc();
            this.add_tp.increment();
        }
        if (this._needSerialization) {
            byte[] sdata = this._serialization.serialize(data, objectType);
            return this._isOffHeap ? this._blobStore.add(offHeapInfo, (Serializable)sdata, objectType) : this._blobStore.add(id, (Serializable)sdata, objectType);
        }
        return this._isOffHeap ? this._blobStore.add(offHeapInfo, data, objectType) : this._blobStore.add(id, data, objectType);
    }

    @Override
    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType, IBlobStoreOffHeapInfo offHeapInfo) {
        Serializable data;
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return null;
        }
        Serializable serializable = data = this._isOffHeap ? this._blobStore.get(offHeapInfo, position, objectType) : this._blobStore.get(id, position, objectType);
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.get.inc();
            this.get_tp.increment();
        }
        return data != null && this._needSerialization ? this._serialization.deserialize(data, objectType, false, false, offHeapInfo) : data;
    }

    @Override
    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType, boolean indexesPartOnly, IBlobStoreOffHeapInfo offHeapInfo) {
        Serializable data;
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return null;
        }
        Serializable serializable = data = this._isOffHeap ? this._blobStore.get(offHeapInfo, position, objectType) : this._blobStore.get(id, position, objectType);
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.get.inc();
            this.get_tp.increment();
        }
        return data != null && this._needSerialization ? this._serialization.deserialize(data, objectType, false, indexesPartOnly, offHeapInfo) : data;
    }

    @Override
    public Object replace(Serializable id, Serializable data, Object position, BlobStoreObjectType objectType, IBlobStoreOffHeapInfo offHeapInfo) {
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return null;
        }
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.replace.inc();
            this.replace_tp.increment();
        }
        if (this._needSerialization) {
            byte[] sdata = this._serialization.serialize(data, objectType);
            return this._isOffHeap ? this._blobStore.replace(offHeapInfo, (Serializable)sdata, position, objectType) : this._blobStore.replace(id, (Serializable)sdata, position, objectType);
        }
        return this._isOffHeap ? this._blobStore.replace(offHeapInfo, data, position, objectType) : this._blobStore.replace(id, data, position, objectType);
    }

    @Override
    public Serializable remove(Serializable id, Object position, BlobStoreObjectType objectType, IBlobStoreOffHeapInfo offHeapInfo) {
        Serializable data;
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return null;
        }
        Serializable serializable = data = this._isOffHeap ? this._blobStore.remove(offHeapInfo, position, objectType) : this._blobStore.remove(id, position, objectType);
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.remove.inc();
            this.remove_tp.increment();
        }
        return data != null && this._needSerialization ? this._serialization.deserialize(data, objectType, false, false, offHeapInfo) : data;
    }

    @Override
    public void removeIfExists(Serializable id, Object position, BlobStoreObjectType objectType, IBlobStoreOffHeapInfo offHeapInfo) {
        Serializable data;
        if (this._isOffHeap && objectType != BlobStoreObjectType.DATA) {
            return;
        }
        Serializable serializable = data = this._isOffHeap ? this._blobStore.remove(offHeapInfo, position, objectType) : this._blobStore.remove(id, position, objectType);
        if (objectType.equals((Object)BlobStoreObjectType.DATA)) {
            this.remove.inc();
            this.remove_tp.increment();
        }
    }

    @Override
    public List<BlobStoreBulkOperationResult> executeBulk(List<BlobStoreBulkOperationRequest> operations, BlobStoreObjectType objectType, boolean transactional) {
        boolean isDataType = objectType.equals((Object)BlobStoreObjectType.DATA);
        for (BlobStoreBulkOperationRequest request : operations) {
            if (isDataType) {
                this.metricsByOpType(request);
            }
            if (request.getData() == null || !this._needSerialization) continue;
            request.setData((Serializable)this._serialization.serialize(request.getData(), objectType));
        }
        List<BlobStoreBulkOperationResult> results = this._blobStore.executeBulk(operations, objectType, transactional);
        for (BlobStoreBulkOperationResult result : results) {
            if (result.getData() == null || !this._needSerialization) continue;
            result.setData(this._serialization.deserialize(result.getData(), objectType, false, false, result.getOffHeapInfo()));
        }
        return results;
    }

    @Override
    public DataIterator<BlobStoreGetBulkOperationResult> iterator(BlobStoreObjectType objectType) {
        return new IteratorWrapper(this._cacheManager, objectType, this._serialization, this._needSerialization, this._blobStore.iterator(objectType), false);
    }

    @Override
    public DataIterator<BlobStoreGetBulkOperationResult> initialLoadIterator() {
        return new IteratorWrapper(this._cacheManager, BlobStoreObjectType.DATA, this._serialization, this._needSerialization, this._blobStore.iterator(BlobStoreObjectType.DATA), true);
    }

    @Override
    public void close() {
        this._blobStore.close();
        this._registrator.clear();
        if (this._preFetchThreadPool != null) {
            this._preFetchThreadPool.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorService getPreFetchPool() {
        if (this._preFetchThreadPool == null) {
            BlobStoreOperationsWrapper blobStoreOperationsWrapper = this;
            synchronized (blobStoreOperationsWrapper) {
                if (this._preFetchThreadPool == null) {
                    this._preFetchThreadPool = DynamicExecutors.newScalingThreadPool(_blobStorePreFetchMinThreads, _blobStorePreFetchMaxThreads, 15000L);
                }
            }
        }
        return this._preFetchThreadPool;
    }

    private void registerOperations() {
        this._registrator.register("add", this.add);
        this._registrator.register("get", this.get);
        this._registrator.register("remove", this.remove);
        this._registrator.register("replace", this.replace);
        this._registrator.register("add-tp", this.add_tp);
        this._registrator.register("get-tp", this.get_tp);
        this._registrator.register("remove-tp", this.remove_tp);
        this._registrator.register("replace-tp", this.replace_tp);
        if (this._offHeapCache != null) {
            this._offHeapCache.initMetrics(this._registrator.extend("off-heap-cache"));
        }
        if (this._offHeapStore != null) {
            this._offHeapStore.initMetrics(this._registrator.extend("off-heap"));
        }
    }

    private void metricsByOpType(BlobStoreBulkOperationRequest request) {
        switch (request.getOpType()) {
            case ADD: {
                this.add.inc();
                this.add_tp.increment();
                break;
            }
            case GET: {
                this.get.inc();
                this.get_tp.increment();
                break;
            }
            case REMOVE: {
                this.remove.inc();
                this.remove_tp.increment();
                break;
            }
            case REPLACE: {
                this.replace.inc();
                this.replace_tp.increment();
            }
        }
    }

    private static class IteratorWrapper
    implements DataIterator<BlobStoreGetBulkOperationResult> {
        private final DataIterator<BlobStoreGetBulkOperationResult> _iter;
        private boolean _finished;
        private final BlobStoreSerializationUtils _serialization;
        private final boolean _needSerialization;
        private final BlobStoreObjectType _objectType;
        private final CacheManager _cacheManager;
        private final boolean _fromInitialLoad;

        IteratorWrapper(CacheManager cacheManager, BlobStoreObjectType objectType, BlobStoreSerializationUtils serialization, boolean needSerialization, DataIterator<BlobStoreGetBulkOperationResult> iter, boolean fromInitialLoad) {
            this._serialization = serialization;
            this._iter = iter;
            this._needSerialization = needSerialization;
            this._objectType = objectType;
            this._cacheManager = cacheManager;
            this._fromInitialLoad = fromInitialLoad;
        }

        @Override
        public void close() {
            if (this._iter != null) {
                this._iter.close();
            }
        }

        @Override
        public boolean hasNext() {
            if (this._finished || this._iter == null) {
                return false;
            }
            if (!this._iter.hasNext()) {
                this._finished = true;
            }
            return !this._finished;
        }

        @Override
        public BlobStoreGetBulkOperationResult next() {
            if (this._iter == null) {
                return null;
            }
            BlobStoreGetBulkOperationResult res = (BlobStoreGetBulkOperationResult)this._iter.next();
            if (res == null) {
                this._finished = true;
                return null;
            }
            if (res.getData() != null && this._needSerialization) {
                res.setData(this._serialization.deserialize(res.getData(), this._objectType, this._fromInitialLoad, this._fromInitialLoad, res.getOffHeapInfo()));
            }
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

