/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.ServerTypeDesc;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.CacheOperationReason;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.ILeasedEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import com.j_spaces.core.cache.blobStore.IBlobStoreCacheHandler;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreRefCacheInfo;
import com.j_spaces.core.cache.blobStore.errors.BlobStoreErrorBulkEntryInfo;
import com.j_spaces.core.cache.blobStore.errors.BlobStoreErrorsHandler;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBulkInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBusyInBulkException;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationBasicInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationInsertInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationRemoveInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationUpdateInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import com.j_spaces.kernel.locks.ILockObject;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreRefEntryCacheInfo
implements IEntryCacheInfo,
IBlobStoreRefCacheInfo,
IBlobStoreOffHeapInfo,
ILockObject {
    public static final long UNALLOCATED_OFFHEAP_MEMORY = -1L;
    private static final Object DummyBlobStorePos = new Object();
    private static final BlobStoreBusyInBulkException BusyInBulkIndicator = new BlobStoreBusyInBulkException();
    private volatile long _crcForFields;
    private long _singleValueIndexIndicators;
    private long _offHeapIndexValuesAddress = -1L;
    private static final byte STATUS_PINNED = 1;
    private static final byte STATUS_UNPINNED = -2;
    private static final byte STATUS_DIRTY = 2;
    private static final byte STATUS_UNDIRTY = -3;
    private static final byte STATUS_DELETED = 4;
    private static final byte STATUS_UNDELETED = -5;
    private static final byte STATUS_FULL_INDEXES_BACREFS_FORCED = 8;
    private static final byte STATUS_UNFORCE_FULL_INDEXES_BACREFS = -9;
    private static final byte STATUS_BULK_FLUSHING = 16;
    private static final byte STATUS_UNBULK_FLUSHING = -17;
    private static final byte STATUS_MATCH_FILTER = 32;
    private static final byte STATUS_UNMATCH_FILTER = -33;
    private volatile BlobStoreEntryHolder _loadedBlobStoreEntry;
    private final String _m_Uid;
    private Object _backRefs;
    private IObjectInfo<Object> _leaseManagerEntryPos;
    private Object _blobStorePosition;
    private volatile short _blobStoreVersion;
    private final short _serverTypeDescCode;
    private volatile byte _status;
    private byte _latestIndexCreationNumber;

    public BlobStoreRefEntryCacheInfo(IEntryHolder eh, int backRefsSize) {
        boolean recoveredFromblobStore = false;
        boolean restartBlobStoreVersionCount = false;
        this._loadedBlobStoreEntry = (BlobStoreEntryHolder)eh;
        if (((BlobStoreEntryHolder)eh).getBlobStoreVersion() != 0) {
            this._blobStoreVersion = ((BlobStoreEntryHolder)eh).getBlobStoreVersion();
            recoveredFromblobStore = true;
            if (this._blobStoreVersion == -1) {
                this._blobStoreVersion = 1;
                restartBlobStoreVersionCount = true;
                CacheManager.getLogger().finest("Blobstore- read _blobStoreVersion = -1 from initial load, set _blobStoreVersion to " + this._blobStoreVersion);
            }
        }
        if (this.indexesBackRefsKept()) {
            this._backRefs = backRefsSize != -1 ? new ArrayList(backRefsSize) : new ArrayList(3);
        }
        this._m_Uid = eh.getUID();
        this.pin();
        if (!recoveredFromblobStore || restartBlobStoreVersionCount) {
            this.setDirty_impl(true, false, null);
        }
        this._serverTypeDescCode = eh.getServerTypeDesc().getServerTypeDescCode();
    }

    public BlobStoreRefEntryCacheInfo(IEntryHolder eh) {
        this(eh, -1);
    }

    private boolean isDirty() {
        return (this._status & 2) == 2;
    }

    @Override
    public boolean isInBlobStoreStorage() {
        return this.getBlobStoreStoragePos() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getBlobStoreStoragePos() {
        Object object = this.getStateLockObject();
        synchronized (object) {
            return this.getBlobStorePos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobStoreVersion(short blobStoreVersion) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this._blobStoreVersion = blobStoreVersion;
            this._loadedBlobStoreEntry.setBlobStoreVersion(blobStoreVersion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDirty(boolean value, CacheManager cacheManager) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.setDirty_impl(value, true, cacheManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushedFromBulk(Context context, CacheManager cacheManager, Object blobStorePos, boolean removed, boolean onTxnEnd) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.setDirty_impl(false, false, cacheManager);
            if (removed || this.isDeleted() || this.isPhantom()) {
                this.removeFromInternalCache(context, cacheManager, this._loadedBlobStoreEntry);
                if (cacheManager.hasBlobStoreOffHeapCache()) {
                    cacheManager.getBlobStoreStorageHandler().getOffHeapCache().delete(this);
                }
                if (!this.isPhantom()) {
                    this._blobStorePosition = null;
                }
            } else {
                if (!this.isWrittenToBlobStore()) {
                    this.insertOrTouchInternalCache(context, cacheManager, this._loadedBlobStoreEntry, CacheOperationReason.ON_WRITE);
                    if (cacheManager.hasBlobStoreOffHeapCache()) {
                        try {
                            cacheManager.getBlobStoreStorageHandler().getOffHeapCache().write(this, ((BlobStoreEntryLayout)this.getEntryLayout(cacheManager)).getIndexValuesBytes(cacheManager));
                        }
                        catch (IOException e) {
                            CacheManager.getLogger().log(Level.SEVERE, "Blobstore- BLRECI:flushedFromBulk could not write to off heap,  got exception " + e.toString(), e);
                            throw new RuntimeException("Blobstore- BLRECI:flushedFromBulk got exception " + e.toString(), e);
                        }
                    }
                } else {
                    if (onTxnEnd) {
                        this.insertOrTouchInternalCache(context, cacheManager, this._loadedBlobStoreEntry, CacheOperationReason.ON_UPDATE);
                    }
                    if (cacheManager.hasBlobStoreOffHeapCache()) {
                        try {
                            cacheManager.getBlobStoreStorageHandler().getOffHeapCache().update(this, ((BlobStoreEntryLayout)this.getEntryLayout(cacheManager)).getIndexValuesBytes(cacheManager));
                        }
                        catch (IOException e) {
                            CacheManager.getLogger().log(Level.SEVERE, "Blobstore- BLRECI:flushedFromBulk could not update valur in off heap, got exception " + e.toString(), e);
                            throw new RuntimeException("Blobstore- BLRECI:flushedFromBulk got exception " + e.toString(), e);
                        }
                    }
                }
                this._blobStorePosition = blobStorePos == null ? DummyBlobStorePos : blobStorePos;
            }
        }
    }

    private void setDirty_impl(boolean value, boolean set_indexses, CacheManager cacheManager) {
        if (value) {
            this._status = (byte)(this._status | 2);
            this._crcForFields = BlobStoreRefEntryCacheInfo.buildCrcForFields(this._loadedBlobStoreEntry);
            if (this._blobStoreVersion != -1) {
                this._blobStoreVersion = (short)(this._blobStoreVersion + 1);
                if (this._blobStoreVersion == -1 && CacheManager.getLogger().isLoggable(Level.WARNING)) {
                    CacheManager.getLogger().warning("Blobstore- entry " + this.getUID() + " of type " + this.getTypeName() + " has been updated 65535 times, and exhausted its update counter, update optimization for this entry is now disabled");
                }
                if (CacheManager.getLogger().isLoggable(Level.FINEST)) {
                    CacheManager.getLogger().finest("Blobstore- bumped _blobStoreVersion to " + this._blobStoreVersion);
                }
            }
            this._loadedBlobStoreEntry.setBlobStoreVersion(this._blobStoreVersion);
            if (set_indexses && !this.isDeleted()) {
                this.economizeBackRefs((ArrayList)this._backRefs, this._loadedBlobStoreEntry, cacheManager.getTypeData(this._loadedBlobStoreEntry.getServerTypeDesc()), false, true);
            }
        } else {
            this._status = (byte)(this._status & 0xFFFFFFFD);
        }
    }

    @Override
    public boolean isMatchCacheFilter(IBlobStoreCacheHandler blobStoreCacheHandler) {
        return blobStoreCacheHandler.getBlobStoreInternalCacheFilter() == null || (this._status & 0x20) == 32;
    }

    @Override
    public void setMatchCacheFilter(IBlobStoreCacheHandler blobStoreCacheHandler, boolean val) {
        if (blobStoreCacheHandler.getBlobStoreInternalCacheFilter() != null) {
            this._status = val ? (byte)(this._status | 0x20) : (byte)(this._status & 0xFFFFFFDF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildCrcForFields() {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this._crcForFields = BlobStoreRefEntryCacheInfo.buildCrcForFields(this._loadedBlobStoreEntry);
        }
    }

    @Override
    public boolean isBulkFlushing() {
        return (this._status & 0x10) == 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBulkFlushing(BlobStoreBulkInfo caller) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            if (this.isInBulk() && this._loadedBlobStoreEntry.getBulkInfo().isActive() && this._loadedBlobStoreEntry.getBulkInfo() == caller) {
                this.setBulkFlushing_impl(true);
                return true;
            }
            return false;
        }
    }

    private void setBulkFlushing_impl(boolean value) {
        this._status = value ? (byte)(this._status | 0x10) : (byte)(this._status & 0xFFFFFFEF);
    }

    @Override
    public IServerTypeDesc getServerTypeDesc() {
        BlobStoreEntryHolder eh = this._loadedBlobStoreEntry;
        return eh != null ? eh.getServerTypeDesc() : ServerTypeDesc.getByServerTypeDescCode(this._serverTypeDescCode);
    }

    private Object getStateLockObject() {
        return this._m_Uid;
    }

    @Override
    public void setDeleted(boolean deleted) {
        if (!this.isPinned()) {
            throw new RuntimeException("setDeleted but entry not pinned uid=" + this._m_Uid);
        }
        this._status = deleted ? (byte)(this._status | 4) : (byte)(this._status & 0xFFFFFFFB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPhantom() {
        Object object = this.getStateLockObject();
        synchronized (object) {
            return this._loadedBlobStoreEntry.isPhantom();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntryFromBlobStoreStorage(Context context, CacheManager cacheManager) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.removeEntryFromBlobStoreStorage_impl(context, cacheManager);
        }
    }

    private void removeEntryFromBlobStoreStorage_impl(Context context, CacheManager cacheManager) {
        this.removeFromInternalCache(context, cacheManager, this._loadedBlobStoreEntry);
        if (this.isWrittenToBlobStore()) {
            cacheManager.getBlobStoreStorageHandler().removeIfExists(this.getStorageKey_impl(), this.getBlobStorePos(), BlobStoreObjectType.DATA, this);
        }
        this._blobStorePosition = null;
    }

    @Override
    public IEntryHolder getLatestEntryVersion(CacheManager cacheManager, boolean attach, IBlobStoreEntryHolder lastKnownEntry, Context attachingContext) {
        return this.getLatestEntryVersion(cacheManager, attach, lastKnownEntry, attachingContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetNonTransactionalFailedBlobstoreOpStatus(Context context, CacheManager cm) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.removeFromInternalCache(context, cm, this._loadedBlobStoreEntry);
            this.setDirty(false, cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IEntryHolder getLatestEntryVersion(CacheManager cacheManager, boolean attach, IBlobStoreEntryHolder lastKnownEntry, Context attachingContext, boolean onlyIndexesPart) {
        BlobStoreEntryHolder res = null;
        if (!onlyIndexesPart && lastKnownEntry != null && lastKnownEntry.isOptimizedEntry()) {
            lastKnownEntry = null;
        }
        if (!attach) {
            res = this._loadedBlobStoreEntry;
            if (res != null && !onlyIndexesPart && res.isOptimizedEntry()) {
                res = null;
            }
            if (res != null) {
                return res;
            }
        }
        while (true) {
            try {
                return this.getLatestEntryVersion_impl(cacheManager, attach, lastKnownEntry, attachingContext, onlyIndexesPart);
            }
            catch (BlobStoreBusyInBulkException ex) {
                BlobStoreBulkInfo bi;
                if (attachingContext.isActiveBlobStoreBulk()) {
                    attachingContext.getBlobStoreBulkInfo().bulk_flush(attachingContext, false, true);
                }
                BlobStoreBulkInfo bulkInfo = null;
                Object object = this.getStateLockObject();
                synchronized (object) {
                    res = this._loadedBlobStoreEntry;
                    BlobStoreBulkInfo blobStoreBulkInfo = bulkInfo = res != null ? res.getBulkInfo() : null;
                    if (res != null && bulkInfo != null && !this.isBulkFlushing()) {
                        try {
                            BlobStoreErrorBulkEntryInfo.setOnContext(attachingContext, bulkInfo.getPerviousStateForEntry(this._m_Uid));
                            this.flush_impl(cacheManager, attachingContext, false);
                            if (bulkInfo.getDirectPersistencyCoordinationObject(this.getUID()) != null) {
                                cacheManager.getEngine().getReplicationNode().getDirectPesistencySyncHandler().afterOperationPersisted(bulkInfo.getDirectPersistencyCoordinationObject(this.getUID()));
                                DelayedReplicationBasicInfo dri = bulkInfo.getDelayedReplicationInfo(this._m_Uid);
                                if (dri != null) {
                                    this.handleDelayedReplication(cacheManager, attachingContext, dri);
                                }
                            }
                            this.bulkUnRegister(cacheManager);
                            continue;
                        }
                        catch (Exception t) {
                            res.getBulkInfo().setExecption(t);
                            throw !(t instanceof BlobStoreException) ? new BlobStoreException(t) : (BlobStoreException)t;
                        }
                    }
                }
                if (res == null || res.getBulkInfo() == null || (bi = res.getBulkInfo()) == null || bi != bulkInfo) continue;
                bi.waitForBulkFlush(this);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IEntryHolder getLatestEntryVersion_impl(CacheManager cacheManager, boolean attach, IBlobStoreEntryHolder lastKnownEntry, Context context, boolean onlyIndexesPart) {
        BlobStoreEntryHolder res = null;
        Object object = this.getStateLockObject();
        synchronized (object) {
            res = this._loadedBlobStoreEntry;
            if (res != null && !attach) {
                if (!onlyIndexesPart && res.isOptimizedEntry()) {
                    if (!this.isWrittenToBlobStore() || res.isDeleted() || this.isPhantom()) {
                        return res;
                    }
                    res = null;
                } else {
                    return res;
                }
            }
            if (!attach && context != null && (res = this.getPreFetchedEntry(cacheManager, context)) != null) {
                return res;
            }
            if (res != null) {
                if (res.getBulkInfo() != null && res.getBulkInfo().isActive() && res.getBulkInfo().getOwnerThread() != Thread.currentThread()) {
                    throw BusyInBulkIndicator;
                }
                if (!this.isPinned()) {
                    throw new RuntimeException("entry attach and entry in RefEntryCacheInfo but not pinned " + this._m_Uid);
                }
                if (!onlyIndexesPart && res.isOptimizedEntry()) {
                    if (this.isDirty()) {
                        throw new RuntimeException("invalid entry state- entry attach and dirty" + this._m_Uid);
                    }
                    this.unLoadFullEntryIfPossible_impl(cacheManager, context);
                    res = null;
                } else {
                    return res;
                }
            }
            if (lastKnownEntry != null && lastKnownEntry.getBlobStoreVersion() == this._blobStoreVersion && this._blobStoreVersion != -1) {
                res = (BlobStoreEntryHolder)lastKnownEntry;
                if (attach) {
                    this._loadedBlobStoreEntry = res;
                    if (this.indexesBackRefsKept() && !this.is_full_indexes_backrefs_forced()) {
                        this._backRefs = this.buildBackrefsArrayListFromBlobStore(cacheManager.getTypeData(res.getServerTypeDesc()), res);
                    }
                    this.pin();
                }
                return res;
            }
            res = this.getFullEntry(cacheManager, onlyIndexesPart);
            if (attach) {
                this._loadedBlobStoreEntry = res;
                if (this.indexesBackRefsKept() && !this.is_full_indexes_backrefs_forced()) {
                    this._backRefs = this.buildBackrefsArrayListFromBlobStore(cacheManager.getTypeData(res.getServerTypeDesc()), res);
                }
                this.pin();
            }
            return res;
        }
    }

    private void handleDelayedReplication(CacheManager cacheManager, Context context, DelayedReplicationBasicInfo dri) {
        try {
            IReplicationOutContext ro = cacheManager.getReplicationContext(context);
            ro.setDirectPersistencyPendingEntry(dri.getDirectPersistencyOpInfo());
            switch (dri.getOpCode()) {
                case INSERT: {
                    DelayedReplicationInsertInfo ii = (DelayedReplicationInsertInfo)dri;
                    cacheManager.handleInsertEntryReplication(context, dri.getEntry());
                    break;
                }
                case UPDATE: {
                    DelayedReplicationUpdateInfo ui = (DelayedReplicationUpdateInfo)dri;
                    cacheManager.handleUpdateEntryReplication(context, ui.getEntry(), ui.getOriginalData(), ui.getMutators());
                    break;
                }
                case REMOVE: {
                    DelayedReplicationRemoveInfo ri = (DelayedReplicationRemoveInfo)dri;
                    cacheManager.handleRemoveEntryReplication(context, ri.getEntry(), ri.getRemoveReason());
                }
            }
        }
        catch (SAException ex) {
            CacheManager.getLogger().severe("Blobstore- BLRECI:handleDelayedReplication got execption" + ex.toString() + ex.getStackTrace());
            throw new RuntimeException("Blobstore- BLRECI:handleDelayedReplication got execption" + ex.toString() + ex.getStackTrace());
        }
    }

    private BlobStoreEntryHolder getPreFetchedEntry(CacheManager cacheManager, Context context) {
        BlobStoreEntryHolder res = null;
        if (context.getBlobStorePreFetchBatchResult() != null) {
            BlobStoreEntryLayout ole = context.getBlobStorePreFetchBatchResult().getFromStore(this);
            if (ole != null) {
                if (ole.getBlobStoreVersion() != this._blobStoreVersion || this._blobStoreVersion == -1) {
                    return null;
                }
                res = ole.buildBlobStoreEntryHolder(cacheManager, this);
            } else {
                res = context.getBlobStorePreFetchBatchResult().getFromCache(this);
                if (res != null && (res.getBlobStoreVersion() != this._blobStoreVersion || this._blobStoreVersion == -1)) {
                    res = null;
                }
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    private BlobStoreEntryHolder getFullEntry(CacheManager cacheManager, boolean onlyIndexesPart) {
        dbe = this.getFromInternalCache(cacheManager);
        if (dbe != null && (dbe.getBlobStoreVersion() != this._blobStoreVersion || this._blobStoreVersion == -1)) {
            dbe = null;
        }
        if (dbe == null && this.isWrittenToBlobStore()) {
            ole = new BlobStoreEntryLayout();
            if (onlyIndexesPart && cacheManager.hasBlobStoreOffHeapCache()) {
                try {
                    ole.readIndexValuesBytes(cacheManager, this._serverTypeDescCode, cacheManager.getBlobStoreStorageHandler().getOffHeapCache().get(this));
                    ole.setBlobStoreVersion(this._blobStoreVersion);
                    ole.setOnlyIndexesPart(true);
                    ole.setUid(this._m_Uid);
                    if (!CacheManager.getLogger().isLoggable(Level.FINER)) ** GOTO lbl24
                    CacheManager.getLogger().finer("container [" + cacheManager.getEngine().getFullSpaceName() + "] Blobstore- entry loaded from off heap, uid=" + this._m_Uid);
                }
                catch (Exception e) {
                    CacheManager.getLogger().severe("Blobstore- BLRECI:getFullEntry got execption" + e.toString() + e.getStackTrace());
                    throw new RuntimeException("Blobstore- BLRECI:getFullEntry got execption" + e.toString() + e.getStackTrace());
                }
            } else {
                ole = (BlobStoreEntryLayout)cacheManager.getBlobStoreStorageHandler().get(this.getStorageKey_impl(), this._blobStorePosition, BlobStoreObjectType.DATA, onlyIndexesPart, this);
                if (CacheManager.getLogger().isLoggable(Level.FINER)) {
                    if (cacheManager.isPersistentBlobStore()) {
                        CacheManager.getLogger().finer("container [" + cacheManager.getEngine().getFullSpaceName() + "] Blobstore- entry loaded from disk, uid=" + this._m_Uid);
                    } else {
                        CacheManager.getLogger().finer("container [" + cacheManager.getEngine().getFullSpaceName() + "] Blobstore- entry loaded from off heap, uid=" + this._m_Uid);
                    }
                }
            }
lbl24:
            // 6 sources

            v0 = dbe = ole != null ? ole.buildBlobStoreEntryHolder(cacheManager, this) : null;
            if (dbe == null) {
                throw new RuntimeException("loadFullEntryIfNeeded entry not found in blob-storage key=" + this.getUID() + " deleted=" + this.isDeleted() + " pinned=" + this.isPinned() + " isWrittenToBlobStore=" + this.isWrittenToBlobStore());
            }
        }
        return dbe;
    }

    @Override
    public BlobStoreEntryHolder getFromInternalCache(CacheManager cacheManager) {
        if (!this.isMatchCacheFilter(cacheManager.getBlobStoreInternalCache())) {
            return null;
        }
        BlobStoreEntryHolder res = cacheManager.getBlobStoreInternalCache().get(this);
        return res != null && res.getBlobStoreVersion() == this._blobStoreVersion && this._blobStoreVersion != -1 ? res : null;
    }

    private void removeFromInternalCache(Context context, CacheManager cacheManager, BlobStoreEntryHolder entry) {
        cacheManager.getBlobStoreInternalCache().handleOnSpaceOperation(context, entry, CacheOperationReason.ON_TAKE);
    }

    public void insertOrTouchInternalCache(Context context, CacheManager cacheManager, BlobStoreEntryHolder entry, CacheOperationReason cacheOperationReason) {
        if (cacheOperationReason == CacheOperationReason.ON_TAKE) {
            return;
        }
        cacheManager.getBlobStoreInternalCache().handleOnSpaceOperation(context, entry, cacheOperationReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unLoadFullEntryIfPossible(CacheManager cacheManager, Context context) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.unLoadFullEntryIfPossible_impl(cacheManager, context);
        }
    }

    private void unLoadFullEntryIfPossible_impl(CacheManager cacheManager, Context context) {
        BlobStoreEntryHolder entry = this._loadedBlobStoreEntry;
        if (entry == null) {
            return;
        }
        if (this.isDirty()) {
            this.flush_impl(cacheManager, context, true);
        } else {
            if (this.indexesBackRefsKept() && !this.isDeleted()) {
                this.economizeBackRefs((ArrayList)this._backRefs, entry, cacheManager.getTypeData(entry.getServerTypeDesc()), true, false);
            }
            if (context.isInInitialLoad()) {
                this.insertOrTouchInternalCache(context, cacheManager, entry, CacheOperationReason.ON_INITIAL_LOAD);
            }
        }
        if (!this.isDeleted()) {
            this._loadedBlobStoreEntry = null;
            this.unpin();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(CacheManager cacheManager, Context context) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this.flush_impl(cacheManager, context, false);
        }
    }

    private void flush_impl(CacheManager cacheManager, Context context, boolean unloadingEntry) {
        boolean isFromInitialLoad = context.isInInitialLoad();
        try {
            if (!this.isDirty()) {
                return;
            }
            BlobStoreEntryHolder entry = this._loadedBlobStoreEntry;
            if (entry == null) {
                return;
            }
            if (entry.isPhantom() && !this.isDeleted()) {
                throw new BlobStoreException("inconsistent state - phantom but entry not signaled as deleted!!! uid=" + this._m_Uid);
            }
            if (this.isDeleted() && !entry.isPhantom()) {
                this.removeEntryFromBlobStoreStorage_impl(context, cacheManager);
                if (cacheManager.hasBlobStoreOffHeapCache()) {
                    cacheManager.getBlobStoreStorageHandler().getOffHeapCache().delete(this);
                }
            } else {
                if (this.isPhantom()) {
                    this.removeFromInternalCache(context, cacheManager, this._loadedBlobStoreEntry);
                    if (cacheManager.hasBlobStoreOffHeapCache()) {
                        cacheManager.getBlobStoreStorageHandler().getOffHeapCache().delete(this);
                    }
                }
                if (this.indexesBackRefsKept() && unloadingEntry) {
                    this.economizeBackRefs((ArrayList)this._backRefs, entry, cacheManager.getTypeData(entry.getServerTypeDesc()), unloadingEntry, true);
                }
                BlobStoreEntryLayout entryLayout = (BlobStoreEntryLayout)this.getEntryLayout_impl(cacheManager, entry);
                if (!this.isWrittenToBlobStore()) {
                    if (isFromInitialLoad) {
                        if (cacheManager.getBlobStoreInternalCache().getBlobStoreInternalCacheFilter() != null) {
                            this.insertOrTouchInternalCache(context, cacheManager, entry, CacheOperationReason.ON_INITIAL_LOAD);
                        }
                    } else {
                        this.insertOrTouchInternalCache(context, cacheManager, entry, CacheOperationReason.ON_WRITE);
                    }
                    if (cacheManager.hasBlobStoreOffHeapCache() && !this.isPhantom()) {
                        cacheManager.getBlobStoreStorageHandler().getOffHeapCache().write(this, entryLayout.getIndexValuesBytes(cacheManager));
                    }
                    this._blobStorePosition = cacheManager.getBlobStoreStorageHandler().add(this.getStorageKey_impl(), entryLayout, BlobStoreObjectType.DATA, this);
                } else {
                    if (cacheManager.hasBlobStoreOffHeapCache() && !this.isPhantom()) {
                        cacheManager.getBlobStoreStorageHandler().getOffHeapCache().update(this, entryLayout.getIndexValuesBytes(cacheManager));
                    }
                    this._blobStorePosition = cacheManager.getBlobStoreStorageHandler().replace(this.getStorageKey_impl(), entryLayout, this.getBlobStorePos(), BlobStoreObjectType.DATA, this);
                }
                if (this._blobStorePosition == null) {
                    this._blobStorePosition = DummyBlobStorePos;
                }
            }
            this.setDirty_impl(false, false, cacheManager);
        }
        catch (BlobStoreException bex) {
            if (!isFromInitialLoad) {
                this.revertFailedOp(cacheManager, context, bex);
            }
            throw bex;
        }
        catch (IOException e) {
            throw new BlobStoreException("failed to get indexed value bytes for entry " + this._m_Uid, e);
        }
    }

    private void revertFailedOp(CacheManager cacheManager, Context context, BlobStoreException cause) {
        try {
            if (this.isDeleted()) {
                BlobStoreErrorsHandler.onFailedRemove(cacheManager, context, this, this._loadedBlobStoreEntry);
            } else if (!this.isWrittenToBlobStore()) {
                BlobStoreErrorsHandler.onFailedWrite(cacheManager, context, this, this._loadedBlobStoreEntry);
            } else {
                BlobStoreErrorsHandler.onFailedUpdate(cacheManager, context, this, this._loadedBlobStoreEntry);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getStorageKey() {
        Object object = this.getStateLockObject();
        synchronized (object) {
            return this.getStorageKey_impl();
        }
    }

    private Serializable getStorageKey_impl() {
        return this._m_Uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getEntryLayout(CacheManager cacheManager) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            return this.getEntryLayout_impl(cacheManager, this._loadedBlobStoreEntry);
        }
    }

    private Serializable getEntryLayout_impl(CacheManager cacheManager, BlobStoreEntryHolder entry) {
        return new BlobStoreEntryLayout(entry, cacheManager.isPersistentBlobStore());
    }

    private Object getBlobStorePos() {
        return this._blobStorePosition;
    }

    @Override
    public String getTypeName() {
        return ServerTypeDesc.getByServerTypeDescCode(this._serverTypeDescCode).getTypeName();
    }

    @Override
    public short getServerTypeDescCode() {
        return this._serverTypeDescCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlobStorePosition(Object pos) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            this._blobStorePosition = pos != null ? pos : DummyBlobStorePos;
        }
    }

    private void pin() {
        if (this.isPinned()) {
            throw new RuntimeException("blobStoreCacheInfo: pin called but already pinned " + this.getUID());
        }
        this._status = (byte)(this._status | 1);
    }

    private void unpin() {
        if (!this.isPinned()) {
            throw new RuntimeException("blobStoreCacheInfo: unpin called but not pinned uid= " + this.getUID());
        }
        this._status = (byte)(this._status & 0xFFFFFFFE);
        if (this._loadedBlobStoreEntry != null && !this.isDeleted()) {
            throw new RuntimeException("blobStoreCacheInfo: unpin called and _loadedBlobStoreEntry != null uid= " + this.getUID());
        }
    }

    private void set_full_indexes_backrefs_forced(boolean value) {
        this._status = value ? (byte)(this._status | 8) : (byte)(this._status & 0xFFFFFFF7);
    }

    private boolean is_full_indexes_backrefs_forced() {
        return (this._status & 8) == 8;
    }

    private boolean isWrittenToBlobStore() {
        return this._blobStorePosition != null;
    }

    @Override
    public IEntryHolder getEntryHolderIfInMemory() {
        return this._loadedBlobStoreEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkRegister(Context context, BlobStoreBulkInfo bulkInfo, int spaceOperation, boolean registerDirectPersistency) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            bulkInfo.add(context, this, spaceOperation, registerDirectPersistency);
            this._loadedBlobStoreEntry.setBulkInfo(bulkInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkUnRegister(CacheManager cacheManager) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            BlobStoreEntryHolder loadedBlobStoreEntry = this._loadedBlobStoreEntry;
            loadedBlobStoreEntry.setBulkInfo(null);
            this.setBulkFlushing_impl(false);
        }
    }

    @Override
    public boolean isInBulk() {
        BlobStoreEntryHolder loadedBlobStoreEntry = this._loadedBlobStoreEntry;
        return loadedBlobStoreEntry != null && loadedBlobStoreEntry.getBulkInfo() != null;
    }

    public IEntryHolder getEntryHolder() {
        return this._loadedBlobStoreEntry;
    }

    @Override
    public IEntryHolder getEntryHolder(CacheManager cacheManager) {
        boolean canBeOptimized;
        Context context = cacheManager.viewCacheContext();
        boolean bl = canBeOptimized = context != null && context.getOptimizedBlobStoreReadEnabled() != null && context.getOptimizedBlobStoreReadEnabled() != false;
        if (context != null) {
            return this.getLatestEntryVersion(cacheManager, false, null, context, canBeOptimized || context.isInInitialLoad());
        }
        return this.getLatestEntryVersion(cacheManager, false, null, null);
    }

    @Override
    public IEntryHolder getEntryHolder(CacheManager cacheManager, Context context) {
        boolean canBeOptimized;
        boolean bl = canBeOptimized = context != null && context.getOptimizedBlobStoreReadEnabled() != null && context.getOptimizedBlobStoreReadEnabled() != false;
        if (context != null) {
            return this.getLatestEntryVersion(cacheManager, false, null, context, canBeOptimized || context.isInInitialLoad());
        }
        return this.getLatestEntryVersion(cacheManager, false, null, context);
    }

    @Override
    public ArrayList<IObjectInfo<IEntryCacheInfo>> getBackRefs() {
        if (this.indexesBackRefsKept()) {
            return (ArrayList)this._backRefs;
        }
        return null;
    }

    private ArrayList<IObjectInfo<IEntryCacheInfo>> buildBackrefsArrayListFromBlobStore(TypeData pType, BlobStoreEntryHolder entryHolder) {
        ArrayList<IObjectInfo<IEntryCacheInfo>> builtBrefs = new ArrayList<IObjectInfo<IEntryCacheInfo>>();
        long singleValueIndexIndicators = this._singleValueIndexIndicators;
        IObjectInfo[] nonSingleRefs = null;
        if (this._backRefs.getClass().isArray()) {
            nonSingleRefs = (IObjectInfo[])this._backRefs;
            builtBrefs.add(nonSingleRefs[0]);
        } else {
            builtBrefs.add((IObjectInfo)this._backRefs);
        }
        int bitpos = 0;
        if (pType.hasIndexes()) {
            int indxNum = 0;
            int backrefNonSelfPos = 1;
            IEntryData entryData = entryHolder.getEntryData();
            TypeDataIndex[] indexes = pType.getIndexes();
            boolean pos = false;
            for (TypeDataIndex index : indexes) {
                if (index.disableIndexUsageForOperation(pType, this.getLatestIndexCreationNumber())) continue;
                int numBackRefs = index.numOfEntryIndexBackRefs(index.getIndexValue(entryData));
                if ((singleValueIndexIndicators >> bitpos & 1L) == 1L) {
                    builtBrefs.add(this);
                } else {
                    builtBrefs.add(nonSingleRefs[backrefNonSelfPos++]);
                }
                if (index.isExtendedIndex()) {
                    if ((singleValueIndexIndicators >> bitpos + 1 & 1L) == 1L) {
                        builtBrefs.add(this);
                    } else if (numBackRefs == 2) {
                        builtBrefs.add(nonSingleRefs[backrefNonSelfPos++]);
                    }
                }
                ++indxNum;
                bitpos += index.isExtendedIndex() ? 2 : 1;
            }
        }
        return builtBrefs;
    }

    @Override
    public void setBackRefs(ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs) {
        if (this.indexesBackRefsKept()) {
            this._backRefs = backRefs;
        } else if (backRefs != null) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void economizeBackRefs(ArrayList<IObjectInfo<IEntryCacheInfo>> backRefs, BlobStoreEntryHolder entryHolder, TypeData pType, boolean unloadingEntry, boolean flushingEntry) {
        if (this.is_full_indexes_backrefs_forced()) {
            return;
        }
        IObjectInfo[] newBackRefs = null;
        long singleValueIndexIndicators = 0L;
        try {
            if (!pType.hasIndexes()) {
                newBackRefs = backRefs.get(0);
                return;
            }
            TypeDataIndex[] indexes = pType.getIndexes();
            boolean anySingleRef = false;
            int indxNum = 0;
            int bitpos = 0;
            int arrayListPos = 1;
            int numNonSingleRefs = 0;
            IEntryData entryData = entryHolder.getEntryData();
            for (TypeDataIndex index : indexes) {
                if (index.disableIndexUsageForOperation(pType, this.getLatestIndexCreationNumber())) continue;
                int numBackRefs = index.numOfEntryIndexBackRefs(index.getIndexValue(entryData));
                if (bitpos > 62) {
                    if (CacheManager.getLogger().isLoggable(Level.INFO)) {
                        CacheManager.getLogger().info("Blobstore- num of indexes exceeds efficient limit, num=" + indxNum);
                    }
                    this.set_full_indexes_backrefs_forced(true);
                    this._singleValueIndexIndicators = 0L;
                    newBackRefs = null;
                    return;
                }
                if (backRefs.get(arrayListPos++) == this) {
                    singleValueIndexIndicators |= 1L << bitpos;
                } else {
                    ++numNonSingleRefs;
                }
                if (numBackRefs == 2) {
                    if (bitpos + 1 > 62) {
                        if (CacheManager.getLogger().isLoggable(Level.INFO)) {
                            CacheManager.getLogger().info("Blobstore- num of indexes exceeds efficient limit, num=" + indxNum);
                        }
                        this.set_full_indexes_backrefs_forced(true);
                        this._singleValueIndexIndicators = 0L;
                        newBackRefs = null;
                        return;
                    }
                    if (backRefs.get(arrayListPos++) == this) {
                        singleValueIndexIndicators |= 1L << bitpos + 1;
                    } else {
                        ++numNonSingleRefs;
                    }
                }
                bitpos += index.isExtendedIndex() ? 2 : 1;
                ++indxNum;
            }
            if (numNonSingleRefs > 0) {
                IObjectInfo[] nonSingleRefs = new IObjectInfo[numNonSingleRefs + 1];
                int pos = 0;
                for (IObjectInfo<IEntryCacheInfo> ref : backRefs) {
                    if (ref == this) continue;
                    nonSingleRefs[pos++] = ref;
                }
                newBackRefs = nonSingleRefs;
            } else {
                newBackRefs = backRefs.get(0);
            }
        }
        finally {
            if (newBackRefs != null) {
                this._singleValueIndexIndicators = singleValueIndexIndicators;
                if (unloadingEntry) {
                    this._backRefs = newBackRefs;
                }
            }
        }
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> getMainListBackRef() {
        if (this.indexesBackRefsKept()) {
            return (IObjectInfo)((ArrayList)this._backRefs).get(0);
        }
        return (IObjectInfo)this._backRefs;
    }

    @Override
    public boolean indexesBackRefsKept() {
        return TypeDataIndex.isIndexesBackRefsForBlobStoreData();
    }

    @Override
    public void setMainListBackRef(IObjectInfo<IEntryCacheInfo> mainListBackref) {
        if (this.indexesBackRefsKept()) {
            ((ArrayList)this._backRefs).add(mainListBackref);
        } else {
            this._backRefs = mainListBackref;
        }
    }

    @Override
    public void setLeaseManagerListRefAndPosition(IStoredList<Object> entriesList, IObjectInfo<Object> entryPos) {
        this._leaseManagerEntryPos = entryPos;
    }

    @Override
    public IStoredList<Object> getLeaseManagerListRef() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IObjectInfo<Object> getLeaseManagerPosition() {
        return this._leaseManagerEntryPos;
    }

    @Override
    public boolean isConnectedToLeaseManager() {
        return this._loadedBlobStoreEntry.getExpirationTime() != Long.MAX_VALUE;
    }

    @Override
    public boolean isSameLeaseManagerRef(ILeasedEntryCacheInfo other) {
        return this._leaseManagerEntryPos == other.getLeaseManagerPosition();
    }

    @Override
    public boolean isBlobStoreEntry() {
        return true;
    }

    @Override
    public Object getObjectStoredInLeaseManager() {
        return this._m_Uid;
    }

    @Override
    public int getLatestIndexCreationNumber() {
        return this._latestIndexCreationNumber;
    }

    @Override
    public void setLatestIndexCreationNumber(int val) {
        if (val > 255) {
            CacheManager.getLogger().severe("Blobstore- LatestIndexCreationNumber exceeds supported limit, num=" + val);
            throw new RuntimeException("Blobstore- LatestIndexCreationNumber exceeds supported limit, num=" + val);
        }
        this._latestIndexCreationNumber = (byte)val;
    }

    @Override
    public String getClassName() {
        return this._loadedBlobStoreEntry.getClassName();
    }

    @Override
    public void setEvictionPayLoad(Object evictionBackRef) {
        throw new RuntimeException("setEvictionBackref invalid here");
    }

    @Override
    public Object getEvictionPayLoad() {
        return null;
    }

    @Override
    public String getUID() {
        return this._m_Uid;
    }

    @Override
    public void setInCache(boolean checkPendingPin) {
    }

    @Override
    public boolean setPinned(boolean value, boolean waitIfPendingInsertion) {
        return true;
    }

    @Override
    public boolean setPinned(boolean value) {
        return this.setPinned(value, false);
    }

    @Override
    public boolean isPinned() {
        return (this._status & 1) == 1;
    }

    @Override
    public boolean setRemoving(boolean isPinned) {
        return true;
    }

    @Override
    public boolean isRemoving() {
        return false;
    }

    @Override
    public void setRemoved() {
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public boolean isRemovingOrRemoved() {
        return false;
    }

    @Override
    public boolean wasInserted() {
        return true;
    }

    @Override
    public boolean isRecentDelete() {
        return false;
    }

    @Override
    public void setRecentDelete() {
        throw new RuntimeException("invalid usage !!!");
    }

    @Override
    public boolean isDeleted() {
        return (this._status & 4) == 4;
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> getHead() {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public IEntryCacheInfo getObjectFromHead() {
        return this;
    }

    @Override
    public void freeSLHolder(IStoredListIterator slh) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public void remove(IObjectInfo oi) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public void removeUnlocked(IObjectInfo oi) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public boolean invalidate() {
        return false;
    }

    @Override
    public void dump(Logger logger, String msg) {
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public IStoredListIterator<IEntryCacheInfo> establishListScan(boolean random_scan) {
        return this;
    }

    @Override
    public IStoredListIterator<IEntryCacheInfo> next(IStoredListIterator<IEntryCacheInfo> slh) {
        return null;
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> add(IEntryCacheInfo subject) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public IObjectInfo<IEntryCacheInfo> addUnlocked(IEntryCacheInfo subject) {
        throw new RuntimeException(" invalid usage");
    }

    @Override
    public boolean removeByObject(IEntryCacheInfo obj) {
        return false;
    }

    @Override
    public boolean contains(IEntryCacheInfo obj) {
        return this == obj;
    }

    @Override
    public void setSubject(IEntryCacheInfo subject) {
    }

    @Override
    public IEntryCacheInfo getSubject() {
        return this;
    }

    @Override
    public boolean isMultiObjectCollection() {
        return false;
    }

    @Override
    public boolean optimizeScanForSingleObject() {
        return true;
    }

    @Override
    public boolean hasNext() throws SAException {
        return true;
    }

    @Override
    public IEntryCacheInfo next() throws SAException {
        return this;
    }

    @Override
    public void releaseScan() throws SAException {
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this.getEntryHolder().getEntryData().getSpaceTypeDescriptor();
    }

    @Override
    public Object getFixedPropertyValue(int position) {
        return this.getEntryHolder().getEntryData().getFixedPropertyValue(position);
    }

    @Override
    public Object getPropertyValue(String name) {
        return this.getEntryHolder().getEntryData().getPropertyValue(name);
    }

    @Override
    public Object getPathValue(String path) {
        return this.getEntryHolder().getEntryData().getPathValue(path);
    }

    @Override
    public int getVersion() {
        return this.getEntryHolder().getEntryData().getVersion();
    }

    @Override
    public long getExpirationTime() {
        return this.getEntryHolder().getEntryData().getExpirationTime();
    }

    @Override
    public int getHashCode(int id) {
        return this.getKey(id).hashCode();
    }

    @Override
    public Object getKey(int id) {
        if (id == -1) {
            return this._m_Uid;
        }
        return this.getEntryHolder().getEntryData().getFixedPropertyValue(id);
    }

    @Override
    public IStoredList<IEntryCacheInfo> getValue(int id) {
        return this;
    }

    @Override
    public boolean isNativeHashEntry() {
        return false;
    }

    @Override
    public void release() {
    }

    @Override
    public boolean isLockSubject() {
        return false;
    }

    @Override
    public boolean preMatch(Context context, ITemplateHolder template) {
        if (this._loadedBlobStoreEntry != null) {
            return true;
        }
        return template.getExtendedMatchCodes() == null ? BlobStoreRefEntryCacheInfo.preMatch_impl(context, template, this._crcForFields) : BlobStoreRefEntryCacheInfo.preMatch_extendex_impl(context, template, this._crcForFields);
    }

    private static boolean preMatch_impl(Context context, ITemplateHolder template, long entryCrcForFields) {
        if (template.getEntryData().getFixedPropertiesValues() == null || template.getEntryData().getFixedPropertiesValues().length == 0) {
            return true;
        }
        int lim = Math.min(8, template.getEntryData().getFixedPropertiesValues().length);
        for (int i = 0; i < lim; ++i) {
            byte templateCrc;
            byte entryCrc;
            if (template.getEntryData().getFixedPropertyValue(i) == null || (entryCrc = (byte)(entryCrcForFields >>> i * 8 & 0xFFL)) == 0 || (templateCrc = BlobStoreRefEntryCacheInfo.create8BitsCRCFromHashCode(template.getEntryData().getFixedPropertyValue(i).hashCode())) == entryCrc) continue;
            context.incrementNumOfEntriesMatched();
            return false;
        }
        return true;
    }

    private static boolean preMatch_extendex_impl(Context context, ITemplateHolder template, long entryCrcForFields) {
        if (template.getEntryData().getFixedPropertiesValues() == null || template.getEntryData().getFixedPropertiesValues().length == 0) {
            return true;
        }
        int lim = Math.min(8, template.getExtendedMatchCodes().length);
        for (int i = 0; i < lim; ++i) {
            byte templateCrc;
            byte entryCrc;
            if (template.getEntryData().getFixedPropertyValue(i) == null || template.getExtendedMatchCodes()[i] != 0 || (entryCrc = (byte)(entryCrcForFields >>> i * 8 & 0xFFL)) == 0 || (templateCrc = BlobStoreRefEntryCacheInfo.create8BitsCRCFromHashCode(template.getEntryData().getFixedPropertyValue(i).hashCode())) == entryCrc) continue;
            context.incrementNumOfEntriesMatched();
            return false;
        }
        return true;
    }

    private static long buildCrcForFields(IEntryHolder entry) {
        long result = 0L;
        int lim = Math.min(8, entry.getEntryData().getFixedPropertiesValues().length);
        for (int i = 0; i < lim; ++i) {
            if (entry.getEntryData().getFixedPropertyValue(i) == null || entry.getEntryData().getFixedPropertyValue(i).getClass().isArray() || entry.getEntryData().getFixedPropertyValue(i) instanceof Collection) continue;
            int hashCode = entry.getEntryData().getFixedPropertyValue(i) == null ? 0 : entry.getEntryData().getFixedPropertyValue(i).hashCode();
            byte crc = BlobStoreRefEntryCacheInfo.create8BitsCRCFromHashCode(hashCode);
            long tmp = crc;
            tmp &= 0xFFL;
            result |= (tmp <<= i * 8);
        }
        return result;
    }

    private static byte create8BitsCRCFromHashCode(int hashCode) {
        byte checksum = 0;
        for (int i = 0; i < 4; ++i) {
            byte data = (byte)(hashCode >>> i * 8 & 0xFF);
            checksum = (byte)(checksum + data & 0xFF);
        }
        if ((checksum = (byte)((byte)((checksum ^ 0xFF) + 1 & 0xFF))) == 0) {
            checksum = 1;
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeOffHeap(CacheManager cacheManager, AbstractMemoryPool offHeapMemoryPool) {
        Object object = this.getStateLockObject();
        synchronized (object) {
            offHeapMemoryPool.delete(this);
        }
    }

    @Override
    public void setOffHeapAddress(long address) {
        this._offHeapIndexValuesAddress = address;
    }

    @Override
    public long getOffHeapAddress() {
        return this._offHeapIndexValuesAddress;
    }
}

