/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBulkInfo;
import com.j_spaces.core.cache.context.Context;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class BlobStoreReplicaConsumeHelper {
    private final SpaceEngine _engine;
    private final ConcurrentMap<Thread, Context> _contextMap;

    public BlobStoreReplicaConsumeHelper(SpaceEngine engine) {
        this._engine = engine;
        this._contextMap = new ConcurrentHashMap<Thread, Context>();
    }

    public void prepareForBulking() {
        if (!this._engine.getCacheManager().useBlobStoreBulks()) {
            return;
        }
        Context context = this._engine.getCacheManager().getCacheContext();
        context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._engine.getCacheManager(), false));
        this._contextMap.put(Thread.currentThread(), context);
    }

    public Context getContext() {
        return (Context)this._contextMap.get(Thread.currentThread());
    }

    public void flushBulk() {
        Context context = this.getContext();
        if (context == null) {
            return;
        }
        try {
            if (context.isActiveBlobStoreBulk()) {
                context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
            }
        }
        finally {
            this._engine.getCacheManager().freeCacheContext(context);
            this._contextMap.remove(Thread.currentThread());
        }
    }
}

