/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreBulkInfo;
import com.j_spaces.core.cache.context.Context;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class BlobStoreReplicationBulkConsumeHelper {
    private final SpaceEngine _engine;
    private final ConcurrentMap<Thread, Context> _contextMap;
    private volatile boolean _bulkPrepared = false;
    private long _lastProcessedKey;

    public BlobStoreReplicationBulkConsumeHelper(SpaceEngine engine) {
        this._engine = engine;
        this._contextMap = new ConcurrentHashMap<Thread, Context>();
    }

    public void prepareForBulking(boolean take) {
        if (!this._engine.getCacheManager().useBlobStoreReplicationBackupBulks() || this._bulkPrepared) {
            return;
        }
        Context context = this._engine.getCacheManager().getCacheContext();
        context.setBlobStoreBulkInfo(new BlobStoreBulkInfo(this._engine.getCacheManager(), take));
        this._contextMap.put(Thread.currentThread(), context);
        this._bulkPrepared = true;
    }

    public Context getContext() {
        return (Context)this._contextMap.get(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBulk(long packetKey) {
        Context context = this.getContext();
        try {
            if (context == null) {
                this._lastProcessedKey = packetKey;
                return;
            }
            if (context.isActiveBlobStoreBulk()) {
                context.getBlobStoreBulkInfo().bulk_flush(context, false, true);
                this._lastProcessedKey = packetKey;
                context.setBlobStoreBulkInfo(null);
            }
        }
        finally {
            this._bulkPrepared = false;
            if (context != null) {
                this._engine.getCacheManager().freeCacheContext(context);
                this._contextMap.remove(Thread.currentThread());
            }
        }
    }

    public long getLastProcessedKey() {
        return this._lastProcessedKey;
    }
}

