/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import org.jini.rio.boot.ServiceClassLoader;

@InternalApi
public class BlobStoreSerializationUtils {
    private static final ThreadLocal<ByteArrayOutputStream> threadLocal = new ThreadLocal();
    private final CacheManager _cacheManager;

    public BlobStoreSerializationUtils(CacheManager _cacheManager) {
        this._cacheManager = _cacheManager;
    }

    public byte[] serialize(Serializable obj, BlobStoreObjectType objectType) {
        ByteArrayOutputStream baos = threadLocal.get();
        if (baos == null) {
            baos = new ByteArrayOutputStream(512);
            baos.reset();
            threadLocal.set(baos);
        } else {
            baos.reset();
        }
        this.serialize(obj, baos, objectType);
        return baos.toByteArray();
    }

    private void serialize(Serializable obj, OutputStream outputStream, BlobStoreObjectType objectType) {
        if (outputStream == null) {
            throw new IllegalArgumentException("The OutputStream must not be null");
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(outputStream);
            if (objectType != BlobStoreObjectType.DATA) {
                out.writeObject(obj);
            } else {
                BlobStoreEntryLayout el = (BlobStoreEntryLayout)obj;
                el.writeExternal(out, this._cacheManager);
            }
        }
        catch (RuntimeException rte) {
            throw new BlobStoreException(rte);
        }
        catch (IOException ex) {
            throw new BlobStoreException(ex);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public Serializable deserialize(Serializable input, BlobStoreObjectType objectType, boolean initialLoad, boolean onlyIndexedPart, IBlobStoreOffHeapInfo offHeapInfo) {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        return this.deserialize((byte[])input, objectType, initialLoad, onlyIndexedPart, offHeapInfo);
    }

    private Serializable deserialize(InputStream inputStream, BlobStoreObjectType objectType, boolean initialLoad, boolean onlyIndexedPart, IBlobStoreOffHeapInfo offHeapInfo) {
        BlobStoreEntryLayout blobStoreEntryLayout;
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ClassLoaderAwareInputStream in = null;
        try {
            in = new ClassLoaderAwareInputStream(inputStream);
            if (objectType != BlobStoreObjectType.DATA) {
                Serializable serializable = (Serializable)in.readObject();
                return serializable;
            }
            BlobStoreEntryLayout el = new BlobStoreEntryLayout();
            el.readExternal(in, this._cacheManager, initialLoad, onlyIndexedPart, offHeapInfo);
            blobStoreEntryLayout = el;
        }
        catch (RuntimeException rte) {
            throw new BlobStoreException(rte);
        }
        catch (ClassNotFoundException ex) {
            throw new BlobStoreException(ex);
        }
        catch (IOException ex) {
            throw new BlobStoreException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return blobStoreEntryLayout;
    }

    private Serializable deserialize(byte[] objectData, BlobStoreObjectType objectType, boolean initialLoad, boolean onlyIndexedPart, IBlobStoreOffHeapInfo offHeapInfo) {
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return this.deserialize(bais, objectType, initialLoad, onlyIndexedPart, offHeapInfo);
    }

    private class ClassLoaderAwareInputStream
    extends ObjectInputStream {
        private ClassLoaderAwareInputStream(InputStream in) throws IOException {
            super(in);
        }

        public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader currentTccl = Thread.currentThread().getContextClassLoader();
            if (currentTccl instanceof ServiceClassLoader) {
                try {
                    return Class.forName(desc.getName(), false, currentTccl);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return super.resolveClass(desc);
        }
    }
}

