/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.errors;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.sadapter.IBlobStoreStorageAdapter;
import com.j_spaces.core.cache.context.Context;

@InternalApi
public class BlobStoreErrorsHandler {
    public static boolean revertOpOnBlobStoreError(CacheManager cm) {
        return ((IBlobStoreStorageAdapter)((Object)cm.getStorageAdapter())).shouldRevertOpOnBlobStoreError();
    }

    public static void onFailedWrite(CacheManager cm, Context context, BlobStoreRefEntryCacheInfo eci, IEntryHolder eh) {
        try {
            if (!BlobStoreErrorsHandler.revertOpOnBlobStoreError(cm)) {
                return;
            }
            eh.setDeleted(true);
            eci.resetNonTransactionalFailedBlobstoreOpStatus(context, cm);
            cm.removeEntryFromCache(eh, false, true, eci, CacheManager.RecentDeleteCodes.NONE);
        }
        catch (Throwable ex) {
            cm.getLogger().severe("error while reverting failed blob store op in backup,space " + cm.getEngine().getFullSpaceName() + " uid=" + eci.getUID() + " error=" + ex);
        }
    }

    public static void onFailedRemove(CacheManager cm, Context context, BlobStoreRefEntryCacheInfo eci, IEntryHolder eh) {
        try {
            if (!BlobStoreErrorsHandler.revertOpOnBlobStoreError(cm)) {
                return;
            }
            eci.resetNonTransactionalFailedBlobstoreOpStatus(context, cm);
            eh.setDeleted(false);
        }
        catch (Throwable ex) {
            cm.getLogger().severe("error while reverting failed blob store op in backup,space " + cm.getEngine().getFullSpaceName() + " uid=" + eci.getUID() + " error=" + ex);
        }
    }

    public static void onFailedUpdate(CacheManager cm, Context context, BlobStoreRefEntryCacheInfo eci, IEntryHolder eh) {
        try {
            if (!BlobStoreErrorsHandler.revertOpOnBlobStoreError(cm)) {
                return;
            }
            eci.resetNonTransactionalFailedBlobstoreOpStatus(context, cm);
            TypeData typeData = cm.getTypeData(eh.getServerTypeDesc());
            cm.removeEntryReferences(eci, typeData, -1);
            cm.getLeaseManager().unregister(eci, eh.getEntryData().getExpirationTime());
            eci.setBlobStoreVersion(context.getOriginalBlobStoreVersion());
            eh.updateEntryData(context.getOriginalData(), context.getOriginalData().getExpirationTime());
            eci.buildCrcForFields();
            cm.insertEntryReferences(context, eci, typeData, false);
            cm.getLeaseManager().registerEntryLease(eci, eh.getEntryData().getExpirationTime());
        }
        catch (Throwable ex) {
            cm.getLogger().severe("error while reverting failed blob store op in backup,space " + cm.getEngine().getFullSpaceName() + " uid=" + eci.getUID() + " error=" + ex);
        }
    }
}

