/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.memory_pool;

import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;

public abstract class AbstractMemoryPool {
    protected final long threshold;
    private MetricRegistrator metricRegistrator;

    protected AbstractMemoryPool(long threshold) {
        this.threshold = threshold;
    }

    protected String metricsPath(String typeName) {
        return this.metricRegistrator.toPath("used-bytes", typeName);
    }

    public long getThreshold() {
        return this.threshold;
    }

    public MetricRegistrator getMetricRegistrator() {
        return this.metricRegistrator;
    }

    public void setMetricRegistrator(MetricRegistrator metricRegistrator) {
        this.metricRegistrator = metricRegistrator;
    }

    public abstract void initMetrics(MetricRegistrator var1);

    public abstract void register(String var1, short var2);

    public abstract void unregister(String var1, short var2);

    public abstract long getUsedBytes();

    public abstract void write(IBlobStoreOffHeapInfo var1, byte[] var2);

    public abstract byte[] get(IBlobStoreOffHeapInfo var1);

    public abstract void update(IBlobStoreOffHeapInfo var1, byte[] var2);

    public abstract void delete(IBlobStoreOffHeapInfo var1);

    public abstract boolean isPmem();

    public abstract boolean isOffHeap();

    public abstract void close();
}

