/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.memory_pool;

import com.gigaspaces.internal.utils.concurrent.UnsafeHolder;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.MetricRegistrator;
import com.j_spaces.core.cache.blobStore.IBlobStoreOffHeapInfo;
import com.j_spaces.core.cache.blobStore.memory_pool.AbstractMemoryPool;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OffHeapMemoryPool
extends AbstractMemoryPool {
    private Logger logger = Logger.getLogger("com.gigaspaces.cache");
    private int minimalDiffToAllocate;
    private final LongCounter totalCounter = new LongCounter();
    private final Map<Short, LongCounter> typesCounters = new ConcurrentHashMap<Short, LongCounter>();

    public OffHeapMemoryPool(long threshold) {
        super(threshold);
        if (!UnsafeHolder.isAvailable()) {
            throw new RuntimeException(" unsafe instance could not be obtained");
        }
    }

    public void setMinimalDiffToAllocate(int minimalDiffToAllocate) {
        this.minimalDiffToAllocate = minimalDiffToAllocate;
    }

    @Override
    public void initMetrics(MetricRegistrator metricRegistrator) {
        this.setMetricRegistrator(metricRegistrator);
        this.getMetricRegistrator().register(this.metricsPath("total"), this.totalCounter);
    }

    @Override
    public void register(String typeName, short typeCode) {
        LongCounter counter = new LongCounter();
        this.typesCounters.put(typeCode, counter);
        this.getMetricRegistrator().register(this.metricsPath(typeName), counter);
    }

    @Override
    public void unregister(String typeName, short typeCode) {
        this.typesCounters.remove(typeCode);
        this.getMetricRegistrator().unregisterByPrefix(this.metricsPath(typeName));
    }

    @Override
    public long getUsedBytes() {
        return this.totalCounter.getCount();
    }

    @Override
    public void write(IBlobStoreOffHeapInfo info, byte[] buf) {
        this.allocateAndWriteImpl(info, buf, false);
    }

    @Override
    public byte[] get(IBlobStoreOffHeapInfo info) {
        if (info.getOffHeapAddress() == -1L) {
            throw new IllegalStateException("trying to read from off heap but no address found");
        }
        int headerSize = OffHeapMemoryPool.getHeaderSizeFromUnsafe(info.getOffHeapAddress());
        int numOfBytes = OffHeapMemoryPool.getHeaderFromUnsafe(info.getOffHeapAddress(), headerSize);
        return OffHeapMemoryPool.readBytes(info.getOffHeapAddress() + (long)headerSize, numOfBytes);
    }

    @Override
    public void update(IBlobStoreOffHeapInfo info, byte[] buf) {
        if (info.getOffHeapAddress() == -1L) {
            throw new IllegalStateException("trying to update when no off heap memory is allocated");
        }
        int oldHeaderSize = OffHeapMemoryPool.getHeaderSizeFromUnsafe(info.getOffHeapAddress());
        int oldEntryLength = OffHeapMemoryPool.getHeaderFromUnsafe(info.getOffHeapAddress(), oldHeaderSize);
        if (oldEntryLength < buf.length || oldEntryLength - buf.length >= this.minimalDiffToAllocate) {
            this.deleteImpl(info, true);
            this.allocateAndWriteImpl(info, buf, true);
        } else {
            OffHeapMemoryPool.writeBytes(info.getOffHeapAddress() + (long)oldHeaderSize, buf);
        }
    }

    @Override
    public void delete(IBlobStoreOffHeapInfo info) {
        this.deleteImpl(info, false);
    }

    @Override
    public boolean isPmem() {
        return false;
    }

    @Override
    public boolean isOffHeap() {
        return true;
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("OffHeapMemoryPool.close() is not supported");
    }

    private void incrementMetrics(long n, short typeCode) {
        this.totalCounter.inc(n);
        LongCounter typeCounter = this.typesCounters.get(typeCode);
        if (typeCounter != null) {
            typeCounter.inc(n);
        }
    }

    private void decrementMetrics(long n, short typeCode) {
        this.totalCounter.dec(n);
        LongCounter typeCounter = this.typesCounters.get(typeCode);
        if (typeCounter != null) {
            typeCounter.dec(n);
        }
    }

    private void allocateAndWriteImpl(IBlobStoreOffHeapInfo info, byte[] buf, boolean fromUpdate) {
        long newAddress;
        if (info.getOffHeapAddress() == -1L) {
            fromUpdate = false;
        }
        if (info.getOffHeapAddress() != -1L && !fromUpdate) {
            throw new IllegalStateException("trying to allocateAndWrite when already allocated in off heap");
        }
        int headerSize = OffHeapMemoryPool.calculateHeaderSize(buf.length);
        try {
            newAddress = fromUpdate ? UnsafeHolder.reallocateMemory(info.getOffHeapAddress(), headerSize + buf.length) : UnsafeHolder.allocateMemory(headerSize + buf.length);
        }
        catch (Error e) {
            this.logger.log(Level.SEVERE, "failed to allocateAndWrite offheap space", e);
            throw e;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "failed to allocateAndWrite offheap space");
            throw new RuntimeException("failed to allocateAndWrite offheap space", e);
        }
        if (newAddress == 0L) {
            this.logger.log(Level.SEVERE, "failed to allocateAndWrite offheap space");
            throw new RuntimeException("failed to allocateAndWrite offheap space");
        }
        OffHeapMemoryPool.putHeaderToUnsafe(newAddress, buf.length);
        OffHeapMemoryPool.writeBytes(newAddress + (long)headerSize, buf);
        info.setOffHeapAddress(newAddress);
        this.incrementMetrics(headerSize + buf.length, info.getServerTypeDescCode());
    }

    private void deleteImpl(IBlobStoreOffHeapInfo info, boolean fromUpdate) {
        long valuesAddress = info.getOffHeapAddress();
        if (valuesAddress != -1L) {
            int headerSize = OffHeapMemoryPool.getHeaderSizeFromUnsafe(info.getOffHeapAddress());
            int numOfBytes = OffHeapMemoryPool.getHeaderFromUnsafe(valuesAddress, headerSize);
            if (!fromUpdate) {
                UnsafeHolder.freeFromMemory(valuesAddress);
                info.setOffHeapAddress(-1L);
            }
            this.decrementMetrics(headerSize + numOfBytes, info.getServerTypeDescCode());
        }
    }

    private static void writeBytes(long address, byte[] bytes) {
        UnsafeHolder.copyByteArrayToMemory(bytes, address, bytes.length);
    }

    private static byte[] readBytes(long address, int numOfBytes) {
        byte[] res = new byte[numOfBytes];
        UnsafeHolder.copyByteArrayFromMemory(res, address, numOfBytes);
        return res;
    }

    private static int calculateHeaderSize(int bufferLen) {
        if (bufferLen > 0x3FFFFFFF) {
            throw new RuntimeException("Illegal buffer length =" + bufferLen);
        }
        for (int left = 3; left >= 0; --left) {
            int next = bufferLen >>> left * 8 & 0xFF;
            if (next == 0) continue;
            if ((next & 0xC0) != 0) {
                return left + 2;
            }
            return left + 1;
        }
        throw new RuntimeException("Illegal buffer length =" + bufferLen);
    }

    private static int putHeaderToUnsafe(long address, int bufferLen) {
        int headerSize = 0;
        boolean started = false;
        for (int left = 3; left >= 0; --left) {
            int next = bufferLen >>> left * 8 & 0xFF;
            if (!started) {
                if (next == 0) continue;
                if ((next & 0xC0) != 0) {
                    headerSize = left + 1;
                    UnsafeHolder.putByte(address, (byte)(headerSize << 6));
                    ++address;
                } else {
                    headerSize = left;
                    next |= headerSize << 6;
                }
                ++headerSize;
                started = true;
            }
            UnsafeHolder.putByte(address, (byte)next);
            ++address;
        }
        return headerSize;
    }

    private static int getHeaderSizeFromUnsafe(long address) {
        return ((UnsafeHolder.getByte(address) & 0xC0) >> 6) + 1;
    }

    private static int getHeaderFromUnsafe(long address, int headerSize) {
        int len = 0;
        for (int i = 0; i < headerSize; ++i) {
            int intByte = UnsafeHolder.getByte(address);
            intByte = i == 0 ? (intByte &= 0x3F) : (intByte &= 0xFF);
            len |= intByte << (headerSize - 1 - i) * 8;
            ++address;
        }
        return len;
    }
}

