/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.optimizations;

import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.LocalViewRegistrations;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.context.Context;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlobStoreOperationOptimizations {
    private static Logger logger = Logger.getLogger("com.gigaspaces.cache");

    public static boolean isConsiderOptimizedForBlobstore(SpaceEngine spaceEngine, Context context, ITemplateHolder template, IEntryCacheInfo pEntry) {
        if (!pEntry.isBlobStoreEntry() || template.getXidOriginatedTransaction() != null) {
            return false;
        }
        if (context.getOptimizedBlobStoreReadEnabled() != null) {
            return context.getOptimizedBlobStoreReadEnabled();
        }
        IServerTypeDesc serverTypeDesc = pEntry.getServerTypeDesc();
        boolean res = false;
        if (template.isReadOperation()) {
            res = BlobStoreOperationOptimizations.isConsiderOptimizedReadForBlobstore(spaceEngine, template, serverTypeDesc, pEntry.getUID());
        } else if (template.getBatchOperationContext() != null && template.getBatchOperationContext().isClear()) {
            res = BlobStoreOperationOptimizations.isConsiderOptimizedClearForBlobstore(spaceEngine, template, serverTypeDesc);
        } else if (template.isTakeOperation()) {
            res = BlobStoreOperationOptimizations.isConsiderOptimizedTakeForBlobstore(spaceEngine, context, serverTypeDesc);
        }
        context.setOptimizedBlobStoreReadEnabled(res);
        if (logger.isLoggable(Level.FINE)) {
            if (res) {
                logger.fine("BlobStore - enabled optimization for query: " + template.toSQLQuery(serverTypeDesc.getTypeDesc()).toString());
            } else {
                logger.fine("BlobStore - disabled optimization for query: " + template.toSQLQuery(serverTypeDesc.getTypeDesc()).toString());
            }
        }
        return res;
    }

    private static boolean isConsiderOptimizedTakeForBlobstore(SpaceEngine spaceEngine, Context context, IServerTypeDesc serverTypeDesc) {
        boolean onBackup;
        boolean bl = onBackup = context.isFromReplication() && spaceEngine.getSpaceImpl().isBackup();
        if (onBackup) {
            LocalViewRegistrations registrations = spaceEngine.getLocalViewRegistrations();
            return spaceEngine.getCacheManager().getTemplatesManager().isBlobStoreClearTakeOptimizationAllowedNotify(serverTypeDesc, onBackup) && registrations != null && registrations.isBlobStoreClearOptimizationAllowed(serverTypeDesc);
        }
        return false;
    }

    private static boolean isConsiderOptimizedClearForBlobstore(SpaceEngine spaceEngine, ITemplateHolder template, IServerTypeDesc serverTypeDesc) {
        if (!spaceEngine.getCacheManager().optimizedBlobStoreClear()) {
            return false;
        }
        return template.isOptimizedForBlobStoreOp(spaceEngine.getCacheManager()) && (spaceEngine.getLocalViewRegistrations() == null || spaceEngine.getLocalViewRegistrations().isBlobStoreClearOptimizationAllowed(serverTypeDesc)) && spaceEngine.getCacheManager().getTemplatesManager().isBlobStoreClearTakeOptimizationAllowedNotify(serverTypeDesc, false);
    }

    private static boolean isConsiderOptimizedReadForBlobstore(SpaceEngine spaceEngine, ITemplateHolder template, IServerTypeDesc serverTypeDesc, String entryUid) {
        AbstractProjectionTemplate projectionTemplate = template.getProjectionTemplate();
        if (!template.isOptimizedForBlobStoreOp(spaceEngine.getCacheManager())) {
            return false;
        }
        if (template.isReturnOnlyUid()) {
            return true;
        }
        if (projectionTemplate == null) {
            return false;
        }
        if (projectionTemplate.isMultiUidsProjection()) {
            return projectionTemplate.isAllIndexesProjections(serverTypeDesc, template, entryUid);
        }
        return projectionTemplate.isAllIndexesProjections(serverTypeDesc, template);
    }
}

