/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.recovery;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DefaultStorageConsistency;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.IStorageConsistency;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.StorageConsistencyModes;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.j_spaces.core.cache.blobStore.recovery.BlobStoreRecoveryHelper;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreRecoveryHelperWrapper
implements IStorageConsistency {
    private final Logger _logger;
    private final BlobStoreRecoveryHelper _original;
    private final IStorageConsistency _default;
    private final String _spaceName;

    public BlobStoreRecoveryHelperWrapper(Logger logger, String spaceName, BlobStoreStorageHandler driver, int numberOfPartitions, int numberOfBackups) {
        Properties p = driver.getProperties();
        this._original = p != null ? (BlobStoreRecoveryHelper)p.get(BlobStoreRecoveryHelper.BLOB_STORE_RECOVERY_HELPER_PROPERTY_NAME) : null;
        this._spaceName = spaceName;
        this._logger = logger;
        if (this._original != null) {
            this._original.initialize(this._spaceName, numberOfPartitions, numberOfBackups);
        }
        this._default = new DefaultStorageConsistency();
    }

    @Override
    public StorageConsistencyModes getStorageState() {
        if (!this.isPerInstancePersistency()) {
            return this._default.getStorageState();
        }
        StorageConsistencyModes res = this._original.getStorageState();
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.info("blob-store getStorageState result=" + (Object)((Object)res) + " space=" + this._spaceName);
        }
        return res;
    }

    @Override
    public void setStorageState(StorageConsistencyModes s) {
        if (!this.isPerInstancePersistency()) {
            this._default.setStorageState(s);
            return;
        }
        this._original.setStorageState(s);
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.info("blob-store setStorageState to " + (Object)((Object)s) + " space=" + this._spaceName);
        }
    }

    @Override
    public boolean isPerInstancePersistency() {
        return this._original == null ? false : this._original.isPerInstancePersistency();
    }
}

