/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.sadapter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import java.io.IOException;

@InternalApi
public class BlobStoreInitialLoadDataIterator
implements ISAdapterIterator<IEntryHolder> {
    private final SpaceEngine _engine;
    private final DataIterator<BlobStoreGetBulkOperationResult> _iter;

    public BlobStoreInitialLoadDataIterator(SpaceEngine engine) {
        this._engine = engine;
        this._iter = this._engine.getCacheManager().getBlobStoreStorageHandler().initialLoadIterator();
    }

    @Override
    public IEntryHolder next() throws SAException {
        if (this._iter == null) {
            return null;
        }
        BlobStoreBulkOperationResult res = null;
        if (this._iter.hasNext()) {
            res = (BlobStoreGetBulkOperationResult)this._iter.next();
        }
        if (res == null) {
            return null;
        }
        BlobStoreEntryLayout entryLayout = (BlobStoreEntryLayout)res.getData();
        BlobStoreEntryHolder eh = entryLayout.buildBlobStoreEntryHolder(this._engine.getCacheManager());
        EntryCacheInfoFactory.createBlobStoreEntryCacheInfo(eh);
        IBlobStoreEntryHolder oeh = eh;
        oeh.getBlobStoreResidentPart().setBlobStorePosition(res.getPosition());
        if (this._engine.getCacheManager().hasBlobStoreOffHeapCache()) {
            try {
                this._engine.getCacheManager().getBlobStoreStorageHandler().getOffHeapCache().write(oeh.getBlobStoreResidentPart(), entryLayout.getIndexValuesBytes(this._engine.getCacheManager()));
            }
            catch (IOException e) {
                CacheManager.getLogger().severe("Blobstore- BLRECI:BlobStoreInitialLoadDataIterator.next got execption" + e.toString() + e.getStackTrace());
                throw new RuntimeException("Blobstore- BLRECI:BlobStoreInitialLoadDataIterator.next got execption" + e.toString() + e.getStackTrace());
            }
        }
        return eh;
    }

    @Override
    public void close() throws SAException {
        if (this._iter != null) {
            this._iter.close();
        }
    }
}

