/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.sadapter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.TypeDescriptorUtils;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapterClassInfo;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreTypeDescSerializable;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@InternalApi
public class BlobStoreMetaDataIterator
implements ISAdapterIterator<ITypeDesc> {
    private final SpaceEngine _engine;
    private final Iterator<ITypeDesc> _iter;
    private final Map<String, BlobStoreStorageAdapterClassInfo> _classesInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStoreMetaDataIterator(SpaceEngine engine) throws SAException {
        this._engine = engine;
        this._classesInfo = new HashMap<String, BlobStoreStorageAdapterClassInfo>();
        DataIterator<BlobStoreGetBulkOperationResult> iter = this._engine.getCacheManager().getBlobStoreStorageHandler().iterator(BlobStoreObjectType.METADATA);
        if (iter == null) {
            this._iter = null;
            return;
        }
        HashMap<String, ITypeDesc> typeDescriptors = new HashMap<String, ITypeDesc>();
        try {
            ITypeDesc typeDesc;
            while ((typeDesc = this.nextFromBlobStore(iter)) != null) {
                typeDescriptors.put(typeDesc.getTypeName(), typeDesc);
            }
        }
        finally {
            iter.close();
        }
        if (typeDescriptors.isEmpty()) {
            this._iter = null;
            return;
        }
        List<ITypeDesc> result = TypeDescriptorUtils.sort(typeDescriptors);
        this._iter = result.iterator();
    }

    @Override
    public ITypeDesc next() throws SAException {
        if (this._iter == null) {
            return null;
        }
        if (this._iter.hasNext()) {
            return this._iter.next();
        }
        return null;
    }

    private ITypeDesc nextFromBlobStore(DataIterator<BlobStoreGetBulkOperationResult> iter) throws SAException {
        BlobStoreGetBulkOperationResult res = null;
        if (iter.hasNext()) {
            res = (BlobStoreGetBulkOperationResult)iter.next();
        }
        if (res == null) {
            return null;
        }
        BlobStoreTypeDescSerializable stored = (BlobStoreTypeDescSerializable)res.getData();
        if (stored != null) {
            this._classesInfo.put(stored.getTypeDesc().getTypeName(), stored.getBlobStoreStorageAdapterClassInfo());
        }
        return stored != null ? stored.getTypeDesc() : null;
    }

    public Map<String, BlobStoreStorageAdapterClassInfo> getClassesInfo() {
        return this._classesInfo;
    }

    @Override
    public void close() throws SAException {
    }
}

