/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.sadapter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.EntryCacheInfoFactory;
import com.j_spaces.core.cache.InitialLoadInfo;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

@InternalApi
public class BlobStoreSegmentInitialLoader
extends Thread {
    private final DataIterator<BlobStoreGetBulkOperationResult> _segmentIter;
    private final CacheManager _cacheManager;
    private final int _segmentNumber;
    private final CountDownLatch _sync;
    private final InitialLoadInfo _initialLoadInfo;

    public BlobStoreSegmentInitialLoader(CacheManager cacheManager, DataIterator<BlobStoreGetBulkOperationResult> segmentIter, CountDownLatch sync, int segmentNumber, InitialLoadInfo initialLoadInfo) {
        this._segmentIter = segmentIter;
        this._cacheManager = cacheManager;
        this._sync = sync;
        this._initialLoadInfo = initialLoadInfo;
        this._segmentNumber = segmentNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Context context = this._cacheManager.getCacheContext();
        try {
            while (true) {
                Object o = null;
                if (this._segmentIter.hasNext()) {
                    o = this._segmentIter.next();
                }
                if (o == null) {
                    this._segmentIter.close();
                    return;
                }
                this._initialLoadInfo.incrementFoundInDatabase();
                BlobStoreGetBulkOperationResult res = o;
                BlobStoreEntryHolder eh = ((BlobStoreEntryLayout)res.getData()).buildBlobStoreEntryHolder(this._cacheManager);
                EntryCacheInfoFactory.createBlobStoreEntryCacheInfo(eh);
                IBlobStoreEntryHolder oeh = eh;
                oeh.getBlobStoreResidentPart().setBlobStorePosition(res.getPosition());
                if (eh.getServerTypeDesc().isFifoSupported() || eh.getServerTypeDesc().getTypeDesc().getFifoGroupingPropertyPath() != null) {
                    if (this._initialLoadInfo.getCurTypeData() == null || this._initialLoadInfo.getCurDesc() != eh.getServerTypeDesc()) {
                        this._initialLoadInfo.setCurTypeData(this._cacheManager.getTypeData(eh.getServerTypeDesc()));
                        this._initialLoadInfo.setCurDesc(eh.getServerTypeDesc());
                    }
                    this._initialLoadInfo.getBlobStoreFifoInitialLoader().add(eh, this._initialLoadInfo.getCurTypeData());
                    continue;
                }
                this._cacheManager.safeInsertEntryToCache(context, eh, false, null, false, CacheManager.InitialLoadOrigin.FROM_BLOBSTORE);
                ((IBlobStoreEntryHolder)eh).getBlobStoreResidentPart().unLoadFullEntryIfPossible(this._cacheManager, context);
                this._initialLoadInfo.incrementInsertedToCache();
                this._initialLoadInfo.setLastLoggedTime(this.logInsertionIfNeeded(this._initialLoadInfo.getRecoveryStartTime(), this._initialLoadInfo.getLastLoggedTime(), this._initialLoadInfo.getInsertedToCache()));
                continue;
                break;
            }
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException(ex);
            this._segmentIter.close();
            throw rte;
        }
        finally {
            if (context != null) {
                this._cacheManager.freeCacheContext(context);
            }
            this._sync.countDown();
        }
    }

    private long logInsertionIfNeeded(long startLogTime, long lastLogTime, int fetchedEntries) {
        long curTime;
        if (this._initialLoadInfo.isLogRecoveryProcess() && this._initialLoadInfo.getLogger().isLoggable(Level.INFO) && (curTime = SystemTime.timeMillis()) - lastLogTime > this._initialLoadInfo.getRecoveryLogInterval()) {
            this._initialLoadInfo.getLogger().info("BlobStore segment #" + this._segmentNumber + " entries loaded so far : " + fetchedEntries + " [" + JSpaceUtilities.formatMillis(curTime - startLogTime) + "]");
            return curTime;
        }
        return lastLogTime;
    }
}

