/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.sadapter;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.TypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationRequest;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.IBlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreInitialLoadDataIterator;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreMetaDataIterator;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapterClassInfo;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreStorageAdapterClasses;
import com.j_spaces.core.cache.blobStore.sadapter.BlobStoreTypeDescSerializable;
import com.j_spaces.core.cache.blobStore.sadapter.IBlobStoreStorageAdapter;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationInsertInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationRemoveInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationUpdateInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.IStorageAdapter;
import com.j_spaces.core.sadapter.SAException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.server.ServerTransaction;

@InternalApi
public class BlobStoreStorageAdapter
implements IStorageAdapter,
IBlobStoreStorageAdapter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.persistent");
    private final SpaceEngine _engine;
    private final SpaceTypeManager _typeManager;
    private final IStorageAdapter _possibleRecoverySA;
    private final boolean _persistentBlobStore;
    private boolean _localBlobStoreRecoveryPerformed;
    private final BlobStoreStorageAdapterClasses _classes;
    private final Object _classesLock;

    public BlobStoreStorageAdapter(SpaceEngine engine, boolean persistentBlobStore) {
        this(engine, persistentBlobStore, null);
    }

    public BlobStoreStorageAdapter(SpaceEngine engine, boolean persistentBlobStore, IStorageAdapter recoverySA) {
        this._engine = engine;
        this._typeManager = engine.getTypeManager();
        this._persistentBlobStore = persistentBlobStore;
        this._possibleRecoverySA = recoverySA;
        this._classes = new BlobStoreStorageAdapterClasses();
        this._classesLock = new Object();
    }

    @Override
    public void initialize() throws SAException {
        if (this._possibleRecoverySA != null) {
            this._possibleRecoverySA.initialize();
        }
    }

    @Override
    public ISAdapterIterator initialLoad(Context context, ITemplateHolder template) throws SAException {
        if (this._localBlobStoreRecoveryPerformed || !this._persistentBlobStore) {
            return this._possibleRecoverySA != null ? this._possibleRecoverySA.initialLoad(context, template) : null;
        }
        this._localBlobStoreRecoveryPerformed = true;
        BlobStoreMetaDataIterator metadataIterator = new BlobStoreMetaDataIterator(this._engine);
        Map<String, BlobStoreStorageAdapterClassInfo> classesInfo = metadataIterator.getClassesInfo();
        try {
            ITypeDesc typeDescriptor;
            while ((typeDescriptor = metadataIterator.next()) != null) {
                String[] superClassesNames = typeDescriptor.getRestrictSuperClassesNames();
                if (superClassesNames != null) {
                    for (String superClassName : superClassesNames) {
                        if (this._typeManager.getServerTypeDesc(superClassName) != null) continue;
                        throw new IllegalArgumentException("Missing super class type descriptor [" + superClassName + "] for type [" + typeDescriptor.getTypeName() + "]");
                    }
                }
                this._classes.put(typeDescriptor.getTypeName(), classesInfo.get(typeDescriptor.getTypeName()));
                this._typeManager.addTypeDesc(typeDescriptor);
            }
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.throwing(this.getClass().getName(), "Initial Metadata Load", e);
            }
            throw new SAException(e);
        }
        finally {
            metadataIterator.close();
        }
        for (String className : classesInfo.keySet()) {
            TypeData typeData = this._engine.getCacheManager().getTypeData(this._engine.getTypeManager().getServerTypeDesc(className));
            if (typeData == null) continue;
            BlobStoreStorageAdapterClassInfo cur = this._classes.get(className);
            if (this._classes.isContained(className, typeData)) continue;
            this.introduceDataType_impl(this._engine.getTypeManager().getTypeDesc(className));
        }
        return new BlobStoreInitialLoadDataIterator(this._engine);
    }

    @Override
    public boolean hasAnotherInitialLoadSource() {
        return this._possibleRecoverySA != null;
    }

    @Override
    public boolean shouldRevertOpOnBlobStoreError() {
        return this._engine.getSpaceImpl().isBackup();
    }

    @Override
    public void insertEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean shouldReplicate) throws SAException {
        if (!entryHolder.isBlobStoreEntry()) {
            return;
        }
        context.setDelayedReplicationForbulkOpUsed(false);
        boolean needDirectPersistencySync = this.handleDirectPersistencyConsistency(context, entryHolder, shouldReplicate, false);
        ((IBlobStoreEntryHolder)((Object)entryHolder)).setDirty(this._engine.getCacheManager());
        if (!context.isActiveBlobStoreBulk()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("[" + this._engine.getFullSpaceName() + "] inserting entry with uid=" + entryHolder.getUID() + " using BlobStoreStorageAdapter");
            }
            ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().flush(this._engine.getCacheManager(), context);
            if (needDirectPersistencySync) {
                this.reportOpPersisted(context);
            }
        } else {
            ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().bulkRegister(context, context.getBlobStoreBulkInfo(), 1, needDirectPersistencySync);
            if (this.useEmbeddedSyncOnPrimary(needDirectPersistencySync)) {
                context.setDelayedReplicationForbulkOpUsed(true);
                DelayedReplicationInsertInfo dr = new DelayedReplicationInsertInfo(context.getBlobStoreEntry());
                context.getBlobStoreBulkInfo().addDelayedReplicationInfo(context, ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), dr);
            }
            context.getBlobStoreBulkInfo().bulk_flush(context, true);
        }
    }

    @Override
    public void updateEntry(Context context, IEntryHolder updatedEntry, boolean shouldReplicate, boolean origin, boolean[] partialUpdateValuesIndicators) throws SAException {
        if (!updatedEntry.isBlobStoreEntry()) {
            return;
        }
        context.setDelayedReplicationForbulkOpUsed(false);
        boolean needDirectPersistencySync = this.handleDirectPersistencyConsistency(context, updatedEntry, shouldReplicate, false);
        ((IBlobStoreEntryHolder)((Object)updatedEntry)).setDirty(this._engine.getCacheManager());
        if (!context.isActiveBlobStoreBulk()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("[" + this._engine.getFullSpaceName() + "] updating entry with uid=" + updatedEntry.getUID() + " using BlobStoreStorageAdapter");
            }
            ((IBlobStoreEntryHolder)((Object)updatedEntry)).getBlobStoreResidentPart().flush(this._engine.getCacheManager(), context);
            if (needDirectPersistencySync) {
                this.reportOpPersisted(context);
            }
        } else {
            ((IBlobStoreEntryHolder)((Object)updatedEntry)).getBlobStoreResidentPart().bulkRegister(context, context.getBlobStoreBulkInfo(), 7, needDirectPersistencySync);
            if (this.useEmbeddedSyncOnPrimary(needDirectPersistencySync)) {
                context.setDelayedReplicationForbulkOpUsed(true);
                DelayedReplicationUpdateInfo dr = new DelayedReplicationUpdateInfo(context.getBlobStoreEntry(), context.getOriginalData(), context.getMutators());
                context.getBlobStoreBulkInfo().addDelayedReplicationInfo(context, ((IBlobStoreEntryHolder)((Object)updatedEntry)).getBlobStoreResidentPart(), dr);
            }
            context.getBlobStoreBulkInfo().bulk_flush(context, true);
        }
    }

    @Override
    public void removeEntry(Context context, IEntryHolder entryHolder, boolean origin, boolean fromLeaseExpiration, boolean shouldReplicate) throws SAException {
        if (!entryHolder.isBlobStoreEntry()) {
            return;
        }
        context.setDelayedReplicationForbulkOpUsed(false);
        boolean needDirectPersistencySync = this.handleDirectPersistencyConsistency(context, entryHolder, shouldReplicate, true);
        ((IBlobStoreEntryHolder)((Object)entryHolder)).setDirty(this._engine.getCacheManager());
        if (!context.isActiveBlobStoreBulk() || !context.getBlobStoreBulkInfo().isTakeMultipleBulk()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("[" + this._engine.getFullSpaceName() + "] removing entry with uid=" + entryHolder.getUID() + " using BlobStoreStorageAdapter");
            }
            ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().flush(this._engine.getCacheManager(), context);
            if (needDirectPersistencySync) {
                this.reportOpPersisted(context);
            }
        } else {
            ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().bulkRegister(context, context.getBlobStoreBulkInfo(), 4, needDirectPersistencySync);
            if (this.useEmbeddedSyncOnPrimary(needDirectPersistencySync)) {
                context.setDelayedReplicationForbulkOpUsed(true);
                DelayedReplicationRemoveInfo dr = new DelayedReplicationRemoveInfo(context.getBlobStoreEntry(), context.getRemoveReason());
                context.getBlobStoreBulkInfo().addDelayedReplicationInfo(context, ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart(), dr);
            }
            context.getBlobStoreBulkInfo().bulk_flush(context, true);
        }
    }

    @Override
    public void prepare(Context context, ServerTransaction xtn, ArrayList<IEntryHolder> pLocked, boolean singleParticipant, Map<String, Object> partialUpdatesAndInPlaceUpdatesInfo, boolean shouldReplicate) throws SAException {
        HashMap<String, IEntryHolder> ohEntries = new HashMap<String, IEntryHolder>();
        ArrayList<String> uids = shouldReplicate && this._engine.getReplicationNode().getDirectPesistencySyncHandler() != null ? new ArrayList<String>(pLocked.size()) : null;
        HashSet<String> takes = null;
        boolean checkedOnTake = false;
        for (IEntryHolder inputeh : pLocked) {
            IEntryHolder entryHolder = inputeh.getOriginalEntryHolder();
            if (!entryHolder.isBlobStoreEntry() || entryHolder == null || entryHolder.isDeleted() || entryHolder.getWriteLockTransaction() == null || !entryHolder.getWriteLockTransaction().equals((Object)xtn) || (entryHolder.getWriteLockOperation() == 4 || entryHolder.getWriteLockOperation() == 5) && !((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().isInBlobStoreStorage()) continue;
            ((IBlobStoreEntryHolder)((Object)entryHolder)).setDirty(this._engine.getCacheManager());
            ohEntries.put(entryHolder.getUID(), entryHolder);
            if (entryHolder.getWriteLockOperation() == 4 || entryHolder.getWriteLockOperation() == 5) {
                if (!checkedOnTake) {
                    if (this.useEmbeddedSyncOnPrimary(this.useDirectPersistencySync(shouldReplicate))) {
                        takes = new HashSet<String>();
                    }
                    checkedOnTake = true;
                }
                if (takes != null) {
                    takes.add(entryHolder.getUID());
                }
            }
            if (uids == null) continue;
            uids.add(entryHolder.getUID());
        }
        if (ohEntries.isEmpty()) {
            return;
        }
        boolean needDirectPersistencySync = false;
        if (uids != null) {
            needDirectPersistencySync = this.handleDirectPersistencyConsistency(context, uids, shouldReplicate, takes, ohEntries);
        }
        try {
            LinkedList<BlobStoreBulkOperationRequest> operations = new LinkedList<BlobStoreBulkOperationRequest>();
            block12: for (IEntryHolder inputeh : pLocked) {
                if (!ohEntries.containsKey(inputeh.getUID())) continue;
                IEntryHolder entryHolder = inputeh.getOriginalEntryHolder();
                BlobStoreRefEntryCacheInfo entryCacheInfo = ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart();
                switch (entryHolder.getWriteLockOperation()) {
                    case 1: {
                        operations.add(new BlobStoreAddBulkOperationRequest(entryCacheInfo.getStorageKey(), entryCacheInfo.getEntryLayout(this._engine.getCacheManager()), entryCacheInfo));
                        continue block12;
                    }
                    case 7: {
                        operations.add(new BlobStoreReplaceBulkOperationRequest(entryCacheInfo.getStorageKey(), entryCacheInfo.getEntryLayout(this._engine.getCacheManager()), entryCacheInfo.getBlobStoreStoragePos(), entryCacheInfo));
                        continue block12;
                    }
                    case 4: 
                    case 5: {
                        boolean phantom = ((IBlobStoreEntryHolder)((Object)entryHolder)).isPhantom();
                        if (!phantom) {
                            operations.add(new BlobStoreRemoveBulkOperationRequest(entryCacheInfo.getStorageKey(), entryCacheInfo.getBlobStoreStoragePos(), entryCacheInfo));
                            continue block12;
                        }
                        operations.add(new BlobStoreReplaceBulkOperationRequest(entryCacheInfo.getStorageKey(), entryCacheInfo.getEntryLayout(this._engine.getCacheManager()), entryCacheInfo.getBlobStoreStoragePos(), entryCacheInfo));
                        continue block12;
                    }
                }
                throw new UnsupportedOperationException("uid=" + entryHolder.getUID() + " operation=" + entryHolder.getWriteLockOperation());
            }
            List<BlobStoreBulkOperationResult> results = this._engine.getCacheManager().getBlobStoreStorageHandler().executeBulk(operations, BlobStoreObjectType.DATA, true);
            for (BlobStoreBulkOperationResult res : results) {
                if (res.getException() == null) continue;
                throw res.getException();
            }
            for (BlobStoreBulkOperationResult res : results) {
                IEntryHolder entryHolder = ohEntries.get(res.getId());
                switch (entryHolder.getWriteLockOperation()) {
                    case 1: 
                    case 7: {
                        ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().flushedFromBulk(context, this._engine.getCacheManager(), res.getPosition(), false, true);
                        break;
                    }
                    case 4: 
                    case 5: {
                        ((IBlobStoreEntryHolder)((Object)entryHolder)).getBlobStoreResidentPart().flushedFromBulk(context, this._engine.getCacheManager(), null, true, true);
                    }
                }
            }
        }
        catch (Throwable t) {
            _logger.severe(this.getClass().getName() + " Prepare " + t);
            throw new SAException(t);
        }
        if (needDirectPersistencySync) {
            this.reportOpPersisted(context);
        }
    }

    @Override
    public void rollback(ServerTransaction xtn, boolean anyUpdates) throws SAException {
    }

    @Override
    public IEntryHolder getEntry(Context context, Object uid, String classname, IEntryHolder template) throws SAException {
        IEntryHolder eh = context.getBlobStoreOpEntryHolder();
        if (eh == null && context.getBlobStoreOpEntryCacheInfo() == null) {
            throw new UnsupportedOperationException();
        }
        if (eh != null && !eh.isBlobStoreEntry() || context.getBlobStoreOpEntryCacheInfo() != null && !context.getBlobStoreOpEntryCacheInfo().isBlobStoreEntry()) {
            throw new UnsupportedOperationException();
        }
        if (eh == null) {
            eh = context.getBlobStoreOpEntryCacheInfo().getEntryHolder(this._engine.getCacheManager());
        }
        if (context.getBlobStoreOpPin() && eh.isDeleted()) {
            return null;
        }
        if (context.getOptimizedBlobStoreReadEnabled() == null) {
            return ((IBlobStoreEntryHolder)((Object)eh)).getLatestEntryVersion(this._engine.getCacheManager(), context.getBlobStoreOpPin(), context);
        }
        return ((IBlobStoreEntryHolder)((Object)eh)).getBlobStoreResidentPart().getLatestEntryVersion(this._engine.getCacheManager(), context.getBlobStoreOpPin(), (IBlobStoreEntryHolder)((Object)eh), context, context.getOptimizedBlobStoreReadEnabled());
    }

    @Override
    public Map<String, IEntryHolder> getEntries(Context context, Object[] ids, String typeName, IEntryHolder[] templates) throws SAException {
        return null;
    }

    @Override
    public ISAdapterIterator<IEntryHolder> makeEntriesIter(ITemplateHolder template, long SCNFilter, long leaseFilter, IServerTypeDesc[] subClasses) throws SAException {
        return null;
    }

    @Override
    public void commit(ServerTransaction xtn, boolean anyUpdates) throws SAException {
    }

    @Override
    public int count(ITemplateHolder template, String[] subClasses) throws SAException {
        return 0;
    }

    @Override
    public void shutDown() throws SAException {
        this._engine.getCacheManager().getBlobStoreStorageHandler().close();
        if (this._possibleRecoverySA != null) {
            this._possibleRecoverySA.shutDown();
        }
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean supportsExternalDB() {
        return false;
    }

    @Override
    public boolean supportsPartialUpdate() {
        return false;
    }

    @Override
    public boolean supportsGetEntries() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void introduceDataType(ITypeDesc typeDesc) {
        String typeName = typeDesc.getTypeName();
        if (typeName.equals(Object.class.getName())) {
            return;
        }
        if (!typeDesc.isBlobstoreEnabled()) {
            return;
        }
        Object object = this._classesLock;
        synchronized (object) {
            this.introduceDataType_impl(typeDesc);
        }
    }

    private void introduceDataType_impl(ITypeDesc typeDesc) {
        String typeName = typeDesc.getTypeName();
        TypeData typeData = this._engine.getCacheManager().getTypeData(this._engine.getTypeManager().getServerTypeDesc(typeName));
        BlobStoreStorageAdapterClassInfo cur = this._classes.get(typeName);
        boolean renew = cur == null || !this._classes.isContained(typeName, typeData);
        BlobStoreStorageAdapterClassInfo updated = null;
        if (renew) {
            updated = typeData == null ? new BlobStoreStorageAdapterClassInfo(new boolean[typeDesc.getNumOfFixedProperties()], null, 0) : new BlobStoreStorageAdapterClassInfo(typeData.getIndexesRelatedFixedProperties(), typeData.getIndexesRelatedDynamicProperties(), cur == null ? (short)0 : (short)(cur.getStoredVersion() + 1));
        }
        BlobStoreTypeDescSerializable stored = new BlobStoreTypeDescSerializable((TypeDesc)typeDesc, renew ? updated : cur);
        if (this._engine.getCacheManager().getBlobStoreStorageHandler().get((Serializable)((Object)typeName), null, BlobStoreObjectType.METADATA, null) != null) {
            this._engine.getCacheManager().getBlobStoreStorageHandler().replace((Serializable)((Object)typeName), stored, null, BlobStoreObjectType.METADATA, null);
        } else {
            this._engine.getCacheManager().getBlobStoreStorageHandler().add((Serializable)((Object)typeName), stored, BlobStoreObjectType.METADATA, null);
        }
        if (renew) {
            this._classes.put(typeName, updated);
        }
    }

    @Override
    public BlobStoreStorageAdapterClassInfo getBlobStoreStorageAdapterClassInfo(String typeName) {
        return this._classes.get(typeName);
    }

    @Override
    public SpaceSynchronizationEndpoint getSynchronizationInterceptor() {
        return null;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndexes(String typeName, SpaceIndex[] indexes) {
        if (typeName.equals(Object.class.getName())) {
            return;
        }
        ITypeDesc typeDesc = this.getType(typeName);
        if (!typeDesc.isBlobstoreEnabled()) {
            return;
        }
        Object object = this._classesLock;
        synchronized (object) {
            this.introduceDataType_impl(typeDesc);
        }
    }

    private ITypeDesc getType(String typeName) {
        IServerTypeDesc serverTypeDesc = this._typeManager.getServerTypeDesc(typeName);
        return serverTypeDesc != null ? serverTypeDesc.getTypeDesc() : null;
    }

    private boolean handleDirectPersistencyConsistency(Context context, IEntryHolder entryHolder, boolean shouldReplicate, boolean removeEntry) {
        if (!this.useDirectPersistencySync(shouldReplicate)) {
            return false;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("[" + this._engine.getFullSpaceName() + "] handling adding entry with uid=" + entryHolder.getUID() + " to sync using BlobStoreStorageAdapter");
        }
        this._engine.getReplicationNode().getDirectPesistencySyncHandler().beforeDirectPersistencyOp(this._engine.getCacheManager().getReplicationContext(context), entryHolder, removeEntry);
        return true;
    }

    private boolean handleDirectPersistencyConsistency(Context context, List<String> uids, boolean shouldReplicate, Set<String> removedUids, Map<String, IEntryHolder> entryHolderMap) {
        if (!this.useDirectPersistencySync(shouldReplicate)) {
            return false;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.finer("[" + this._engine.getFullSpaceName() + "] handling adding entries with uids=" + uids + " to sync using BlobStoreStorageAdapter");
        }
        this._engine.getReplicationNode().getDirectPesistencySyncHandler().beforeDirectPersistencyOp(this._engine.getCacheManager().getReplicationContext(context), uids, removedUids, entryHolderMap);
        return true;
    }

    private boolean useDirectPersistencySync(boolean shouldReplicate) {
        return shouldReplicate && this._engine.getReplicationNode().getDirectPesistencySyncHandler() != null && this._engine.getSpaceImpl().isPrimary();
    }

    private boolean useEmbeddedSyncOnPrimary(boolean directPersistencySyncUsed) {
        return directPersistencySyncUsed && this._engine.getReplicationNode().getDirectPesistencySyncHandler().isEmbeddedListUsed();
    }

    private void reportOpPersisted(Context context) {
        this._engine.getReplicationNode().getDirectPesistencySyncHandler().afterOperationPersisted(context.getReplicationContext().getDirectPersistencyPendingEntry());
    }
}

