/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreConfig;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class BlobStoreHashMock
extends BlobStoreStorageHandler {
    private ConcurrentHashMap<Serializable, Serializable> _data;
    private ConcurrentHashMap<Serializable, Serializable> _metadata;
    private ConcurrentHashMap<Serializable, Serializable> _sync;
    private ConcurrentHashMap<Serializable, Serializable> _syncovf;
    private ConcurrentHashMap<Serializable, Serializable> _admin;

    private Serializable marsh(Serializable data) {
        return data;
    }

    private Serializable unmarsh(Serializable data) {
        return data;
    }

    @Override
    public void initialize(BlobStoreConfig blobStoreConfig) {
        if (this._data == null) {
            this._data = new ConcurrentHashMap(16, 0.75f, 128);
            this._metadata = new ConcurrentHashMap();
            this._syncovf = new ConcurrentHashMap(16, 0.75f, 128);
            this._sync = new ConcurrentHashMap(16, 0.75f, 128);
            this._admin = new ConcurrentHashMap(16, 0.75f, 128);
            System.out.println("performed init on BlobStoreHashMock___");
        } else {
            System.out.println("performed WARM init on BlobStoreHashMock___");
        }
    }

    @Override
    public Object add(Serializable id, Serializable data, BlobStoreObjectType objectType) {
        if (objectType == BlobStoreObjectType.SYNC) {
            return this.add_impl(id, data, this._sync);
        }
        if (objectType == BlobStoreObjectType.SYNC_OVERFLOW) {
            return this.add_impl(id, data, this._syncovf);
        }
        if (objectType == BlobStoreObjectType.ADMIN) {
            return this.add_impl(id, data, this._admin);
        }
        return objectType == BlobStoreObjectType.DATA ? this.add_impl(id, data, this._data) : this.add_impl(id, data, this._metadata);
    }

    private Object add_impl(Serializable id, Serializable data, ConcurrentHashMap<Serializable, Serializable> store) {
        if (store.putIfAbsent(id, data = this.marsh(data)) != null) {
            throw new RuntimeException("key already exist " + id);
        }
        return -1;
    }

    @Override
    public Serializable get(Serializable id, Object position, BlobStoreObjectType objectType) {
        if (objectType == BlobStoreObjectType.SYNC) {
            return this.get_impl(id, position, this._sync);
        }
        if (objectType == BlobStoreObjectType.SYNC_OVERFLOW) {
            return this.get_impl(id, position, this._syncovf);
        }
        if (objectType == BlobStoreObjectType.ADMIN) {
            return this.get_impl(id, position, this._admin);
        }
        return objectType == BlobStoreObjectType.DATA ? this.get_impl(id, position, this._data) : this.get_impl(id, position, this._metadata);
    }

    private Serializable get_impl(Serializable id, Object position, ConcurrentHashMap<Serializable, Serializable> store) {
        Serializable o = store.get(id);
        return o != null ? this.unmarsh(o) : null;
    }

    @Override
    public Object replace(Serializable id, Serializable data, Object position, BlobStoreObjectType objectType) {
        if (objectType == BlobStoreObjectType.SYNC) {
            return this.replace_impl(id, data, position, this._sync);
        }
        if (objectType == BlobStoreObjectType.SYNC_OVERFLOW) {
            return this.replace_impl(id, data, null, this._syncovf);
        }
        if (objectType == BlobStoreObjectType.ADMIN) {
            return this.replace_impl(id, data, null, this._admin);
        }
        return objectType == BlobStoreObjectType.DATA ? this.replace_impl(id, data, position, this._data) : this.replace_impl(id, data, position, this._metadata);
    }

    private Object replace_impl(Serializable id, Serializable data, Object position, ConcurrentHashMap<Serializable, Serializable> store) {
        if (store.replace(id, data = this.marsh(data)) == null) {
            throw new RuntimeException("no key exist " + id);
        }
        return -1;
    }

    @Override
    public Serializable remove(Serializable id, Object position, BlobStoreObjectType objectType) {
        if (objectType == BlobStoreObjectType.SYNC) {
            return this.remove_impl(id, null, this._sync);
        }
        if (objectType == BlobStoreObjectType.SYNC_OVERFLOW) {
            return this.remove_impl(id, null, this._syncovf);
        }
        if (objectType == BlobStoreObjectType.DATA) {
            return this.remove_impl(id, position, this._data);
        }
        if (objectType == BlobStoreObjectType.ADMIN) {
            return this.remove_impl(id, position, this._admin);
        }
        return this.remove_impl(id, position, this._metadata);
    }

    private Serializable remove_impl(Serializable id, Object position, ConcurrentHashMap<Serializable, Serializable> store) {
        Serializable o = store.remove(id);
        if (o == null) {
            throw new RuntimeException("remove: didn't find object with id=" + id);
        }
        return this.unmarsh(o);
    }

    @Override
    public void close() {
    }

    @Override
    public DataIterator<BlobStoreGetBulkOperationResult> iterator(BlobStoreObjectType objectType) {
        if (objectType == BlobStoreObjectType.SYNC) {
            return new MockIter(this._sync);
        }
        if (objectType == BlobStoreObjectType.SYNC_OVERFLOW) {
            return new MockIter(this._syncovf);
        }
        if (objectType == BlobStoreObjectType.ADMIN) {
            return new MockIter(this._admin);
        }
        return objectType == BlobStoreObjectType.DATA ? new MockIter(this._data) : new MockIter(this._metadata);
    }

    public class MockIter
    implements DataIterator<BlobStoreGetBulkOperationResult> {
        private final ConcurrentHashMap<Serializable, Serializable> _map;
        private final Iterator<Map.Entry<Serializable, Serializable>> _iter;

        MockIter(ConcurrentHashMap<Serializable, Serializable> map) {
            this._map = map;
            this._iter = this._map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iter.hasNext();
        }

        @Override
        public void remove() {
        }

        @Override
        public BlobStoreGetBulkOperationResult next() {
            Map.Entry<Serializable, Serializable> e = this._iter.next();
            return new BlobStoreGetBulkOperationResult(e.getKey(), BlobStoreHashMock.this.unmarsh(e.getValue()), null, null);
        }

        @Override
        public void close() {
        }
    }
}

