/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.j_spaces.core.cache.blobStore.storage.BlobStoreSegmentedParallelIterator;
import java.util.concurrent.TimeUnit;

@InternalApi
public class BlobStoreSegmentDataLoader
extends Thread {
    private static final int QUEUE_OFFER_TIME_OUT = 180;
    private final int _segment;
    private final BlobStoreSegmentedParallelIterator _mainIter;
    private final DataIterator<BlobStoreGetBulkOperationResult> _segmentIter;

    public BlobStoreSegmentDataLoader(BlobStoreSegmentedParallelIterator mainIter, int segment, DataIterator<BlobStoreGetBulkOperationResult> segmentIter) {
        this._segment = segment;
        this._mainIter = mainIter;
        this._segmentIter = segmentIter;
    }

    @Override
    public void run() {
        boolean terminated = false;
        try {
            while (true) {
                Object o = null;
                if (this._segmentIter.hasNext()) {
                    o = this._segmentIter.next();
                }
                if (o == null) {
                    this._segmentIter.close();
                    terminated = true;
                    this.offer(this._mainIter.getTerminationIndicator());
                    return;
                }
                this.offer(o);
            }
        }
        catch (Exception ex) {
            RuntimeException rte = new RuntimeException(ex);
            this._mainIter.getObjectsQueue().add(rte);
            this._segmentIter.close();
            try {
                if (!terminated) {
                    this.offer(this._mainIter.getTerminationIndicator());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw rte;
        }
    }

    private void offer(Object object) throws InterruptedException {
        while (!this._mainIter.getObjectsQueue().offer(object, 180L, TimeUnit.SECONDS)) {
        }
    }
}

