/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationResult;
import com.j_spaces.core.cache.blobStore.storage.BlobStoreSegmentDataLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class BlobStoreSegmentedParallelIterator
implements DataIterator<BlobStoreGetBulkOperationResult> {
    private final int QUEUE_CAPACITY = 15000;
    private int _segmentsToDo;
    private final int _numSegments;
    private final BlockingQueue<Object> _objectsQueue;
    private static final Object _terminationIndicator = new Object();
    private boolean _finished;
    private boolean _initialized;
    private static final long TIME_TO_WAIT = 120L;

    public BlobStoreSegmentedParallelIterator(int numSegments) {
        this._segmentsToDo = numSegments;
        this._numSegments = numSegments;
        this._objectsQueue = new LinkedBlockingQueue<Object>(15000);
    }

    @Override
    public BlobStoreGetBulkOperationResult next() {
        Object o;
        block7: {
            if (!this._initialized) {
                this.startPerSegmentLoaders();
                this._initialized = true;
            }
            do {
                if (!this.hasNext()) {
                    return null;
                }
                o = null;
                try {
                    o = this._objectsQueue.poll(120L, TimeUnit.SECONDS);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                if (o == null) {
                    throw new RuntimeException("next() : timeout reached while reading blobstore parallel iterator");
                }
                if (o != _terminationIndicator) break block7;
                --this._segmentsToDo;
            } while (this.hasNext());
            return null;
        }
        if (o instanceof Throwable) {
            this._finished = true;
            throw new RuntimeException((Throwable)o);
        }
        return (BlobStoreGetBulkOperationResult)o;
    }

    @Override
    public boolean hasNext() {
        return !this._finished && this._segmentsToDo > 0;
    }

    @Override
    public void close() {
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object getTerminationIndicator() {
        return _terminationIndicator;
    }

    public BlockingQueue<Object> getObjectsQueue() {
        return this._objectsQueue;
    }

    private void startPerSegmentLoaders() {
        for (int segment = 0; segment < this._numSegments; ++segment) {
            BlobStoreSegmentDataLoader dl = new BlobStoreSegmentDataLoader(this, segment, this.createDataIteratorForSegmen(segment));
            dl.start();
        }
    }

    public abstract DataIterator<BlobStoreGetBulkOperationResult> createDataIteratorForSegmen(int var1);
}

