/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage.bulks;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationOutContext;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.IDirectPersistencyOpInfo;
import com.gigaspaces.server.blobstore.BlobStoreAddBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.gigaspaces.server.blobstore.BlobStoreRemoveBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreReplaceBulkOperationRequest;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.errors.BlobStoreErrorBulkEntryInfo;
import com.j_spaces.core.cache.blobStore.errors.BlobStoreErrorsHandler;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationBasicInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationInsertInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationRemoveInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.delayedReplication.DelayedReplicationUpdateInfo;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.server.processor.BlobStoreUnpinMultiplePacket;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreBulkInfo {
    private static final int BULK_CHUNK_SIZE = 1000;
    private static final long BULK_MAX_WAIT_TIME = 300000L;
    private final Logger _logger;
    private final CacheManager _cacheManager;
    private final HashMap<String, BulkOpHolder> _uids;
    private final List<BulkOpHolder> _ops;
    private volatile boolean _terminated;
    private final Object _lock;
    private final Thread _ownerThread;
    private final boolean _takeMultipleBulk;
    private volatile Throwable _exceptionOccured;
    private int _lastNotificationStamp;
    private volatile boolean _disabled;
    private HashSet<String> _removedEntries;
    private final Map<String, IDirectPersistencyOpInfo> _directPersistencyCoordinationObjects;
    private final Map<String, DelayedReplicationBasicInfo> _delayedReplMap;
    private static final AtomicInteger _bulkIdCounter = new AtomicInteger(1);
    private int _blobstoreBulkId;
    private final Map<String, BlobStoreErrorBulkEntryInfo> _previousStates;

    public BlobStoreBulkInfo(CacheManager cacheManager, boolean takeMultipleBulk) {
        this._cacheManager = cacheManager;
        this._uids = new HashMap();
        this._ops = new LinkedList<BulkOpHolder>();
        this._lock = new Object();
        BlobStoreBulkInfo blobStoreBulkInfo = this;
        this._logger = blobStoreBulkInfo._cacheManager.getLogger();
        this._ownerThread = Thread.currentThread();
        this._takeMultipleBulk = takeMultipleBulk;
        this._directPersistencyCoordinationObjects = cacheManager.getEngine().getReplicationNode() != null && cacheManager.getEngine().getReplicationNode().getDirectPesistencySyncHandler() != null ? new Hashtable() : null;
        this._delayedReplMap = new Hashtable<String, DelayedReplicationBasicInfo>();
        this._previousStates = new Hashtable<String, BlobStoreErrorBulkEntryInfo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Context context, BlobStoreRefEntryCacheInfo eci, int operation, boolean registerDirectPersistency) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isActive()) {
                throw new RuntimeException("try to add uid to bulk-info when bulk inactive, uid=" + eci.getUID());
            }
            if (this._exceptionOccured != null) {
                throw new BlobStoreException("bulk operation failed- a previous exception have been thrown " + this._exceptionOccured);
            }
            if (this._uids.containsKey(eci.getUID())) {
                throw new RuntimeException("Duplicate uid in bulk-info, uid=" + eci.getUID());
            }
            this.generateBulkIdIfNeeded(registerDirectPersistency);
            BulkOpHolder boh = new BulkOpHolder(operation, eci);
            this._ops.add(boh);
            this._uids.put(eci.getUID(), boh);
            if (this._removedEntries != null && this._ops.size() == 1) {
                this._removedEntries.clear();
            }
            if (registerDirectPersistency) {
                this._directPersistencyCoordinationObjects.put(eci.getUID(), context.getReplicationContext().getDirectPersistencyPendingEntry());
            }
            if (this._previousStates != null && BlobStoreErrorBulkEntryInfo.isRelevant(operation)) {
                this._previousStates.put(eci.getUID(), new BlobStoreErrorBulkEntryInfo(context));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedReplicationInfo(Context context, BlobStoreRefEntryCacheInfo eci, DelayedReplicationBasicInfo dri) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isActive()) {
                throw new RuntimeException("try to addDelayedReplicationInfo to bulk-info when bulk inactive, uid=" + eci.getUID());
            }
            IDirectPersistencyOpInfo oi = this._directPersistencyCoordinationObjects.get(eci.getUID());
            if (oi == null) {
                throw new RuntimeException("try to addDelayedReplicationInfo to bulk-info when no direct persistency for uid=" + eci.getUID());
            }
            BulkOpHolder boh = this._uids.get(eci.getUID());
            if (boh == null || boh.isDiscarded()) {
                throw new RuntimeException("try to addDelayedReplicationInfo to bulk-info when no relevant bulkinfoholder for uid=" + eci.getUID());
            }
            dri.setDirectPersistencyOpInfo(oi);
            this._delayedReplMap.put(eci.getUID(), dri);
            IReplicationOutContext ro = this._cacheManager.getReplicationContext(context);
            ro.setDirectPersistencyPendingEntry(null);
        }
    }

    public boolean isActive() {
        return !this._terminated;
    }

    public IDirectPersistencyOpInfo getDirectPersistencyCoordinationObject(String uid) {
        return this._directPersistencyCoordinationObjects != null ? this._directPersistencyCoordinationObjects.get(uid) : null;
    }

    public DelayedReplicationBasicInfo getDelayedReplicationInfo(String uid) {
        return this._delayedReplMap.get(uid);
    }

    public void bulk_flush(Context context, boolean only_if_chunk_reached) {
        this.bulk_flush(context, only_if_chunk_reached, false);
    }

    public void bulk_flush(Context context, boolean only_if_chunk_reached, boolean termination) {
        if (only_if_chunk_reached && termination) {
            throw new IllegalArgumentException();
        }
        if (this._cacheManager.getEngine().isReplicatedPersistentBlobstore() && this._cacheManager.getEngine().getSpaceImpl().isPrimary()) {
            this._cacheManager.getReplicationContext(context).blobstorePendingReplicationBulk();
        }
        if (this._terminated) {
            return;
        }
        if (only_if_chunk_reached && this._uids.size() < 1000) {
            return;
        }
        if (this._uids.isEmpty()) {
            this.afterBulkFlush(context, termination);
            return;
        }
        if (this._exceptionOccured != null) {
            throw new BlobStoreException("bulk operation failed- a previous exception has been thrown " + this._exceptionOccured);
        }
        try {
            LinkedList<BlobStoreBulkOperationRequest> operations = new LinkedList<BlobStoreBulkOperationRequest>();
            block16: for (BulkOpHolder boh : this._ops) {
                if (!boh.getBlobStoreRefEntryCacheInfo().setBulkFlushing(this)) {
                    boh.setDiscarded();
                    continue;
                }
                switch (boh.getOperation()) {
                    case 1: {
                        operations.add(new BlobStoreAddBulkOperationRequest(boh.getBlobStoreRefEntryCacheInfo().getStorageKey(), boh.getBlobStoreRefEntryCacheInfo().getEntryLayout(this._cacheManager), boh.getBlobStoreRefEntryCacheInfo()));
                        continue block16;
                    }
                    case 7: {
                        operations.add(new BlobStoreReplaceBulkOperationRequest(boh.getBlobStoreRefEntryCacheInfo().getStorageKey(), boh.getBlobStoreRefEntryCacheInfo().getEntryLayout(this._cacheManager), boh.getBlobStoreRefEntryCacheInfo().getBlobStoreStoragePos(), boh.getBlobStoreRefEntryCacheInfo()));
                        continue block16;
                    }
                    case 4: {
                        boolean phantom;
                        boolean bl = phantom = this._cacheManager.isDirectPersistencyEmbeddedtHandlerUsed() && boh.getBlobStoreRefEntryCacheInfo().isPhantom();
                        if (!phantom) {
                            operations.add(new BlobStoreRemoveBulkOperationRequest(boh.getBlobStoreRefEntryCacheInfo().getStorageKey(), boh.getBlobStoreRefEntryCacheInfo().getBlobStoreStoragePos(), boh.getBlobStoreRefEntryCacheInfo()));
                            continue block16;
                        }
                        operations.add(new BlobStoreReplaceBulkOperationRequest(boh.getBlobStoreRefEntryCacheInfo().getStorageKey(), boh.getBlobStoreRefEntryCacheInfo().getEntryLayout(this._cacheManager), boh.getBlobStoreRefEntryCacheInfo().getBlobStoreStoragePos(), boh.getBlobStoreRefEntryCacheInfo()));
                        continue block16;
                    }
                }
                throw new UnsupportedOperationException("uid=" + boh.getBlobStoreRefEntryCacheInfo().getUID() + " operation=" + boh.getOperation());
            }
            Throwable t = null;
            LinkedList results = !operations.isEmpty() ? this._cacheManager.getBlobStoreStorageHandler().executeBulk(operations, BlobStoreObjectType.DATA, false) : new LinkedList();
            for (BlobStoreBulkOperationResult res : results) {
                DelayedReplicationBasicInfo dri;
                BulkOpHolder boh = this._uids.get(res.getId());
                if (res.getException() != null) {
                    if (t != null) continue;
                    t = res.getException();
                    continue;
                }
                if (this._directPersistencyCoordinationObjects != null && !this._directPersistencyCoordinationObjects.isEmpty()) {
                    this._cacheManager.getEngine().getReplicationNode().getDirectPesistencySyncHandler().afterOperationPersisted(this._directPersistencyCoordinationObjects.remove(boh.getBlobStoreRefEntryCacheInfo().getUID()));
                }
                switch (boh.getOperation()) {
                    case 1: 
                    case 7: {
                        boh.getBlobStoreRefEntryCacheInfo().flushedFromBulk(context, this._cacheManager, res.getPosition(), false, false);
                        break;
                    }
                    case 4: {
                        boh.getBlobStoreRefEntryCacheInfo().flushedFromBulk(context, this._cacheManager, null, true, false);
                        this._cacheManager.removeEntryFromCache(boh.getBlobStoreRefEntryCacheInfo().getEntryHolder(), false, true, boh.getBlobStoreRefEntryCacheInfo(), CacheManager.RecentDeleteCodes.NONE);
                        if (this._removedEntries == null) {
                            this._removedEntries = new HashSet();
                        }
                        this._removedEntries.add(boh.getBlobStoreRefEntryCacheInfo().getUID());
                    }
                }
                if ((dri = this._delayedReplMap.get(boh.getBlobStoreRefEntryCacheInfo().getUID())) == null) continue;
                IReplicationOutContext ro = this._cacheManager.getReplicationContext(context);
                ro.setDirectPersistencyPendingEntry(dri.getDirectPersistencyOpInfo());
                ro.setDirectPesistencySyncHandler(this._cacheManager.getEngine().getReplicationNode().getDirectPesistencySyncHandler());
                switch (dri.getOpCode()) {
                    case INSERT: {
                        DelayedReplicationInsertInfo ii = (DelayedReplicationInsertInfo)dri;
                        this._cacheManager.handleInsertEntryReplication(context, dri.getEntry(), this._blobstoreBulkId);
                        break;
                    }
                    case UPDATE: {
                        DelayedReplicationUpdateInfo ui = (DelayedReplicationUpdateInfo)dri;
                        this._cacheManager.handleUpdateEntryReplication(context, ui.getEntry(), ui.getOriginalData(), ui.getMutators(), this._blobstoreBulkId);
                        break;
                    }
                    case REMOVE: {
                        DelayedReplicationRemoveInfo ri = (DelayedReplicationRemoveInfo)dri;
                        this._cacheManager.handleRemoveEntryReplication(context, ri.getEntry(), ri.getRemoveReason(), this._blobstoreBulkId);
                    }
                }
            }
            if (t == null && this._exceptionOccured != null) {
                t = this._exceptionOccured;
            }
            if (t != null) {
                throw !(t instanceof BlobStoreException) ? new BlobStoreException(t) : (BlobStoreException)t;
            }
            this.afterBulkFlush(context, termination);
        }
        catch (Throwable t) {
            BlobStoreException ex;
            this._logger.log(Level.SEVERE, this.getClass().getName() + " blobstore:execute-bulk ", t);
            BlobStoreException blobStoreException = ex = t instanceof BlobStoreException ? (BlobStoreException)t : new BlobStoreException(t);
            if (this.getException() == null) {
                this.setExecption(t);
            }
            this._exceptionOccured = t;
            this.onFlushError(context);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterBulkFlush(Context context, boolean termination) {
        Object object = this._lock;
        synchronized (object) {
            if (this._exceptionOccured == null) {
                LinkedList<BlobStoreRefEntryCacheInfo> unpined = null;
                for (BulkOpHolder boh : this._ops) {
                    if (boh.isDiscarded()) continue;
                    boh.getBlobStoreRefEntryCacheInfo().bulkUnRegister(this._cacheManager);
                    if (boh.getBlobStoreRefEntryCacheInfo().isDeleted()) continue;
                    if (unpined == null) {
                        unpined = new LinkedList<BlobStoreRefEntryCacheInfo>();
                    }
                    unpined.add(boh.getBlobStoreRefEntryCacheInfo());
                }
                if (unpined != null) {
                    this._cacheManager.getEngine().getProcessorWG().enqueueBlocked(new BlobStoreUnpinMultiplePacket(unpined));
                }
                this._uids.clear();
                this._ops.clear();
                this.clearBulkId();
            }
            if (termination) {
                this._terminated = true;
            }
            ++this._lastNotificationStamp;
            this._lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushError(Context context) {
        Object object = this._lock;
        synchronized (object) {
            try {
                this._terminated = true;
                if (this._previousStates == null) {
                    return;
                }
                LinkedList<BlobStoreRefEntryCacheInfo> unpined = null;
                for (BulkOpHolder boh : this._ops) {
                    if (boh.isDiscarded()) continue;
                    if (unpined == null) {
                        unpined = new LinkedList<BlobStoreRefEntryCacheInfo>();
                    }
                    unpined.add(boh.getBlobStoreRefEntryCacheInfo());
                    BlobStoreErrorBulkEntryInfo.setOnContext(context, this._previousStates.get(boh.getBlobStoreRefEntryCacheInfo().getUID()));
                    switch (boh.getOperation()) {
                        case 1: {
                            BlobStoreErrorsHandler.onFailedWrite(this._cacheManager, context, boh.getBlobStoreRefEntryCacheInfo(), boh.getBlobStoreRefEntryCacheInfo().getEntryHolder());
                            break;
                        }
                        case 7: {
                            BlobStoreErrorsHandler.onFailedUpdate(this._cacheManager, context, boh.getBlobStoreRefEntryCacheInfo(), boh.getBlobStoreRefEntryCacheInfo().getEntryHolder());
                            break;
                        }
                        case 4: {
                            BlobStoreErrorsHandler.onFailedRemove(this._cacheManager, context, boh.getBlobStoreRefEntryCacheInfo(), boh.getBlobStoreRefEntryCacheInfo().getEntryHolder());
                        }
                    }
                    boh.getBlobStoreRefEntryCacheInfo().bulkUnRegister(this._cacheManager);
                }
                if (unpined != null) {
                    this._cacheManager.getEngine().getProcessorWG().enqueueBlocked(new BlobStoreUnpinMultiplePacket(unpined));
                }
            }
            catch (Throwable ex) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, "failure during handling flush error", ex);
                }
            }
            finally {
                if (this._uids != null) {
                    this._uids.clear();
                }
                if (this._ops != null) {
                    this._ops.clear();
                }
                this.clearBulkId();
                this._lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBulkFlush(BlobStoreRefEntryCacheInfo eci) {
        if (this._terminated) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._terminated) {
                return;
            }
            if (this._exceptionOccured != null) {
                throw new BlobStoreException("bulk operation failed- a previous exception have been thrown " + this._exceptionOccured);
            }
            if (this._uids.get(eci.getUID()) == null) {
                return;
            }
            int mystamp = 0;
            try {
                long towait;
                mystamp = this._lastNotificationStamp;
                long upto = System.currentTimeMillis() + 300000L;
                while ((towait = upto - System.currentTimeMillis()) > 0L) {
                    this._lock.wait(towait);
                    if (mystamp == this._lastNotificationStamp) continue;
                    break;
                }
                if (mystamp == this._lastNotificationStamp) {
                    throw new BlobStoreException("wait for bulk operation: max time expired, uid=" + eci.getUID());
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BlobStoreException(e);
            }
        }
    }

    public Thread getOwnerThread() {
        return this._ownerThread;
    }

    public boolean isTakeMultipleBulk() {
        return this._takeMultipleBulk;
    }

    public Throwable getException() {
        return this._exceptionOccured;
    }

    public void setExecption(Throwable t) {
        this._logger.severe(this.getClass().getName() + " blobstore:set exception [in bulk] " + t);
        if (this._exceptionOccured == null) {
            this._exceptionOccured = t;
        }
    }

    public boolean wasEntryRemovedInChunk(String uid) {
        return this._removedEntries != null ? this._removedEntries.contains(uid) : false;
    }

    public BlobStoreErrorBulkEntryInfo getPerviousStateForEntry(String uid) {
        return this._previousStates.get(uid);
    }

    private void generateBulkIdIfNeeded(boolean neededDirectPersistency) {
        if (this._blobstoreBulkId == 0 && neededDirectPersistency && this._cacheManager.useBlobStoreReplicationBackupBulks()) {
            this._blobstoreBulkId = _bulkIdCounter.getAndIncrement();
        }
    }

    private void clearBulkId() {
        this._blobstoreBulkId = 0;
    }

    private static class BulkOpHolder {
        private final int _operation;
        private final BlobStoreRefEntryCacheInfo _eci;
        private boolean _discarded;

        BulkOpHolder(int operation, BlobStoreRefEntryCacheInfo eci) {
            this._operation = operation;
            this._eci = eci;
        }

        int getOperation() {
            return this._operation;
        }

        BlobStoreRefEntryCacheInfo getBlobStoreRefEntryCacheInfo() {
            return this._eci;
        }

        boolean isDiscarded() {
            return this._discarded;
        }

        void setDiscarded() {
            this._discarded = true;
        }
    }
}

