/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage.bulks;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreBulkOperationResult;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreGetBulkOperationRequest;
import com.gigaspaces.server.blobstore.BlobStoreObjectType;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryHolder;
import com.j_spaces.core.cache.blobStore.BlobStoreEntryLayout;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchBatchHandler;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchBatchResult;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

@InternalApi
public class BlobStoreReadBulkHandler {
    private final CacheManager _cacheManager;
    Map<BlobStoreRefEntryCacheInfo, BlobStoreEntryLayout> _res;
    private final BlobStorePreFetchBatchHandler _request;
    private final Logger _logger;

    public BlobStoreReadBulkHandler(CacheManager cacheManager, BlobStorePreFetchBatchHandler request) {
        this._cacheManager = cacheManager;
        this._request = request;
        BlobStoreReadBulkHandler blobStoreReadBulkHandler = this;
        this._logger = blobStoreReadBulkHandler._cacheManager.getLogger();
    }

    public BlobStorePreFetchBatchResult execute() {
        BlobStorePreFetchBatchResult res = new BlobStorePreFetchBatchResult(this._request);
        HashMap<String, BlobStoreRefEntryCacheInfo> uids = new HashMap<String, BlobStoreRefEntryCacheInfo>(this._request.getEntries().size());
        try {
            LinkedList<BlobStoreBulkOperationRequest> operations = new LinkedList<BlobStoreBulkOperationRequest>();
            for (BlobStoreRefEntryCacheInfo e : this._request.getEntries()) {
                if (e.isDeleted()) continue;
                BlobStoreEntryHolder eh = e.getFromInternalCache(this._cacheManager);
                if (eh != null) {
                    res.add(e, eh);
                    continue;
                }
                if (uids.put(e.getUID(), e) == null) {
                    // empty if block
                }
                operations.add(new BlobStoreGetBulkOperationRequest(e.getStorageKey(), e.getBlobStoreStoragePos(), e));
            }
            if (operations.isEmpty()) {
                return res;
            }
            Object t = null;
            List<BlobStoreBulkOperationResult> results = this._cacheManager.getBlobStoreStorageHandler().executeBulk(operations, BlobStoreObjectType.DATA, false);
            for (BlobStoreBulkOperationResult r : results) {
                if (r.getException() != null) {
                    res.setException(r.getException());
                    return res;
                }
                res.add((BlobStoreRefEntryCacheInfo)uids.get(r.getId()), (BlobStoreEntryLayout)r.getData());
            }
        }
        catch (Throwable t) {
            this._logger.severe(this.getClass().getName() + " blobstore:execute-bulk " + t);
            BlobStoreException ex = t instanceof BlobStoreException ? (BlobStoreException)t : new BlobStoreException(t);
            res.setException(ex);
        }
        return res;
    }
}

