/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage.preFetch;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.storage.bulks.BlobStoreReadBulkHandler;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchBatchResult;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchIteratorBasedHandler;
import com.j_spaces.core.cache.context.Context;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStorePreFetchBatchHandler
implements Callable<BlobStorePreFetchBatchResult> {
    public static final long FETCH_WAIT_TIME = 60000L;
    private final List<BlobStoreRefEntryCacheInfo> _entries = new LinkedList<BlobStoreRefEntryCacheInfo>();
    private volatile BlobStorePreFetchBatchResult _result;
    private volatile Future<BlobStorePreFetchBatchResult> _future;
    private final boolean _executeByMainThread;
    private final CacheManager _cacheManager;
    private final BlobStorePreFetchIteratorBasedHandler _caller;
    private final Logger _logger;

    public BlobStorePreFetchBatchHandler(CacheManager cacheManager, boolean executeByMainThread, BlobStorePreFetchIteratorBasedHandler caller, Logger logger) {
        this._cacheManager = cacheManager;
        this._executeByMainThread = executeByMainThread;
        this._caller = caller;
        this._logger = logger;
    }

    public int addEntry(BlobStoreRefEntryCacheInfo e) {
        if (e != null) {
            this._entries.add(e);
        }
        return this._entries.size();
    }

    public List<BlobStoreRefEntryCacheInfo> getEntries() {
        return this._entries;
    }

    public BlobStorePreFetchBatchResult getResult() {
        return this._result;
    }

    public void setResult(BlobStorePreFetchBatchResult res) {
        this._result = res;
    }

    public boolean hasResult() {
        return this._result != null;
    }

    public BlobStorePreFetchBatchResult getReadyResult() {
        if (this._executeByMainThread || this._result != null) {
            return this._result;
        }
        try {
            this._future.get(60000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            if (this._result != null) {
                this._result.setException(e);
            }
            this._logger.log(Level.SEVERE, "PreFetchBatchHandler got an exception:", e);
            throw new BlobStoreException(e);
        }
        if (!this._future.isDone()) {
            BlobStoreException ex = new BlobStoreException("BlobStorePreFetchBatchHandler:getReadyResult could not get any batch on time");
            this._logger.log(Level.SEVERE, "BlobStorePreFetchBatchHandler got an exception:", ex);
            throw ex;
        }
        return this._result;
    }

    public boolean isReadyResult() {
        return this._executeByMainThread || this._future.isDone();
    }

    public void setFuture(Future<BlobStorePreFetchBatchResult> f) {
        this._future = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlobStorePreFetchBatchResult call() {
        Thread.currentThread().setName("GS-BlobStorePreFetchHandler#" + Thread.currentThread().getId());
        Context context = this._cacheManager.getCacheContext();
        try {
            BlobStorePreFetchBatchResult res = this.execute(context);
            this._caller.notifyResultReady(this);
            BlobStorePreFetchBatchResult blobStorePreFetchBatchResult = res;
            return blobStorePreFetchBatchResult;
        }
        finally {
            if (context != null) {
                this._cacheManager.freeCacheContext(context);
            }
        }
    }

    public BlobStorePreFetchBatchResult execute(Context context) {
        BlobStoreReadBulkHandler bh = new BlobStoreReadBulkHandler(this._cacheManager, this);
        this.setResult(bh.execute());
        return this._result;
    }

    public boolean isExcecuteByMainThread() {
        return this._executeByMainThread;
    }
}

