/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.blobStore.storage.preFetch;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.server.blobstore.BlobStoreException;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.BlobStoreRefEntryCacheInfo;
import com.j_spaces.core.cache.blobStore.storage.preFetch.BlobStorePreFetchBatchHandler;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.list.IScanListIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class BlobStorePreFetchIteratorBasedHandler
implements IScanListIterator<IEntryCacheInfo> {
    private static final int MAX_BATCH_SIZE = 5000;
    private static final int MAX_QUOTA_SIZE_IN_BATCHES = 5;
    private static final double PREFETCH_FACTOR = 1.0;
    private final IScanListIterator<BlobStoreRefEntryCacheInfo> _mainIterator;
    private boolean _mainIterTerminated;
    private final ITemplateHolder _template;
    private final Object _lock;
    private final LinkedList<BlobStorePreFetchBatchHandler> _requests;
    private Iterator<BlobStoreRefEntryCacheInfo> _curIter;
    private BlobStorePreFetchBatchHandler _curHandeledRequest;
    private boolean _finished;
    private final Context _mainThreadContext;
    private final CacheManager _cacheManager;
    private final int _numEntriesRequested;
    private int _numEntriesSoFar;
    private int _quotaNumber;
    private final Logger _logger;

    public BlobStorePreFetchIteratorBasedHandler(Context mainThreadContext, CacheManager cacheManager, IScanListIterator<IEntryCacheInfo> mainIterator, ITemplateHolder template, int numEntriesRequested, Logger logger) {
        this._mainIterator = mainIterator;
        this._template = template;
        this._lock = new Object();
        this._requests = new LinkedList();
        this._mainThreadContext = mainThreadContext;
        this._cacheManager = cacheManager;
        this._numEntriesRequested = numEntriesRequested != Integer.MAX_VALUE ? (int)((double)numEntriesRequested * 1.0) : numEntriesRequested;
        this._logger = logger;
    }

    public static IScanListIterator<IEntryCacheInfo> createPreFetchIterIfRelevant(Context context, CacheManager cacheManager, IScanListIterator<IEntryCacheInfo> mainIterator, ITemplateHolder template, Logger logger) {
        return BlobStorePreFetchIteratorBasedHandler.isRelevantForPreFetchIterator(context, cacheManager, mainIterator, template) ? new BlobStorePreFetchIteratorBasedHandler(context, cacheManager, mainIterator, template, template.getBatchOperationContext().getMaxEntries(), logger) : mainIterator;
    }

    private static boolean isRelevantForPreFetchIterator(Context context, CacheManager cacheManager, IScanListIterator<IEntryCacheInfo> mainIterator, ITemplateHolder template) {
        return mainIterator.isIterator() && template.isBatchOperation() && cacheManager.isBlobStoreCachePolicy() && cacheManager.useBlobStorePreFetch() && !context.isDisableBlobStorePreFetching() && template.getBatchOperationContext().getMaxEntries() > 1 && !template.isFifoGroupPoll() && template.getXidOriginated() == null;
    }

    @Override
    public boolean hasNext() throws SAException {
        while (true) {
            if (this._finished) {
                this.replaceContextPreFetchResult();
                return false;
            }
            if (this._curIter != null) {
                if (this._curIter.hasNext()) {
                    return true;
                }
                this._curIter = null;
                this._requests.remove(this._curHandeledRequest);
                this._curHandeledRequest = null;
                if (this._requests.isEmpty() && this._mainIterTerminated) {
                    this._finished = true;
                    this.replaceContextPreFetchResult();
                    return false;
                }
            }
            this._curHandeledRequest = this.getNextBatch();
            if (this._curHandeledRequest == null) continue;
            this._curIter = this._curHandeledRequest.getEntries().iterator();
            this.replaceContextPreFetchResult();
        }
    }

    private void replaceContextPreFetchResult() {
        if (this._finished) {
            this._mainThreadContext.setBlobStorePreFetchBatchResult(null);
        } else {
            this._mainThreadContext.setBlobStorePreFetchBatchResult(this._curHandeledRequest.getResult());
        }
    }

    private BlobStorePreFetchBatchHandler getNextBatch() {
        if (this._template.isFifoTemplate()) {
            return this.getFirstBatchForProcessing();
        }
        return this.getNextBatchNonFifo();
    }

    private BlobStorePreFetchBatchHandler getFirstBatchForProcessing() {
        BlobStorePreFetchBatchHandler r = this.getFirstBatch();
        if (this._finished) {
            return null;
        }
        if (!r.isExcecuteByMainThread()) {
            r.getReadyResult();
        }
        return r;
    }

    private BlobStorePreFetchBatchHandler getFirstBatch() {
        if (!this._requests.isEmpty()) {
            return this._requests.getFirst();
        }
        this.bringNextQuota();
        if (this._finished) {
            return null;
        }
        return this._requests.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlobStorePreFetchBatchHandler getNextBatchNonFifo() {
        if (this._requests.isEmpty()) {
            this.bringNextQuota();
        }
        if (this._finished) {
            return null;
        }
        if (this._requests.size() == 1) {
            return this.getFirstBatchForProcessing();
        }
        BlobStorePreFetchBatchHandler r = null;
        r = this.getAnyCompleted();
        if (r != null) {
            return r;
        }
        Object object = this._lock;
        synchronized (object) {
            r = this.getAnyCompleted();
            if (r != null) {
                return r;
            }
            long upto = System.currentTimeMillis() + 60000L;
            long w = 60000L;
            while (true) {
                try {
                    this._lock.wait(w);
                }
                catch (InterruptedException e) {
                    if (this._logger.isLoggable(Level.SEVERE)) {
                        this._logger.log(Level.SEVERE, "PreFetchIterator got an exception:", e);
                    }
                    throw new BlobStoreException(e);
                }
                r = this.getAnyCompleted();
                if (r != null) {
                    return r;
                }
                long cur = System.currentTimeMillis();
                if (cur >= upto) break;
                w = upto - cur;
            }
            if (r == null) {
                BlobStoreException ex = new BlobStoreException("PreFetchIterator:getNextBatchNonFifo could not get any batch on time");
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, "PreFetchIterator got an exception:", ex);
                }
                throw ex;
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyResultReady(BlobStorePreFetchBatchHandler r) {
        if (!r.isExcecuteByMainThread()) {
            Object object = this._lock;
            synchronized (object) {
                this._lock.notify();
            }
        }
    }

    private BlobStorePreFetchBatchHandler getAnyCompleted() {
        for (BlobStorePreFetchBatchHandler r : this._requests) {
            if (!r.isReadyResult()) continue;
            return r;
        }
        return null;
    }

    private void bringNextQuota() {
        int numToLimit;
        boolean finishedQuota = false;
        if (this._finished) {
            return;
        }
        if (this._mainIterTerminated) {
            this._finished = true;
            return;
        }
        this._requests.clear();
        ++this._quotaNumber;
        int n = numToLimit = this._quotaNumber == 1 ? this._numEntriesRequested : this._numEntriesRequested / 2;
        if (numToLimit <= 1) {
            numToLimit = 2;
        }
        int numThisQuota = 0;
        try {
            BlobStorePreFetchBatchHandler first = null;
            for (int bn = 0; bn < 5; ++bn) {
                BlobStorePreFetchBatchHandler cur = null;
                if (this._mainIterTerminated || finishedQuota) break;
                do {
                    if (numThisQuota >= numToLimit) {
                        finishedQuota = true;
                        break;
                    }
                    if (!this._mainIterator.hasNext()) {
                        this._mainIterTerminated = true;
                        finishedQuota = true;
                        break;
                    }
                    if (cur == null) {
                        cur = new BlobStorePreFetchBatchHandler(this._cacheManager, first == null, this, this._logger);
                    }
                    ++this._numEntriesSoFar;
                    ++numThisQuota;
                } while (cur.addEntry(this._mainIterator.next()) < 5000);
                if (cur != null) {
                    this._requests.addLast(cur);
                }
                if (first == null) {
                    first = cur;
                    cur = null;
                    continue;
                }
                if (cur == null) continue;
                this.execute(this._mainThreadContext, cur);
            }
            if (first != null) {
                this.execute(this._mainThreadContext, first);
            }
            if (this._requests.isEmpty()) {
                this._finished = true;
                return;
            }
        }
        catch (Throwable t) {
            throw new BlobStoreException("PreFetchIterator:bringNextQuota " + t);
        }
    }

    private void execute(Context mainThreadContext, BlobStorePreFetchBatchHandler bh) {
        if (!bh.isExcecuteByMainThread()) {
            bh.setFuture(this._cacheManager.getBlobStoreStorageHandler().getPreFetchPool().submit(bh));
        } else {
            bh.execute(mainThreadContext);
        }
    }

    @Override
    public IEntryCacheInfo next() throws SAException {
        return this._curIter.next();
    }

    @Override
    public void releaseScan() throws SAException {
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }
}

