/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.IExtendedIndexIterator;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupIterator;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.IStoredListIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;

@InternalApi
public class ExtendedIndexFifoGroupsIterator<V>
implements IFifoGroupIterator<V>,
IExtendedIndexIterator<V> {
    private boolean _initializedIter;
    private boolean _wraped;
    private final Iterator<Map.Entry<Object, IStoredList<V>>> _iter;
    private IStoredListIterator<V> _pos;
    private IStoredList<V> _entries;
    private boolean _eof;
    private V _res;
    private final TypeDataIndex _idx;
    private final NavigableMap _mapToScan;

    public ExtendedIndexFifoGroupsIterator(NavigableMap mapToScan, TypeDataIndex idx) {
        this._idx = idx;
        this._mapToScan = mapToScan;
        this._iter = this._mapToScan.entrySet().iterator();
    }

    @Override
    public void nextGroup() {
        this.release();
    }

    @Override
    public boolean hasNext() {
        this._res = this.nextValue();
        return this._res != null;
    }

    @Override
    public V next() {
        V res = this._res;
        this._res = null;
        return res;
    }

    private V nextValue() {
        V res = null;
        while (true) {
            if (this._eof) {
                return null;
            }
            boolean newSl = false;
            if (this._entries == null) {
                if (this._iter.hasNext()) {
                    Map.Entry<Object, IStoredList<V>> valEntry = this._iter.next();
                    IStoredList<V> entries = valEntry.getValue();
                    if (entries.optimizeScanForSingleObject()) {
                        res = entries.getObjectFromHead();
                        if (res != null) {
                            return res;
                        }
                        newSl = true;
                    } else {
                        newSl = true;
                        this._pos = entries.establishListScan(false);
                        this._entries = entries;
                    }
                } else {
                    this._eof = true;
                    return null;
                }
            }
            if (!newSl) {
                this._pos = this._entries.next(this._pos);
            }
            if (this._pos == null) {
                this._entries = null;
                continue;
            }
            res = this._pos.getSubject();
            if (res != null) break;
        }
        return res;
    }

    public void release() {
        if (this._entries != null) {
            this._entries.freeSLHolder(this._pos);
        }
        this._pos = null;
        this._entries = null;
    }

    protected void finalize() {
        this.release();
    }

    @Override
    public void releaseScan() {
        this.release();
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        if (this._idx == null) {
            return -1;
        }
        return this._idx.getPos();
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    public boolean isMultiValueIterator() {
        return true;
    }

    public void remove() {
        throw new RuntimeException(" not supported");
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    protected Object getActualGroupValue(Map.Entry<Object, IStoredList<V>> mapEntry) {
        return mapEntry.getKey();
    }
}

