/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.gigaspaces.internal.query.ICustomQuery;
import com.gigaspaces.internal.query.IQueryIndexScanner;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.TypeDataFactory;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.metadata.index.CompoundIndex;
import com.gigaspaces.metadata.index.ISpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexFactory;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.cache.fifoGroup.ExtendedIndexFifoGroupsIterator;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsCacheHandler;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsMultiList;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsScanAllValuesByCompoundIndexIterator;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsScanAllValuesIterator;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsScanByFGIndexIterator;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsScanByGeneralIndexIterator;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupIterator;
import com.j_spaces.core.client.TemplateMatchCodes;
import com.j_spaces.kernel.ICollection;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IObjectsList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.MultiStoredList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class FifoGroupCacheImpl {
    private final CacheManager _cacheManager;
    private final FifoGroupsCacheHandler _fgCacheHandeler;
    private static String Compound_Fifo_Groups_Index_Name_Suffix = "+COMPOUND_FIFO_GROUPS";
    private final AtomicInteger _numOfTemplates = new AtomicInteger();
    private static int MIN_NUM_ENTRIES_TO_CONSIDER_COMPOUND_INDEX_USAGE = 30;
    private static int MIN_NUM_ENTRIES_TO_CONSIDER_ALL_VALUES_SCAN_USAGE = 10;
    private static int FIFO_GROUPS_RATIO = 10;
    private final Logger _logger;

    public FifoGroupCacheImpl(CacheManager cacheManager, Logger logger) {
        this._cacheManager = cacheManager;
        this._fgCacheHandeler = new FifoGroupsCacheHandler(this._cacheManager);
        this._logger = logger;
    }

    private IScanListIterator<IEntryCacheInfo> getScannableEntriesMinIndexFifoGroup(Context context, TypeData typeData, ITemplateHolder template, IStoredList<IEntryCacheInfo> res, boolean extendedMatch) {
        if (!res.isMultiObjectCollection()) {
            return res.getObjectFromHead();
        }
        TypeDataIndex<Object> fgIndex = typeData.getFifoGroupingIndex();
        if (res == typeData.getEntries()) {
            return new FifoGroupsScanAllValuesIterator<IEntryCacheInfo>(fgIndex.getFifoGroupsIndexExtention().getFifoGroupLists());
        }
        if (extendedMatch && res instanceof IFifoGroupIterator) {
            return (IScanListIterator)((Object)res);
        }
        TypeDataIndex indexUsed = context.getIndexUsedInFifoGroupScan(res);
        if (context.getIndexUsedInFifoGroupScan(res) == typeData.getFifoGroupingIndex()) {
            if (template.getExtendedMatchCodes() == null && template.getCustomQuery() == null && typeData.anyCompoundIndex() && res.size() >= MIN_NUM_ENTRIES_TO_CONSIDER_COMPOUND_INDEX_USAGE) {
                for (TypeDataIndex other : typeData.getCompoundIndexes()) {
                    if (other.getFifoGroupsIndexExtention() == null || other.getSegmentsOriginatingIndexes()[0].getIndexValueForTemplate(template.getEntryData()) == null) continue;
                    IStoredList<IEntryCacheInfo> list = other.getIndexEntries(other.getCompoundIndexValueForTemplate(template.getEntryData()));
                    return list != null ? new FifoGroupsScanByFGIndexIterator<IEntryCacheInfo>(list) : null;
                }
            }
            return new FifoGroupsScanByFGIndexIterator<IEntryCacheInfo>(res);
        }
        return FifoGroupCacheImpl.createScanIterOnNonFGIndex(res, template, indexUsed, typeData);
    }

    public static IScanListIterator<IEntryCacheInfo> createScanIterOnNonFGIndex(IStoredList<IEntryCacheInfo> entries, ITemplateHolder template, TypeDataIndex usedIndexForRes, TypeData typeData) {
        int num_entries = entries.size();
        TypeDataIndex<Object> fgIndex = typeData.getFifoGroupingIndex();
        if (usedIndexForRes.getCompoundFifoGroupsIndexForSegment() != null && num_entries >= MIN_NUM_ENTRIES_TO_CONSIDER_COMPOUND_INDEX_USAGE) {
            Object indexValue = usedIndexForRes.getIndexValueForTemplate(template.getEntryData());
            IStoredList<IEntryCacheInfo> list = null;
            if (template.getExtendedMatchCodes() == null && template.getCustomQuery() == null && fgIndex.getIndexValueForTemplate(template.getEntryData()) != null) {
                list = usedIndexForRes.getCompoundFifoGroupsIndexForSegment().getIndexEntries(usedIndexForRes.getCompoundFifoGroupsIndexForSegment().getCompoundIndexValueForTemplate(template.getEntryData()));
                return list != null ? new FifoGroupsScanByFGIndexIterator<IEntryCacheInfo>(list) : null;
            }
            list = usedIndexForRes.getCompoundFifoGroupsIndexForSegment().getFifoGroupsIndexExtention().getFifoGroupLists(indexValue);
            return list != null ? new FifoGroupsScanAllValuesByCompoundIndexIterator((IStoredList<Object>)list) : null;
        }
        return num_entries > MIN_NUM_ENTRIES_TO_CONSIDER_ALL_VALUES_SCAN_USAGE && template.isTakeOperation() && fgIndex.getFifoGroupsIndexExtention().getNumGroups() < num_entries / FIFO_GROUPS_RATIO ? new FifoGroupsScanAllValuesIterator(fgIndex.getFifoGroupsIndexExtention().getFifoGroupLists()) : new FifoGroupsScanByGeneralIndexIterator(typeData.getFifoGroupingIndex(), entries);
    }

    public IScanListIterator<IEntryCacheInfo> getScannableEntriesMinIndex(Context context, TypeData typeData, int numOfFields, ITemplateHolder template) {
        context.resetFifoGroupIndexUsedInFifoGroupScan();
        IStoredList<IEntryCacheInfo> res = this.getEntriesMinIndex(context, typeData, numOfFields, template);
        return res != null ? this.getScannableEntriesMinIndexFifoGroup(context, typeData, template, res, false) : null;
    }

    private IStoredList<IEntryCacheInfo> getEntriesMinIndex(Context context, TypeData typeData, int numOfFields, ITemplateHolder template) {
        if (!typeData.hasFifoGroupingIndex()) {
            return null;
        }
        context.setAnyFifoGroupIndex();
        return this._cacheManager.getEntriesMinIndex(context, typeData, numOfFields, template);
    }

    public IScanListIterator<IEntryCacheInfo> getScannableEntriesMinIndexExtended(Context context, TypeData entryType, int numOfFields, ITemplateHolder template) {
        context.setFifoGroupQueryContainsOrCondition(false);
        context.resetFifoGroupIndexUsedInFifoGroupScan();
        Object chosen = this.getEntriesMinIndexExtended(context, entryType, numOfFields, template);
        if (chosen == null) {
            return null;
        }
        if (chosen instanceof ExtendedIndexFifoGroupsIterator) {
            return (ExtendedIndexFifoGroupsIterator)chosen;
        }
        if (chosen instanceof MultiStoredList) {
            return new FifoGroupsMultiList<IEntryCacheInfo>((MultiStoredList)chosen, entryType, context.getFfoGroupIndexResultsUsedInFifoGroupScan(), template);
        }
        return chosen != null ? this.getScannableEntriesMinIndexFifoGroup(context, entryType, template, (IStoredList)chosen, true) : null;
    }

    private Object getEntriesMinIndexExtended(Context context, TypeData entryType, int numOfFields, ITemplateHolder template) {
        if (template.isFifoSearch()) {
            throw new UnsupportedOperationException(" fifo template cannot support fifo groups");
        }
        if (!entryType.hasFifoGroupingIndex()) {
            return null;
        }
        context.setAnyFifoGroupIndex();
        return this.getEntriesMinIndexExtended_impl(context, entryType, numOfFields, template);
    }

    private Object getEntriesMinIndexExtended_impl(Context context, TypeData entryType, int numOfFields, ITemplateHolder template) {
        TypeDataIndex index;
        int pos;
        TypeDataIndex[] indexes;
        IStoredList<IEntryCacheInfo> resultSL = null;
        IScanListIterator resultOIS = null;
        boolean ignoreOrderedIndexes = entryType.getEntries().size() < this._cacheManager.getMinExtendedIndexActivationSize();
        int latestIndexToConsider = entryType.getLastIndexCreationNumber();
        IObjectsList fifoGroupMainIndexResult = null;
        ICollection fgMainIndexEqResult = null;
        IEntryCacheInfo fgOtherIndexEqResult = null;
        TypeDataIndex fgOtherIndexEq = null;
        TypeDataIndex[] typeDataIndexArray = indexes = entryType.getIndexes();
        int n = typeDataIndexArray.length;
        block7: for (int i = 0; i < n && (pos = (index = typeDataIndexArray[i]).getPos()) < numOfFields; ++i) {
            boolean fifoGroupIndex;
            if (index.getIndexCreationNumber() > latestIndexToConsider) continue;
            short extendedMatchCode = template.getExtendedMatchCodes()[pos];
            boolean bl = fifoGroupIndex = template.isFifoGroupPoll() && index == entryType.getFifoGroupingIndex();
            if (!fifoGroupIndex && !TemplateMatchCodes.supportFifoOrder(extendedMatchCode)) continue;
            Object templateValue = index.getIndexValueForTemplate(template.getEntryData());
            IEntryCacheInfo entriesVector = null;
            switch (extendedMatchCode) {
                case 7: 
                case 8: {
                    continue block7;
                }
                case 6: {
                    entriesVector = index.getNullEntries();
                    if (resultSL != null && resultSL.size() <= entriesVector.size()) continue block7;
                    resultSL = entriesVector;
                    continue block7;
                }
                case 1: {
                    if (templateValue == null || (entriesVector = (IEntryCacheInfo)index.getNonUniqueEntriesStore().get(templateValue)) == null || entriesVector.size() != entryType.getEntries().size()) continue block7;
                    return null;
                }
                case 0: {
                    if (templateValue == null) continue block7;
                    entriesVector = entryType.disableIdIndexForEntries(index) ? this._cacheManager.getPEntryByUid(entryType.generateUid(templateValue)) : index.getIndexEntries(templateValue);
                    if (entriesVector == null) {
                        return null;
                    }
                    if (fifoGroupIndex) {
                        fgMainIndexEqResult = entriesVector;
                    } else if (fgOtherIndexEqResult == null && index.getCompoundFifoGroupsIndexForSegment() != null) {
                        fgOtherIndexEqResult = entriesVector;
                        fgOtherIndexEq = index;
                    }
                    if (resultSL != null && resultSL.size() <= entriesVector.size()) continue block7;
                    resultSL = entriesVector;
                    if (fifoGroupIndex) {
                        fifoGroupMainIndexResult = resultSL;
                    }
                    context.setFifoGroupIndexUsedInFifoGroupScan(entriesVector, index);
                    continue block7;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (templateValue == null || ignoreOrderedIndexes || index.getExtendedIndexForScanning() == null || resultOIS != null && !fifoGroupIndex) continue block7;
                    Object rangeValue = template.getRangeValue(pos);
                    boolean isInclusive = rangeValue == null ? false : template.getRangeInclusion(pos);
                    resultOIS = index.getExtendedFifoGroupsIndexForScanning().establishScan(templateValue, extendedMatchCode, rangeValue, isInclusive);
                    if (resultOIS == null) {
                        return null;
                    }
                    fifoGroupMainIndexResult = resultOIS;
                }
            }
        }
        ICustomQuery customQuery = template.getCustomQuery();
        if (customQuery != null && customQuery.getCustomIndexes() != null) {
            for (IQueryIndexScanner index2 : customQuery.getCustomIndexes()) {
                IObjectsList result = index2.getIndexedEntriesByType(context, entryType, template, latestIndexToConsider);
                if (result == IQueryIndexScanner.RESULT_IGNORE_INDEX) continue;
                if (result == IQueryIndexScanner.RESULT_NO_MATCH) {
                    return null;
                }
                if (result != null && result.isIterator()) {
                    resultOIS = (IScanListIterator)result;
                    if (!this._logger.isLoggable(Level.FINEST)) continue;
                    this._logger.log(Level.FINEST, "EXTENDED-INDEX '" + index2.getIndexName() + "' has been used for type [" + entryType.getClassName() + "]");
                    continue;
                }
                IStoredList entriesVector = (IStoredList)result;
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINEST, "BASIC-INDEX '" + index2.getIndexName() + "' has been used for type [" + entryType.getClassName() + "]");
                }
                if (entriesVector == null) {
                    return null;
                }
                if (resultSL != null && resultSL.size() <= entriesVector.size()) continue;
                resultSL = entriesVector;
            }
        }
        if (fifoGroupMainIndexResult != null && (fifoGroupMainIndexResult == resultOIS || fifoGroupMainIndexResult == resultSL)) {
            if (fifoGroupMainIndexResult == fgMainIndexEqResult && fgOtherIndexEqResult != null && fgMainIndexEqResult.size() >= MIN_NUM_ENTRIES_TO_CONSIDER_ALL_VALUES_SCAN_USAGE) {
                TypeDataIndex compound = fgOtherIndexEq.getCompoundFifoGroupsIndexForSegment();
                IStoredList<IEntryCacheInfo> res = compound.getIndexEntries(compound.getCompoundIndexValueForTemplate(template.getEntryData()));
                context.setFifoGroupIndexUsedInFifoGroupScan(res, entryType.getFifoGroupingIndex());
                return res;
            }
            return fifoGroupMainIndexResult;
        }
        if (resultSL == null) {
            if (resultOIS == null) {
                return entryType.getEntries();
            }
            return resultOIS;
        }
        if (resultOIS == null || resultSL.size() < entryType.getEntries().size()) {
            if (resultSL != null && resultSL == fgOtherIndexEqResult && fgMainIndexEqResult != null && resultSL.size() >= MIN_NUM_ENTRIES_TO_CONSIDER_ALL_VALUES_SCAN_USAGE) {
                TypeDataIndex compound = fgOtherIndexEq.getCompoundFifoGroupsIndexForSegment();
                IStoredList<IEntryCacheInfo> res = compound.getIndexEntries(compound.getCompoundIndexValueForTemplate(template.getEntryData()));
                context.setFifoGroupIndexUsedInFifoGroupScan(res, entryType.getFifoGroupingIndex());
                return res;
            }
            return resultSL;
        }
        return resultOIS;
    }

    public IScanListIterator<IEntryCacheInfo> getScannableEntriesByIndexValue(Context context, ITemplateHolder template, IEntryHolder entry, IServerTypeDesc templateTypeDesc) {
        IStoredList<IEntryCacheInfo> chosen;
        TypeData typeData = this._cacheManager.getTypeData(entry.getServerTypeDesc());
        if (!typeData.hasFifoGroupingIndex()) {
            return null;
        }
        Object groupToFind = typeData.getFifoGroupingIndex().getIndexValue(entry.getEntryData());
        if (groupToFind == null) {
            return null;
        }
        if (template.getExtendedMatchCodes() == null && template.getCustomQuery() == null && typeData.anyCompoundIndex()) {
            for (TypeDataIndex other : typeData.getCompoundIndexes()) {
                if (other.getFifoGroupsIndexExtention() == null || other.getSegmentsOriginatingIndexes()[0].getIndexValueForTemplate(template.getEntryData()) == null) continue;
                IStoredList<IEntryCacheInfo> list = other.getIndexEntries(other.getIndexValue(entry.getEntryData()));
                return list != null ? new FifoGroupsScanByFGIndexIterator<IEntryCacheInfo>(list) : null;
            }
        }
        if ((chosen = typeData.getFifoGroupingIndex().getIndexEntries(groupToFind)) == null) {
            return null;
        }
        return new FifoGroupsScanByFGIndexIterator<IEntryCacheInfo>(chosen);
    }

    public boolean testAndSetFGCacheForEntry(Context context, IEntryHolder entry, ITemplateHolder template, Object val, boolean testOnly) {
        return this._fgCacheHandeler.testAndSetFGCacheForEntry(context, entry, template, val, testOnly);
    }

    public void handleFifoGroupsCacheOnXtnEnd(Context context, XtnEntry xtnEntry) {
        Map<String, Object> emap = xtnEntry.getXtnData().getFifoGroupsEntries();
        if (emap == null || emap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> el : emap.entrySet()) {
            this._fgCacheHandeler.removeEntryFromFGCache(context, el.getKey(), el.getValue(), xtnEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TypeDataIndex> createFifoGroupCompoundIndexes(PropertyInfo[] _properties, Map<String, SpaceIndex> typeIndexes, ConcurrentHashMap<String, TypeDataIndex<?>> _indexTable, TypeDataIndex<Object> _fifoGroupIndex, ISpaceIndex fifoGroupingPropertyDef, TypeDataFactory typeDataFactory, int indexPosition, String fifoGroupingName, Set<String> fifoGroupingIndexes, List<CompoundIndex> compoundIndexDefinitions, IServerTypeDesc serverTypeDesc) {
        ArrayList<TypeDataIndex> res = new ArrayList<TypeDataIndex>();
        HashSet<String> propertiesIndexes = new HashSet<String>();
        RuntimeException exp = null;
        try {
            Object newIndex;
            CompoundIndex def;
            String compound_index_name;
            boolean create;
            ISpaceIndex.FifoGroupsIndexTypes indexFifoGroupingType;
            for (int i = 0; i < _properties.length; ++i) {
                PropertyInfo property = _properties[i];
                SpaceIndex index = typeIndexes.get(property.getName());
                if (index == null || !index.getIndexType().isIndexed()) continue;
                indexFifoGroupingType = TypeData.getIndexFifoGroupingType(index, fifoGroupingName, fifoGroupingIndexes);
                propertiesIndexes.add(index.getName());
                if (((ISpaceIndex)index).isMultiValuePerEntryIndex() || indexFifoGroupingType != ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY) continue;
                create = true;
                compound_index_name = property.getName() + Compound_Fifo_Groups_Index_Name_Suffix;
                def = (CompoundIndex)SpaceIndexFactory.createCompoundIndex(new String[]{property.getName(), _fifoGroupIndex.getIndexDefinition().getName()}, SpaceIndexType.EQUAL, compound_index_name, false);
                for (CompoundIndex c : compoundIndexDefinitions) {
                    if (!c.isEquivalent(def)) continue;
                    create = false;
                    break;
                }
                if (!create) continue;
                newIndex = TypeData.buildCompoundIndex(def, _indexTable, serverTypeDesc, indexPosition++, ISpaceIndex.FifoGroupsIndexTypes.COMPOUND, 0, typeDataFactory);
                _indexTable.put(compound_index_name, (TypeDataIndex<?>)newIndex);
                res.add((TypeDataIndex)newIndex);
            }
            if (typeIndexes != null) {
                for (Map.Entry<String, SpaceIndex> entry : typeIndexes.entrySet()) {
                    SpaceIndex spaceIndex;
                    if (propertiesIndexes.contains(entry.getKey()) || !(spaceIndex = entry.getValue()).getIndexType().isIndexed()) continue;
                    indexFifoGroupingType = TypeData.getIndexFifoGroupingType(spaceIndex, fifoGroupingName, fifoGroupingIndexes);
                    if (((ISpaceIndex)spaceIndex).isMultiValuePerEntryIndex() || indexFifoGroupingType != ISpaceIndex.FifoGroupsIndexTypes.AUXILIARY) continue;
                    create = true;
                    compound_index_name = spaceIndex.getName() + Compound_Fifo_Groups_Index_Name_Suffix;
                    def = (CompoundIndex)SpaceIndexFactory.createCompoundIndex(new String[]{spaceIndex.getName(), _fifoGroupIndex.getIndexDefinition().getName()}, SpaceIndexType.EQUAL, compound_index_name, false);
                    for (CompoundIndex c : compoundIndexDefinitions) {
                        if (!c.isEquivalent(def)) continue;
                        create = false;
                        break;
                    }
                    if (!create) continue;
                    newIndex = TypeData.buildCompoundIndex(def, _indexTable, serverTypeDesc, indexPosition++, ISpaceIndex.FifoGroupsIndexTypes.COMPOUND, 0, typeDataFactory);
                    _indexTable.put(compound_index_name, (TypeDataIndex<?>)newIndex);
                    res.add((TypeDataIndex)newIndex);
                }
            }
        }
        catch (Exception ex) {
            CacheManager.getCacheLogger().log(Level.SEVERE, "createFifoGroupCompoundIndexes failed with exception " + ex.fillInStackTrace() + "]");
            exp = new RuntimeException(ex);
            return exp;
        }
        finally {
            if (exp != null) {
                throw exp;
            }
            return res;
        }
    }

    public void incrementNumOfTemplates() {
        this._numOfTemplates.incrementAndGet();
    }

    public void decrementNumOfTemplates() {
        this._numOfTemplates.decrementAndGet();
    }

    public int getNumOfTemplates() {
        return this._numOfTemplates.get();
    }

    public Object aquireIndexLock(Object obj) {
        return this._fgCacheHandeler.aquireIndexLock(obj);
    }

    public void releaseIndexLock(Object lockObject) {
        this._fgCacheHandeler.releaseIndexLock(lockObject);
    }
}

