/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.storage.EntryHolder;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.ITransactionalEntryData;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.context.Context;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@InternalApi
public class FifoGroupsCacheHandler {
    private final FifoGroupsLockManager _lm = new FifoGroupsLockManager();
    private final CacheManager _cacheManager;

    public FifoGroupsCacheHandler(CacheManager cacheManager) {
        this._cacheManager = cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean testAndSetFGCacheForEntry(Context context, IEntryHolder entry, ITemplateHolder template, Object val, boolean testOnly) {
        List entries;
        FgCacheElement lock;
        ITemplateHolder lastRawmatchTemplate;
        IEntryHolder lastRawmatchEntry;
        ITransactionalEntryData lastRawMatchSnapshot;
        MatchResult matchResult;
        block14: {
            boolean bl;
            matchResult = context.getLastMatchResult();
            lastRawMatchSnapshot = context.getLastRawMatchSnapshot();
            lastRawmatchEntry = context.getLastRawmatchEntry();
            lastRawmatchTemplate = context.getLastRawmatchTemplate();
            lock = this._lm.aquireLock(val);
            try {
                FgCacheElement fgCacheElement = lock;
                // MONITORENTER : fgCacheElement
                entries = lock.getFGEntriesPerValue(val);
                if (entries == null) break block14;
                for (FgCacheElementEntryHolder e : entries) {
                    MatchResult match;
                    IEntryHolder curEntry;
                    XtnStatus entryWriteLockStatus = e._xtn.getStatus();
                    if (entryWriteLockStatus == XtnStatus.COMMITED || entryWriteLockStatus == XtnStatus.COMMITING || entryWriteLockStatus == XtnStatus.PREPARED && ((FgCacheElementEntryHolder)e)._xtn.m_SingleParticipant || entryWriteLockStatus == XtnStatus.ROLLED || entryWriteLockStatus == XtnStatus.ROLLING && !((FgCacheElementEntryHolder)e)._xtn.m_AlreadyPrepared || (curEntry = e._entry).isDeleted() || this._cacheManager.getTypeData(entry.getServerTypeDesc()).getFifoGroupingIndex() != this._cacheManager.getTypeData(curEntry.getServerTypeDesc()).getFifoGroupingIndex()) continue;
                    if ((template.isEmptyTemplate() || template.getEntryData().getNumOfFixedProperties() <= curEntry.getEntryData().getNumOfFixedProperties()) && ((match = template.match(this._cacheManager, curEntry, -1, null, false, context, this._cacheManager.getEngine().getTemplateScanner().getRegexCache())) == MatchResult.SHADOW || match == MatchResult.MASTER_AND_SHADOW || match == MatchResult.MASTER && context.getLastRawMatchSnapshot().getOtherUpdateUnderXtnEntry() == null)) {
                        if (template.getXidOriginated() == e._xtn) continue;
                        boolean bl2 = false;
                        // MONITOREXIT : fgCacheElement
                        if (lock != null) {
                            this._lm.releaseLock(lock);
                        }
                        context.setRawmatchResult(lastRawMatchSnapshot, matchResult, lastRawmatchEntry, lastRawmatchTemplate);
                        return bl2;
                    }
                    if (!e._holdingTemplate.isEmptyTemplate() && e._holdingTemplate.getEntryData().getNumOfFixedProperties() > entry.getEntryData().getNumOfFixedProperties() || (match = e._holdingTemplate.match(this._cacheManager, entry, -1, null, true, context, this._cacheManager.getEngine().getTemplateScanner().getRegexCache())) != MatchResult.SHADOW && match != MatchResult.MASTER_AND_SHADOW && (match != MatchResult.MASTER || context.getLastRawMatchSnapshot().getOtherUpdateUnderXtnEntry() != null)) continue;
                    bl = false;
                }
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    this._lm.releaseLock(lock);
                }
                context.setRawmatchResult(lastRawMatchSnapshot, matchResult, lastRawmatchEntry, lastRawmatchTemplate);
                throw throwable;
            }
            {
                // MONITOREXIT : fgCacheElement
                if (lock != null) {
                    this._lm.releaseLock(lock);
                }
                context.setRawmatchResult(lastRawMatchSnapshot, matchResult, lastRawmatchEntry, lastRawmatchTemplate);
                return bl;
            }
        }
        if (!testOnly) {
            lock.addToFGEntriesPerValue(val, entry, template.getXidOriginated(), entries, template);
        }
        boolean bl = true;
        // MONITOREXIT : fgCacheElement
        if (lock != null) {
            this._lm.releaseLock(lock);
        }
        context.setRawmatchResult(lastRawMatchSnapshot, matchResult, lastRawmatchEntry, lastRawmatchTemplate);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryFromFGCache(Context context, String uid, Object val, XtnEntry xtnEntry) {
        FgCacheElement lock = this._lm.aquireLock(val);
        try {
            FgCacheElement fgCacheElement = lock;
            synchronized (fgCacheElement) {
                lock.removeFromFGEntriesPerValue(val, uid, xtnEntry);
            }
        }
        finally {
            if (lock != null) {
                this._lm.releaseLock(lock);
            }
        }
    }

    public Object aquireIndexLock(Object obj) {
        return this._lm.aquireIndexLock(obj);
    }

    public void releaseIndexLock(Object lockObject) {
        this._lm.releaseIndexLock(lockObject);
    }

    private static class FifoGroupsLockManager {
        private static final int FIFO_GROUP_CACHE_FACTOR = 10;
        private static final int NUMBER_OF_FIFO_GROUPS_LOCKS = 1024;
        private static final int CACHE_POS_COMPUTE = 1023;
        private final FgCacheElement[] _locks = new FgCacheElement[1024];
        private final Object[] _indexLocks = new Object[1024];

        public FifoGroupsLockManager() {
            for (int i = 0; i < this._locks.length; ++i) {
                this._locks[i] = new FgCacheElement();
                this._indexLocks[i] = new Object();
            }
        }

        public FgCacheElement aquireLock(Object obj) {
            return this._locks[obj.hashCode() & 0x3FF];
        }

        public void releaseLock(FgCacheElement lockObject) {
        }

        public Object aquireIndexLock(Object obj) {
            return this._indexLocks[obj.hashCode() & 0x3FF];
        }

        public void releaseIndexLock(Object lockObject) {
        }
    }

    private static class FgCacheElementEntryHolder {
        private IEntryHolder _entry;
        private XtnEntry _xtn;
        private ITemplateHolder _holdingTemplate;
        private final boolean _fromPool;
        private FgCacheElementEntryHolder _next;

        public FgCacheElementEntryHolder() {
            this(null, null, false);
        }

        public FgCacheElementEntryHolder(IEntryHolder entry, XtnEntry xtn, boolean fromPool) {
            this._entry = entry;
            this._xtn = xtn;
            this._fromPool = fromPool;
        }

        public void setValues(IEntryHolder entry, XtnEntry xtn, ITemplateHolder holdingTemplate) {
            this._entry = entry;
            this._xtn = xtn;
            this._holdingTemplate = holdingTemplate;
        }

        public void resetValues() {
            this._entry = null;
            this._xtn = null;
            this._holdingTemplate = null;
        }

        public void toPool(FgCacheElement ce) {
            this._next = ce._holdersPool;
            this.resetValues();
            ce._holdersPool = this;
        }

        public static FgCacheElementEntryHolder fromPool(FgCacheElement ce) {
            FgCacheElementEntryHolder ans = ce._holdersPool;
            if (ans != null) {
                ce._holdersPool = ans._next;
                ans._next = null;
            }
            return ans;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            FgCacheElementEntryHolder other = (FgCacheElementEntryHolder)o;
            return this._entry.getUID() == other._entry.getUID() && this._xtn == other._xtn;
        }

        public int hashCode() {
            return this._entry.getUID().hashCode();
        }
    }

    private static class FgCacheElement {
        private final HashMap<Object, List<FgCacheElementEntryHolder>> _fgValueHolders = new HashMap();
        private final FgCacheElementEntryHolder _elementEntryHolderForRemoves = new FgCacheElementEntryHolder();
        private FgCacheElementEntryHolder _holdersPool;
        private final IEntryHolder _dummyEH = new EntryHolder(null, null, 0L, false, null);
        private boolean _poolInitiated;
        private static final int HOLDERRS_PER_SEGMENT_POOL_SIZE = 5;

        private List<FgCacheElementEntryHolder> getFGEntriesPerValue(Object val) {
            return this._fgValueHolders.get(val);
        }

        private void addToFGEntriesPerValue(Object val, IEntryHolder entry, XtnEntry xtn, List<FgCacheElementEntryHolder> entries, ITemplateHolder template) {
            if (!this._poolInitiated) {
                this._poolInitiated = true;
                for (int i = 0; i < 5; ++i) {
                    FgCacheElementEntryHolder h = new FgCacheElementEntryHolder(null, null, true);
                    h.toPool(this);
                }
            }
            if (entries == null) {
                entries = new ArrayList<FgCacheElementEntryHolder>(1);
                this._fgValueHolders.put(val, entries);
            }
            FgCacheElementEntryHolder h = this._holdersPool != null ? FgCacheElementEntryHolder.fromPool(this) : new FgCacheElementEntryHolder();
            h.setValues(new EntryHolder(entry.getServerTypeDesc(), entry.getUID(), 0L, entry.isTransient(), entry.getTxnEntryData()), xtn, template);
            entries.add(h);
        }

        private void removeFromFGEntriesPerValue(Object val, String uid, XtnEntry xtn) {
            List<FgCacheElementEntryHolder> vals = this._fgValueHolders.get(val);
            if (vals != null) {
                this._dummyEH.setUID(uid);
                this._elementEntryHolderForRemoves.setValues(this._dummyEH, xtn, null);
                FgCacheElementEntryHolder cur = vals.remove(vals.indexOf(this._elementEntryHolderForRemoves));
                this._elementEntryHolderForRemoves.resetValues();
                if (cur._fromPool) {
                    cur.toPool(this);
                }
                if (vals.isEmpty()) {
                    this._fgValueHolders.remove(val);
                }
            }
        }
    }
}

