/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.FifoGroupCacheImpl;
import com.j_spaces.core.cache.fifoGroup.FifoGroupsBackRefsSingleEntryHolder;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupsIndexExtention;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupsListHolder;
import com.j_spaces.kernel.IObjectInfo;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.StoredListFactory;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@InternalApi
public class FifoGroupsMainIndexExtention<K>
implements IFifoGroupsIndexExtention<K> {
    private final TypeDataIndex<K> _index;
    private final IStoredList<Object> _fifoGroupValues;
    private final ConcurrentMap<Object, IObjectInfo<IEntryCacheInfo>> _fifoGroupsBackrefs;
    private final FifoGroupCacheImpl _fifoGroupsCacheImpl;

    public FifoGroupsMainIndexExtention(CacheManager cacheManager, TypeDataIndex<K> index) {
        this._index = index;
        this._fifoGroupValues = StoredListFactory.createConcurrentSegmentedList(true);
        this._fifoGroupsBackrefs = new ConcurrentHashMap<Object, IObjectInfo<IEntryCacheInfo>>();
        this._fifoGroupsCacheImpl = cacheManager.getFifoGroupCacheImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType) {
        if (fieldValue == null) {
            this._index.insertEntryIndexedField_impl(pEntry, fieldValue, pType, pEntry.getBackRefs());
            return;
        }
        Object lockObject = this._fifoGroupsCacheImpl.aquireIndexLock(fieldValue);
        try {
            Object object = lockObject;
            synchronized (object) {
                this._index.insertEntryIndexedField_impl(pEntry, fieldValue, pType, pEntry.getBackRefs());
            }
        }
        finally {
            this._fifoGroupsCacheImpl.releaseIndexLock(lockObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertEntryIndexedField(IEntryCacheInfo pEntry, K fieldValue, TypeData pType, ArrayList<IObjectInfo<IEntryCacheInfo>> insertBackRefs) {
        if (fieldValue == null) {
            this._index.insertEntryIndexedField_impl(pEntry, fieldValue, pType, insertBackRefs);
            return;
        }
        Object lockObject = this._fifoGroupsCacheImpl.aquireIndexLock(fieldValue);
        try {
            Object object = lockObject;
            synchronized (object) {
                this._index.insertEntryIndexedField_impl(pEntry, fieldValue, pType, insertBackRefs);
            }
        }
        finally {
            this._fifoGroupsCacheImpl.releaseIndexLock(lockObject);
        }
    }

    @Override
    public void addToValuesList(K groupValue, IStoredList list) {
        if (groupValue == null) {
            return;
        }
        IObjectInfo<Object> fgoi = this._fifoGroupValues.add(new PlainFGListHolder(groupValue, list));
        this._fifoGroupsBackrefs.put(list.isMultiObjectCollection() ? list : new FifoGroupsBackRefsSingleEntryHolder(list, groupValue), fgoi);
    }

    @Override
    public void removeFromValuesList(K groupValue, IStoredList list) {
        if (groupValue == null) {
            return;
        }
        IObjectInfo fgoi = (IObjectInfo)this._fifoGroupsBackrefs.remove(list.isMultiObjectCollection() ? list : new FifoGroupsBackRefsSingleEntryHolder(list, groupValue));
        this._fifoGroupValues.remove(fgoi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeEntryIndexedField(IEntryHolder eh, ArrayList<IObjectInfo<IEntryCacheInfo>> deletedBackRefs, K fieldValue, int refpos, boolean removeIndexedValue, IEntryCacheInfo pEntry) {
        if (fieldValue == null) {
            return this._index.removeEntryIndexedField_impl(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
        }
        Object lockObject = this._fifoGroupsCacheImpl.aquireIndexLock(fieldValue);
        try {
            Object object = lockObject;
            synchronized (object) {
                int n = this._index.removeEntryIndexedField_impl(eh, deletedBackRefs, fieldValue, refpos, removeIndexedValue, pEntry);
                return n;
            }
        }
        finally {
            this._fifoGroupsCacheImpl.releaseIndexLock(lockObject);
        }
    }

    @Override
    public IStoredList getFifoGroupLists() {
        return this._fifoGroupValues;
    }

    @Override
    public IStoredList getFifoGroupLists(Object otherIndexValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumGroups() {
        return this._fifoGroupValues.size();
    }

    public static class PlainFGListHolder
    implements IFifoGroupsListHolder {
        private final Object _mainGroupValue;
        private final IStoredList _list;

        public PlainFGListHolder(Object key, IStoredList list) {
            this._mainGroupValue = key;
            this._list = list;
        }

        @Override
        public Object getMainGroupValue() {
            return this._mainGroupValue;
        }

        @Override
        public Object getOtherIndexValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IStoredList getList() {
            return this._list;
        }
    }
}

