/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupIterator;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupsListHolder;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;

@InternalApi
public class FifoGroupsScanAllValuesIterator<T>
implements IFifoGroupIterator<T> {
    private ScanSingleListIterator<Object> _entriesIter;
    private IScanListIterator<T> _curValueList;
    private ScanSingleListIterator<T> _lastIterUsed;
    private IFifoGroupsListHolder _curValueListHolder;

    public FifoGroupsScanAllValuesIterator(IStoredList<Object> entries) {
        this._entriesIter = new ScanSingleListIterator<Object>(entries, false);
    }

    @Override
    public boolean hasNext() throws SAException {
        while (this._entriesIter != null) {
            if (this._curValueList != null) {
                if (this._curValueList.hasNext()) {
                    return true;
                }
                this._curValueList.releaseScan();
                this._curValueList = null;
            }
            if (this._entriesIter != null && this._entriesIter.hasNext()) {
                Object nxt = this._entriesIter.next();
                IStoredList nextList = this.getActualList(nxt);
                if (nextList == null) continue;
                if (this._lastIterUsed == null) {
                    this._curValueList = new ScanSingleListIterator(nextList, true);
                    this._lastIterUsed = (ScanSingleListIterator)this._curValueList;
                    continue;
                }
                this._curValueList = this._lastIterUsed;
                this._lastIterUsed.reuse(nextList);
                continue;
            }
            this.releaseScan();
        }
        return false;
    }

    @Override
    public T next() throws SAException {
        return this._curValueList.next();
    }

    @Override
    public void nextGroup() throws SAException {
        this._curValueListHolder = null;
        if (this._curValueList != null) {
            this._curValueList.releaseScan();
            this._curValueList = null;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() throws SAException {
        if (this._curValueList != null) {
            this._curValueList.releaseScan();
            this._curValueList = null;
        }
        if (this._entriesIter != null) {
            this._entriesIter.releaseScan();
            this._entriesIter = null;
        }
        this._curValueListHolder = null;
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }

    protected IStoredList getActualList(Object candidate) {
        this._curValueListHolder = (IFifoGroupsListHolder)candidate;
        return this._curValueListHolder.getList();
    }
}

