/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.cache.fifoGroup;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cache.IEntryCacheInfo;
import com.j_spaces.core.cache.TypeDataIndex;
import com.j_spaces.core.cache.fifoGroup.IFifoGroupIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.IStoredList;
import com.j_spaces.kernel.list.IScanListIterator;
import com.j_spaces.kernel.list.ScanSingleListIterator;
import java.util.HashSet;

@InternalApi
public class FifoGroupsScanByGeneralIndexIterator
implements IFifoGroupIterator<IEntryCacheInfo> {
    private final TypeDataIndex<Object> _f_g_index;
    private HashSet<Object> _alreadyUsedGroupValues;
    private Object _curGroupValue;
    private final Object _onlyGroupValue;
    private IScanListIterator<IEntryCacheInfo> _curValueList;

    public FifoGroupsScanByGeneralIndexIterator(TypeDataIndex<Object> f_g_index, IStoredList<IEntryCacheInfo> entries) {
        this(f_g_index, entries, null);
    }

    public FifoGroupsScanByGeneralIndexIterator(TypeDataIndex<Object> f_g_index, IStoredList<IEntryCacheInfo> entries, Object onlyGroupValue) {
        this._f_g_index = f_g_index;
        this._onlyGroupValue = onlyGroupValue;
        this._curValueList = new ScanSingleListIterator<IEntryCacheInfo>(entries, true);
    }

    @Override
    public boolean hasNext() throws SAException {
        if (this._curValueList != null) {
            if (this._curValueList.hasNext()) {
                return true;
            }
            this._curValueList.releaseScan();
            this._curValueList = null;
        }
        return false;
    }

    @Override
    public IEntryCacheInfo next() throws SAException {
        if (this._curValueList == null) {
            return null;
        }
        IEntryCacheInfo res = null;
        while (true) {
            if ((res = this._curValueList.next()) != null) {
                Object groupValue = this._f_g_index.getIndexValue(res.getEntryHolder(this._f_g_index.getCacheManager()).getEntryData());
                if (this._onlyGroupValue != null && !this._onlyGroupValue.equals(groupValue)) continue;
                if (this._alreadyUsedGroupValues == null || !this._alreadyUsedGroupValues.contains(groupValue)) {
                    this._curGroupValue = groupValue;
                    return res;
                }
            }
            if (!this._curValueList.hasNext()) break;
        }
        this._curValueList.releaseScan();
        this._curValueList = null;
        return null;
    }

    @Override
    public void nextGroup() throws SAException {
        if (this._curGroupValue != null) {
            if (this._alreadyUsedGroupValues == null) {
                this._alreadyUsedGroupValues = new HashSet();
            }
            this._alreadyUsedGroupValues.add(this._curGroupValue);
            this._curGroupValue = null;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseScan() throws SAException {
        if (this._curValueList != null) {
            this._curValueList.releaseScan();
            this._curValueList = null;
        }
    }

    @Override
    public int getAlreadyMatchedFixedPropertyIndexPos() {
        return -1;
    }

    @Override
    public String getAlreadyMatchedIndexPath() {
        return null;
    }

    @Override
    public boolean isAlreadyMatched() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return true;
    }
}

