/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.SpaceRemoteEvent;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.nio.LRMIMethodTrackingIdProvider;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.OperationID;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.entry.UnusableEntryException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class EntryArrivedRemoteEvent
extends SpaceRemoteEvent
implements Cloneable,
LRMIMethodTrackingIdProvider {
    private static final long serialVersionUID = -8397537059416989796L;
    private int _notifyType;
    protected String _templateUID;
    private QueryResultTypeInternal _resultType;
    private Uuid _spaceProxyUuid;
    private IEntryPacket _entryPacket;
    private List<String> _acceptableFilterIDList;
    private boolean _fromReplication;
    protected transient IJSpace _spaceProxy;
    private static final int FLAG_EVENT_ID = 1;
    private static final int FLAG_SEQ_NUM = 2;
    private static final int FLAG_NOTIFY_TYPE = 4;
    private static final int FLAG_TEMPLATE_UID = 8;
    private static final int FLAG_SPACE_PROXY_UUID = 16;
    private static final int FLAG_ENTRY_PACKET = 32;
    private static final int FLAG_HANDBACK = 64;
    private static final int FLAG_FROM_REPLICATION = 128;
    private static final int FLAG_FILTER_ID_LIST = 256;
    private static final int FLAG_RESULT_ENTRY_TYPE = 512;
    private static final int FLAG_OLD_ENTRY_PACKET = 1024;

    public EntryArrivedRemoteEvent() {
    }

    public EntryArrivedRemoteEvent(IJSpace source, long eventID, long seqNum, MarshalledObject handback, IEntryPacket entryPacket, IEntryPacket oldEntryPacket, NotifyActionType notifyType, boolean fromReplication, String templateUID, QueryResultTypeInternal resultType) {
        super("", eventID, seqNum, handback);
        this._notifyType = notifyType.getModifier();
        this._entryPacket = EntryArrivedRemoteEvent.initEntryPacket(entryPacket, oldEntryPacket, this._notifyType);
        this._spaceProxy = source;
        this._spaceProxyUuid = this._spaceProxy.getReferentUuid();
        this._fromReplication = fromReplication;
        this._templateUID = templateUID;
        this._resultType = resultType;
    }

    private static IEntryPacket initEntryPacket(IEntryPacket entryPacket, IEntryPacket oldEntryPacket, int notifyType) {
        IEntryPacket result = entryPacket;
        if (notifyType == NotifyActionType.NOTIFY_UNMATCHED.getModifier()) {
            result = oldEntryPacket;
            if (oldEntryPacket.getTypeDescriptor() == null) {
                oldEntryPacket.setTypeDesc(entryPacket.getTypeDescriptor(), entryPacket.isSerializeTypeDesc());
            }
        }
        return result;
    }

    public IEntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    public Object getSource() {
        return this._spaceProxy;
    }

    public OperationID getOperationID() {
        if (this._entryPacket == null) {
            return null;
        }
        return this._entryPacket.getOperationID();
    }

    public Uuid getSpaceUuid() {
        return this._spaceProxyUuid;
    }

    public Object getObject() throws UnusableEntryException {
        return this._entryPacket.toObject(this._resultType);
    }

    @Deprecated
    public int getNotifyType() {
        return this._notifyType;
    }

    public NotifyActionType getNotifyActionType() {
        return NotifyActionType.fromModifier(this._notifyType);
    }

    public MarshalledObject getRegistrationObject() {
        return this.handback;
    }

    void setHandback(MarshalledObject handback) {
        this.handback = handback;
    }

    public void setSpaceProxy(IJSpace spaceProxy) {
        this._spaceProxy = spaceProxy;
        if (this._entryPacket != null) {
            spaceProxy.getDirectProxy().getTypeManager().loadTypeDescToPacket(this._entryPacket);
        }
    }

    void setSequenceNumber(long sequenceNumber) {
        this.seqNum = sequenceNumber;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected void setSpaceProxyUuid(Uuid spaceProxyUuid) {
        this._spaceProxyUuid = spaceProxyUuid;
    }

    void initAcceptableFilterList(int capacity) {
        if (this._acceptableFilterIDList == null && capacity > 0) {
            this._acceptableFilterIDList = new ArrayList<String>(capacity);
        }
    }

    void addAcceptableFilterID(String destID) {
        this.initAcceptableFilterList(1);
        this._acceptableFilterIDList.add(destID);
    }

    List<?> getAcceptableFilterList() {
        return this._acceptableFilterIDList;
    }

    public String getTemplateUID() {
        return this._templateUID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this._spaceProxy != null) {
            sb.append(" [Source space: ").append(this._spaceProxy.getName()).append("]");
        }
        sb.append("\n [ EventId: ").append(this.eventID).append("]");
        sb.append("\n [ SeqId: ").append(this.seqNum).append("]");
        sb.append("\n [ NotifyType: ").append(this._notifyType).append("]");
        sb.append("\n [ SpaceUUID: ").append(this._spaceProxyUuid).append("]");
        return sb.toString();
    }

    public boolean isFromReplication() {
        return this._fromReplication;
    }

    public String getKey() {
        if (this._templateUID != null) {
            return this._templateUID;
        }
        return Long.toString(this.getID());
    }

    @Override
    protected void writeExternal(ObjectOutput out, PlatformLogicalVersion version) throws IOException {
        super.writeExternal(out, version);
        this.writeExternalV9_0_2(out);
    }

    @Override
    protected void readExternal(ObjectInput in, PlatformLogicalVersion version) throws IOException, ClassNotFoundException {
        super.readExternal(in, version);
        this.readExternalV9_0_2(in);
    }

    private int buildFlags() {
        int flags = 0;
        if (this.eventID != 0L) {
            flags |= 1;
        }
        if (this.seqNum != 0L) {
            flags |= 2;
        }
        if (this._notifyType != 0) {
            flags |= 4;
        }
        if (this._templateUID != null) {
            flags |= 8;
        }
        if (this._spaceProxyUuid != null) {
            flags |= 0x10;
        }
        if (this._entryPacket != null) {
            flags |= 0x20;
        }
        if (this.handback != null) {
            flags |= 0x40;
        }
        if (this._fromReplication) {
            flags |= 0x80;
        }
        if (this._acceptableFilterIDList != null && this._acceptableFilterIDList.size() != 0) {
            flags |= 0x100;
        }
        if (this._resultType != null) {
            flags |= 0x200;
        }
        return flags;
    }

    private void writeExternalV9_0_2(ObjectOutput out) throws IOException {
        int filterLength;
        int flags = this.buildFlags();
        out.writeInt(flags);
        if (this.eventID != 0L) {
            out.writeLong(this.eventID);
        }
        if (this.seqNum != 0L) {
            out.writeLong(this.seqNum);
        }
        if (this._notifyType != 0) {
            out.writeInt(this._notifyType);
        }
        if (this._templateUID != null) {
            IOUtils.writeString(out, this._templateUID);
        }
        if (this._resultType != null) {
            out.writeByte(this._resultType.getCode());
        }
        if (this._spaceProxyUuid != null) {
            out.writeLong(this._spaceProxyUuid.getMostSignificantBits());
            out.writeLong(this._spaceProxyUuid.getLeastSignificantBits());
        }
        if (this._entryPacket != null) {
            IOUtils.writeObject(out, this._entryPacket);
        }
        if (this.handback != null) {
            IOUtils.writeObject(out, this.handback);
        }
        int n = filterLength = this._acceptableFilterIDList == null ? 0 : this._acceptableFilterIDList.size();
        if (filterLength != 0) {
            out.writeInt(filterLength);
            for (int i = 0; i < filterLength; ++i) {
                String filterId = this._acceptableFilterIDList.get(i);
                IOUtils.writeString(out, filterId);
            }
        }
        this._acceptableFilterIDList = null;
    }

    private void readExternalV9_0_2(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        boolean bl = this._fromReplication = (flags & 0x80) != 0;
        if ((flags & 1) != 0) {
            this.eventID = in.readLong();
        }
        if ((flags & 2) != 0) {
            this.seqNum = in.readLong();
        }
        if ((flags & 4) != 0) {
            this._notifyType = in.readInt();
        }
        if ((flags & 8) != 0) {
            this._templateUID = IOUtils.readString(in);
        }
        if ((flags & 0x200) != 0) {
            this._resultType = QueryResultTypeInternal.fromCode(in.readByte());
        }
        if ((flags & 0x10) != 0) {
            long msb = in.readLong();
            long lsb = in.readLong();
            this._spaceProxyUuid = UuidFactory.create((long)msb, (long)lsb);
        }
        if ((flags & 0x20) != 0) {
            this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
        }
        if ((flags & 0x40) != 0) {
            this.handback = (MarshalledObject)IOUtils.readObject(in);
        }
        if ((flags & 0x100) != 0) {
            int filterLength = in.readInt();
            this._acceptableFilterIDList = new ArrayList<String>(filterLength);
            for (int i = 0; i < filterLength; ++i) {
                String filterId = IOUtils.readString(in);
                this._acceptableFilterIDList.add(filterId);
            }
        }
    }

    @Override
    public String getLRMIMethodTrackingId() {
        return "notify";
    }
}

