/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.io.IOUtils;
import com.j_spaces.core.EntrySerializationException;
import com.j_spaces.core.IGSEntry;
import com.j_spaces.core.IJSpace;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;

@Deprecated
public class ExternalEntry
implements Entry,
IGSEntry,
Cloneable {
    private static final long serialVersionUID = 1L;
    public String m_UID;
    public String m_ClassName;
    public String[] m_SuperClassesNames;
    public String[] m_FieldsNames;
    public String[] m_FieldsTypes;
    public Object[] m_FieldsValues;
    public boolean[] m_IndexIndicators;
    public String m_PrimaryKeyName;
    public boolean m_Replicatable;
    public String[] m_MultipleUIDs;
    public boolean m_ReturnOnlyUids;
    public boolean m_isFifo;
    public int m_VersionID;
    public short[] m_ExtendedMatchCodes;
    public Object[] m_RangeValues;
    public boolean[] m_RangeValuesInclusion;
    public long m_TimeToLive = Long.MAX_VALUE;
    public boolean m_isTransient;
    public boolean m_NOWriteLeaseMode;
    public String routingFieldName;
    public boolean[] _primitiveFields;
    public boolean _returnTrueType;

    public ExternalEntry() {
    }

    public ExternalEntry(String entryUID) {
        this.m_UID = entryUID;
    }

    protected ExternalEntry(ExternalEntry entry) {
        this.m_UID = entry.m_UID;
        this.m_ClassName = entry.m_ClassName;
        this.m_SuperClassesNames = entry.m_SuperClassesNames;
        this.m_FieldsNames = entry.m_FieldsNames;
        this.m_FieldsTypes = entry.m_FieldsTypes;
        this.m_FieldsValues = entry.m_FieldsValues;
        this.m_IndexIndicators = entry.m_IndexIndicators;
        this.m_PrimaryKeyName = entry.m_PrimaryKeyName;
        this.m_Replicatable = entry.m_Replicatable;
        this.m_MultipleUIDs = entry.m_MultipleUIDs;
        this.m_ReturnOnlyUids = entry.m_ReturnOnlyUids;
        this.m_isFifo = entry.m_isFifo;
        this.m_VersionID = entry.m_VersionID;
        this.m_ExtendedMatchCodes = entry.m_ExtendedMatchCodes;
        this.m_RangeValues = entry.m_RangeValues;
        this.m_RangeValuesInclusion = entry.m_RangeValuesInclusion;
        this.m_TimeToLive = entry.m_TimeToLive;
        this.m_isTransient = entry.m_isTransient;
        this.m_NOWriteLeaseMode = entry.m_NOWriteLeaseMode;
        this.routingFieldName = entry.routingFieldName;
    }

    public ExternalEntry(String[] multipleUIDs) {
        this.m_MultipleUIDs = multipleUIDs;
    }

    public ExternalEntry(String className, Object[] fieldsValues, String[] fieldsNames, String[] fieldsTypes) {
        this(className, fieldsValues, fieldsNames);
        this.m_FieldsTypes = fieldsTypes;
    }

    public ExternalEntry(String className, Object[] fieldsValues, String[] fieldsNames) {
        int names_size;
        if (className == null) {
            throw new RuntimeException("ExternalEntry problem, Class Name is NULL !");
        }
        this.m_ClassName = className;
        int values_size = fieldsValues == null ? 0 : fieldsValues.length;
        int n = names_size = fieldsNames == null ? 0 : fieldsNames.length;
        if (values_size != 0 && names_size != 0 && values_size != names_size) {
            throw new RuntimeException("ExternalEntry problem, values do not match fields names !");
        }
        this.m_FieldsValues = fieldsValues;
        this.m_FieldsNames = fieldsNames;
    }

    public ExternalEntry(String className, Object[] fieldsValues) {
        this(className, fieldsValues, null);
    }

    public boolean[] getPrimitiveFields() {
        return this._primitiveFields;
    }

    public boolean hasExtendedInfo() {
        return this._returnTrueType || this.m_RangeValues != null || this.m_ExtendedMatchCodes != null || this.m_RangeValuesInclusion != null;
    }

    private void writePrimitiveObject(ObjectOutput out, Object obj, int indexField) {
        try {
            IOUtils.writeObject(out, obj);
        }
        catch (IOException ex) {
            String fieldName = "";
            String fieldValue = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[indexField] != null) {
                fieldName = "\nField Name      : " + this.m_FieldsNames[indexField];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[indexField] != null) {
                fieldValue = "\nField Type     : " + this.m_FieldsValues[indexField].getClass().getName();
            }
            throw new EntrySerializationException("Failed to serialize Entry field.\nEntry Class name : " + this.m_ClassName + fieldValue + fieldName, ex);
        }
    }

    private Object readPrimitiveObject(ObjectInput in, int indexField) throws IOException, ClassNotFoundException {
        try {
            return IOUtils.readObject(in);
        }
        catch (IOException ex) {
            String fieldName = "";
            String fieldValue = "";
            if (this.m_FieldsNames != null && this.m_FieldsNames[indexField] != null) {
                fieldName = "\nField Name      : " + this.m_FieldsNames[indexField];
            }
            if (this.m_FieldsValues != null && this.m_FieldsValues[indexField] != null) {
                fieldValue = "\nField Type     : " + this.m_FieldsValues[indexField].getClass().getName();
            }
            throw new EntrySerializationException("Failed to deserialize Entry field.\nEntry Classname : " + this.m_ClassName + fieldValue + fieldName, ex);
        }
    }

    private int buildFlags() {
        int flags = 0;
        if (this.m_UID != null) {
            flags |= 0x10000000;
        }
        if (this.m_ClassName != null) {
            flags |= 0x20000000;
        }
        if (this.m_SuperClassesNames != null) {
            flags |= 0x40000000;
        }
        if (this.m_FieldsNames != null) {
            flags |= Integer.MIN_VALUE;
        }
        if (this.m_FieldsTypes != null) {
            flags |= 0x1000000;
        }
        if (this.m_FieldsValues != null) {
            flags |= 0x2000000;
        }
        if (this.m_IndexIndicators != null) {
            flags |= 0x4000000;
        }
        if (this.m_Replicatable) {
            flags |= 0x8000000;
        }
        if (this.m_MultipleUIDs != null) {
            flags |= 0x100000;
        }
        if (this.m_ReturnOnlyUids) {
            flags |= 0x200000;
        }
        if (this.m_isFifo) {
            flags |= 0x400000;
        }
        if (this.m_ExtendedMatchCodes != null) {
            flags |= 0x800000;
        }
        if (this.m_RangeValues != null) {
            flags |= 0x10000;
        }
        if (this.m_RangeValuesInclusion != null) {
            flags |= 0x1000;
        }
        if (this.m_TimeToLive != 0L) {
            flags |= 0x20000;
        }
        if (this.m_isTransient) {
            flags |= 0x40000;
        }
        if (this.m_NOWriteLeaseMode) {
            flags |= 0x80000;
        }
        return flags;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            int i;
            out.writeInt(this.buildFlags());
            if (this.m_UID != null) {
                out.writeUTF(this.m_UID);
                out.writeInt(this.m_VersionID);
                if (this.m_TimeToLive != 0L) {
                    out.writeLong(this.m_TimeToLive);
                }
            }
            if (this.m_ClassName != null) {
                out.writeUTF(this.m_ClassName);
            }
            if (this.m_FieldsValues != null) {
                int i2;
                int size = this.m_FieldsValues.length;
                out.writeInt(size);
                int numNonNullFields = 0;
                boolean compressedMode = false;
                if (size > 3) {
                    for (i2 = 0; i2 < size; ++i2) {
                        if (this.m_FieldsValues[i2] == null) continue;
                        ++numNonNullFields;
                    }
                    if (numNonNullFields < size / 2) {
                        compressedMode = true;
                    }
                    out.writeBoolean(compressedMode);
                    if (compressedMode) {
                        out.writeInt(numNonNullFields);
                    }
                }
                for (i2 = 0; i2 < size; ++i2) {
                    if (this.m_FieldsValues[i2] != null) {
                        if (compressedMode) {
                            out.writeInt(i2);
                        } else {
                            out.writeBoolean(true);
                        }
                        this.writePrimitiveObject(out, this.m_FieldsValues[i2], i2);
                        continue;
                    }
                    if (compressedMode) continue;
                    out.writeBoolean(false);
                }
            }
            if (this.m_FieldsNames != null) {
                out.writeInt(this.m_FieldsNames.length);
                for (i = 0; i < this.m_FieldsNames.length; ++i) {
                    out.writeUTF(this.m_FieldsNames[i]);
                }
            }
            if (this.m_FieldsTypes != null) {
                out.writeInt(this.m_FieldsTypes.length);
                for (i = 0; i < this.m_FieldsTypes.length; ++i) {
                    out.writeUTF(this.m_FieldsTypes[i]);
                }
            }
            if (this.m_IndexIndicators != null) {
                out.writeInt(this.m_IndexIndicators.length);
                for (i = 0; i < this.m_IndexIndicators.length; ++i) {
                    out.writeBoolean(this.m_IndexIndicators[i]);
                }
            }
            out.writeShort(0);
            if (this.m_SuperClassesNames != null) {
                out.writeInt(this.m_SuperClassesNames.length);
                for (i = 0; i < this.m_SuperClassesNames.length; ++i) {
                    out.writeUTF(this.m_SuperClassesNames[i]);
                }
            }
            if (this.m_MultipleUIDs != null) {
                out.writeInt(this.m_MultipleUIDs.length);
                for (i = 0; i < this.m_MultipleUIDs.length; ++i) {
                    out.writeUTF(this.m_MultipleUIDs[i]);
                }
            }
            if (this.m_ExtendedMatchCodes != null) {
                out.writeInt(this.m_ExtendedMatchCodes.length);
                for (i = 0; i < this.m_ExtendedMatchCodes.length; ++i) {
                    out.writeShort(this.m_ExtendedMatchCodes[i]);
                }
            }
            if (this.m_RangeValues != null) {
                out.writeInt(this.m_RangeValues.length);
                for (i = 0; i < this.m_RangeValues.length; ++i) {
                    out.writeObject(this.m_RangeValues[i]);
                }
            }
            if (this.m_RangeValuesInclusion != null) {
                out.writeInt(this.m_RangeValuesInclusion.length);
                for (i = 0; i < this.m_RangeValuesInclusion.length; ++i) {
                    out.writeObject(this.m_RangeValuesInclusion[i]);
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof EntrySerializationException) {
                throw (EntrySerializationException)ex;
            }
            String className = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to serialize Entry " + className, ex);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            int i;
            int size;
            int i2;
            int size2;
            int flags = in.readInt();
            if ((flags & 0x10000000) != 0) {
                this.m_UID = in.readUTF();
                this.m_VersionID = in.readInt();
                if ((flags & 0x20000) != 0) {
                    this.m_TimeToLive = in.readLong();
                }
            }
            if ((flags & 0x20000000) != 0) {
                this.m_ClassName = in.readUTF();
            }
            this.m_Replicatable = (flags & 0x8000000) != 0;
            this.m_ReturnOnlyUids = (flags & 0x200000) != 0;
            this.m_isFifo = (flags & 0x400000) != 0;
            this.m_isTransient = (flags & 0x40000) != 0;
            boolean bl = this.m_NOWriteLeaseMode = (flags & 0x80000) != 0;
            if ((flags & 0x2000000) != 0) {
                int i3;
                size2 = in.readInt();
                this.m_FieldsValues = new Object[size2];
                int numNonNullFields = 0;
                boolean compressedMode = false;
                if (size2 > 3 && (compressedMode = in.readBoolean())) {
                    numNonNullFields = in.readInt();
                }
                if (compressedMode) {
                    for (i3 = 0; i3 < numNonNullFields; ++i3) {
                        int indx = in.readInt();
                        this.m_FieldsValues[indx] = this.readPrimitiveObject(in, indx);
                    }
                } else {
                    for (i3 = 0; i3 < size2; ++i3) {
                        if (!in.readBoolean()) continue;
                        this.m_FieldsValues[i3] = this.readPrimitiveObject(in, i3);
                    }
                }
            }
            if ((flags & Integer.MIN_VALUE) != 0) {
                size2 = in.readInt();
                this.m_FieldsNames = new String[size2];
                for (i2 = 0; i2 < size2; ++i2) {
                    this.m_FieldsNames[i2] = in.readUTF();
                }
            }
            if ((flags & 0x1000000) != 0) {
                size2 = in.readInt();
                this.m_FieldsTypes = new String[size2];
                for (i2 = 0; i2 < size2; ++i2) {
                    this.m_FieldsTypes[i2] = in.readUTF();
                }
            }
            if ((flags & 0x4000000) != 0) {
                size2 = in.readInt();
                this.m_IndexIndicators = new boolean[size2];
                for (i2 = 0; i2 < size2; ++i2) {
                    this.m_IndexIndicators[i2] = in.readBoolean();
                }
            }
            short objectFormat = in.readShort();
            if ((flags & 0x40000000) != 0) {
                size = in.readInt();
                this.m_SuperClassesNames = new String[size];
                for (i = 0; i < size; ++i) {
                    this.m_SuperClassesNames[i] = in.readUTF();
                }
            }
            if ((flags & 0x100000) != 0) {
                size = in.readInt();
                this.m_MultipleUIDs = new String[size];
                for (i = 0; i < size; ++i) {
                    this.m_MultipleUIDs[i] = in.readUTF();
                }
            }
            if ((flags & 0x800000) != 0) {
                size = in.readInt();
                this.m_ExtendedMatchCodes = new short[size];
                for (i = 0; i < size; ++i) {
                    this.m_ExtendedMatchCodes[i] = in.readShort();
                }
            }
            if ((flags & 0x10000) != 0) {
                size = in.readInt();
                this.m_RangeValues = new Object[size];
                for (i = 0; i < size; ++i) {
                    this.m_RangeValues[i] = in.readObject();
                }
            }
            if ((flags & 0x1000) != 0) {
                size = in.readInt();
                this.m_RangeValuesInclusion = new boolean[size];
                for (i = 0; i < size; ++i) {
                    this.m_RangeValuesInclusion[i] = in.readBoolean();
                }
            }
        }
        catch (Exception ex) {
            if (ex instanceof EntrySerializationException) {
                throw (EntrySerializationException)ex;
            }
            String className = this.m_ClassName != null ? this.m_ClassName : ".";
            throw new EntrySerializationException("Failed to deserialize Entry " + className, ex);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalEntry)) {
            return false;
        }
        ExternalEntry e = (ExternalEntry)obj;
        return ExternalEntry.equals(this.m_UID, e.m_UID) && ExternalEntry.equals(this.m_FieldsValues, e.m_FieldsValues);
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c = o1.getClass();
        if (c != o2.getClass()) {
            return false;
        }
        if (c.isArray()) {
            int length2;
            int length = Array.getLength(o1);
            if (length != (length2 = Array.getLength(o2))) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object c2;
                Object c1 = Array.get(o1, i);
                if (ExternalEntry.equals(c1, c2 = Array.get(o2, i))) continue;
                return false;
            }
            return true;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        return this.m_UID != null ? this.m_UID.hashCode() : 10;
    }

    @Override
    public String getClassName() {
        return this.m_ClassName;
    }

    public void setClassName(String className) {
        this.m_ClassName = className;
    }

    public short[] getExtendedMatchCodes() {
        return this.m_ExtendedMatchCodes;
    }

    public void setExtendedMatchCodes(short[] extendedMatchCodes) {
        this.m_ExtendedMatchCodes = extendedMatchCodes;
    }

    @Override
    public String[] getFieldsNames() {
        return this.m_FieldsNames;
    }

    public void setFieldsNames(String[] fieldsNames) {
        this.m_FieldsNames = fieldsNames;
    }

    @Override
    public String[] getFieldsTypes() {
        return this.m_FieldsTypes;
    }

    public void setFieldsTypes(String[] fieldsTypes) {
        this.m_FieldsTypes = fieldsTypes;
    }

    @Override
    public Object[] getFieldsValues() {
        return this.m_FieldsValues;
    }

    public void setFieldsValues(Object[] fieldsValues) {
        this.m_FieldsValues = fieldsValues;
    }

    public Object[] getRangeValues() {
        return this.m_RangeValues;
    }

    public void setRangeValues(Object[] rangeValues) {
        this.m_RangeValues = rangeValues;
    }

    @Override
    public boolean isFifo() {
        return this.m_isFifo;
    }

    public void setFifo(boolean fifo) {
        this.m_isFifo = fifo;
    }

    @Override
    public boolean[] getIndexIndicators() {
        return this.m_IndexIndicators;
    }

    public void setIndexIndicators(boolean[] indexIndicators) {
        this.m_IndexIndicators = indexIndicators;
    }

    @Override
    public String getPrimaryKeyName() {
        return this.m_PrimaryKeyName;
    }

    public void setPrimaryKeyName(String fieldName) {
        this.m_PrimaryKeyName = fieldName;
    }

    public String[] getMultipleUIDs() {
        return this.m_MultipleUIDs;
    }

    public void setMultipleUIDs(String[] multipleUIDs) {
        this.m_MultipleUIDs = multipleUIDs;
    }

    @Override
    public boolean isReplicatable() {
        return this.m_Replicatable;
    }

    public void setReplicatable(boolean replicatable) {
        this.m_Replicatable = replicatable;
    }

    public boolean isReturnOnlyUids() {
        return this.m_ReturnOnlyUids;
    }

    public void setReturnOnlyUids(boolean returnOnlyUids) {
        this.m_ReturnOnlyUids = returnOnlyUids;
    }

    @Override
    public String[] getSuperClassesNames() {
        return this.m_SuperClassesNames;
    }

    @Override
    public String getCodebase() {
        return null;
    }

    public void setSuperClassesNames(String[] superClassesNames) {
        this.m_SuperClassesNames = superClassesNames;
    }

    @Override
    public long getTimeToLive() {
        return this.m_TimeToLive;
    }

    public ExternalEntry setTimeToLive(long timeToLive) {
        this.m_TimeToLive = timeToLive;
        return this;
    }

    @Override
    public int getVersion() {
        return this.m_VersionID;
    }

    public void setVersion(int version) {
        this.m_VersionID = version;
    }

    @Override
    public boolean isTransient() {
        return this.m_isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.m_isTransient = isTransient;
    }

    public void makeTransient() {
        this.m_isTransient = true;
    }

    public void makePersistent() {
        this.m_isTransient = false;
    }

    @Override
    public Map.Entry getMapEntry() {
        return null;
    }

    @Override
    public String getUID() {
        return this.m_UID;
    }

    public void setUID(String m_uid) {
        this.m_UID = m_uid;
    }

    public int getVersionID() {
        return this.getVersion();
    }

    public void setVersionID(int versionID) {
        this.setVersion(versionID);
    }

    public void setNOWriteLeaseMode(boolean noWriteLeaseMode) {
        this.m_NOWriteLeaseMode = noWriteLeaseMode;
    }

    public boolean isNOWriteLeaseMode() {
        return this.m_NOWriteLeaseMode;
    }

    @Override
    public Object getFieldValue(String fieldName) {
        return this.getFieldValue(this.getFieldPosition(fieldName));
    }

    @Override
    public Object setFieldValue(String fieldName, Object value) {
        return this.setFieldValue(this.getFieldPosition(fieldName), value);
    }

    @Override
    public String getFieldType(String fieldName) {
        int index = this.getFieldPosition(fieldName);
        try {
            return this.m_FieldsTypes[index];
        }
        catch (Exception e) {
            throw new IllegalStateException("The field types array was not properly set", e);
        }
    }

    @Override
    public boolean isIndexedField(String fieldName) {
        int index = this.getFieldPosition(fieldName);
        try {
            return this.m_IndexIndicators[index];
        }
        catch (Exception e) {
            throw new IllegalStateException("The field indexes array was not properly set", e);
        }
    }

    @Override
    public Object getFieldValue(int index) throws IllegalArgumentException, IllegalStateException {
        try {
            return this.m_FieldsValues[index];
        }
        catch (Exception e) {
            throw new IllegalStateException("The field values array was not properly set", e);
        }
    }

    @Override
    public Object setFieldValue(int index, Object value) throws IllegalArgumentException, IllegalStateException {
        try {
            Object oldValue = this.m_FieldsValues[index];
            this.m_FieldsValues[index] = value;
            return oldValue;
        }
        catch (Exception e) {
            throw new IllegalStateException("The field values array was not properly set", e);
        }
    }

    @Override
    public int getFieldPosition(String fieldName) {
        if (this.m_FieldsNames != null) {
            for (int i = 0; i < this.m_FieldsNames.length; ++i) {
                if (!this.m_FieldsNames[i].equals(fieldName)) continue;
                return i;
            }
        }
        throw new IllegalArgumentException("Field name " + fieldName + " is not available in class " + this.getClassName());
    }

    public Entry getEntry(IJSpace space) throws UnusableEntryException {
        return (Entry)this.getObject(space);
    }

    @Override
    public Object getObject(IJSpace space) throws UnusableEntryException {
        return ((ISpaceProxy)space).getDirectProxy().getTypeManager().getObjectFromIGSEntry(this);
    }

    @Override
    public String getRoutingFieldName() {
        return this.routingFieldName;
    }

    public void setRoutingFieldName(String routingFieldName) {
        this.routingFieldName = routingFieldName;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public short getExtendedMatchCode(int index) {
        if (this.m_ExtendedMatchCodes == null) {
            return 0;
        }
        return this.m_ExtendedMatchCodes[index];
    }

    public Object getRangeValue(int index) {
        if (this.m_RangeValues == null) {
            return null;
        }
        return this.m_RangeValues[index];
    }

    public boolean getRangeValueInclusion(int index) {
        if (this.m_RangeValuesInclusion == null) {
            return true;
        }
        return this.m_RangeValuesInclusion[index];
    }

    public boolean isExtended() {
        return this.m_ClassName != null && this.m_ExtendedMatchCodes != null && this.m_FieldsNames != null && this.m_FieldsNames.length > 0;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Class Name: ").append(this.getClassName());
        str.append("\nSuper Classes: ").append(Arrays.toString(this.getSuperClassesNames()));
        str.append("\nUID: ").append(this.getUID());
        str.append("\nFields Values: ").append(Arrays.toString(this.getFieldsValues()));
        str.append("\nFields Names: ").append(Arrays.toString(this.getFieldsNames()));
        str.append("\nFields Types: ").append(Arrays.toString(this.getFieldsTypes()));
        return str.toString();
    }

    private static final class BitMap {
        private static final int UID = 0x10000000;
        private static final int CLASSNAME = 0x20000000;
        private static final int SUPER_CLASSES = 0x40000000;
        private static final int FIELDS_NAMES = Integer.MIN_VALUE;
        private static final int FIELDS_TYPES = 0x1000000;
        private static final int FIELDS_VALUES = 0x2000000;
        private static final int INDEX_INDICATORS = 0x4000000;
        private static final int REPLICATABLE = 0x8000000;
        private static final int MULTIPLE_UIDS = 0x100000;
        private static final int RETURN_ONLY_UIDS = 0x200000;
        private static final int IS_FIFO = 0x400000;
        private static final int EXTENDED_MATCH = 0x800000;
        private static final int RANGE_VALUES = 65536;
        private static final int TIME_TO_LIVE = 131072;
        private static final int IS_TRANSIENT = 262144;
        private static final int NO_WRITE_LEASE = 524288;
        private static final int RANGE_INCLUSION = 4096;

        private BitMap() {
        }
    }
}

