/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.metadata.PropertyInfo;
import com.j_spaces.core.client.ExternalEntry;

@InternalApi
public class ExternalEntryUtils {
    public static ExternalEntry createExternalEntry(String className, Object[] fieldsValues, ITypeDesc typeDesc) {
        ExternalEntry ee = new ExternalEntry();
        ee.m_ClassName = className;
        ee.m_FieldsValues = fieldsValues;
        ExternalEntryUtils.updateProperties(ee, typeDesc);
        return ee;
    }

    public static void updateProperties(ExternalEntry ee, ITypeDesc typeDesc) {
        int length = typeDesc.getNumOfFixedProperties();
        String[] fieldNames = new String[length];
        String[] fieldTypes = new String[length];
        boolean[] indices = new boolean[length];
        boolean[] primitives = new boolean[length];
        for (int i = 0; i < length; ++i) {
            PropertyInfo property = typeDesc.getFixedProperty(i);
            fieldNames[i] = property.getName();
            fieldTypes[i] = property.getTypeName();
            indices[i] = typeDesc.getIndexType(property.getName()).isIndexed();
            primitives[i] = property.isSpacePrimitive();
        }
        ee.m_FieldsNames = fieldNames;
        ee.m_FieldsTypes = fieldTypes;
        ee.m_IndexIndicators = indices;
        ee._primitiveFields = primitives;
    }

    public static void updateTypeDescription(ExternalEntry ee, ITypeDesc typeDesc) {
        ee.setClassName(typeDesc.getTypeName());
        ExternalEntryUtils.updateProperties(ee, typeDesc);
        ee.setPrimaryKeyName(typeDesc.getRoutingPropertyName());
        ee.setReplicatable(typeDesc.isReplicable());
        ee.setSuperClassesNames(typeDesc.getRestrictSuperClassesNames());
    }
}

