/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.iterator.GSIteratorConfig;
import com.gigaspaces.client.iterator.IteratorScope;
import com.gigaspaces.client.iterator.internal.MultipleUidsPerPartitionList;
import com.gigaspaces.events.AbstractDataEventSession;
import com.gigaspaces.events.DataEventSessionFactory;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.events.batching.BatchRemoteEvent;
import com.gigaspaces.events.batching.BatchRemoteEventListener;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.ReadTakeEntriesUidsResult;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ISpaceProxyTypeManager;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.query.IPartitionResultMetadata;
import com.gigaspaces.internal.query.PartitionResultMetadata;
import com.gigaspaces.internal.transport.AbstractProjectionTemplate;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.ITransportPacket;
import com.gigaspaces.internal.transport.MutliProjectionByUids;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.UidQueryPacket;
import com.j_spaces.core.client.EntryArrivedRemoteEvent;
import com.j_spaces.core.client.EntrySnapshot;
import com.j_spaces.core.client.ReadModifiers;
import com.j_spaces.core.client.sql.IQueryManager;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.transaction.TransactionException;

@Deprecated
@InternalApi
public class GSIterator
implements Iterator,
Iterable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client.gsiterator");
    private final ISpaceProxy _spaceProxy;
    private final GSIteratorConfig _config;
    private final ILeasedIterator _leasedIterator;
    private List<Lease> _notifyLeases;
    private IEntryPacket _snapshot;
    private final Object _lock = new Object();
    private Set<String> _historyUids;
    private final MultipleUidsPerPartitionList _uidsPartitionedList;
    private final List<IEntryPacket> _buffer;
    private Iterator<IEntryPacket> _bufferIterator;
    private final QueryResultTypeInternal _queryResultType;
    private final boolean _returnEntryPacket;
    private List<ITemplatePacket> _templatesWithProjection;
    private AbstractProjectionTemplate[] _projectionTemplates;
    private ConcurrentMap<String, Short> _uidsToProjection;
    private boolean _oneOverallProjection;
    private static final NotifyActionType NOTIFY_MASK = NotifyActionType.NOTIFY_WRITE.or(NotifyActionType.NOTIFY_TAKE).or(NotifyActionType.NOTIFY_LEASE_EXPIRATION);

    public GSIterator(IJSpace spaceProxy, Collection<?> templates) throws RemoteException, UnusableEntryException {
        this(spaceProxy, templates, new GSIteratorConfig());
    }

    @Deprecated
    public GSIterator(IJSpace spaceProxy, Collection<?> templates, int bufferSize, boolean withHistory, long leaseDuration) throws RemoteException, UnusableEntryException {
        this(spaceProxy, templates, new GSIteratorConfig().setBufferSize(bufferSize).setLeaseDuration(leaseDuration).setIteratorScope(withHistory ? IteratorScope.CURRENT_AND_FUTURE : IteratorScope.FUTURE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GSIterator(IJSpace spaceProxy, Collection<?> templates, GSIteratorConfig config) throws RemoteException, UnusableEntryException {
        this.validateArgs(spaceProxy, templates, config);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "GSIterator initialized with scope=" + (Object)((Object)config.getIteratorScope()) + ", bufferSize=" + config.getBufferSize() + ", leaseDuration=" + config.getLeaseDuration());
        }
        this._spaceProxy = (ISpaceProxy)spaceProxy;
        this._config = config;
        this._uidsPartitionedList = new MultipleUidsPerPartitionList();
        this._buffer = new LinkedList<IEntryPacket>();
        Object firstTemplate = templates.iterator().next();
        this._returnEntryPacket = firstTemplate instanceof ITransportPacket;
        this._templatesWithProjection = null;
        this._projectionTemplates = null;
        this._uidsToProjection = null;
        ITemplatePacket[] templatesPackets = this.extractTemplatePacketsFromCollection(templates);
        this._queryResultType = templatesPackets[0].getQueryResultType();
        this._leasedIterator = this._config.getIteratorScope().hasFuture() ? new TimedLeasedIterator(this._config.getLeaseDuration()) : new InfiniteLeasedIterator();
        try {
            Object object = this._lock;
            synchronized (object) {
                if (this._config.getIteratorScope().hasFuture()) {
                    this.registerForNotifications(templatesPackets);
                }
                this.extractHistoryIfNeeded(templatesPackets, this._config.getIteratorScope());
            }
        }
        catch (TransactionException transactionException) {
            // empty catch block
        }
    }

    private void validateArgs(IJSpace space, Collection<?> collectionTemplates, GSIteratorConfig config) {
        if (space == null) {
            throw new IllegalArgumentException("space argument must not be null.");
        }
        if (collectionTemplates == null || collectionTemplates.isEmpty()) {
            throw new IllegalArgumentException("templates argument must contain at least one element.");
        }
        if (config == null) {
            throw new IllegalArgumentException("config argument must not be null.");
        }
        if (config.getBufferSize() <= 0) {
            throw new IllegalArgumentException("bufferSize argument must be greater than zero.");
        }
        this.validateDuration(config.getLeaseDuration());
    }

    private ITemplatePacket[] extractTemplatePacketsFromCollection(Collection<?> templates) throws NullPointerException, IllegalArgumentException {
        ITemplatePacket[] templatesPackets = new ITemplatePacket[templates.size()];
        ISpaceProxyTypeManager typeManager = this._spaceProxy.getDirectProxy().getTypeManager();
        IQueryManager queryManager = this._spaceProxy.getDirectProxy().getQueryManager();
        int index = 0;
        for (Object template : templates) {
            ObjectType objectType;
            ITemplatePacket templatePacket = typeManager.getTemplatePacketFromObject(template, objectType = ObjectType.fromObject(template));
            if (templatePacket instanceof SQLQueryTemplatePacket) {
                templatePacket = queryManager.getSQLTemplate((SQLQueryTemplatePacket)templatePacket, null);
            }
            templatesPackets[index++] = templatePacket;
            if (templatePacket.getProjectionTemplate() == null) continue;
            if (this._templatesWithProjection == null) {
                this._templatesWithProjection = new ArrayList<ITemplatePacket>(templates.size());
            }
            this._templatesWithProjection.add(templatePacket);
        }
        if (this._templatesWithProjection != null) {
            if (templates.size() == 1) {
                this._oneOverallProjection = true;
            } else {
                this._uidsToProjection = new ConcurrentHashMap<String, Short>();
                this._projectionTemplates = new AbstractProjectionTemplate[this._templatesWithProjection.size()];
                int pos = 0;
                for (ITemplatePacket p : this._templatesWithProjection) {
                    this._projectionTemplates[pos++] = p.getProjectionTemplate();
                }
            }
        }
        return templatesPackets;
    }

    private void registerForNotifications(ITemplatePacket[] templates) throws RemoteException, TransactionException {
        this._notifyLeases = new ArrayList<Lease>(templates.length);
        boolean isFifoPerTemplate = false;
        EventSessionConfig sessionConfig = this._config.getEventSessionConfig();
        if (sessionConfig == null) {
            sessionConfig = new EventSessionConfig();
            if (this._spaceProxy.isFifo() || ReadModifiers.isFifo(this._spaceProxy.getReadModifiers())) {
                sessionConfig.setFifo(true);
            } else {
                isFifoPerTemplate = true;
            }
        }
        AbstractDataEventSession session = (AbstractDataEventSession)DataEventSessionFactory.create(this._spaceProxy, sessionConfig);
        AbstractDataEventSession fifoSession = null;
        if (isFifoPerTemplate) {
            EventSessionConfig fifoSessionConfig = new EventSessionConfig();
            fifoSessionConfig.setFifo(true);
            fifoSession = (AbstractDataEventSession)DataEventSessionFactory.create(this._spaceProxy, fifoSessionConfig);
        }
        long leaseDuration = sessionConfig.isAutoRenew() ? sessionConfig.getRenewDuration() : Long.MAX_VALUE;
        NotificationListener defaultListener = new NotificationListener(-1);
        int projectionNum = 0;
        for (ITemplatePacket template : templates) {
            NotificationListener notificationListener;
            AbstractDataEventSession currSession;
            AbstractDataEventSession abstractDataEventSession = currSession = isFifoPerTemplate && template.getTypeDescriptor() != null && template.getTypeDescriptor().isFifoDefault() ? fifoSession : session;
            if (template.getProjectionTemplate() != null && !this._oneOverallProjection) {
                ++projectionNum;
                notificationListener = new NotificationListener(projectionNum);
            } else {
                notificationListener = defaultListener;
            }
            NotificationListener curListener = notificationListener;
            NotifyInfo notifyInfo = currSession.createNotifyInfo(curListener, NOTIFY_MASK).setReturnOnlyUids(true);
            EventRegistration event = currSession.addListener((Object)template, leaseDuration, notifyInfo);
            this._notifyLeases.add(event.getLease());
        }
    }

    private void extractHistoryIfNeeded(ITemplatePacket[] templates, IteratorScope iteratorScope) throws RemoteException, TransactionException, UnusableEntryException {
        if (!iteratorScope.hasCurrent()) {
            return;
        }
        if (iteratorScope.hasFuture()) {
            this._historyUids = new HashSet<String>();
        }
        for (ITemplatePacket template : templates) {
            ReadTakeEntriesUidsResult uidsResult = this._spaceProxy.readEntriesUids(template, null, Integer.MAX_VALUE, this._config.getReadModifiers());
            String[] uids = uidsResult.getUids();
            int uidIndex = 0;
            for (IPartitionResultMetadata partitionData : uidsResult.getPartitionsMetadata()) {
                this._uidsPartitionedList.startPartition(partitionData);
                int projectionpos = this._templatesWithProjection != null && !this._oneOverallProjection ? this.indexOfByRef(this._templatesWithProjection, template) : -1;
                int i = 0;
                while (i < partitionData.getNumOfResults()) {
                    if (this._historyUids != null) {
                        this._historyUids.add(uids[uidIndex]);
                    }
                    this._uidsPartitionedList.addIfNew(uids[uidIndex]);
                    if (projectionpos != -1) {
                        this._uidsToProjection.putIfAbsent(uids[uidIndex], (short)projectionpos);
                    }
                    ++i;
                    ++uidIndex;
                }
            }
        }
        this._uidsPartitionedList.startPartition(new PartitionResultMetadata(null, 0));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "extractHistoryIfNeeded found " + this._uidsPartitionedList.size() + " matching uids.");
        }
    }

    private int indexOfByRef(List l, Object o) {
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            if (l.get(i) != o) continue;
            return i;
        }
        return -1;
    }

    public EntrySnapshot snapshot() throws IllegalStateException {
        if (this._snapshot == null) {
            throw new IllegalStateException("Last next call either returned null or failed.");
        }
        try {
            return (EntrySnapshot)this._spaceProxy.snapshot(this._snapshot.toObject(this._queryResultType));
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this._leasedIterator.isTerminated()) {
            result = false;
        } else {
            if (this._bufferIterator == null) {
                this._bufferIterator = this.getNextBatch();
            }
            if (this._bufferIterator == null) {
                result = false;
            } else if (this._bufferIterator.hasNext()) {
                result = true;
            } else {
                this._bufferIterator = null;
                result = this.hasNext();
            }
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "hasNext() returned " + result);
        }
        return result;
    }

    public Object[] nextBatch(int limit) throws NoSuchElementException {
        Object next;
        ArrayList<Object> list = new ArrayList<Object>(limit);
        for (int i = 0; i < limit && (next = this.next()) != null; ++i) {
            list.add(next);
        }
        return list.toArray();
    }

    public Object next() {
        IEntryPacket result = null;
        this._snapshot = null;
        if (this.hasNext()) {
            this._snapshot = this._bufferIterator.next();
            result = this._returnEntryPacket ? this._snapshot : this._snapshot.toObject(this._queryResultType);
        } else {
            this._snapshot = null;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "next() returned " + (this._snapshot == null ? "null" : "object with uid=" + this._snapshot.getUID()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object next(long timeout) throws NoSuchElementException {
        Object nextEntry = this.next();
        if (nextEntry != null) {
            return nextEntry;
        }
        Object object = this._lock;
        synchronized (object) {
            if (!this._leasedIterator.isTerminated()) {
                try {
                    this._lock.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        nextEntry = this.next();
        if (nextEntry == null) {
            throw new NoSuchElementException();
        }
        return nextEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<IEntryPacket> getNextBatch() {
        Iterator<IEntryPacket> result;
        block22: {
            UidQueryPacket template;
            result = null;
            this._buffer.clear();
            Object object = this._lock;
            synchronized (object) {
                template = this._uidsPartitionedList.buildQueryPacket(this._config.getBufferSize(), this._queryResultType);
                if (template != null && this._templatesWithProjection != null) {
                    if (this._oneOverallProjection) {
                        template.setProjectionTemplate(this._templatesWithProjection.get(0).getProjectionTemplate());
                    } else {
                        Short pos;
                        ObjectShortMap<String> puids = null;
                        String[] uids = template.getMultipleUIDs();
                        if (uids != null && uids.length > 0) {
                            for (String uid : uids) {
                                Short pos2 = (Short)this._uidsToProjection.remove(uid);
                                if (pos2 == null) continue;
                                if (puids == null) {
                                    puids = CollectionsFactory.getInstance().createObjectShortMap();
                                }
                                puids.put(uid, pos2);
                            }
                        } else if (template.getUID() != null && (pos = (Short)this._uidsToProjection.remove(template.getUID())) != null) {
                            if (puids == null) {
                                puids = CollectionsFactory.getInstance().createObjectShortMap();
                            }
                            puids.put(template.getUID(), pos);
                        }
                        if (puids != null) {
                            MutliProjectionByUids mp = new MutliProjectionByUids(this._projectionTemplates, puids);
                            template.setProjectionTemplate(mp);
                        }
                    }
                }
            }
            if (template != null) {
                try {
                    Object[] entries = this._spaceProxy.readMultiple(template, null, template.getMultipleUIDs().length, this._config.getReadModifiers());
                    this._buffer.clear();
                    for (Object entry : entries) {
                        this._buffer.add((IEntryPacket)entry);
                    }
                    result = this._buffer.iterator();
                }
                catch (RemoteException e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to build iterator data", e);
                    }
                }
                catch (UnusableEntryException e) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, "Failed to build iterator data", e);
                    }
                }
                catch (TransactionException e) {
                    if (!_logger.isLoggable(Level.SEVERE)) break block22;
                    _logger.log(Level.SEVERE, "Failed to build iterator data", e);
                }
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "getNextBatch returns with a buffer of " + this._buffer.size() + " entries.");
        }
        return result;
    }

    public long getExpiration() {
        return this._leasedIterator.getExpiration();
    }

    public void renew(long duration) throws IllegalArgumentException, LeaseDeniedException {
        if (this._leasedIterator.isTerminated()) {
            throw new LeaseDeniedException("Lease has already expired or been cancelled.");
        }
        this._leasedIterator.renew(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Iterator<Lease> iterator = this._lock;
        synchronized (iterator) {
            boolean alreadyCancelled = this._leasedIterator.cancel();
            this._lock.notifyAll();
            if (alreadyCancelled) {
                return;
            }
            this._uidsPartitionedList.clear();
            if (this._historyUids != null) {
                this._historyUids.clear();
            }
        }
        if (this._notifyLeases != null) {
            for (Lease lease : this._notifyLeases) {
                try {
                    lease.cancel();
                }
                catch (Exception exception) {}
            }
        }
        if (this._bufferIterator != null) {
            while (this._bufferIterator.hasNext()) {
                this._bufferIterator.next();
                this._bufferIterator.remove();
            }
        }
        this._buffer.clear();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported on GSIterator");
    }

    public Iterator<?> iterator() {
        return new GSIteratorIterable();
    }

    private long validateDuration(long duration) throws IllegalArgumentException {
        if (duration == -1L) {
            return Long.MAX_VALUE;
        }
        if (duration <= 0L) {
            throw new IllegalArgumentException("duration argument must be greater than zero.");
        }
        return duration;
    }

    private final class GSIteratorIterable
    implements Iterator<Object> {
        private GSIteratorIterable() {
        }

        @Override
        public boolean hasNext() {
            if (GSIterator.this.hasNext()) {
                return true;
            }
            GSIterator.this.cancel();
            return false;
        }

        @Override
        public Object next() {
            return GSIterator.this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported with GSIterator");
        }
    }

    private final class TimedLeasedIterator
    extends GSThread
    implements ILeasedIterator {
        private long _duration;
        private long _expirationTime;
        private boolean _cancelled;
        private boolean _renewed;
        private boolean _expired;

        public TimedLeasedIterator(long duration) {
            super("<" + GSIterator.this._spaceProxy.getName() + ">-Leased-Iterator");
            this.setDaemon(true);
            this._duration = GSIterator.this.validateDuration(duration);
            this.start();
        }

        public void run() {
            try {
                while (this.stillLeased() && !this.isInterrupted()) {
                }
            }
            catch (InterruptedException ie) {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, this.getName() + " interrupted.\n", ie);
                }
                this.interrupt();
            }
            GSIterator.this.cancel();
        }

        private synchronized boolean stillLeased() throws InterruptedException {
            if (this._cancelled) {
                return false;
            }
            this._expirationTime = SystemTime.timeMillis() + this._duration;
            this.wait(this._duration);
            if (this._renewed) {
                this._renewed = false;
                return true;
            }
            this._expired = true;
            return false;
        }

        @Override
        public synchronized boolean cancel() {
            if (this._cancelled) {
                return true;
            }
            this._cancelled = true;
            this.notify();
            return false;
        }

        @Override
        public synchronized void renew(long newDuration) {
            this._duration = GSIterator.this.validateDuration(newDuration);
            this._renewed = true;
            this.notify();
        }

        @Override
        public synchronized boolean isTerminated() {
            return this._expired || this._cancelled;
        }

        @Override
        public synchronized long getExpiration() {
            return this._expirationTime;
        }
    }

    private static final class InfiniteLeasedIterator
    implements ILeasedIterator {
        private boolean _cancelled;

        private InfiniteLeasedIterator() {
        }

        @Override
        public synchronized boolean cancel() {
            if (this._cancelled) {
                return false;
            }
            this._cancelled = true;
            return true;
        }

        @Override
        public long getExpiration() {
            return Long.MAX_VALUE;
        }

        @Override
        public synchronized boolean isTerminated() {
            return this._cancelled;
        }

        @Override
        public void renew(long newDuration) {
        }
    }

    private static interface ILeasedIterator {
        public boolean isTerminated();

        public long getExpiration();

        public boolean cancel();

        public void renew(long var1);
    }

    private final class NotificationListener
    implements BatchRemoteEventListener {
        private final int _projectionTemplateNumber;

        public NotificationListener(int projectionTemplateNumber) {
            this._projectionTemplateNumber = projectionTemplateNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(RemoteEvent event) {
            Object object = GSIterator.this._lock;
            synchronized (object) {
                if (GSIterator.this._leasedIterator.isTerminated()) {
                    return;
                }
                this.processEvent((EntryArrivedRemoteEvent)event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyBatch(BatchRemoteEvent batchEvent) {
            Object object = GSIterator.this._lock;
            synchronized (object) {
                if (GSIterator.this._leasedIterator.isTerminated()) {
                    return;
                }
                for (RemoteEvent event : batchEvent.getEvents()) {
                    this.processEvent((EntryArrivedRemoteEvent)event);
                }
            }
        }

        private void processEvent(EntryArrivedRemoteEvent spaceEvent) {
            NotifyActionType notifyType = spaceEvent.getNotifyActionType();
            String uid = spaceEvent.getEntryPacket().getUID();
            if (notifyType.isWrite()) {
                boolean isDuplicate;
                boolean bl = isDuplicate = GSIterator.this._historyUids != null && GSIterator.this._historyUids.remove(uid);
                if (!isDuplicate) {
                    boolean isNew;
                    if (GSIterator.this._uidsToProjection != null && this._projectionTemplateNumber != -1) {
                        GSIterator.this._uidsToProjection.putIfAbsent(uid, (short)this._projectionTemplateNumber);
                    }
                    if (isNew = GSIterator.this._uidsPartitionedList.addIfNew(uid)) {
                        GSIterator.this._lock.notifyAll();
                    }
                }
            } else if (notifyType.isTake() || notifyType.isLeaseExpiration()) {
                GSIterator.this._uidsPartitionedList.remove(uid);
                if (GSIterator.this._historyUids != null) {
                    GSIterator.this._historyUids.remove(uid);
                }
                if (GSIterator.this._uidsToProjection != null && this._projectionTemplateNumber != -1) {
                    GSIterator.this._uidsToProjection.remove(uid);
                }
            }
        }
    }
}

