/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.IJSpace;
import java.io.Serializable;
import java.rmi.Remote;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

@InternalApi
public class JSpaceProxyWrapper
implements Remote,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final short SPACE_MODE_REGULAR = 1;
    public static final short SPACE_MODE_PRIMARY = 2;
    public static final short SPACE_MODE_BACKUP = 3;
    public static final short SPACE_MODE_REMOVED_FROM_JINI_LUS = 4;
    private Object proxyObject;
    private String proxyName;
    private int spaceState = 1;
    private short _spaceMode = 1;
    private ServiceID _serviceID;

    public JSpaceProxyWrapper() {
    }

    public JSpaceProxyWrapper(IJSpace spaceProxy) {
        this.proxyObject = spaceProxy;
        this.proxyName = spaceProxy.getName();
        Uuid spaceUuid = spaceProxy.getReferentUuid();
        this._serviceID = new ServiceID(spaceUuid.getMostSignificantBits(), spaceUuid.getLeastSignificantBits());
    }

    public Object proxy() {
        return this.proxyObject;
    }

    public String toString() {
        return this.proxyName;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public int hashCode() {
        return this.proxyObject.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare((Object)this.proxyObject, (Object)o);
    }

    public int getState() {
        return this.spaceState;
    }

    public void setState(int state) {
        this.spaceState = state;
    }

    public ServiceID getServiceID() {
        return this._serviceID;
    }

    public short getSpaceMode() {
        return this._spaceMode;
    }

    public void setSpaceMode(short mode) {
        this._spaceMode = mode;
    }
}

