/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.LookupRequest;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import com.j_spaces.core.service.ServiceConfigLoader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.entry.Name;

@InternalApi
public class LookupFinder {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.lookupfinder");
    public static final long DEFAULT_TIMEOUT = 5000L;
    public static final long DEFAULT_INTERVAL_TIMEOUT = 100L;
    public static final long SINGLE_LOOKUP_TIMEOUT = 1L;
    public static final String ACTUAL_CLOSE_SYSTEM_PROPERTY = "com.gigaspaces.lookupfinder.actualclose";
    private static final long REPEATS_BASED_LUS_LOOKUP_TIMEOUT = 5000L;
    private static final Set<SharedDiscoveryManagement.SharedServiceDiscoveryManager> sdms = new HashSet<SharedDiscoveryManagement.SharedServiceDiscoveryManager>();
    private static Configuration serviceConfig;
    private static Comparator<Entry> ATTRIBUTES_COMPARATOR;

    public static void close() {
        if (System.getProperty(ACTUAL_CLOSE_SYSTEM_PROPERTY, "true").equals("true")) {
            LookupFinder.forceClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceClose() {
        Set<SharedDiscoveryManagement.SharedServiceDiscoveryManager> set = sdms;
        synchronized (set) {
            for (SharedDiscoveryManagement.SharedServiceDiscoveryManager sdm : sdms) {
                sdm.terminate();
            }
            sdms.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object find(LookupRequest request) throws FinderException {
        Exception exception;
        SharedDiscoveryManagement.SharedServiceDiscoveryManager sdm;
        String[] lookupGroups;
        LookupLocator[] lookupLocators;
        long timeout;
        Entry[] serviceAttributes;
        ServiceID serviceID;
        Class serviceClass;
        String serviceName;
        block23: {
            Object ex2;
            block24: {
                Set<SharedDiscoveryManagement.SharedServiceDiscoveryManager> set;
                Class[] classArray;
                serviceName = request.getServiceName();
                serviceClass = request.getServiceClass();
                serviceID = LookupFinder.getServiceIDFromRequest(request);
                serviceAttributes = LookupFinder.appendNameIfNeeded(request.getServiceAttributes(), serviceName);
                LookupFinder.sortLookupAttributes(serviceAttributes);
                if (serviceName == null && serviceClass == null && serviceAttributes == null) {
                    throw new IllegalArgumentException("All parameters can not be null.");
                }
                timeout = request.getTimeout() <= 0L ? 5000L : request.getTimeout();
                lookupLocators = request.getLookupLocators();
                lookupGroups = request.getLookupGroups();
                if (serviceClass != null) {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = serviceClass;
                } else {
                    classArray = null;
                }
                Class[] serviceClasses = classArray;
                ServiceTemplate template = new ServiceTemplate(serviceID, serviceClasses, serviceAttributes);
                sdm = null;
                Object result = null;
                try {
                    exception = null;
                    try {
                        sdm = SharedDiscoveryManagement.getBackwardsServiceDiscoveryManager(lookupGroups, lookupLocators, null);
                        result = LookupFinder.find(template, sdm, timeout, request);
                    }
                    catch (Exception ex2) {
                        exception = ex2;
                    }
                    if (result == null) break block23;
                    if (_logger.isLoggable(Level.CONFIG)) {
                        _logger.config(LookupFinder.generateReport(result, serviceName, serviceID, serviceClass, serviceAttributes, lookupLocators, lookupGroups, timeout, sdm));
                    }
                    ex2 = result;
                    if (sdm == null) break block24;
                    set = sdms;
                }
                catch (Throwable throwable) {
                    if (sdm != null) {
                        Set<SharedDiscoveryManagement.SharedServiceDiscoveryManager> set2 = sdms;
                        synchronized (set2) {
                            boolean terminateSDM;
                            boolean bl = terminateSDM = request.getLookupType() == LookupType.TimeBasedLastIteration || request.getLookupType() == LookupType.RepeatsBased;
                            if (result == null && terminateSDM) {
                                sdm.terminate();
                            } else {
                                boolean isNew = sdms.add(sdm);
                                if (!isNew) {
                                    sdm.terminate();
                                }
                            }
                        }
                    }
                    throw throwable;
                }
                synchronized (set) {
                    boolean terminateSDM;
                    boolean bl = terminateSDM = request.getLookupType() == LookupType.TimeBasedLastIteration || request.getLookupType() == LookupType.RepeatsBased;
                    if (result == null && terminateSDM) {
                        sdm.terminate();
                    } else {
                        boolean isNew = sdms.add(sdm);
                        if (!isNew) {
                            sdm.terminate();
                        }
                    }
                }
            }
            return ex2;
        }
        String report = LookupFinder.generateReport(null, serviceName, serviceID, serviceClass, serviceAttributes, lookupLocators, lookupGroups, timeout, sdm);
        if (_logger.isLoggable(Level.CONFIG)) {
            _logger.config(report);
        }
        throw new FinderException(report, exception);
    }

    private static ServiceID getServiceIDFromRequest(LookupRequest request) {
        if (request.getSpaceUuid() == null) {
            return null;
        }
        UUID uuid = UUID.fromString(request.getSpaceUuid());
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private static Object find(ServiceTemplate template, SharedDiscoveryManagement.SharedServiceDiscoveryManager sdm, long timeout, LookupRequest request) throws InterruptedException {
        long interval = request.getLookupInterval();
        long sdmCreationTime = SystemTime.timeMillis();
        if (timeout == 1L && request.getLookupType() == LookupType.RepeatsBased && sdm.getDiscoveryManager().getRegistrars().length == 0) {
            LookupFinder.waitForLookupService(sdm);
        }
        long deadline = SystemTime.timeMillis() + timeout;
        boolean firstTime = true;
        while (true) {
            Object result;
            if (firstTime && _logger.isLoggable(Level.FINE) && sdm.getDiscoveryManager().getRegistrars().length > 0) {
                _logger.fine("Initial LUS found in [" + (SystemTime.timeMillis() - sdmCreationTime) + "ms]");
                firstTime = false;
            }
            long lookupTimeStart = _logger.isLoggable(Level.FINE) ? SystemTime.timeMillis() : 0L;
            ServiceItem foundService = sdm.lookup(template, null);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Service Lookup took [" + (SystemTime.timeMillis() - lookupTimeStart) + "ms]");
            }
            Object object = result = foundService == null ? null : foundService.getService();
            if (result != null) {
                return result;
            }
            if (SystemTime.timeMillis() > deadline) {
                return null;
            }
            Thread.sleep(interval);
        }
    }

    private static void waitForLookupService(ServiceDiscoveryManager sdm) throws InterruptedException {
        final CountDownLatch discoveredLatch = new CountDownLatch(1);
        DiscoveryListener listener = new DiscoveryListener(){

            @Override
            public void discovered(DiscoveryEvent e) {
                discoveredLatch.countDown();
            }

            @Override
            public void discarded(DiscoveryEvent e) {
            }
        };
        sdm.getDiscoveryManager().addDiscoveryListener(listener);
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("1ms (special value) passed, waiting at most [5000ms] to discover at least one lookup service");
            }
            discoveredLatch.await(5000L, TimeUnit.MILLISECONDS);
            if (_logger.isLoggable(Level.FINE) && sdm.getDiscoveryManager().getRegistrars().length == 0) {
                _logger.fine("No LUS found after wait");
            }
        }
        finally {
            sdm.getDiscoveryManager().removeDiscoveryListener(listener);
        }
    }

    private static String generateReport(Object foundService, String serviceName, ServiceID serviceID, Class serviceClass, Entry[] serviceAttributes, LookupLocator[] lookupLocators, String[] lookupGroups, long timeout, ServiceDiscoveryManager sdm) {
        StringBuilder sb = foundService != null ? new StringBuilder("LookupFinder found service using the following service attributes: \n") : new StringBuilder("LookupFinder failed to find service using the following service attributes: \n");
        if (serviceAttributes != null && serviceAttributes.length > 0) {
            for (int i = 0; i < serviceAttributes.length; ++i) {
                sb.append("\n\t Service attributes: [").append(serviceAttributes[i]).append(']');
            }
        }
        sb.append("\n\t Lookup timeout: [").append(timeout).append(']');
        if (serviceClass != null) {
            sb.append("\n\t Class: " + serviceClass.getName());
        }
        if (serviceName != null) {
            sb.append("\n\t Service name: [").append(serviceName).append(']');
        }
        if (serviceID != null) {
            sb.append("\n\t Service Id: [").append(serviceID).append(']');
        }
        if (lookupGroups != null) {
            sb.append("\n\t Jini Lookup Groups: ").append(Arrays.asList(lookupGroups));
        }
        if (lookupLocators != null) {
            sb.append("\n\t Jini Lookup Locators: ").append(Arrays.asList(lookupLocators));
        }
        if (foundService != null) {
            sb.append("\n\t Found Jini service: ").append(foundService.toString());
        }
        if (sdm != null) {
            sb.append("\n\t Number of Lookup Services: ").append(sdm.getDiscoveryManager().getRegistrars().length);
        }
        sb.append('\n');
        return sb.toString();
    }

    private static Entry[] appendNameIfNeeded(Entry[] attributes, String serviceName) {
        if (serviceName == null) {
            return attributes;
        }
        Name nameAttribute = new Name(serviceName);
        if (attributes == null || attributes.length == 0) {
            return new Entry[]{nameAttribute};
        }
        Entry[] result = new Entry[attributes.length + 1];
        for (int i = 0; i < attributes.length; ++i) {
            result[i] = attributes[i];
        }
        result[attributes.length] = nameAttribute;
        return result;
    }

    public static void sortLookupAttributes(Entry[] attributes) {
        if (attributes != null && attributes.length > 1) {
            Arrays.sort(attributes, ATTRIBUTES_COMPARATOR);
        }
    }

    static {
        try {
            serviceConfig = ServiceConfigLoader.getConfiguration();
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
        ATTRIBUTES_COMPARATOR = new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.getClass().getSimpleName().compareTo(o2.getClass().getSimpleName());
            }
        };
    }
}

