/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.remoting.routing.clustered.LookupType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.LookupManager;
import com.j_spaces.kernel.JSpaceUtilities;
import java.util.Properties;
import java.util.StringTokenizer;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class LookupRequest {
    private final Class serviceClass;
    private String serviceName;
    private Entry[] serviceAttributes;
    private String locators;
    private String groups;
    private Properties customProperties;
    private long timeout;
    private long lookupInterval = 100L;
    private LookupType lookupType = LookupType.TimeBasedLastIteration;
    private String spaceUuid;

    public LookupRequest(Class serviceClass) {
        this.serviceClass = serviceClass;
    }

    public static LookupRequest TransactionManager() {
        return new LookupRequest(TransactionManager.class);
    }

    public static LookupRequest IJSpace() {
        return new LookupRequest(IJSpace.class);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public LookupRequest setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public Class getServiceClass() {
        return this.serviceClass;
    }

    public Entry[] getServiceAttributes() {
        return this.serviceAttributes;
    }

    public LookupRequest setServiceAttributes(Entry[] attributes) {
        this.serviceAttributes = attributes;
        return this;
    }

    public String getLocators() {
        return this.locators;
    }

    public LookupRequest setLocators(String lookupHost) {
        this.locators = lookupHost;
        return this;
    }

    public String getGroups() {
        return this.groups;
    }

    public LookupRequest setGroups(String groups) {
        this.groups = groups;
        return this;
    }

    public String[] getLookupGroups() {
        String PUBLIC = "public";
        String PUBLIC_GROUP = "";
        String[] DEFAULT_GROUPS = new String[]{""};
        if (this.groups == null || this.groups.equalsIgnoreCase("public")) {
            return DEFAULT_GROUPS;
        }
        StringTokenizer st = new StringTokenizer(this.groups, ",");
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            String gr = st.nextToken().trim();
            result[i] = gr.equalsIgnoreCase("public") ? "" : gr;
            ++i;
        }
        return result;
    }

    public LookupLocator[] getLookupLocators() {
        String customLookupHost;
        if (this.customProperties != null && !JSpaceUtilities.isEmpty(customLookupHost = this.customProperties.getProperty("com.j_spaces.core.container.directory_services.jini_lus.unicast_discovery.lus_host"))) {
            this.locators = customLookupHost;
        }
        return this.locators != null ? LookupManager.buildLookupLocators(this.locators) : new LookupLocator[]{};
    }

    public Properties getCustomProperties() {
        return this.customProperties;
    }

    public LookupRequest setCustomProperties(Properties customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public LookupRequest setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public LookupType getLookupType() {
        return this.lookupType;
    }

    public LookupRequest setLookupType(LookupType lookupType) {
        this.lookupType = lookupType;
        return this;
    }

    public long getLookupInterval() {
        return this.lookupInterval;
    }

    public LookupRequest setLookupInterval(long lookupInterval) {
        this.lookupInterval = lookupInterval;
        return this;
    }

    public String getSpaceUuid() {
        return this.spaceUuid;
    }

    public LookupRequest setSpaceUuid(String spaceUuid) {
        this.spaceUuid = spaceUuid;
        return this;
    }
}

