/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.config.lrmi.ITransportConfig;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.internal.lrmi.stubs.LRMISpaceImpl;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.lrmi.RemoteStub;
import com.j_spaces.core.IJSpaceContainer;
import com.j_spaces.core.IStubHandler;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.client.SpaceSettings;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.LBProxyHolder;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Properties;
import net.jini.id.Uuid;

@InternalApi
public class ProxySettings
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int SERIAL_VERSION = 1;
    private static final String _codebase = System.getProperty("java.rmi.server.codebase");
    private static final String _timeProvider = System.getProperty("com.gs.time-provider");
    private final IRemoteSpace _remoteSpace;
    private final SpaceSettings _spaceSettings;
    private final boolean _isCollocated;
    private final SpaceImpl _spaceImpl;
    private final int _uuidHashCode;
    private final String _memberName;
    private final Properties _customProperties;
    private final SpaceClusterInfo _clusterInfo;
    private final SpaceClusterInfo _nonClusterInfo;
    private SpaceURL _finderURL;
    private transient int _updateModifiers;
    private transient int _readModifiers;
    private transient boolean _fifo;
    private transient boolean _isVersioned;
    private transient boolean _gatewayProxy;
    private transient LBProxyHolder _oldProxyHolder;

    public ProxySettings(IRemoteSpace remoteSpace, SpaceSettings spaceSettings) {
        LRMISpaceImpl lrmiSpaceImpl;
        this._remoteSpace = remoteSpace;
        this._spaceSettings = spaceSettings;
        this._memberName = this._spaceSettings.getMemberName();
        this._uuidHashCode = this._spaceSettings.getUuid().hashCode();
        this._clusterInfo = spaceSettings.getSpaceConfig().getClusterInfo();
        this._nonClusterInfo = this._clusterInfo.isClustered() ? new SpaceClusterInfo(null, this._memberName) : this._clusterInfo;
        this._isCollocated = RemoteStub.isCollocatedStub(this._remoteSpace);
        this._spaceImpl = this._remoteSpace instanceof LRMISpaceImpl ? ((lrmiSpaceImpl = (LRMISpaceImpl)this._remoteSpace).isEmbedded() ? (SpaceImpl)lrmiSpaceImpl.getProxy() : null) : null;
        this._customProperties = new Properties();
        Properties serverProperties = this.getSpaceURL().getCustomProperties();
        if (serverProperties != null) {
            this._customProperties.putAll((Map<?, ?>)serverProperties);
        }
    }

    public Uuid getUuid() {
        return this._spaceSettings.getUuid();
    }

    public int getSerializationType() {
        return this._spaceSettings.getSerializationType();
    }

    public String getContainerName() {
        return this._spaceSettings.getContainerName();
    }

    public String getSpaceName() {
        return this._spaceSettings.getSpaceName();
    }

    public IStubHandler getStubHandler() {
        return this._spaceSettings.getStubHandler();
    }

    public IJSpaceContainer getContainerProxy() {
        return this._spaceSettings.getContainerProxy();
    }

    public SpaceConfig getSpaceAttributes() {
        return this._spaceSettings.getSpaceConfig();
    }

    public SpaceURL getSpaceURL() {
        return this._spaceSettings.getSpaceURL();
    }

    public boolean isSecuredService() {
        return this._spaceSettings.isSecuredService();
    }

    public ITransportConfig getExportedTransportConfig() {
        return this._spaceSettings.getExportedTransportConfig();
    }

    public SpaceURL getFinderURL() {
        return this._finderURL;
    }

    public ProxySettings setFinderURL(SpaceURL finderURL) {
        this._finderURL = finderURL;
        if (finderURL != null && finderURL.getCustomProperties() != null) {
            this._customProperties.putAll((Map<?, ?>)finderURL.getCustomProperties());
        }
        return this;
    }

    public String getTimeProvider() {
        return _timeProvider;
    }

    public String getCodebase() {
        return _codebase;
    }

    public String getMemberName() {
        return this._memberName;
    }

    public int getUUIDHashCode() {
        return this._uuidHashCode;
    }

    public IRemoteSpace getRemoteSpace() {
        return this._remoteSpace;
    }

    public SpaceImpl getSpaceImplIfEmbedded() {
        return this._spaceImpl;
    }

    public LBProxyHolder getOldProxyHolder() {
        if (this._oldProxyHolder == null) {
            this._oldProxyHolder = new LBProxyHolder(this._memberName, this.getSpaceURL(), this._remoteSpace);
        }
        return this._oldProxyHolder;
    }

    public boolean isCollocated() {
        return this._isCollocated;
    }

    public int getUpdateModifiers() {
        return this._updateModifiers;
    }

    public void setUpdateModifiers(int updateModifiers) {
        this._updateModifiers = updateModifiers;
    }

    public int getReadModifiers() {
        return this._readModifiers;
    }

    public void setReadModifiers(int readModifiers) {
        this._readModifiers = readModifiers;
    }

    public boolean isVersioned() {
        return this._isVersioned;
    }

    public void setVersioned(boolean isVersioned) {
        this._isVersioned = isVersioned;
    }

    public boolean isFifo() {
        return this._fifo;
    }

    public void setFifo(boolean fifo) {
        this._fifo = fifo;
    }

    public boolean isGatewayProxy() {
        return this._gatewayProxy;
    }

    public void setGatewayProxy(boolean gatewayProxy) {
        this._gatewayProxy = gatewayProxy;
    }

    public Properties getCustomProperties() {
        return this._customProperties;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v11_0_0)) {
            throw new IllegalStateException("Class " + this.getClass().getName() + " should no longer be serialized");
        }
        out.writeInt(1);
        this._spaceSettings.writeExternal(out);
        if (this._finderURL == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this._finderURL.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException("Class " + this.getClass().getName() + " should no longer be serialized");
    }

    public SpaceClusterInfo getSpaceClusterInfo(boolean clustered) {
        return clustered ? this._clusterInfo : this._nonClusterInfo;
    }
}

