/*
 * Decompiled with CFR 0.152.
 */
package com.j_spaces.core.client;

import com.j_spaces.core.client.Modifiers;

public class ReadModifiers {
    public static final int REPEATABLE_READ = 0;
    public static final int DIRTY_READ = 32;
    public static final int EXCLUSIVE_READ_LOCK = 512;
    public static final int READ_COMMITTED = 8192;
    @Deprecated
    public static final int MATCH_BY_ID = 16384;
    @Deprecated
    public static final int THROW_PARTIAL_FAILURE = 32768;
    public static final int IGNORE_PARTIAL_FAILURE = 65536;
    public static final int FIFO = 2048;
    public static final int FIFO_GROUPING_POLL = 0x100000;
    public static final int MEMORY_ONLY_SEARCH = 0x1000000;
    private static final int[] isolationLevelModifiers = new int[]{0, 8192, 32, 512};

    private ReadModifiers() {
    }

    public static int setIsolationLevelModifier(int modifiers, int newIsolationModifier) {
        boolean isIsolationModifier = false;
        for (int modifier : isolationLevelModifiers) {
            if (modifier == newIsolationModifier) {
                isIsolationModifier = true;
                modifiers = Modifiers.add(modifiers, modifier);
                continue;
            }
            modifiers = Modifiers.remove(modifiers, modifier);
        }
        if (!isIsolationModifier) {
            throw new IllegalArgumentException("Given modifier [" + newIsolationModifier + "] is not an isolation level modifier.");
        }
        return modifiers;
    }

    public static boolean isDirtyRead(int mod) {
        return Modifiers.contains(mod, 32);
    }

    public static boolean isExclusiveReadLock(int mod) {
        return Modifiers.contains(mod, 512);
    }

    public static boolean isReadCommitted(int mod) {
        return Modifiers.contains(mod, 8192);
    }

    @Deprecated
    public static boolean isMatchByID(int mod) {
        return Modifiers.contains(mod, 16384);
    }

    @Deprecated
    public static boolean isThrowPartialFailure(int mod) {
        return !Modifiers.contains(mod, 65536);
    }

    public static boolean isFifo(int mod) {
        return Modifiers.contains(mod, 2048);
    }

    public static boolean isFifoGroupingPoll(int mod) {
        return Modifiers.contains(mod, 0x100000);
    }

    public static boolean isMemoryOnlySearch(int mod) {
        return Modifiers.contains(mod, 0x1000000);
    }
}

